/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util;

import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Vehicule;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.CopyFileServeur;
import transpo.system.util.Fonctions;

public class FileManager {
    public static String CHARSET = "UTF-8";
    public static String ARCHIVE_DIRECTORY = String.valueOf(System.getProperty("user.dir")) + "\\data\\";

    public static String getFilePath(Conducteur driver) {
        if (System.getProperty("URL") == null) {
            return FileManager.getLocalPath(driver.getDataDirName());
        }
        return FileManager.getServerPath(driver.getDataDirName());
    }

    public static String getFilePath(Vehicule vehicle) {
        if (System.getProperty("URL") == null) {
            return FileManager.getLocalPath(vehicle.getDataDirName());
        }
        return FileManager.getServerPath(vehicle.getDataDirName());
    }

    private static String getLocalPath(String dataDirName) {
        return String.valueOf(ARCHIVE_DIRECTORY) + dataDirName;
    }

    private static String getServerPath(String dataDirName) {
        return "http://" + System.getProperty("HOME_PATH") + "data/" + dataDirName;
    }

    public static boolean createDirectory(String ... directories) {
        TimsLogger.debug("#FileManager.createDirectory# creating directory of leve " + directories.length);
        String path = "";
        String[] stringArray = directories;
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            String parent = stringArray[n2];
            path = String.valueOf(path) + parent + "/";
            ++n2;
        }
        if (System.getProperty("URL") == null) {
            return FileManager.createLocalirectory(path);
        }
        return FileManager.createServerDirectory(path);
    }

    public static boolean createLocalirectory(String path) {
        File tmp = new File(String.valueOf(ARCHIVE_DIRECTORY) + path);
        TimsLogger.debug("#FileManager.createLocalirectory# Complete file to create " + tmp.getAbsolutePath());
        if (!tmp.exists()) {
            return tmp.mkdirs();
        }
        return true;
    }

    public static boolean createServerDirectory(String path) {
        try {
            URL url = Fonctions.getURL("http://" + System.getProperty("HOME_PATH"), "create.php", "?path=" + path + "&check=" + Fonctions.md5ciphering("test"));
            CopyFileServeur cfs = new CopyFileServeur(null, null, url);
            cfs.start();
            while (!cfs.isDone()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                TimsLogger.verbose("#FM.createServerDirectory# On attend de sortir du script...");
            }
            return cfs.isSuccess();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static boolean moveDirectory(String from, String to) {
        TimsLogger.debug("#FileManager.moveDirectory# from " + from + " to " + to);
        if (System.getProperty("URL") == null) {
            return FileManager.moveLocalDirectory(from, to);
        }
        return FileManager.moveServerDirectory(from, to);
    }

    public static boolean moveLocalDirectory(String from, String to) {
        File fromFile = new File(String.valueOf(ARCHIVE_DIRECTORY) + from);
        if (!fromFile.exists()) {
            TimsLogger.debug("#FileManager.moveLocalDirectory# " + fromFile.getAbsolutePath() + " is missing");
            return false;
        }
        File toFile = new File(String.valueOf(ARCHIVE_DIRECTORY) + to);
        if (toFile.exists()) {
            TimsLogger.debug("#FileManager.moveLocalDirectory# " + toFile.getAbsolutePath() + " ever exists");
            return false;
        }
        if (!toFile.getParentFile().exists()) {
            TimsLogger.info("#FileManager.moveLocalDirectory# r\u00e9pertoire de l'agence absent, on cr\u00e9e le repertoire");
            try {
                toFile.getParentFile().mkdirs();
            }
            catch (Exception ex) {
                TimsLogger.error(ex.getMessage());
                return false;
            }
        }
        if (!fromFile.renameTo(toFile)) {
            TimsLogger.error("#FileManager.moveLocalDirectory# rename " + fromFile.getAbsolutePath() + " to " + toFile.getAbsolutePath() + " failed ");
            return false;
        }
        return true;
    }

    public static boolean moveServerDirectory(String from, String to) {
        try {
            URL url = Fonctions.getURL("http://" + System.getProperty("HOME_PATH"), "move.php", "?from=" + from + "&to=" + to + "&check=" + Fonctions.md5ciphering("test"));
            CopyFileServeur cfs = new CopyFileServeur(null, null, url);
            cfs.start();
            return true;
        }
        catch (Exception ex) {
            TimsLogger.warn("#FileManager.moveServerDirectory# Echec de copie");
            ex.printStackTrace();
            return false;
        }
    }

    public static String moveFile(Conducteur driver, File toMove) {
        return FileManager.moveFile(driver, toMove, toMove.getName());
    }

    public static String moveFile(Conducteur driver, File toMove, String finalName) {
        if (System.getProperty("URL") == null) {
            return FileManager.moveLocalFile(driver.getDataDirName(), toMove, finalName, false);
        }
        return FileManager.moveServerFile(driver.getDataDirName(), toMove, finalName, false);
    }

    public static String moveFile(Conducteur driver, File toMove, String finalName, boolean eraseIfExist) {
        if (System.getProperty("URL") == null) {
            return FileManager.moveLocalFile(driver.getDataDirName(), toMove, finalName, eraseIfExist);
        }
        return FileManager.moveServerFile(driver.getDataDirName(), toMove, finalName, eraseIfExist);
    }

    public static String moveLocalFile(String destinationPath, File toMove, String finalName, boolean eraseIfExist) {
        TimsLogger.debug("#MoveLocalFile# " + toMove.getName() + " to " + destinationPath);
        if (finalName == null) {
            finalName = toMove.getName();
        }
        try {
            File saveDir = new File(String.valueOf(ARCHIVE_DIRECTORY) + destinationPath);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            if (!eraseIfExist) {
                int counter = 1;
                while (FileManager.checkExistingFile(destinationPath, finalName)) {
                    String name = finalName.substring(0, finalName.lastIndexOf("."));
                    String suffix = finalName.substring(finalName.lastIndexOf("."));
                    finalName = String.valueOf(name) + " (" + counter + ")" + suffix;
                    ++counter;
                }
            }
            Fonctions.copy(toMove.getAbsolutePath(), String.valueOf(ARCHIVE_DIRECTORY) + destinationPath + finalName);
            if (System.getProperty("auto.delete", "0").equals("1")) {
                Fonctions.deleteFile(toMove.getAbsolutePath());
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("#FileManager.moveLocalFile# Echec de copie");
            ex.printStackTrace();
            return null;
        }
        return finalName;
    }

    public static String moveServerFile(String destinationPath, File toMove, String finalName, boolean eraseIfExist) {
        TimsLogger.debug("#moveServerFile# " + toMove.getName() + " to " + destinationPath);
        try {
            URL url;
            if (finalName == null) {
                finalName = toMove.getName();
            }
            if (!eraseIfExist) {
                int counter = 1;
                while (FileManager.checkExistingFile(destinationPath, finalName)) {
                    String name = finalName.substring(0, finalName.lastIndexOf("."));
                    String suffix = finalName.substring(finalName.lastIndexOf("."));
                    finalName = String.valueOf(name) + " (" + counter + ")" + suffix;
                    ++counter;
                }
            }
            if (Fonctions.transfer(toMove, finalName, url = Fonctions.getURL("http://" + System.getProperty("HOME_PATH"), "upload.php", "?path=" + destinationPath + "&check=" + Fonctions.md5ciphering("test")), true)) {
                return finalName;
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("#FileManager.moveServerFile# Echec de copie");
            ex.printStackTrace();
        }
        return null;
    }

    public static String moveFile(Vehicule vehicle, File toMove) {
        if (System.getProperty("URL") == null) {
            return FileManager.moveLocalFile(vehicle.getDataDirName(), toMove, toMove.getName(), false);
        }
        return FileManager.moveServerFile(vehicle.getDataDirName(), toMove, toMove.getName(), false);
    }

    public static boolean checkExistingFile(String destinationPath, String toCheck) {
        if (System.getProperty("URL") == null) {
            return FileManager.checkLocalExistingFile(String.valueOf(ARCHIVE_DIRECTORY) + destinationPath + toCheck);
        }
        return FileManager.checkServerExistingFile("data/" + destinationPath + toCheck);
    }

    public static boolean checkLocalExistingFile(String path) {
        TimsLogger.debug("#checkLocalExistingFile# " + path + " " + (new File(path).exists() ? "exist" : "don't exist"));
        return new File(path).exists();
    }

    public static boolean checkServerExistingFile(String url) {
        boolean toReturn = true;
        try {
            URL myURL = Fonctions.getURL(null, url);
            HttpURLConnection uc = (HttpURLConnection)myURL.openConnection();
            uc.setRequestMethod("HEAD");
            uc.connect();
            if (uc.getResponseCode() != 200) {
                toReturn = false;
            }
            TimsLogger.debug("#checkServerExistingFile# return code " + uc.getResponseCode());
        }
        catch (Exception e) {
            e.printStackTrace();
            toReturn = false;
        }
        TimsLogger.debug("#checkServerExistingFile# " + url + " " + (toReturn ? "exist" : "don't exist"));
        return toReturn;
    }

    public static File getFile(Conducteur driver, String fileName) {
        try {
            if (System.getProperty("URL") == null) {
                return FileManager.getLocalFile(driver, fileName);
            }
            return FileManager.getServerFile(driver, fileName);
        }
        catch (IOException e) {
            TimsLogger.warn(e.getMessage());
            return null;
        }
    }

    public static File getFile(Conducteur driver, String fileName, boolean eraseAnyway) {
        try {
            if (System.getProperty("URL") == null) {
                return FileManager.getLocalFile(driver, fileName);
            }
            return FileManager.getServerFile(driver, fileName, eraseAnyway);
        }
        catch (IOException e) {
            TimsLogger.warn(e.getMessage());
            return null;
        }
    }

    public static boolean moveTemporaryFile(File toMove) {
        if (System.getProperty("URL") == null) {
            return FileManager.moveLocalTemporaryFile(toMove);
        }
        return FileManager.moveServerTemporaryFile(toMove);
    }

    public static boolean moveLocalTemporaryFile(File toMove) {
        File to;
        File saveDir = new File(String.valueOf(ARCHIVE_DIRECTORY) + BddTransport.getInstance().getCompany().getNomBase() + "\\");
        if (!saveDir.exists()) {
            saveDir.mkdirs();
        }
        if ((to = new File(String.valueOf(ARCHIVE_DIRECTORY) + BddTransport.getInstance().getCompany().getNomBase() + "\\" + toMove.getName())).exists()) {
            return false;
        }
        return toMove.renameTo(to);
    }

    public static boolean moveServerTemporaryFile(File toMove) {
        try {
            URL url = Fonctions.getURL(null, "upload.php", "?path=" + BddTransport.getInstance().getCompany().getNomBase() + "&check=" + Fonctions.md5ciphering("test"));
            TimsLogger.debug("#FileManager.moveServerTemporaryFile# url = " + url.toString());
            Fonctions.transfer(toMove, null, url, true);
            return true;
        }
        catch (Exception ex) {
            TimsLogger.warn("#FileManager.moveServerTemporaryFile# Echec de copie");
            ex.printStackTrace();
            return false;
        }
    }

    public static File getFile(String origin, String destination) {
        if (System.getProperty("URL") == null) {
            File dest = new File(destination);
            boolean ret = Fonctions.copyLocalFile(new File(origin), dest, false);
            if (ret) {
                return dest;
            }
            return null;
        }
        try {
            return FileManager.getServerFile(origin, destination);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static File getServerFile(String url, String destination) throws IOException, SecurityException {
        return FileManager.getServerFile(url, destination, false);
    }

    public static File getServerFile(String url, String destination, boolean eraseAnyway) throws IOException, SecurityException {
        URL myURL = Fonctions.getURL(null, url);
        TimsLogger.debug("#FileManager.getServerFile# from : " + myURL.toString() + " to : " + destination);
        URLConnection uc = myURL.openConnection();
        int FileLenght = uc.getContentLength();
        if (FileLenght == -1) {
            throw new IOException("Fichier " + url + " non valide.");
        }
        File tmp = new File(destination);
        if (tmp.exists()) {
            if (!eraseAnyway && tmp.lastModified() >= uc.getLastModified()) {
                TimsLogger.debug("#FileManager.getServerFile# file ever exist (" + destination + ")");
                return new File(destination);
            }
            TimsLogger.debug("#FileManager.getServerFile# file more recent detected on server (" + destination + ")");
        }
        InputStream brut = uc.getInputStream();
        BufferedInputStream entree = new BufferedInputStream(brut);
        byte[] donnees = new byte[FileLenght];
        int BitRead = 0;
        int deplacement = 0;
        while (deplacement < FileLenght) {
            BitRead = ((InputStream)entree).read(donnees, deplacement, donnees.length - deplacement);
            if (BitRead == -1) break;
            deplacement += BitRead;
        }
        ((InputStream)entree).close();
        if (deplacement != FileLenght) {
            throw new IOException("#FileManager.getServerFile# Nous n'avons lu que " + deplacement + " octets au lieu des " + FileLenght + " attendus");
        }
        try {
            tmp.createNewFile();
        }
        catch (IOException e) {
            TimsLogger.warn("#FileManager.getServerFile# Erreur d'I/O \u00e0 la cr\u00e9ation du fichier " + destination + " (" + e.getMessage() + ")");
            e.printStackTrace();
            throw e;
        }
        catch (SecurityException e) {
            TimsLogger.warn("#FileManager.getServerFile# Erreur de s\u00e9curit\u00e9 \u00e0 la cr\u00e9ation du fichier " + destination + " (" + e.getMessage() + ")");
            throw e;
        }
        FileOutputStream WritenFile = new FileOutputStream(destination);
        WritenFile.write(donnees);
        WritenFile.flush();
        WritenFile.close();
        return tmp;
    }

    public static File getLocalFile(Conducteur driver, String fileName) throws IOException {
        String from = String.valueOf(ARCHIVE_DIRECTORY) + driver.getDataDirName() + fileName;
        File toReturn = new File(from);
        if (!toReturn.exists()) {
            throw new IOException("Fichier " + fileName + " introuvable.");
        }
        return toReturn;
    }

    public static File getServerFile(Conducteur driver, String fileName) throws IOException {
        return FileManager.getServerFile(driver, fileName, false);
    }

    public static File getServerFile(Conducteur driver, String fileName, boolean eraseAnyway) throws IOException {
        String from = "http://" + System.getProperty("HOME_PATH") + "data/" + driver.getDataDirName() + fileName;
        String to = String.valueOf(Transport.savePath) + fileName;
        return FileManager.getServerFile(from, to, eraseAnyway);
    }

    public static File getFile(Vehicule vehicle, String fileName) {
        try {
            if (System.getProperty("URL") == null) {
                return FileManager.getLocalFile(vehicle, fileName);
            }
            return FileManager.getServerFile(vehicle, fileName);
        }
        catch (IOException e) {
            TimsLogger.error("#FileManager.getFile# " + e.getMessage());
            return null;
        }
    }

    public static File getFile(Vehicule vehicle, String fileName, boolean eraseAnyway) {
        try {
            if (System.getProperty("URL") == null) {
                return FileManager.getLocalFile(vehicle, fileName);
            }
            return FileManager.getServerFile(vehicle, fileName, eraseAnyway);
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public static File getLocalFile(Vehicule vehicle, String fileName) throws IOException {
        String from = String.valueOf(ARCHIVE_DIRECTORY) + vehicle.getDataDirName() + fileName;
        File toReturn = new File(from);
        if (!toReturn.exists()) {
            throw new IOException("Fichier " + fileName + " introuvable.");
        }
        return toReturn;
    }

    public static File getServerFile(Vehicule vehicle, String fileName) throws IOException {
        return FileManager.getServerFile(vehicle, fileName, false);
    }

    public static File getServerFile(Vehicule vehicle, String fileName, boolean eraseAnyway) throws IOException {
        String from = "http://" + System.getProperty("HOME_PATH") + "data/" + vehicle.getDataDirName() + fileName;
        String to = String.valueOf(Transport.savePath) + fileName;
        return FileManager.getServerFile(from, to, eraseAnyway);
    }

    public static boolean getTemporaryFile(File toGet) {
        TimsLogger.debug("#FileManage.getTemporaryFile# toGet : " + toGet.getAbsolutePath());
        if (System.getProperty("URL") == null) {
            return FileManager.moveLocalTemporaryFile(toGet);
        }
        return FileManager.moveServerTemporaryFile(toGet);
    }

    public static boolean getLocalTemporaryFile(File toGet) {
        try {
            Fonctions.copy(toGet.getAbsolutePath(), String.valueOf(ARCHIVE_DIRECTORY) + BddTransport.getInstance().getCompany().getNomBase() + "\\" + toGet.getName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TimsLogger.warn("#FileManager.moveLocalFile# Echec de copie");
            return false;
        }
        return true;
    }

    public static File getServerTemporaryFile(String fileName) throws Exception {
        String from = "http://" + System.getProperty("HOME_PATH") + "data/" + BddTransport.getInstance().getCompany().getNomBase() + "/" + fileName;
        String to = String.valueOf(Transport.savePath) + fileName;
        return FileManager.getServerFile(from, to, false);
    }

    public static boolean deleteTemporaryFile(String fileName) {
        TimsLogger.debug("#FileManage.deleteTemporaryFile# toGet : " + fileName);
        if (System.getProperty("URL") == null) {
            return FileManager.deleteLocalTemporaryFile(fileName);
        }
        return FileManager.deleteServerTemporaryFile(fileName);
    }

    public static boolean deleteLocalTemporaryFile(String fileName) {
        return new File(String.valueOf(ARCHIVE_DIRECTORY) + BddTransport.getInstance().getCompany().getNomBase() + "\\" + fileName).delete();
    }

    public static boolean deleteServerTemporaryFile(String fileName) {
        try {
            URL url = Fonctions.getURL(null, "delete.php", "?path=" + BddTransport.getInstance().getCompany().getNomBase() + "&file=" + fileName + "&check=" + Fonctions.md5ciphering("test"));
            CopyFileServeur cfs = new CopyFileServeur(null, null, url);
            cfs.start();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

