/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util;

import com.mysql.jdbc.CommunicationsException;
import fr.pgh.component.JNotificationFrame;
import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Accident;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.CardDownload;
import fr.pgh.data.bdd.ChangementActivite;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.DriverAttachment;
import fr.pgh.data.bdd.DriverDayAnomaly;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.EmployeeObligation;
import fr.pgh.data.bdd.EmployeeObligationType;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.ExternalDay;
import fr.pgh.data.bdd.GNSSPlace;
import fr.pgh.data.bdd.Intervention;
import fr.pgh.data.bdd.InterventionType;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.OffenceType;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.Societe;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.UevDownload;
import fr.pgh.data.bdd.UevEventsFaults;
import fr.pgh.data.bdd.UevOffence;
import fr.pgh.data.bdd.UevSession;
import fr.pgh.data.bdd.UevSpeed;
import fr.pgh.data.bdd.VehicleAttachment;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.ActivityTypeNotFoundException;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.exception.DayException;
import fr.pgh.exception.DriverNotFoundException;
import fr.pgh.exception.ExpensesNotFoundException;
import fr.pgh.exception.ServiceException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import java.util.concurrent.ThreadLocalRandom;
import java.util.prefs.Preferences;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.imageio.ImageIO;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.jfree.util.Log;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.jsmartcard.DriverCardSaving;
import transpo.system.traitement.CorrectionActiviteDetail;
import transpo.system.traitement.TraitementTempsService;
import transpo.system.uev.UEVCORRECTION;
import transpo.system.uev.UEVProperty;
import transpo.system.uev.VuFileParserG2;
import transpo.system.uev.VuProcessingG1;
import transpo.system.uev.VuProcessingG2;
import transpo.system.uev.object.VuCalibration;
import transpo.system.uev.object.VuFile;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.modele.ComboBoxModel;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.DialogIntervention;
import transpo.system.ui.views.ParametersTable;
import transpo.system.ui.views.ProgressBar;
import transpo.system.ui.views.conducteur.DialogEmployeeObligation;
import transpo.system.util.CopyFileServeur;
import transpo.system.util.CsvReading;
import transpo.system.util.ExcelReading;
import transpo.system.util.FileManager;
import transpo.system.util.GestionChevauchement;
import transpo.system.util.messaging.MessageSystemManager;
import transpo.system.util.messaging.StringMessage;
import transpo.ui.calendrier.JCalendrier;
import transport.offence.CalculInfractionPrincipal;
import transport.report.AccidentReport;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.MasterReport;
import transport.report.generator.DJGenerator;

public class Fonctions {
    public static final int ERROR = 0;
    public static final int SUCCESS = 1;
    public static final int DONE_WITH_ERROR = 2;
    public static final int WARNING = 3;
    public static final int CANCELLED = 4;
    public static final int PROCESSING = 8;
    public static final int WAITING = 9;
    public static final int ICON_ERROR = 0;
    public static final int ICON_SUCCESS = 1;
    public static final int ICON_PROCESSING = 2;
    private static boolean test = false;

    public static String getStringFromBuffer(byte[] buf, int offset, int nbCharToRead) {
        return Fonctions.getStringFromBuffer(buf, offset, nbCharToRead, 0);
    }

    public static String getStringFromBuffer(byte[] buf, int offset, int nbCharToRead, int codePage) {
        offset += codePage;
        byte[] retour = new byte[nbCharToRead];
        int j = 0;
        while (j < nbCharToRead) {
            retour[j] = buf[offset + j];
            ++j;
        }
        return new String(retour).trim();
    }

    public static int getJavaVersion(String version) {
        int iVersion = 0;
        if (version == null) {
            version = System.getProperty("java.version");
        }
        TimsLogger.debug("#Fonctions.getJavaVersion# extract version from " + version);
        String[] dVersion = version.split("\\.");
        iVersion = dVersion.length > 1 ? (dVersion[0].equals("1") ? Integer.parseInt(dVersion[1]) : Integer.parseInt(dVersion[0])) : Integer.parseInt(version);
        return iVersion;
    }

    public static <T> void define(Class<T> toDefine) {
        new ParametersTable((Frame)MainFrameTransport.getInstance(), toDefine).setVisible(true);
    }

    public static void hideColumn(TableColumn aColumn) {
        aColumn.setMinWidth(0);
        aColumn.setMaxWidth(0);
    }

    public static void showColumn(TableColumn aColumn) {
        aColumn.setMinWidth(0);
        aColumn.setMaxWidth(Integer.MAX_VALUE);
        aColumn.setPreferredWidth(75);
    }

    public static void commit(JTable tbl) {
        int row = tbl.getSelectedRow();
        int column = tbl.getSelectedColumn();
        if (tbl.isEditing()) {
            tbl.getCellEditor(row, column).stopCellEditing();
        }
    }

    public static String returnIntCode(byte[] buffer) {
        if (buffer == null || buffer.length < 2) {
            TimsLogger.debug("#Fonctions.returnIntCode# buffer null");
            return "0000";
        }
        String s1 = Integer.toHexString(buffer[buffer.length - 2] & 0xFF);
        while (s1.length() < 2) {
            s1 = "0" + s1;
        }
        String s2 = Integer.toHexString(buffer[buffer.length - 1] & 0xFF);
        while (s2.length() < 2) {
            s2 = "0" + s2;
        }
        TimsLogger.verbose("#Fonctions.returnIntCode# " + s1 + " " + s2 + " ('" + buffer[buffer.length - 2] + ",'" + buffer[buffer.length - 1] + "')");
        return String.valueOf(s1.toUpperCase()) + s2.toUpperCase();
    }

    public static String parseString(String hexAscii) {
        String toReturn = "";
        if (hexAscii.length() % 2 != 0) {
            TimsLogger.warn("Fonctions.parseString# Chaine" + hexAscii + " non valide (caract\u00e8res impaires)");
            return null;
        }
        byte[] toReturnByte = new byte[hexAscii.length() / 2];
        int x = 0;
        while (x < hexAscii.length()) {
            int intVal = Integer.parseInt(hexAscii.substring(x, x + 2), 16);
            toReturnByte[x / 2] = (byte)intVal;
            x += 2;
        }
        toReturn = new String(toReturnByte);
        return toReturn;
    }

    public static byte[] parseStringToByteArray(String hexAscii) {
        if (hexAscii.length() % 2 != 0) {
            TimsLogger.warn("Fonctions.parseString# Chaine non valide (caract\u00e8res impaires)");
            return null;
        }
        byte[] toReturnByte = new byte[hexAscii.length() / 2];
        int x = 0;
        while (x < hexAscii.length()) {
            int intVal = Integer.parseInt(hexAscii.substring(x, x + 2), 16);
            toReturnByte[x / 2] = (byte)intVal;
            x += 2;
        }
        return toReturnByte;
    }

    public static String parseAscii(String chars) {
        String toReturn = "";
        int x = 0;
        while (x < chars.length()) {
            String toAdd = Integer.toHexString(chars.charAt(x));
            while (toAdd.length() < 2) {
                toAdd = "0" + toAdd;
            }
            toReturn = String.valueOf(toReturn) + toAdd.toUpperCase();
            ++x;
        }
        return toReturn;
    }

    public static String parseHexAscii(byte[] chars) {
        return Fonctions.parseHexAscii(chars, 0, -1);
    }

    public static String parseHexAscii(byte[] chars, int begin, int end) {
        String toReturn = "";
        if (chars == null) {
            return toReturn;
        }
        if (end == -1) {
            end = chars.length - 1;
        }
        int x = begin;
        while (x <= end) {
            byte b = chars[x];
            String toAdd = Integer.toHexString(b & 0xFF).toUpperCase();
            while (toAdd.length() < 2) {
                toAdd = "0" + toAdd;
            }
            toReturn = String.valueOf(toReturn) + toAdd;
            ++x;
        }
        return toReturn;
    }

    public static String parseBinaryAscii(byte[] chars, int begin, int end) {
        String toReturn = "";
        if (chars == null) {
            return toReturn;
        }
        if (end == -1) {
            end = chars.length - 1;
        }
        int x = begin;
        while (x <= end) {
            byte b = chars[x];
            String toAdd = Integer.toBinaryString(b & 0xFF);
            while (toAdd.length() < 8) {
                toAdd = "0" + toAdd;
            }
            toReturn = String.valueOf(toReturn) + toAdd;
            ++x;
        }
        return toReturn;
    }

    public static void showDialogInterv(Intervention toShow, Vehicule vehicle) {
        DialogIntervention tmp = new DialogIntervention(MainFrameTransport.getInstance());
        if (toShow == null) {
            tmp.setSelectedVehicle(vehicle);
        } else {
            tmp.setIntervention(toShow);
        }
        tmp.setVisible(true);
    }

    public static void showDialogObligation(EmployeeObligation toShow, Conducteur driver) {
        DialogEmployeeObligation tmp = new DialogEmployeeObligation(MainFrameTransport.getInstance());
        if (driver != null) {
            tmp.setSelectedDriver(driver);
        }
        if (toShow != null) {
            tmp.setEmployeeObligation(toShow);
        }
        tmp.setVisible(true);
    }

    public static Intervention getNextIntervention(Intervention last, Vehicule vehicle) {
        Intervention next = null;
        try {
            InterventionType type = InterventionType.getInterventionType(last.getTypeId());
            if (type.getKmExpiration() != 0) {
                if (vehicle.getAverageDailyKm() == 0) {
                    TimsLogger.verbose("#Fonctions.getNextIntervention# unable to determine future intervention for " + vehicle.getRegistrationNumber() + " no average km");
                } else {
                    int lastKnownKm = vehicle.getLastKnownKm();
                    Date dayLastKm = ConversionTime.stringToDate(vehicle.getDateTelechargement(), "yyyy-MM-dd HH:mm:ss");
                    dayLastKm = ConversionTime.dateTruncate(dayLastKm);
                    int kmOnFuture = last.getKm() + type.getKmExpiration();
                    int workingDayUntilRevision = (kmOnFuture - lastKnownKm) / vehicle.getAverageDailyKm();
                    next = new Intervention();
                    next.setState(3);
                    next.setTypeId(last.getTypeId());
                    next.setVehicleId(last.getVehicleId());
                    next.setDay(ConversionTime.addDay(dayLastKm, workingDayUntilRevision / 5 * 7));
                    next.setKm(kmOnFuture);
                    next.setMoCost(0.0f);
                    next.setCost(0.0f);
                    TimsLogger.verbose("#Fonctions.getNextIntervention# adding (km) " + next.toString());
                }
            }
            if (type.getPeriodExpiration() != 0) {
                Date future = ConversionTime.addDay(last.getDay(), type.getPeriodExpiration());
                if (next != null && next.getDay().before(future)) {
                    TimsLogger.verbose("#Fonctions.getNextIntervention# intervention kilometer period before date period");
                } else {
                    next = new Intervention();
                    next.setTypeId(last.getTypeId());
                    next.setVehicleId(last.getVehicleId());
                    next.setDay(future);
                    next.setState(3);
                    next.setMoCost(0.0f);
                    next.setCost(0.0f);
                    TimsLogger.verbose("#Fonctions.getNextIntervention# adding (time) " + next.toString());
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return next;
    }

    public static Vector<Intervention> getNextIntervention(Vector<Intervention> lasts, Vector<Vehicule> list, boolean withScheduled, Date begin, Date end) {
        Date today = new Date();
        Vector<Intervention> toReturn = new Vector<Intervention>();
        for (Intervention last : lasts) {
            if (last.getState() == 1) {
                TimsLogger.verbose("#Fonctions.getNextIntervention# interv type " + last.getTypeId() + " d\u00e9j\u00e0 planifi\u00e9 pour " + last.getVehicleId());
                if (!withScheduled) continue;
                toReturn.add(last);
                continue;
            }
            try {
                InterventionType type = InterventionType.getInterventionType(last.getTypeId());
                Intervention next = null;
                if (type.getKmExpiration() != 0) {
                    Vehicule tmp = Vehicule.getVehicule(list, last.getVehicleId());
                    if (tmp.getAverageDailyKm() == 0) {
                        TimsLogger.verbose("#Fonctions.getNextIntervention# unable to determine future intervention for " + tmp.getRegistrationNumber() + " no average km");
                    } else {
                        int lastKnownKm = tmp.getLastKnownKm();
                        Date dayLastKm = ConversionTime.stringToDate(tmp.getDateTelechargement(), "yyyy-MM-dd HH:mm:ss");
                        dayLastKm = ConversionTime.dateTruncate(dayLastKm);
                        int kmOnFuture = last.getKm() + type.getKmExpiration();
                        int workingDayUntilRevision = (kmOnFuture - lastKnownKm) / tmp.getAverageDailyKm();
                        next = new Intervention();
                        next.setState(3);
                        next.setTypeId(last.getTypeId());
                        next.setVehicleId(last.getVehicleId());
                        next.setDay(ConversionTime.addDay(dayLastKm, workingDayUntilRevision / 5 * 7));
                        next.setKm(kmOnFuture);
                        next.setMoCost(0.0f);
                        next.setCost(0.0f);
                        TimsLogger.verbose("#Fonctions.getNextIntervention# adding (km) " + next.toString());
                    }
                }
                if (type.getPeriodExpiration() != 0) {
                    Date future = ConversionTime.addDay(last.getDay(), type.getPeriodExpiration());
                    if (next != null && next.getDay().before(future)) {
                        TimsLogger.verbose("#Fonctions.getNextIntervention# intervention kilometer period before date period");
                    } else {
                        next = new Intervention();
                        next.setTypeId(last.getTypeId());
                        next.setVehicleId(last.getVehicleId());
                        next.setDay(future);
                        next.setState(3);
                        next.setMoCost(0.0f);
                        next.setCost(0.0f);
                        TimsLogger.verbose("#Fonctions.getNextIntervention# adding (time) " + next.toString());
                    }
                }
                if (next == null) continue;
                if (begin != null && next.getDay().before(today)) {
                    TimsLogger.verbose("#Fonctions.getNextIntervention# on est d\u00e9j\u00e0 en retard...");
                    next.setState(4);
                    if (begin != null && next.getDay().before(begin)) {
                        next.setDay(begin);
                    }
                }
                if (begin != null && (next.getDay().before(begin) || next.getDay().after(end))) continue;
                toReturn.add(next);
            }
            catch (DBObjectNotFoundException ex) {
                TimsLogger.warn("Fonctions.getNextIntervention# DBObjectNotFoundException (vehicle : " + last.getVehicleId() + ")");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return toReturn;
    }

    public static Vector<EmployeeObligation> getNextObligation(Vector<EmployeeObligation> lasts, boolean withScheduled, Date begin, Date end) {
        Date today = new Date();
        Vector<EmployeeObligation> toReturn = new Vector<EmployeeObligation>();
        for (EmployeeObligation last : lasts) {
            if (last.getState() == 1) {
                TimsLogger.verbose("#Fonctions.getNextObligation# obligation type " + last.getTypeId() + " d\u00e9j\u00e0 planifi\u00e9 pour " + last.getDriverId());
                if (!withScheduled) continue;
                toReturn.add(last);
                continue;
            }
            try {
                EmployeeObligationType type;
                EmployeeObligation next = null;
                if (last.getExpiration() != null) {
                    Date future = last.getExpiration();
                    next = new EmployeeObligation();
                    next.setTypeId(last.getTypeId());
                    next.setDriverId(last.getDriverId());
                    next.setDay(future);
                    next.setState(3);
                    next.setCost(0.0f);
                    TimsLogger.verbose("#Fonctions.getNextObligation# adding (time) " + next.toString());
                }
                if (next == null && (type = EmployeeObligationType.getObligationType(last.getTypeId())).getPeriodExpiration() != 0) {
                    Date future = ConversionTime.addDay(last.getDay(), type.getPeriodExpiration());
                    next = new EmployeeObligation();
                    next.setTypeId(last.getTypeId());
                    next.setDriverId(last.getDriverId());
                    next.setDay(future);
                    next.setState(3);
                    next.setCost(0.0f);
                    TimsLogger.verbose("#Fonctions.getNextObligation# adding (time) " + next.toString());
                }
                if (next == null) continue;
                if (next.getDay().before(today)) {
                    TimsLogger.verbose("#Fonctions.getNextObligation# on est d\u00e9j\u00e0 en retard...");
                    next.setState(4);
                }
                if ((begin != null || end != null) && (next.getDay().before(begin) || next.getDay().after(end))) continue;
                toReturn.add(next);
            }
            catch (Exception ex) {
                TimsLogger.warn(ex.getMessage());
            }
        }
        return toReturn;
    }

    public static Image createImage(String path, String description) {
        URL imageURL = Fonctions.class.getClassLoader().getResource(path);
        if (imageURL == null) {
            System.err.println("Resource not found: " + path);
            return null;
        }
        return new ImageIcon(imageURL, description).getImage();
    }

    public static Image createImage(int width, int height, String path, String description) {
        InputStream imageURL = Fonctions.class.getClassLoader().getResourceAsStream(path);
        try {
            BufferedImage ret = ImageIO.read(imageURL);
            return ret.getScaledInstance(width, height, 4);
        }
        catch (IOException e) {
            TimsLogger.warn(e.getMessage());
            return null;
        }
    }

    public static FilenameFilter getC1BDetector() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".C1B");
            }
        };
    }

    public static FilenameFilter getV1BDetector() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".V1B");
            }
        };
    }

    public static void executeScript(String[] cmd, boolean verbose, PrintStream toWrite) {
        block10: {
            try {
                String line;
                if (verbose) {
                    String sCmd = "";
                    int x = 0;
                    while (x < cmd.length) {
                        sCmd = String.valueOf(sCmd) + cmd[x] + " ";
                        ++x;
                    }
                    TimsLogger.debug("#Fonctions.executeScript# " + sCmd);
                }
                Process proc = Runtime.getRuntime().exec(cmd, null, null);
                InputStream inputstream = proc.getInputStream();
                InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
                BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
                while ((line = bufferedreader.readLine()) != null) {
                    if (toWrite == null) continue;
                    toWrite.println(line);
                }
                if (toWrite != null) {
                    toWrite.close();
                }
                inputstream = proc.getErrorStream();
                inputstreamreader = new InputStreamReader(inputstream);
                bufferedreader = new BufferedReader(inputstreamreader);
                while ((line = bufferedreader.readLine()) != null) {
                    TimsLogger.debug(line);
                }
                if (!verbose) break block10;
                try {
                    if (proc.waitFor() != 0) {
                        TimsLogger.debug("#Fonctions.executeScript# exit value = " + proc.exitValue());
                    }
                }
                catch (InterruptedException e) {
                    TimsLogger.warn(e.getMessage());
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
    }

    public static String executeSqlFromFile(String chemin, BddTransport bdd) {
        String toReturn = "";
        try {
            FileReader reader = new FileReader(chemin);
            BufferedReader br = new BufferedReader(reader);
            String cmd = "";
            String ligne = "";
            do {
                String string = ligne = (ligne = br.readLine()) != null ? ligne.trim() : null;
                if (ligne == null || ligne.startsWith("--")) continue;
                cmd = String.valueOf(cmd) + ligne;
                if (ligne.length() == 0 || !ligne.substring(ligne.length() - 1).equals(";")) continue;
                if (!bdd.executeCmd(cmd)) {
                    toReturn = String.valueOf(toReturn) + "Failed : " + cmd + "\r\n";
                }
                cmd = "";
            } while (ligne != null);
            reader.close();
        }
        catch (FileNotFoundException exc) {
            TimsLogger.warn("#Fonctions.executeSqlFromFile# Erreur d'ouverture : " + chemin);
            toReturn = String.valueOf(toReturn) + "Not found : " + chemin + "\r\n";
            exc.printStackTrace();
        }
        catch (IOException ex) {
            TimsLogger.warn("#Fonctions.executeSqlFromFile# Erreur d'ouverture : " + chemin);
            toReturn = String.valueOf(toReturn) + "Not found : " + chemin + "\r\n";
            ex.printStackTrace();
        }
        return toReturn;
    }

    public static boolean executeCompanyVersionning(String version) {
        if (version.equals("4.0.3")) {
            TimsLogger.info("Execute versionning " + version);
            return Fonctions.refreshActivityInDayTable(null, null);
        }
        if (version.equals("4.1.0")) {
            TimsLogger.info("Execute versionning " + version);
            Fonctions.correctionDirectory();
            return Fonctions.correctionuev2("2018-09-20", "2040-01-01", "0");
        }
        return false;
    }

    public static void getFile(String host, String path) throws IOException, SecurityException {
        TimsLogger.debug("#Fonctions.copy# host : " + host + ", path : " + path);
        URL u = new URL(host);
        URLConnection uc = u.openConnection();
        int FileLenght = uc.getContentLength();
        if (FileLenght == -1) {
            throw new IOException("Fichier non valide.");
        }
        InputStream brut = uc.getInputStream();
        BufferedInputStream entree = new BufferedInputStream(brut);
        byte[] donnees = new byte[FileLenght];
        int BitRead = 0;
        int deplacement = 0;
        while (deplacement < FileLenght) {
            BitRead = ((InputStream)entree).read(donnees, deplacement, donnees.length - deplacement);
            if (BitRead == -1) break;
            deplacement += BitRead;
        }
        ((InputStream)entree).close();
        if (deplacement != FileLenght) {
            throw new IOException("Nous n'avons lu que " + deplacement + " octets au lieu des " + FileLenght + " attendus");
        }
        File tmp = new File(path);
        tmp.createNewFile();
        FileOutputStream WritenFile = new FileOutputStream(path);
        WritenFile.write(donnees);
        WritenFile.flush();
        WritenFile.close();
    }

    public static void copy(String source, String destination) throws Exception {
        TimsLogger.debug("#Fonctions.copy# " + source + " to " + destination);
        FileChannel in = null;
        AbstractInterruptibleChannel out = null;
        try {
            in = new FileInputStream(source).getChannel();
            out = new FileOutputStream(destination).getChannel();
            in.transferTo(0L, in.size(), (WritableByteChannel)((Object)out));
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static boolean copyLocalFile(File source, File destination, boolean delete) {
        if (delete) {
            return source.renameTo(destination);
        }
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        if (destination.exists() && destination.length() == source.length()) {
            return true;
        }
        try {
            try {
                int nbLecture;
                sourceFile = new FileInputStream(source);
                destinationFile = new FileOutputStream(destination);
                byte[] buffer = new byte[524288];
                while ((nbLecture = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbLecture);
                }
            }
            catch (FileNotFoundException f) {
                JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("message.copyError"), LanguageTranslator.getString("message.numberedError", "(aucun numero)"), 2);
                f.printStackTrace();
                try {
                    sourceFile.close();
                    destinationFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            catch (IOException e) {
                JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), LanguageTranslator.getString("message.copyError"), LanguageTranslator.getString("message.numberedError", "(aucun numero)"), 2);
                System.err.println("IOException In copyFile (Fonction)");
                try {
                    sourceFile.close();
                    destinationFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                sourceFile.close();
                destinationFile.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static boolean transfer(File file, String finalName, URL url, boolean wait) {
        if (SwingUtilities.isEventDispatchThread()) {
            System.err.println("Fonctions.transfer# This function must not be called in EDT !!");
        }
        CopyFileServeur cfs = new CopyFileServeur(file, finalName, url);
        cfs.start();
        final JProgressBar pg = new JProgressBar();
        pg.setIndeterminate(true);
        pg.setStringPainted(true);
        pg.setString(LanguageTranslator.getString("generics.inProgress"));
        JNotificationFrame.NotificationMessage msg = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT).addMessage(LanguageTranslator.getString("generics.fileTransferInProgress", file.getName()), pg, Fonctions.getProcessingStatusIcon());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT).showNotification(-1);
            }
        });
        if (wait) {
            while (!cfs.isDone()) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                TimsLogger.verbose("#Fonction.transfer# On attend de sortir du script...");
            }
            msg.setContent(new JLabel(LanguageTranslator.getString("generics.done")));
            msg.setTitle(LanguageTranslator.getString("generics.fileTransferDone", file.getName()));
            if (cfs.isSuccess()) {
                msg.setIcon(Fonctions.getSuccessStatusIcon());
            } else {
                msg.setIcon(Fonctions.getErrorStatusIcon());
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pg.setVisible(false);
                    JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT).showNotification(5);
                }
            });
            return cfs.isSuccess();
        }
        return true;
    }

    public static ImageIcon getStatusIcon(int status) {
        switch (status) {
            case 0: {
                return new ImageIcon(Fonctions.class.getClassLoader().getResource(Transport.res.getResourceString("icone_sup")));
            }
            case 1: {
                return new ImageIcon(Fonctions.class.getClassLoader().getResource(Transport.res.getResourceString("icone_valid")));
            }
            case 2: {
                return new ImageIcon(Fonctions.class.getClassLoader().getResource(Transport.res.getResourceString("icone_valid")));
            }
        }
        return new ImageIcon(Fonctions.class.getClassLoader().getResource(Transport.res.getResourceString("icone_loupe")));
    }

    public static ImageIcon getErrorStatusIcon() {
        return Fonctions.getStatusIcon(0);
    }

    public static ImageIcon getSuccessStatusIcon() {
        return Fonctions.getStatusIcon(1);
    }

    public static ImageIcon getProcessingStatusIcon() {
        return Fonctions.getStatusIcon(2);
    }

    public static boolean silentCopy(String pathName, File destination, boolean delete) {
        if (System.getProperty("URL") != null) {
            try {
                Fonctions.getFile("http://" + System.getProperty("URL") + "data//" + pathName.replace(" ", "%20"), destination.getAbsolutePath());
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return false;
            }
            return true;
        }
        File source = new File(String.valueOf(System.getProperty("user.dir")) + "\\data\\" + pathName);
        if (delete) {
            return source.renameTo(destination);
        }
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        if (destination.exists() && destination.length() == source.length()) {
            return true;
        }
        try {
            try {
                int nbLecture;
                sourceFile = new FileInputStream(source);
                destinationFile = new FileOutputStream(destination);
                byte[] buffer = new byte[524288];
                while ((nbLecture = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbLecture);
                }
            }
            catch (FileNotFoundException f) {
                try {
                    sourceFile.close();
                    destinationFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
            catch (IOException e) {
                try {
                    sourceFile.close();
                    destinationFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                sourceFile.close();
                destinationFile.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static int getActiviteFromDisque(String cleAct) {
        if (cleAct.equals("10")) {
            return 4;
        }
        if (cleAct.equals("20")) {
            return 3;
        }
        if (cleAct.equals("30")) {
            return 2;
        }
        if (cleAct.equals("40")) {
            return 1;
        }
        if (cleAct.equals("50")) {
            return 6;
        }
        if (cleAct.equals("60")) {
            return 5;
        }
        return 0;
    }

    public static String getActiviteFromVecteur(int cleAct) {
        if (cleAct == 4) {
            return "10";
        }
        if (cleAct == 3) {
            return "20";
        }
        if (cleAct == 2) {
            return "30";
        }
        if (cleAct == 1) {
            return "40";
        }
        if (cleAct == 6) {
            return "50";
        }
        if (cleAct == 5) {
            return "60";
        }
        return "0";
    }

    public static Vector<ChangementActivite> fusionDeuxJours(Vector<ChangementActivite> jour1, Vector<ChangementActivite> jour2) throws Exception {
        Vector<ChangementActivite> retour = new Vector<ChangementActivite>();
        boolean tmp1Finished = false;
        boolean tmp2Finished = false;
        int i = 0;
        int j = 0;
        int currentFrom = 0;
        ChangementActivite tmp1 = null;
        ChangementActivite tmp2 = null;
        ChangementActivite current = null;
        int finCurrent = 0;
        while (!tmp1Finished || !tmp2Finished) {
            tmp1 = jour1.get(i);
            tmp2 = jour2.get(j);
            TimsLogger.debug("#Fonctions.fusionDeuxJours# 1 (" + tmp1Finished + ")");
            tmp1.affiche();
            TimsLogger.debug(" 2 (" + tmp2Finished + ")");
            tmp2.affiche();
            TimsLogger.debug(" current (fin = " + finCurrent + ") : ");
            if (current != null) {
                current.affiche();
            }
            int fin1 = 1440;
            if (i != jour1.size() - 1) {
                fin1 = jour1.get(i + 1).getHeure();
                if (!jour1.get(i + 1).getDate().equals(tmp1.getDate())) {
                    fin1 += 1440;
                }
            }
            int fin2 = 1440;
            if (j != jour2.size() - 1) {
                fin2 = jour2.get(j + 1).getHeure();
                if (!jour2.get(j + 1).getDate().equals(tmp2.getDate())) {
                    fin2 += 1440;
                }
            }
            if (!tmp1Finished && tmp1.getDate().before(tmp2.getDate())) {
                if (current != null && Fonctions.isActiv(current.getTypeActivite()) && Fonctions.isActiv(tmp1.getTypeActivite()) && finCurrent > tmp1.getHeure()) {
                    TimsLogger.debug("#Fonctions.fusionDeuxJours#  tmp1 conflict with current (date+1)");
                    return null;
                }
                retour.add(tmp1);
                current = tmp1;
                currentFrom = 1;
                finCurrent = fin1;
                TimsLogger.debug("#Fonctions.fusionDeuxJours# (tmp1 day < tmp2 day) add ");
                tmp1.affiche();
                TimsLogger.debug(" whereas ");
                tmp2.affiche();
                if (i == jour1.size() - 1) {
                    tmp1Finished = true;
                    continue;
                }
                ++i;
                continue;
            }
            if (!tmp2Finished && tmp2.getDate().before(tmp1.getDate())) {
                if (current != null && Fonctions.isActiv(current.getTypeActivite()) && Fonctions.isActiv(tmp2.getTypeActivite()) && finCurrent > tmp2.getHeure()) {
                    TimsLogger.debug("#Fonctions.fusionDeuxJours#  tmp2 conflict with current (date+1)");
                    return null;
                }
                retour.add(tmp2);
                current = tmp2;
                currentFrom = 2;
                finCurrent = fin2;
                TimsLogger.debug("#Fonctions.fusionDeuxJours# (tmp2 day < tmp1 day) add ");
                tmp2.affiche();
                TimsLogger.debug(" whereas ");
                tmp1.affiche();
                if (j == jour2.size() - 1) {
                    tmp2Finished = true;
                    continue;
                }
                ++j;
                continue;
            }
            if (!tmp1Finished && (tmp1.getHeure() < tmp2.getHeure() || tmp2Finished)) {
                if (current != null && Fonctions.isActiv(current.getTypeActivite()) && Fonctions.isActiv(tmp1.getTypeActivite()) && finCurrent > tmp1.getHeure() && current.getDate().compareTo(tmp1.getDate()) == 0) {
                    return null;
                }
                if (current.getDate().before(tmp1.getDate()) && currentFrom == 2 && tmp1.getHeure() == 0 && tmp1.getTypeActivite() == 4) {
                    if (j == jour2.size() - 1) {
                        tmp2Finished = true;
                    } else {
                        ++i;
                    }
                    TimsLogger.debug("#Fonctions.fusionDeuxJours# cas particulier 1 : nothing i++");
                    continue;
                }
                if (current != null && Fonctions.isActiv(current.getTypeActivite()) && finCurrent > fin1 && current.getDate().compareTo(tmp1.getDate()) == 0) {
                    if (i == jour1.size() - 1) {
                        tmp1Finished = true;
                    } else {
                        ++i;
                    }
                    TimsLogger.debug("#Fonctions.fusionDeuxJours# cas particulier 2 : nothing i++");
                    continue;
                }
                retour.add(tmp1);
                current = tmp1;
                currentFrom = 1;
                finCurrent = fin1;
                TimsLogger.debug("#Fonctions.fusionDeuxJours# (tmp2 finished||tmp1<tmp2) add ");
                tmp1.affiche();
                TimsLogger.debug(" whereas ");
                tmp2.affiche();
                if (i == jour1.size() - 1) {
                    tmp1Finished = true;
                    continue;
                }
                ++i;
                continue;
            }
            if (!tmp2Finished && (tmp2.getHeure() < tmp1.getHeure() || tmp1Finished)) {
                if (current != null && Fonctions.isActiv(current.getTypeActivite()) && Fonctions.isActiv(tmp2.getTypeActivite()) && finCurrent > tmp2.getHeure() && current.getDate().compareTo(tmp2.getDate()) == 0) {
                    return null;
                }
                if (current.getDate().before(tmp2.getDate()) && currentFrom == 1 && tmp2.getHeure() == 0 && tmp2.getTypeActivite() == 4) {
                    if (j == jour2.size() - 1) {
                        tmp2Finished = true;
                    } else {
                        ++j;
                    }
                    TimsLogger.debug("#Fonctions.fusionDeuxJours# cas particulier 1 : nothing j++");
                    continue;
                }
                if (current != null && Fonctions.isActiv(current.getTypeActivite()) && finCurrent > fin2 && current.getDate().compareTo(tmp2.getDate()) == 0) {
                    if (j == jour2.size() - 1) {
                        tmp2Finished = true;
                    } else {
                        ++j;
                    }
                    TimsLogger.debug("#Fonctions.fusionDeuxJours# cas particulier 2 : nothing j++");
                    continue;
                }
                retour.add(tmp2);
                current = tmp2;
                currentFrom = 2;
                finCurrent = fin2;
                TimsLogger.debug("#Fonctions.fusionDeuxJours# (tmp1 finished||tmp2<tmp1) add ");
                tmp2.affiche();
                TimsLogger.debug(" whereas ");
                tmp1.affiche();
                if (j == jour2.size() - 1) {
                    tmp2Finished = true;
                    continue;
                }
                ++j;
                continue;
            }
            if (Fonctions.isActiv(tmp2.getTypeActivite()) && Fonctions.isActiv(tmp1.getTypeActivite()) && tmp2.getTypeActivite() != tmp1.getTypeActivite()) {
                return null;
            }
            retour.add(tmp1);
            current = tmp1;
            currentFrom = 0;
            TimsLogger.debug("#Fonctions.fusionDeuxJours# (same act) add ");
            tmp1.affiche();
            TimsLogger.debug(" whereas ");
            tmp2.affiche();
            if (i == jour1.size() - 1) {
                tmp1Finished = true;
            } else {
                ++i;
            }
            if (j == jour2.size() - 1) {
                tmp2Finished = true;
                continue;
            }
            ++j;
        }
        return retour;
    }

    public static boolean updateActivities(Vector<ChangementActivite> activities, Conducteur conducteur, int km, String comment, String sourceName) {
        boolean toReturn = true;
        Transport.bdd.startTransaction();
        TimsLogger.debug("#Fonctions.updateActivities# on modifie " + activities.size() + " activit\u00e9s");
        Date lastExport = null;
        if (System.getProperty("horoquartz", "0").equals("1")) {
            lastExport = BddTransport.getInstance().getLastExport(conducteur.getCleConducteur());
        }
        int conduite = 0;
        int travail = 0;
        int dispo = 0;
        int repos = 0;
        int de = 0;
        int inconnu = 0;
        int nuit = 0;
        int x = 0;
        int random = (int)(Math.random() * 1000.0);
        String dayFn = String.valueOf(Transport.savePath) + "jour" + random + ".txt";
        try {
            FileWriter fluxDay = new FileWriter(dayFn);
            Vector<ActiviteConducteur> tmpJour = new Vector<ActiviteConducteur>();
            while (x < activities.size()) {
                int duree;
                ChangementActivite tmp = activities.get(x);
                int heureFin = 1440;
                if (x != activities.size() - 1 && ConversionTime.dateToString(activities.get(x + 1).getDate(), "dd/MM/yyyy").equals(ConversionTime.dateToString(tmp.getDate(), "dd/MM/yyyy"))) {
                    heureFin = activities.get(x + 1).getHeure();
                }
                if ((duree = heureFin - tmp.getHeure()) != 0) {
                    tmpJour.add(new ActiviteConducteur(conducteur.getCleConducteur(), conducteur.getCleAgence(), tmp.getTypeActivite(), "", tmp.getHeure(), heureFin, duree, ConversionTime.dateToString(tmp.getDate(), "yyyy-MM-dd"), tmp.getSource(), tmp.getNomSource(), tmp.getEtatCarte(), tmp.getEtatConduite(), tmp.getLecteur(), 0));
                }
                if (x == activities.size() - 1 || !ConversionTime.dateToString(activities.get(x + 1).getDate(), "dd/MM/yyyy").equals(ConversionTime.dateToString(tmp.getDate(), "dd/MM/yyyy"))) {
                    String dateJour = ConversionTime.dateToString(activities.get(x).getDate(), "yyyy-MM-dd");
                    int debut = Integer.parseInt(Fonctions.getHeureDebut(tmpJour));
                    int fin = Integer.parseInt(Fonctions.getHeureFin(tmpJour));
                    if (!Transport.bdd.getJourCle(conducteur.getCleConducteur(), dateJour).equals("")) {
                        TimsLogger.debug("#Fonctions.updateActivities# jour existant = " + dateJour);
                        if (comment != null && !comment.equals("")) {
                            Fonctions.updateDay(conducteur, dateJour, tmpJour, comment, sourceName);
                        } else {
                            new GestionChevauchement(tmpJour, conducteur, dateJour, km, fluxDay, sourceName);
                        }
                    } else if (!conducteur.getDateSortie().equals("") && ConversionTime.compare(dateJour, conducteur.getDateSortie().substring(0, 10), "yyyy-MM-dd") > 0) {
                        TimsLogger.debug("#Fonctions.updateActivities# conducteur deja sorti =" + dateJour);
                    } else if (!conducteur.getDateEntree().equals("") && ConversionTime.compare(dateJour, conducteur.getDateEntree().substring(0, 10), "yyyy-MM-dd") < 0) {
                        TimsLogger.debug("#Fonctions.updateActivities# conducteur pas encore rentr\u00e9 =" + dateJour + " (" + conducteur.getDateEntree() + ")");
                    } else {
                        int y = 0;
                        while (y < tmpJour.size()) {
                            ActiviteConducteur act = tmpJour.get(y);
                            switch (act.getCleType()) {
                                case 1: {
                                    conduite += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 2: {
                                    travail += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 3: {
                                    dispo += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 4: {
                                    repos += act.getDuree();
                                    break;
                                }
                                case 5: {
                                    de += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 7: {
                                    inconnu += act.getDuree();
                                    break;
                                }
                                default: {
                                    TimsLogger.debug("#Fonctions.updateActivities# activit\u00e9s inconnue " + act.getCleType());
                                }
                            }
                            ++y;
                        }
                        Jour detailJour = new Jour(0, conducteur.getCleConducteur(), dateJour, conduite, travail, dispo, repos, de, inconnu, 0, conduite + travail + dispo + de, debut, fin, nuit, km, 0, false, tmpJour, comment, ConnexionSettings.getInstance().getUserCle(), sourceName, false);
                        if (!detailJour.insert()) {
                            throw new Exception("#Fonctions.updateActivities# impossible d'enregitrer le jour");
                        }
                        if (comment != null && !comment.equals("")) {
                            BddTransport.getInstance().addComment(conducteur.getCleConducteur(), dateJour, comment);
                        }
                        if (System.getProperty("horoquartz", "0").equals("1") && lastExport != null && (activities.get(x).getDate().before(lastExport) || activities.get(x).getDate().equals(lastExport))) {
                            BddTransport.getInstance().updateExportHoroquartz(conducteur.getCleConducteur(), detailJour.getDate());
                        }
                    }
                    conduite = 0;
                    travail = 0;
                    dispo = 0;
                    repos = 0;
                    de = 0;
                    inconnu = 0;
                    nuit = 0;
                    tmpJour.clear();
                }
                ++x;
            }
            fluxDay.close();
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                Transport.bdd.loadDay(dayFn);
            }
            new File(dayFn).delete();
            if (activities.size() > 0) {
                TraitementTempsService tts = new TraitementTempsService(conducteur, ConversionTime.dateToString(activities.get(0).getDate(), "yyyy-MM-dd"), ConversionTime.dateToString(activities.get(activities.size() - 1).getDate(), "yyyy-MM-dd"), true);
                tts.loadActivite();
                tts.calculService();
                tts.saveListe();
            }
        }
        catch (Exception ex) {
            Transport.bdd.rollback();
            toReturn = false;
            ex.printStackTrace();
        }
        if (toReturn) {
            Transport.bdd.commit();
        }
        return toReturn;
    }

    private static boolean updateDay(Conducteur driver, String day, Vector<ActiviteConducteur> activities, String reason, String source) throws IOException {
        Vector<Jour> days;
        int modification;
        block14: {
            modification = 0;
            try {
                days = BddTransport.getInstance().getJour(driver.getCleConducteur(), day, null, false, false, false);
                if (days.size() != 0) break block14;
                return false;
            }
            catch (DayException ex) {
                ex.printStackTrace();
                return false;
            }
        }
        modification = days.get(0).getUpdate();
        String comment = BddTransport.getInstance().getCommentJour(driver.getCleConducteur(), day);
        if (comment.equals("")) {
            BddTransport.getInstance().addComment(driver.getCleConducteur(), day, reason);
        } else {
            BddTransport.getInstance().updateComment(driver.getCleConducteur(), day, String.valueOf(comment) + "\r\n" + reason);
        }
        TimsLogger.debug("Act\u00e9s+ " + activities.size());
        int cleCond = driver.getCleConducteur();
        int cumulC = 0;
        int cumulD = 0;
        int cumulT = 0;
        int cumulDE = 0;
        int cumulR = 0;
        int cumulI = 0;
        int heureNuit = 0;
        for (ActiviteConducteur act : activities) {
            if (act.getDuree() == 0) continue;
            switch (act.getCleType()) {
                case 1: {
                    cumulC += act.getDuree();
                    heureNuit += Fonctions.getTempsNuit(act);
                    break;
                }
                case 2: {
                    cumulT += act.getDuree();
                    heureNuit += Fonctions.getTempsNuit(act);
                    break;
                }
                case 3: {
                    cumulD += act.getDuree();
                    heureNuit += Fonctions.getTempsNuit(act);
                    break;
                }
                case 4: {
                    cumulR += act.getDuree();
                    break;
                }
                case 5: {
                    cumulDE += act.getDuree();
                    heureNuit += Fonctions.getTempsNuit(act);
                    break;
                }
                case 7: {
                    cumulI += act.getDuree();
                }
            }
        }
        int cumul = cumulC + cumulT + cumulD + cumulDE;
        Integer heureDebut = Integer.parseInt(Fonctions.getHeureDebut(activities));
        Integer heureFin = Integer.parseInt(Fonctions.getHeureFin(activities));
        int km = -1;
        BddTransport.getInstance().prepareUpdateJour(ConnexionSettings.getInstance().getUserCle(), cleCond, day);
        Jour newDay = new Jour(0, cleCond, day, cumulC, cumulT, cumulD, cumulR, cumulDE, cumulI, 0, cumul, heureDebut, heureFin, heureNuit, km, modification + 1, false, activities, "", ConnexionSettings.getInstance().getUserCle(), source, false);
        return newDay.insert();
    }

    public static Date getDateHeureEte(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(2, 2);
        calendar.set(5, 31);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        while (calendar.get(7) != 1) {
            calendar.add(5, -1);
        }
        calendar.set(10, 0);
        return calendar.getTime();
    }

    public static Date getDateHeureHiver(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.set(2, 9);
        calendar.set(5, 31);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        while (calendar.get(7) != 1) {
            calendar.add(5, -1);
        }
        calendar.set(10, 0);
        return calendar.getTime();
    }

    public static int getTimeAdjustement(Date day) {
        Date jourHiverToEte = Fonctions.getDateHeureEte(day);
        Date jourEteToHiver = Fonctions.getDateHeureHiver(day);
        if (day.after(jourHiverToEte) && day.before(jourEteToHiver)) {
            return 120;
        }
        if (jourHiverToEte.equals(day)) {
            return 60;
        }
        return !jourEteToHiver.equals(day) ? 60 : 120;
    }

    public static void pause(int sec) {
        try {
            Thread.sleep(sec * 1000);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static int calculHeureNuit(Vector<ActiviteConducteur> activite) {
        int total = 0;
        int j = 0;
        while (j < activite.size()) {
            ActiviteConducteur tmp = activite.get(j);
            if (tmp.getCleType() == 1 || tmp.getCleType() == 2 || tmp.getCleType() == 3 || tmp.getCleType() == 5) {
                total += Fonctions.getTempsNuit(tmp);
            }
            ++j;
        }
        return total;
    }

    public static int getTempsNuit(ActiviteConducteur tmp) {
        int beginBetween = 1260;
        int endBetween = 360;
        if (System.getProperty("night.begin") != null) {
            beginBetween = Integer.parseInt(System.getProperty("night.begin").toString());
        }
        if (System.getProperty("night.end") != null) {
            endBetween = Integer.parseInt(System.getProperty("night.end").toString());
        }
        if (tmp.getHeureDebut() > beginBetween || tmp.getHeureFin() < endBetween) {
            return tmp.getDuree();
        }
        if (tmp.getHeureDebut() < endBetween) {
            if (tmp.getHeureFin() > beginBetween) {
                return endBetween - tmp.getHeureDebut() + tmp.getHeureFin() - beginBetween;
            }
            return endBetween - tmp.getHeureDebut();
        }
        if (tmp.getHeureFin() > beginBetween) {
            return tmp.getHeureFin() - beginBetween;
        }
        return 0;
    }

    public static int getTempsCumul(int debut, int fin, int limiteDebut, int limiteFin) {
        int retour = 0;
        if (debut >= limiteDebut && fin <= limiteFin) {
            retour = fin - debut;
        } else if (debut < limiteDebut && fin > limiteDebut) {
            retour = fin > limiteFin ? limiteFin - limiteDebut : fin - limiteDebut;
        }
        if (fin > limiteFin && debut < limiteFin) {
            retour = limiteFin - debut;
        }
        return retour;
    }

    public static int getTimeBetween(ActiviteConducteur tmp, int begin, int end) {
        if (begin <= end) {
            if (tmp.getHeureFin() <= begin || end <= tmp.getHeureDebut()) {
                return 0;
            }
            if (tmp.getHeureDebut() <= begin && end <= tmp.getHeureFin()) {
                return end - begin;
            }
            if (begin <= tmp.getHeureDebut() && tmp.getHeureFin() <= end) {
                return tmp.getDuree();
            }
            if (tmp.getHeureDebut() <= begin) {
                return tmp.getHeureFin() - begin;
            }
            if (tmp.getHeureFin() >= end) {
                return end - tmp.getHeureDebut();
            }
            return 0;
        }
        return Fonctions.getTimeBetween(tmp, begin, 1440) + Fonctions.getTimeBetween(tmp, 0, end);
    }

    public static String getHeureDebut(Vector<ActiviteConducteur> activiteListe) {
        String heureDebut = "0";
        ActiviteConducteur phase = null;
        int size = activiteListe.size();
        if (size != 0) {
            int i = 0;
            while (i < size) {
                phase = activiteListe.get(i);
                if (Fonctions.isActiv(phase.getCleType())) {
                    heureDebut = String.valueOf(phase.getHeureDebut());
                    break;
                }
                ++i;
            }
        }
        return heureDebut;
    }

    public static String getHeureFin(Vector<ActiviteConducteur> activiteListe) {
        String heureFin = "0";
        int size = activiteListe.size();
        if (size != 0) {
            int i = size - 1;
            while (i >= 0) {
                ActiviteConducteur phase = activiteListe.get(i);
                if (Fonctions.isActiv(phase.getCleType())) {
                    return String.valueOf(phase.getHeureFin());
                }
                --i;
            }
        }
        return heureFin;
    }

    public static boolean isActiv(int cleType) {
        return cleType == 1 || cleType == 2 || cleType == 3 || cleType == 5;
    }

    public static boolean isActiv(String cleType) {
        return cleType.equals("20") || cleType.equals("30") || cleType.equals("40") || cleType.equals("60");
    }

    public static void verifSaisieHeure(KeyEvent e, JTextField txt) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        if (keyCode == 8 || keyCode == 20 || keyCode == 16) {
            return;
        }
        if ((keyChar < '0' || keyChar > '9') && keyChar != 'H' && keyChar != 'h') {
            txt.setText(txt.getText().replace(String.valueOf(e.getKeyChar()), ""));
            return;
        }
        if (txt.getText().length() == 2) {
            if (keyChar == 'H' || keyChar == 'h') {
                txt.setText("0" + txt.getText().substring(0, 1) + "h");
            } else {
                txt.setText(String.valueOf(txt.getText()) + "h");
            }
        } else if (txt.getText().length() == 3) {
            txt.setText(String.valueOf(txt.getText().substring(0, 2)) + "h" + txt.getText().substring(2));
        } else if (txt.getText().length() >= 6) {
            txt.setText(txt.getText().substring(0, 5));
        }
    }

    public static boolean isInt(String text) {
        try {
            Integer.parseInt(text.replace(",", "."));
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isFloat(String text) {
        text = text.replace(" ", "").replace(",", ".");
        try {
            TimsLogger.debug("IsFloat " + Float.parseFloat(text));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Float parseFloat(String text) {
        text = text.replace(" ", "").replace(",", ".");
        try {
            return Float.valueOf(text.equals("") ? 0.0f : Float.parseFloat(text));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Float.valueOf(0.0f);
        }
    }

    public static void verifSaisieEntier(KeyEvent e, JTextField txt) {
        int keyCode = e.getKeyCode();
        char keyChar = e.getKeyChar();
        if (keyCode == 8 || keyCode == 20 || keyCode == 16) {
            return;
        }
        if (keyChar < '0' || keyChar > '9') {
            txt.setText(txt.getText().replace(String.valueOf(e.getKeyChar()), ""));
        }
    }

    public static boolean shouldAddExpensesByBeginEnd(ExpensesType tmp, Date day, int begin, int end) {
        int dayOfWeekEnd;
        if (tmp.getBeginBefore() == -1 && tmp.getBeginAfter() == -1 && tmp.getEndBefore() == -1 && tmp.getEndAfter() == -1) {
            return false;
        }
        boolean beginOnBadDay = false;
        boolean endOnBadDay = false;
        int dayOfWeekBegin = ConversionTime.getDayOfWeek(day, true) - 1;
        int n = dayOfWeekEnd = end < begin ? dayOfWeekBegin + 1 : dayOfWeekBegin;
        if (tmp.getEnabledDay() != null) {
            if (!tmp.getEnabledDay().contains(dayOfWeekBegin)) {
                beginOnBadDay = true;
            }
            if (!tmp.getEnabledDay().contains(dayOfWeekEnd)) {
                endOnBadDay = true;
            }
            if (beginOnBadDay && endOnBadDay) {
                return false;
            }
        }
        if (end < begin) {
            return Fonctions.shouldAddExpensesByBeginEnd(tmp, day, begin, end + 1440) || Fonctions.shouldAddExpensesByBeginEnd(tmp, day, begin - 1440, end);
        }
        if (tmp.getBeginAfter() != -1 && begin < tmp.getBeginAfter()) {
            return false;
        }
        if (tmp.getBeginBefore() != -1 && begin > tmp.getBeginBefore()) {
            return false;
        }
        if (tmp.getEndAfter() != -1 && end < tmp.getEndAfter()) {
            return false;
        }
        return tmp.getEndBefore() == -1 || end <= tmp.getEndBefore();
    }

    public static boolean shouldAddExpensesByAmount(ExpensesType tmpFrais, Vector<ActiviteConducteur> tmpAct, int indexBegin, int indexEnd) {
        if (tmpFrais.getCumulService() == 0) {
            return false;
        }
        int cumul = 0;
        int avant = tmpFrais.getCumulAvant();
        int apres = tmpFrais.getCumulApres();
        int debutJour = tmpAct.get(indexBegin).getHeureDebut();
        int finJour = tmpAct.get(indexEnd).getHeureFin();
        if (apres > avant) {
            if (finJour < debutJour) {
                avant += 1440;
            } else if (debutJour < avant) {
                apres -= 1440;
            } else if (finJour > apres) {
                avant += 1440;
            } else {
                return false;
            }
        }
        int x = indexBegin;
        while (x <= indexEnd) {
            ActiviteConducteur act = tmpAct.get(x);
            try {
                int percentage = TypeActivite.getActivityType(act.getCleType()).getPaidPercentage();
                int day = ConversionTime.getDayOfWeek(act.getDate(), true) - 1;
                if (tmpFrais.getEnabledDay() == null || tmpFrais.getEnabledDay().contains(day)) {
                    int timeIn;
                    if (!act.getDateJour().equals(tmpAct.get(indexBegin).getDateJour())) {
                        if (percentage != 0) {
                            timeIn = percentage * Fonctions.getTempsCumul(act.getHeureDebut() + 1440, act.getHeureFin() + 1440, apres, avant) / 100;
                            cumul += timeIn;
                        }
                    } else if (percentage != 0) {
                        timeIn = percentage * Fonctions.getTempsCumul(act.getHeureDebut(), act.getHeureFin(), apres, avant) / 100;
                        cumul += timeIn;
                    }
                }
            }
            catch (ActivityTypeNotFoundException ex) {
                TimsLogger.warn("#Fonctions.isFrais# Activit\u00e9 inconnue : " + act.getCleType());
            }
            ++x;
        }
        return cumul > tmpFrais.getCumulService();
    }

    public static boolean shouldAddExpensesByAmount(ExpensesType tmpFrais, int debutJour, int finJour, Vector<ChangementActivite> tmpAct) {
        if (tmpFrais.getCumulService() == 0) {
            return false;
        }
        int cumul = 0;
        int avant = tmpFrais.getCumulAvant();
        int apres = tmpFrais.getCumulApres();
        boolean zero = false;
        if (apres > avant) {
            if (finJour < debutJour) {
                avant += 1440;
            } else if (debutJour < avant) {
                apres -= 1440;
            } else if (finJour > apres) {
                avant += 1440;
            } else {
                return false;
            }
        }
        int x = 0;
        while (x < tmpAct.size()) {
            int fin;
            int debut = tmpAct.get(x).getHeure();
            int n = fin = x == tmpAct.size() - 1 ? 1440 : tmpAct.get(x + 1).getHeure();
            if (fin < debut) {
                fin += 1440;
                zero = true;
            } else if (zero) {
                debut += 1440;
                fin += 1440;
            }
            if (Fonctions.isActiv(tmpAct.get(x).getTypeActivite())) {
                cumul += Fonctions.getTempsCumul(debut, fin, apres, avant);
            }
            ++x;
        }
        return cumul > tmpFrais.getCumulService();
    }

    public static String getLibelleEventFault(int index) {
        if (index == 0 || index == 16 || index == 32 || index == 48 || index == 64) {
            return LanguageTranslator.getString("eventType.00");
        }
        if (index == 1) {
            return LanguageTranslator.getString("eventType.01");
        }
        if (index == 2) {
            return LanguageTranslator.getString("eventType.02");
        }
        if (index == 3) {
            return LanguageTranslator.getString("eventType.03");
        }
        if (index == 4) {
            return LanguageTranslator.getString("eventType.04");
        }
        if (index == 5) {
            return LanguageTranslator.getString("eventType.05");
        }
        if (index == 6) {
            return LanguageTranslator.getString("eventType.06");
        }
        if (index == 7) {
            return LanguageTranslator.getString("eventType.07");
        }
        if (index == 8) {
            return LanguageTranslator.getString("eventType.08");
        }
        if (index == 9) {
            return LanguageTranslator.getString("eventType.09");
        }
        if (index == 17) {
            return LanguageTranslator.getString("eventType.11");
        }
        if (index == 18) {
            return LanguageTranslator.getString("eventType.12");
        }
        if (index == 19) {
            return LanguageTranslator.getString("eventType.13");
        }
        if (index == 20) {
            return LanguageTranslator.getString("eventType.14");
        }
        if (index == 21) {
            return LanguageTranslator.getString("eventType.15");
        }
        if (index == 22) {
            return LanguageTranslator.getString("eventType.16");
        }
        if (index == 23) {
            return LanguageTranslator.getString("eventType.17");
        }
        if (index == 24) {
            return LanguageTranslator.getString("eventType.18");
        }
        if (index == 33) {
            return LanguageTranslator.getString("eventType.21");
        }
        if (index == 34) {
            return LanguageTranslator.getString("eventType.22");
        }
        if (index == 35) {
            return LanguageTranslator.getString("eventType.23");
        }
        if (index == 36) {
            return LanguageTranslator.getString("eventType.24");
        }
        if (index == 37) {
            return LanguageTranslator.getString("eventType.25");
        }
        if (index == 49) {
            return LanguageTranslator.getString("eventType.31");
        }
        if (index == 50) {
            return LanguageTranslator.getString("eventType.32");
        }
        if (index == 51) {
            return LanguageTranslator.getString("eventType.33");
        }
        if (index == 52) {
            return LanguageTranslator.getString("eventType.34");
        }
        if (index == 53) {
            return LanguageTranslator.getString("eventType.35");
        }
        if (index > 128 && 255 < index) {
            return LanguageTranslator.getString("eventType.80");
        }
        if (255 < index) {
            return LanguageTranslator.getString("eventType.FF", String.valueOf(index));
        }
        return LanguageTranslator.getString("eventType.RFU");
    }

    public static String getCategorieEventFault(int index) {
        if (index >= 1 && index <= 15) {
            return LanguageTranslator.getString("eventCategory.01");
        }
        if (index >= 17 && index <= 31) {
            return LanguageTranslator.getString("eventCategory.11");
        }
        if (index >= 33 && index <= 47) {
            return LanguageTranslator.getString("eventCategory.21");
        }
        if (index >= 49 && index <= 63) {
            return LanguageTranslator.getString("eventCategory.31");
        }
        if (index >= 65 && index <= 79) {
            return LanguageTranslator.getString("eventCategory.41");
        }
        return LanguageTranslator.getString("eventCategory.FF", String.valueOf(index));
    }

    public static String getRaisonEventFault(int index) {
        if (index == 0) {
            return LanguageTranslator.getString("eventReason.00");
        }
        if (index == 1) {
            return LanguageTranslator.getString("eventReason.01");
        }
        if (index == 2) {
            return LanguageTranslator.getString("eventReason.02");
        }
        if (index == 3) {
            return LanguageTranslator.getString("eventReason.03");
        }
        if (index == 4) {
            return LanguageTranslator.getString("eventReason.04");
        }
        if (index == 5) {
            return LanguageTranslator.getString("eventReason.05");
        }
        if (index == 6) {
            return LanguageTranslator.getString("eventReason.06");
        }
        if (index == 7) {
            return LanguageTranslator.getString("eventReason.07");
        }
        if (index == 8) {
            return LanguageTranslator.getString("eventReason.08");
        }
        if (index > 128 && 255 < index) {
            return LanguageTranslator.getString("eventReason.80");
        }
        if (255 < index) {
            return LanguageTranslator.getString("eventReason.FF", String.valueOf(index));
        }
        return LanguageTranslator.getString("eventReason.RUU");
    }

    public static boolean afficheCalendrier(JTextField clicked) {
        Point loc = clicked.getLocationOnScreen();
        loc.y += clicked.getHeight();
        JCalendrier.affiche(loc);
        if (JCalendrier.clicked()) {
            clicked.setText(JCalendrier.getDate());
            return true;
        }
        return false;
    }

    public static long bytesToInt(byte[] tmp) {
        return Fonctions.bytesToInt(tmp, 0, tmp.length);
    }

    public static int bytesToInt(byte[] buffer, int beginIndex, int length) {
        int result = 0;
        while (length > 0) {
            result += Fonctions.oneByteToInt(buffer[beginIndex++]) << --length * 8;
        }
        return result;
    }

    public static int oneByteToInt(byte b) {
        return b & 0xFF;
    }

    public static Jour dayTime(Vector<ActiviteConducteur> tmpJour, int cleCond, String dateJour, int cleAgence) {
        try {
            boolean manual = false;
            int conduite = 0;
            int travail = 0;
            int dispo = 0;
            int repos = 0;
            int de = 0;
            int inconnu = 0;
            int nuit = 0;
            int y = 0;
            while (y < tmpJour.size()) {
                ActiviteConducteur act = tmpJour.get(y);
                if (act.isManualInput()) {
                    manual = true;
                }
                switch (act.getCleType()) {
                    case 1: {
                        conduite += act.getDuree();
                        nuit += Fonctions.getTempsNuit(act);
                        break;
                    }
                    case 2: {
                        travail += act.getDuree();
                        nuit += Fonctions.getTempsNuit(act);
                        break;
                    }
                    case 3: {
                        dispo += act.getDuree();
                        nuit += Fonctions.getTempsNuit(act);
                        break;
                    }
                    case 4: {
                        repos += act.getDuree();
                        break;
                    }
                    case 5: {
                        de += act.getDuree();
                        nuit += Fonctions.getTempsNuit(act);
                        break;
                    }
                    case 7: {
                        inconnu += act.getDuree();
                        break;
                    }
                    default: {
                        TimsLogger.warn("activit\u00e9s inconnue " + act.getCleType());
                    }
                }
                ++y;
            }
            Jour detailJour = new Jour(0, cleCond, dateJour, conduite, travail, dispo, repos, de, inconnu, 0, conduite + travail + dispo + de, Integer.parseInt(Fonctions.getHeureDebut(tmpJour)), Integer.parseInt(Fonctions.getHeureFin(tmpJour)), nuit, 0, 0, false, tmpJour, "", ConnexionSettings.getInstance().getUserCle(), "", manual);
            return detailJour;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getFirstLetters(String var) {
        String toReturn = "";
        if (var == null || var.equals("")) {
            return toReturn;
        }
        String[] tmp = var.split(" ");
        int x = 0;
        while (x < tmp.length) {
            toReturn = String.valueOf(toReturn) + tmp[x].substring(0, 1);
            ++x;
        }
        return toReturn;
    }

    public static int[][] getCroppingParameters(String position) {
        int[][] retour = new int[6][2];
        int[][] defaultPosition = new int[][]{{80, 35}, {660, 35}, {80, 615}, {660, 615}, {80, 1195}, {660, 1195}};
        String[] tmp = position.split(";");
        int x = 0;
        while (x < 6) {
            if (x < tmp.length) {
                retour[x][0] = Integer.parseInt(tmp[x].split(",")[0]);
                retour[x][1] = Integer.parseInt(tmp[x].split(",")[1]);
            } else {
                retour[x][0] = defaultPosition[x][0];
                retour[x][0] = defaultPosition[x][0];
            }
            ++x;
        }
        TimsLogger.verbose("#Fonctions.getCroppingParameters#" + position);
        return retour;
    }

    public static String encryptPassword(String pwd, String key) {
        int x = 0;
        while (pwd.length() > key.length()) {
            key = String.valueOf(key) + key.charAt(x % key.length());
            ++x;
        }
        StringBuffer sPwd = new StringBuffer();
        x = 0;
        while (x < pwd.length()) {
            char xChar = (char)(pwd.charAt(x) ^ key.charAt(x));
            sPwd.append(xChar);
            ++x;
        }
        return Fonctions.parseAscii(sPwd.toString());
    }

    public static String decryptPassword(String encryptedPwd, String key) {
        String sPwd = Fonctions.parseString(encryptedPwd);
        int x = 0;
        while (sPwd.length() > key.length()) {
            key = String.valueOf(key) + key.charAt(x);
            ++x;
        }
        StringBuffer sbPwd = new StringBuffer();
        x = 0;
        while (x < sPwd.length()) {
            char xChar = (char)(sPwd.charAt(x) ^ key.charAt(x));
            sbPwd.append(xChar);
            ++x;
        }
        TimsLogger.debug("Decrypt " + encryptedPwd + " with " + key + " = " + sbPwd.toString());
        return sbPwd.toString();
    }

    public static String getDecryptKey() {
        String USER_AGENT = "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36";
        String URL2 = "http://" + System.getProperty("HOME_PATH") + "get_key.php?id=" + ConnexionSettings.getInstance().getUserCle();
        String toReturn = null;
        try {
            String inputLine;
            URL obj = new URL(URL2);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.103 Safari/537.36");
            int responseCode = con.getResponseCode();
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            toReturn = response.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return toReturn;
    }

    public static String ciphering(String cipherKey, String entry) {
        try {
            SecureRandom sr = new SecureRandom(cipherKey.getBytes("UTF-8"));
            KeyGenerator kGen = KeyGenerator.getInstance("DESEDE");
            kGen.init(168, sr);
            SecretKey key = kGen.generateKey();
            Cipher cipher = Cipher.getInstance("DESEDE");
            cipher.init(1, key);
            byte[] texteClaire = entry.getBytes();
            byte[] texteCrypte = cipher.doFinal(texteClaire);
            return new BASE64Encoder().encode(texteCrypte);
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur lors de l'encryptage des donnees");
            e.printStackTrace();
            return "";
        }
    }

    public static String deciphering(String cipherKey, String entry) {
        try {
            SecureRandom sr = new SecureRandom(cipherKey.getBytes("UTF-8"));
            KeyGenerator kGen = KeyGenerator.getInstance("DESEDE");
            kGen.init(168, sr);
            SecretKey key = kGen.generateKey();
            Cipher cipher = Cipher.getInstance("DESEDE");
            cipher.init(2, key);
            byte[] texteCrypte = new BASE64Decoder().decodeBuffer(entry);
            byte[] texteClaire = cipher.doFinal(texteCrypte);
            return new String(texteClaire);
        }
        catch (Exception e) {
            TimsLogger.warn("Erreur lors du d\u00e9cryptage des donnees");
            e.printStackTrace();
            return "";
        }
    }

    public static String md5ciphering(String key) {
        byte[] uniqueKey = key.getBytes();
        byte[] hash = null;
        try {
            hash = MessageDigest.getInstance("MD5").digest(uniqueKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("no MD5 support in this VM");
        }
        StringBuffer hashString = new StringBuffer();
        int i = 0;
        while (i < hash.length) {
            String hex = Integer.toHexString(hash[i]);
            if (hex.length() == 1) {
                hashString.append('0');
                hashString.append(hex.charAt(hex.length() - 1));
            } else {
                hashString.append(hex.substring(hex.length() - 2));
            }
            ++i;
        }
        return hashString.toString();
    }

    public static void centrerTable(JTable table) {
        DefaultTableCellRenderer custom = new DefaultTableCellRenderer();
        custom.setHorizontalAlignment(0);
        int i = 0;
        while (i < table.getColumnCount()) {
            if (table.getModel().getColumnClass(i) != Boolean.class) {
                table.getColumnModel().getColumn(i).setCellRenderer(custom);
            }
            ++i;
        }
    }

    public Vector<String> getIps() {
        Vector<String> ips = new Vector<String>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface interfaceN = interfaces.nextElement();
                Enumeration<InetAddress> ienum = interfaceN.getInetAddresses();
                while (ienum.hasMoreElements()) {
                    InetAddress ia = ienum.nextElement();
                    String adress = ia.getHostAddress().toString();
                    if (adress.startsWith("127")) continue;
                    ips.add(adress);
                }
            }
        }
        catch (Exception e) {
            TimsLogger.warn("pas de carte reseau");
            e.printStackTrace();
        }
        return ips;
    }

    public static URL getURL(String domain, String path) throws UnsupportedEncodingException, MalformedURLException {
        return Fonctions.getURL(domain, path, null);
    }

    public static URL getURL(String domain, String path, String params) throws UnsupportedEncodingException, MalformedURLException {
        TimsLogger.debug("#Fonctions.getURL# encoding " + path);
        if (path.startsWith("http")) {
            URL toSplit = new URL(path);
            TimsLogger.debug("#Fonctions.getURL# Le path contient le domaine, on le s\u00e9pare : " + toSplit.getHost() + " " + toSplit.getProtocol() + " " + toSplit.getPort() + " (" + toSplit.toString() + ")");
            domain = String.valueOf(toSplit.getProtocol()) + "://" + toSplit.getHost() + (toSplit.getPort() == -1 ? "" : ":" + toSplit.getPort()) + "/";
            path = toSplit.getPath().substring(1);
        }
        if (domain == null) {
            TimsLogger.debug("#Fonctions.getURL# Domaine non renseign\u00e9, on ajoute http://" + System.getProperty("HOME_PATH"));
            if (System.getProperty("HOME_PATH") == null) {
                throw new MalformedURLException("Can't invoke getURL on a local version without domain");
            }
            domain = "http://" + System.getProperty("HOME_PATH");
        }
        path = Fonctions.encode(path);
        params = Fonctions.encode(params);
        String result = String.valueOf(domain) + path + (params != null ? "/" + params : "");
        TimsLogger.debug("#Fonctions.getURL# Retourne " + result);
        return new URL(result);
    }

    private static String encode(String toEncode) {
        if (toEncode == null) {
            return null;
        }
        toEncode = toEncode.replace("\\", "/").replace(" ", "%20").replace("\u00e1", "%c3%a1").replace("\u00e2", "%c3%a2").replace("\u00e3", "%c3%a3").replace("\u00e4", "%c3%a4").replace("\u00e5", "%c3%a5").replace("\u00e7", "%c3%a7").replace("\u00e8", "%c3%a8").replace("\u00e9", "%c3%a9").replace("\u00ea", "%c3%aa").replace("\u00eb", "%c3%ab").replace("\u00ec", "%c3%ac").replace("\u00ed", "%c3%ad").replace("\u00ee", "%c3%ae").replace("\u00ef", "%c3%af").replace("\u00f0", "%c3%b0").replace("\u00f1", "%c3%b1").replace("\u00f2", "%c3%b2").replace("\u00f3", "%c3%b3").replace("\u00f4", "%c3%b4").replace("\u00f5", "%c3%b5").replace("\u00f6", "%c3%b6").replace("\u00f9", "%c3%b9").replace("\u00fa", "%c3%ba").replace("\u00fb", "%c3%bb").replace("\u00fc", "%c3%bc").replace("\u00fd", "%c3%bd").replace("\u00ff", "%c3%bf").replace("\u0152", "%c5%92").replace("\u0153", "%c5%93").replace("\u00c0", "%c3%80").replace("\u00c1", "%c3%81").replace("\u00c2", "%c3%82").replace("\u00c3", "%c3%83").replace("\u00c4", "%c3%84").replace("\u00c5", "%c3%85").replaceAll("\u00c6", "%c3%86").replaceAll("\u00c7", "%c3%87").replace("\u00c8", "%c3%88").replace("\u00c9", "%c3%89").replace("\u00ca", "%c3%8a").replace("\u00cb", "%c3%8b").replace("\u00cc", "%c3%8c").replace("\u00cd", "%c3%8d").replace("\u00ce", "%c3%8e").replace("\u00cf", "%c3%8f").replace("\u00d1", "%c3%91").replace("\u00d2", "%c3%92").replace("\u00d3", "%c3%93").replace("\u00d4", "%c3%94").replace("\u00d5", "%c3%95").replace("\u00d6", "%c3%96").replace("\u00d9", "%c3%99").replace("\u00da", "%c3%9a").replace("\u00db", "%c3%9b").replace("\u00dc", "%c3%9c").replace("\u00e6", "%c3%a6");
        return toEncode;
    }

    public static Vector<Integer> reorder(Vector<Service> tmpS, Vector<LienJourConducteur> tmpL) {
        Vector<Integer> tmp = new Vector<Integer>();
        int a = 0;
        if (tmpS != null) {
            for (Service s : tmpS) {
                if (tmp.contains(s.getDriverId())) continue;
                tmp.add(s.getDriverId());
            }
        }
        if (tmpL != null) {
            int id = 0;
            for (LienJourConducteur ljc : tmpL) {
                if (id == ljc.getCleConducteur()) continue;
                if (!tmp.contains(ljc.getCleConducteur())) {
                    tmp.add(a, ljc.getCleConducteur());
                    id = ljc.getCleConducteur();
                } else {
                    id = ljc.getCleConducteur();
                }
                a = tmp.indexOf(id) + 1;
            }
        }
        TimsLogger.debug("#Fonctions.reorder# " + tmp);
        return tmp;
    }

    /*
     * Exception decompiling
     */
    public static String FTPTransfer(File ... toTransfer) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [31[WHILELOOP]], but top level block is 8[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean loadProperty(String ... toLoad) {
        boolean toReturn = true;
        String[] stringArray = toLoad;
        int n = toLoad.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            try {
                FileInputStream in = new FileInputStream(file);
                Properties props = new Properties();
                props.load(in);
                for (Map.Entry<Object, Object> property : props.entrySet()) {
                    System.setProperty(property.getKey().toString(), property.getValue().toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return toReturn;
    }

    public static boolean loadLibrary(String ... toLoad) {
        boolean toReturn = true;
        String[] stringArray = toLoad;
        int n = toLoad.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            String path = String.valueOf(System.getProperty("user.dir")) + "\\lib\\";
            if (System.getProperty("HOME_PATH") != null) {
                path = Transport.savePath;
                try {
                    FileManager.getServerFile("http://" + System.getProperty("HOME_PATH") + "lib/" + file, String.valueOf(path) + file);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, LanguageTranslator.getString("message.dllUpdateError", file, LanguageTranslator.getString("exception.io")), LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(4)) + "1"), 0);
                    ex.printStackTrace();
                    return false;
                }
                catch (SecurityException ex) {
                    JOptionPane.showMessageDialog(null, LanguageTranslator.getString("message.dllUpdateError", file, LanguageTranslator.getString("exception.security")), LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(4)) + "1"), 0);
                    ex.printStackTrace();
                    return false;
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(null, LanguageTranslator.getString("message.dllUpdateError", file, LanguageTranslator.getString("exception.unknown")), LanguageTranslator.getString("message.numberedError", String.valueOf(String.valueOf(4)) + "1"), 0);
                    ex.printStackTrace();
                    return false;
                }
            }
            try {
                TimsLogger.debug("#Fonctions.loadLibrary# try to load " + path + file);
                System.load(String.valueOf(path) + file);
            }
            catch (UnsatisfiedLinkError e) {
                e.printStackTrace();
                String[] param1 = new String[]{file, LanguageTranslator.getString("exception.load")};
                String[] param = new String[]{String.valueOf(String.valueOf(4)) + "0"};
                JOptionPane.showMessageDialog(null, LanguageTranslator.getString("message.dllUpdateError", param1), LanguageTranslator.getString("message.numberedError", param), 0);
                toReturn = false;
            }
            ++n2;
        }
        return toReturn;
    }

    public static JSlider getSlider(int type, int minValue, int maxValue, int defaultValue, int majorTicksSpacing, int minorTicksSpacing, String accessibleName, boolean paintTicks, boolean paintLabel, boolean snapToTicks, ChangeListener listener) {
        JSlider tmp = new JSlider(type, minValue, maxValue, defaultValue);
        tmp.getAccessibleContext().setAccessibleName(accessibleName);
        tmp.getAccessibleContext().setAccessibleDescription(accessibleName);
        tmp.setPaintTicks(paintTicks);
        tmp.addChangeListener(listener);
        tmp.setMajorTickSpacing(majorTicksSpacing);
        tmp.setMinorTickSpacing(minorTicksSpacing);
        tmp.setPaintLabels(paintLabel);
        tmp.setSnapToTicks(snapToTicks);
        return tmp;
    }

    public static boolean fieldChange(Object dbValue, Object formValue) {
        if ((dbValue == null || dbValue.equals("") || dbValue.toString().startsWith("1970-01-01")) && (formValue == null || formValue.equals("") || formValue.toString().startsWith("1970-01-01"))) {
            return false;
        }
        return formValue == null || !formValue.equals(dbValue);
    }

    public static void loadDayType() {
        try {
            GetFile tmp = new GetFile();
            SwingUtilities.invokeAndWait(tmp);
            if (tmp.getPath() != null) {
                File toInsert = tmp.getPath();
                Vector<String[]> toProcess = ExcelReading.convertXlsToArray(toInsert, true);
                for (String[] csvLine : toProcess) {
                    JourType toAdd = new JourType(0, csvLine[1], csvLine[0], Color.black.getRGB(), 420, true, false, false, false, 420, true, false, false, 0, false, false, 0);
                    toAdd.insert();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public static void loadExpensesType() {
        try {
            GetFile tmp = new GetFile();
            SwingUtilities.invokeAndWait(tmp);
            if (tmp.getPath() != null) {
                File toInsert = tmp.getPath();
                Vector<String[]> toProcess = ExcelReading.convertXlsToArray(toInsert, true);
                for (String[] csvLine : toProcess) {
                    ExpensesType toAdd = new ExpensesType(0, csvLine[1], csvLine[0], 0, 0, 0, 0, 0, 0, 0, 0, 0, false, false, false, 0.0f, 0.0f, 0, 0, false, false, null, null, 0, 0, false);
                    toAdd.insert();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public static int restLength(int offsetWeeklyRestBegin, Vector<ActiviteConducteur> activities) {
        int toReturn = 0;
        ActiviteConducteur activite = activities.get(offsetWeeklyRestBegin);
        try {
            while (offsetWeeklyRestBegin < activities.size() - 1 && TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                toReturn += activite.getDuree();
                activite = activities.get(++offsetWeeklyRestBegin);
            }
            if (offsetWeeklyRestBegin == activities.size() && TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                toReturn += activite.getDuree();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public static void acquireStradaFile() {
        try {
            GetFile tmp = new GetFile();
            SwingUtilities.invokeAndWait(tmp);
            if (tmp.getPath() != null) {
                String name = null;
                String firstName = null;
                File toInsert = tmp.getPath();
                Vector<String[]> toProcess = CsvReading.convertCsvToArray(toInsert, false);
                Vector<ChangementActivite> activities = new Vector<ChangementActivite>();
                for (String[] csvLine : toProcess) {
                    TimsLogger.debug("#Fonctions.acquireStradaFile#" + csvLine[1].substring(17, 19));
                    if (!csvLine[1].substring(17, 19).equals("00")) {
                        TimsLogger.debug("#Fonctions.acquireStradaFile# continue");
                        continue;
                    }
                    int nameIndex = 6;
                    if (csvLine[5].equals("2001")) {
                        nameIndex += 2;
                    }
                    TimsLogger.debug("#Fonctions.acquireStradaFile# to split " + csvLine[nameIndex]);
                    firstName = csvLine[nameIndex].split(" ")[0];
                    name = csvLine[nameIndex].split(" ")[1];
                    int activity = 4;
                    if (csvLine[0].equals("0004")) {
                        activity = 1;
                    }
                    if (csvLine[0].equals("0003")) {
                        activity = 2;
                    }
                    int hour = ConversionTime.heureStringToInt(csvLine[1].substring(11, 16), ":");
                    Date date = ConversionTime.stringToDate(csvLine[1].substring(0, 10), "dd/MM/yyyy");
                    if (activities.size() == 0 || activities.get(activities.size() - 1).getDate().before(date)) {
                        if (activities.size() != 0) {
                            ChangementActivite close = (ChangementActivite)activities.get(activities.size() - 1).clone();
                            close.setHeure(close.getHeure() + 10);
                            close.setTypeActivite(4);
                            activities.add(close);
                        }
                        if (hour != 0) {
                            activities.add(new ChangementActivite(4, date, 0, "", "", "", "", ""));
                        }
                    }
                    if (hour == 0) {
                        activity = 4;
                    }
                    activities.add(new ChangementActivite(activity, date, hour, "", "", "", "", ""));
                }
                TimsLogger.debug("#Fonctions.acquireStradaFile# on cherche " + name + " " + firstName);
                Conducteur toLoad = new Conducteur();
                if (!toLoad.loadByName(name, firstName)) {
                    toLoad.setNom(name);
                    toLoad.setMatricule("");
                    toLoad.setPrenom(firstName);
                    toLoad.setCleAgence(2);
                    if (!toLoad.insert()) {
                        TimsLogger.debug("#Fonctions.acquireStradaFile# impossible d'ins\u00e9rer le conducteur");
                    }
                    toLoad.setDateSortie("");
                    toLoad.setDateEntree("");
                }
                Fonctions.saveActivities(activities, toLoad, 0, toInsert.getName());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
    }

    public static void saveActivities(Vector<ChangementActivite> activities, Conducteur conducteur, int km, String source) {
        TimsLogger.debug("#Fonctions.saveActivities# on sauvegarde " + activities.size() + " activit\u00e9s");
        try {
            int random = (int)(Math.random() * 1000.0);
            String dayFn = String.valueOf(Transport.savePath) + "jour" + random + ".txt";
            while (new File(dayFn).exists()) {
                random = (int)(Math.random() * 1000.0);
                dayFn = String.valueOf(Transport.savePath) + "activite" + random + ".txt";
            }
            FileWriter fluxDay = new FileWriter(dayFn);
            Date lastExport = null;
            if (System.getProperty("horoquartz", "0").equals("1")) {
                lastExport = BddTransport.getInstance().getLastExport(conducteur.getCleConducteur());
            }
            int conduite = 0;
            int travail = 0;
            int dispo = 0;
            int repos = 0;
            int de = 0;
            int inconnu = 0;
            int nuit = 0;
            int x = 0;
            Vector<ActiviteConducteur> tmpJour = new Vector<ActiviteConducteur>();
            while (x < activities.size()) {
                int duree;
                ChangementActivite tmp = activities.get(x);
                int heureFin = 1440;
                if (x != activities.size() - 1 && ConversionTime.dateToString(activities.get(x + 1).getDate(), "dd/MM/yyyy").equals(ConversionTime.dateToString(tmp.getDate(), "dd/MM/yyyy"))) {
                    heureFin = activities.get(x + 1).getHeure();
                }
                if ((duree = heureFin - tmp.getHeure()) != 0) {
                    tmpJour.add(new ActiviteConducteur(conducteur.getCleConducteur(), conducteur.getCleAgence(), tmp.getTypeActivite(), "", tmp.getHeure(), heureFin, duree, ConversionTime.dateToString(tmp.getDate(), "yyyy-MM-dd"), tmp.getSource(), tmp.getNomSource(), tmp.getEtatCarte(), tmp.getEtatConduite(), tmp.getLecteur(), 0));
                }
                if (x == activities.size() - 1 || !ConversionTime.dateToString(activities.get(x + 1).getDate(), "dd/MM/yyyy").equals(ConversionTime.dateToString(tmp.getDate(), "dd/MM/yyyy"))) {
                    String dateJour = ConversionTime.dateToString(activities.get(x).getDate(), "yyyy-MM-dd");
                    boolean manualInput = false;
                    int debut = Integer.parseInt(Fonctions.getHeureDebut(tmpJour));
                    int fin = Integer.parseInt(Fonctions.getHeureFin(tmpJour));
                    if (Transport.bdd.getJourCle(conducteur.getCleConducteur(), dateJour) != "") {
                        new GestionChevauchement(tmpJour, conducteur, dateJour, km, fluxDay, source);
                    } else if (!conducteur.getDateSortie().equals("") && ConversionTime.compare(dateJour, conducteur.getDateSortie().substring(0, 10), "yyyy-MM-dd") > 0) {
                        TimsLogger.debug("#Fonctions.saveActivities# conducteur deja sorti =" + dateJour);
                    } else if (!conducteur.getDateEntree().equals("") && ConversionTime.compare(dateJour, conducteur.getDateEntree().substring(0, 10), "yyyy-MM-dd") < 0) {
                        TimsLogger.debug("#Fonctions.saveActivities# conducteur pas encore rentr\u00e9 =" + dateJour + " (" + conducteur.getDateEntree() + ")");
                    } else {
                        for (ActiviteConducteur act : tmpJour) {
                            if (act.isManualInput()) {
                                manualInput = true;
                            }
                            switch (act.getCleType()) {
                                case 1: {
                                    conduite += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 2: {
                                    travail += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 3: {
                                    dispo += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 4: {
                                    repos += act.getDuree();
                                    break;
                                }
                                case 5: {
                                    de += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 7: {
                                    inconnu += act.getDuree();
                                    break;
                                }
                                default: {
                                    TimsLogger.warn("#Fonctions.saveActivities# activit\u00e9s inconnue " + act.getCleType());
                                }
                            }
                        }
                        Jour detailJour = new Jour(0, conducteur.getCleConducteur(), dateJour, conduite, travail, dispo, repos, de, inconnu, 0, conduite + travail + dispo + de, debut, fin, nuit, km, 0, false, tmpJour, "", ConnexionSettings.getInstance().getUserCle(), source, manualInput);
                        if (System.getProperty("SGBDR", "mysql").equals("oracle") && !detailJour.insert()) {
                            TimsLogger.warn("#Fonctions.saveActivities# impossible d'enregitrer le jour");
                            return;
                        }
                        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                            fluxDay.write(detailJour.getSQLInsert());
                            fluxDay.write("\n");
                        }
                        if (System.getProperty("horoquartz", "0").equals("1") && lastExport != null && (activities.get(x).getDate().before(lastExport) || activities.get(x).getDate().equals(lastExport))) {
                            BddTransport.getInstance().updateExportHoroquartz(conducteur.getCleConducteur(), detailJour.getDate());
                        }
                    }
                    conduite = 0;
                    travail = 0;
                    dispo = 0;
                    repos = 0;
                    de = 0;
                    inconnu = 0;
                    nuit = 0;
                    tmpJour.clear();
                }
                ++x;
            }
            fluxDay.close();
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                Transport.bdd.loadDay(dayFn);
            }
            new File(dayFn).delete();
            if (activities.size() > 0) {
                TraitementTempsService tts = new TraitementTempsService(conducteur, ConversionTime.dateToString(activities.get(0).getDate(), "yyyy-MM-dd"), ConversionTime.dateToString(activities.get(activities.size() - 1).getDate(), "yyyy-MM-dd"), true);
                TimsLogger.debug("updateActivities# update service");
                tts.loadActivite();
                tts.calculService();
                tts.saveListe();
            }
        }
        catch (ServiceException ex) {
            ex.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int saveDriverActivities(Vector<ActiviteConducteur> toInsert, Conducteur driver, int km, String source) {
        Transport.bdd.startTransaction();
        int random = (int)(Math.random() * 1000.0);
        String dayFn = String.valueOf(Transport.savePath) + "jour" + random + ".txt";
        while (new File(dayFn).exists()) {
            random = (int)(Math.random() * 1000.0);
            dayFn = String.valueOf(Transport.savePath) + "activite" + random + ".txt";
        }
        try {
            FileWriter fluxDay = new FileWriter(dayFn);
            ProgressBar progression = new ProgressBar(MainFrameTransport.getInstance(), LanguageTranslator.getString("activity.transfer", driver.getNom()));
            if (Transport.apiMode == 0) {
                progression.setVisible(true);
                progression.getBar().setMinimum(0);
                progression.getBar().setMaximum(toInsert.size() + 3);
            }
            int x = 0;
            Vector<ActiviteConducteur> tmpJour = new Vector<ActiviteConducteur>();
            int conduite = 0;
            int travail = 0;
            int dispo = 0;
            int repos = 0;
            int de = 0;
            int inconnu = 0;
            int nuit = 0;
            Date lastExport = null;
            if (System.getProperty("horoquartz", "0").equals("1")) {
                lastExport = BddTransport.getInstance().getLastExport(driver.getCleConducteur());
            }
            while (x < toInsert.size()) {
                TimsLogger.debug("saveDriverActivities# on gere l'activit\u00e9 " + x);
                if (Transport.apiMode == 0) {
                    progression.getBar().setValue(x);
                }
                tmpJour.add(toInsert.get(x));
                if (x == toInsert.size() - 1 || !ConversionTime.dateToString(toInsert.get(x + 1).getDate(), "dd/MM/yyyy").equals(ConversionTime.dateToString(toInsert.get(x).getDate(), "dd/MM/yyyy"))) {
                    TimsLogger.debug("saveDriverActivities# on sauvegarde le " + toInsert.get(x).getDate());
                    String dateJour = ConversionTime.dateToString(toInsert.get(x).getDate(), "yyyy-MM-dd");
                    boolean manualInput = false;
                    int debut = Integer.parseInt(Fonctions.getHeureDebut(tmpJour));
                    int fin = Integer.parseInt(Fonctions.getHeureFin(tmpJour));
                    if (!driver.getDateSortie().equals("") && ConversionTime.compare(dateJour, driver.getDateSortie().substring(0, 10), "yyyy-MM-dd") > 0) {
                        TimsLogger.debug("#CardDriverData.stockActivite# conducteur deja sorti =" + dateJour);
                    } else if (Transport.bdd.getJourCle(driver.getCleConducteur(), dateJour) != "") {
                        new GestionChevauchement(tmpJour, driver, dateJour, km, fluxDay, source);
                    } else if (!driver.getDateEntree().equals("") && ConversionTime.compare(dateJour, driver.getDateEntree().substring(0, 10), "yyyy-MM-dd") < 0) {
                        TimsLogger.debug("#CardDriverData.stockActivite# conducteur pas encore rentr\u00e9 =" + dateJour + " (" + driver.getDateEntree() + ")");
                    } else {
                        for (ActiviteConducteur act : tmpJour) {
                            if (act.isManualInput()) {
                                manualInput = true;
                            }
                            switch (act.getCleType()) {
                                case 1: {
                                    conduite += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 2: {
                                    travail += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 3: {
                                    dispo += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 4: {
                                    repos += act.getDuree();
                                    break;
                                }
                                case 5: {
                                    de += act.getDuree();
                                    nuit += Fonctions.getTempsNuit(act);
                                    break;
                                }
                                case 7: {
                                    inconnu += act.getDuree();
                                    break;
                                }
                                default: {
                                    TimsLogger.warn("#DCP.stockActivite()# activit\u00e9s inconnue " + act.getCleType());
                                }
                            }
                        }
                        Jour detailJour = new Jour(0, driver.getCleConducteur(), dateJour, conduite, travail, dispo, repos, de, inconnu, 0, conduite + travail + dispo + de, debut, fin, nuit, km, 0, false, tmpJour, "", ConnexionSettings.getInstance().getUserCle(), source, manualInput);
                        if (System.getProperty("SGBDR", "mysql").equals("oracle") && !detailJour.insert()) {
                            TimsLogger.warn("#DCP.stockActivite()# unable to save day");
                            Fonctions.deleteFile(dayFn);
                            return 4;
                        }
                        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                            TimsLogger.debug("to Hex : " + detailJour.getDate() + " => " + Fonctions.parseHexAscii(ActiviteConducteur.toCondensed(tmpJour), 0, -1));
                            fluxDay.write(detailJour.getSQLInsert());
                            fluxDay.write("\n");
                        }
                        if (System.getProperty("horoquartz", "0").equals("1") && lastExport != null && (toInsert.get(0).getDate().before(lastExport) || toInsert.get(0).getDate().equals(lastExport))) {
                            BddTransport.getInstance().updateExportHoroquartz(driver.getCleConducteur(), detailJour.getDate());
                        }
                    }
                    conduite = 0;
                    travail = 0;
                    dispo = 0;
                    repos = 0;
                    de = 0;
                    inconnu = 0;
                    nuit = 0;
                    tmpJour.clear();
                }
                ++x;
            }
            TimsLogger.debug("saveDriverActivities# on enregistre les informations");
            fluxDay.close();
            if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                Transport.ps.startOperation();
                if (Transport.apiMode == 0) {
                    progression.getBar().setValue(toInsert.size() + 1);
                    progression.getBar().setString(LanguageTranslator.getString("card.activitySaving"));
                }
                Transport.ps.endOperation(PerformanceScanner.INSERT, "card activity");
                Transport.ps.startOperation();
                if (Transport.apiMode == 0) {
                    progression.getBar().setValue(toInsert.size() + 2);
                    progression.getBar().setString(LanguageTranslator.getString("card.daySaving"));
                }
                Transport.bdd.loadDay(dayFn);
                Transport.ps.endOperation(PerformanceScanner.INSERT, "card day");
            }
            if (Transport.apiMode == 0) {
                progression.getBar().setValue(toInsert.size() + 3);
                progression.getBar().setString(LanguageTranslator.getString("card.serviceUpdating"));
            }
            TraitementTempsService tts = new TraitementTempsService(driver, toInsert.get(0).getDateJour(), toInsert.get(toInsert.size() - 1).getDateJour(), true);
            TimsLogger.debug("saveDriverActivities# on recalcule les services");
            tts.loadActivite();
            tts.calculService();
            tts.saveListe();
            if (Transport.apiMode == 0) {
                progression.dispose();
            }
            TimsLogger.debug("saveDriverActivities# on valide tout");
            Transport.bdd.commit();
        }
        catch (Exception ex) {
            TimsLogger.error("Fonctions.saveDriverActivities# Error on saving activities" + ex.getMessage());
            ex.printStackTrace();
            return 4;
        }
        Fonctions.deleteFile(dayFn);
        return 2;
    }

    public static boolean activiteCorrection(int driverId, String begin, String end) {
        try {
            CorrectionActiviteDetail tts = new CorrectionActiviteDetail(driverId, begin, end);
            tts.loadActivite();
            tts.calculService();
            tts.saveListe();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean reloadService(int driverId, String begin, String end) {
        try {
            TraitementTempsService tts = new TraitementTempsService(driverId, begin, end, true);
            tts.loadActivite();
            tts.calculService();
            tts.saveListe();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
        return true;
    }

    public static void deleteFile(String ... toDelete) {
        String[] stringArray = toDelete;
        int n = toDelete.length;
        int n2 = 0;
        while (n2 < n) {
            String tmp = stringArray[n2];
            new File(tmp).delete();
            ++n2;
        }
    }

    public static String vectorToString(Vector<?> list, String separator) {
        String toReturn = "";
        if (list == null || list.size() == 0) {
            return toReturn;
        }
        for (Object item : list) {
            toReturn = String.valueOf(toReturn) + separator + item.toString();
        }
        return toReturn.substring(1);
    }

    public static Vector<DriverExpenses> checkExpenseQuenchers(Vector<DriverExpenses> list) {
        Transport.ps.startOperation();
        TimsLogger.debug("#Fonctions.checkExpenses# list contains " + list.size() + " expenses to check ");
        int y = 0;
        while (y < list.size()) {
            try {
                DriverExpenses de = list.get(y);
                ExpensesType e = ExpensesType.getExpenses(de.getExpensesId());
                if (e.getQuencher() != null) {
                    int z = 0;
                    while (z < list.size()) {
                        DriverExpenses det = list.get(z);
                        if (e.getQuencher().contains(det.getExpensesId())) {
                            TimsLogger.debug("#Fonctions.checkExpenses# delete expenses " + det.getExpensesId() + " due to quencher of " + e.getCle() + "(" + det.getDate() + ")");
                            list.remove(z);
                            --z;
                            --y;
                        }
                        ++z;
                    }
                }
            }
            catch (ExpensesNotFoundException ex) {
                TimsLogger.warn("#Fonctions.checkExpenses# unable to find expense type " + list.get(y).getExpensesId());
            }
            ++y;
        }
        TimsLogger.debug("#Fonctions.checkExpenses# checked list contains " + list.size() + " expenses. End of function");
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#Fonctions.checkExpenses#");
        return list;
    }

    public static void afficheMap(Map<?, ?> tmp) {
        TimsLogger.info("#Fonctions.afficheMap# : ");
        for (Map.Entry<?, ?> to : tmp.entrySet()) {
            TimsLogger.info(to.getKey() + " => " + (to.getValue() == null ? "null" : to.getValue().toString()) + "; ");
        }
        TimsLogger.info("");
    }

    public static OffenceThreshold getOffenceThreshold(OffenceType offence, String partName, String thresholdName) {
        if (offence == null) {
            return null;
        }
        for (OffencePart part : offence.getParts()) {
            if (!part.getName().equals(partName)) continue;
            for (OffenceThreshold threshold : part.getThresholds()) {
                if (!threshold.getName().equals(thresholdName)) continue;
                return threshold;
            }
        }
        TimsLogger.debug("\t\t#Fonctions.getOffenceThreshold# threshold " + thresholdName + " not found on part " + partName + " for offence " + offence.getName());
        return null;
    }

    public static void setEnabled(JPanel component, boolean enabled) {
        Component[] comp = component.getComponents();
        int i = 0;
        while (i < comp.length) {
            if (comp[i] instanceof JPanel) {
                Fonctions.setEnabled((JPanel)comp[i], enabled);
            } else {
                comp[i].setEnabled(enabled);
                if (comp[i] instanceof JTextField) {
                    ((JTextField)comp[i]).setText("");
                }
            }
            ++i;
        }
    }

    public static boolean tblToReport(CustomReport cr, DJGenerator generator, ArrayList<Map<String, ?>> data, String out) {
        return Fonctions.tblToReport(cr, generator, data, out, null);
    }

    public static boolean tblToReport(CustomReport cr, DJGenerator generator, ArrayList<Map<String, ?>> data) {
        return Fonctions.tblToReport(cr, generator, data, "imprimer");
    }

    public static boolean tblToReport(CustomReport cr, DJGenerator generator, ArrayList<Map<String, ?>> data, String out, String destination) {
        try {
            cr.updateProperty("OUT", out);
            if (destination != null) {
                cr.updateProperty("DESTINATION", destination);
            }
            DynamicGeneric gen = new DynamicGeneric();
            gen.setData(data);
            gen.setCustomReport(cr);
            if (generator != null) {
                gen.setGenerator(generator);
            }
            gen.process();
        }
        catch (Exception ex) {
            TimsLogger.error("#Fonctions.printTbl()# error during report process " + ex.getMessage());
            return false;
        }
        return true;
    }

    public static void driversToReport(String out) {
        ArrayList drivers = new ArrayList();
        for (Conducteur driver : Conducteur.getList()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(LanguageTranslator.getString("user.firstName"), driver.getPrenom());
            map.put(LanguageTranslator.getString("user.lastName"), driver.getNom());
            Agence agency = Agence.find(null, driver.getCleAgence());
            map.put(LanguageTranslator.getString("generics.agency"), agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription());
            map.put(LanguageTranslator.getString("user.registration"), driver.getMatricule());
            map.put(LanguageTranslator.getString("generics.cardNumber"), driver.getNumeroCarte());
            map.put(LanguageTranslator.getString("generics.expiry"), ConversionTime.dateFromBDDToFrance(driver.getDateFinValiditeCarte()));
            map.put(LanguageTranslator.getString("generics.last.download"), ConversionTime.dateFromBDDToFrance(driver.getDernierTelechargement(), true, true));
            drivers.add(map);
        }
        Fonctions.tblToReport(CustomReportFactory.getDriversReport(), null, drivers, out == null ? "xls" : out);
    }

    public static void vehiclesToReport(String out) {
        ArrayList vehicules = new ArrayList();
        for (Vehicule vehicule : Vehicule.getList()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(LanguageTranslator.getString("vehicle.brand"), vehicule.getBrand());
            map.put(LanguageTranslator.getString("vehicle.registrationNumber"), vehicule.getRegistrationNumber());
            map.put(LanguageTranslator.getString("generics.designation"), vehicule.getDesignation());
            map.put(LanguageTranslator.getString("vehicle.identificationNumber"), vehicule.getIdentificationNumber());
            map.put(LanguageTranslator.getString("generics.last.download"), ConversionTime.dateFromBDDToFrance(vehicule.getDateTelechargement(), true, true));
            map.put(LanguageTranslator.getString("vehicle.vuBrand"), vehicule.getVuBrand());
            map.put(LanguageTranslator.getString("vehicle.vuVersion"), vehicule.getVuVersion());
            Agence agency = Agence.find(null, vehicule.getAgencyId());
            map.put(LanguageTranslator.getString("generics.agency"), agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription());
            vehicules.add(map);
        }
        Fonctions.tblToReport(CustomReportFactory.getVehiclesReport(), null, vehicules, out == null ? "xls" : out);
    }

    public static JComboBox getCustomizedCB() {
        return new JComboBox(){
            private boolean layingOut;

            @Override
            public void doLayout() {
                this.layingOut = true;
                super.doLayout();
                this.layingOut = false;
            }

            @Override
            public Dimension getSize() {
                Dimension dim = super.getSize();
                if (!this.layingOut) {
                    dim.width = Math.max(dim.width, this.getPreferredSize().width);
                }
                return dim;
            }
        };
    }

    public static GridBagConstraints getGridBagConstraints(int gridx, int gridy, int gridheight, int gridwidth, double weightx, double weighty, int fill, int anchor, Insets insets) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.gridheight = gridheight;
        gbc.gridwidth = gridwidth;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        if (fill != -1) {
            gbc.fill = fill;
        }
        Insets insets2 = gbc.insets = insets == null ? new Insets(0, 0, 0, 0) : insets;
        if (anchor != -1) {
            gbc.anchor = anchor;
        }
        return gbc;
    }

    public static GridBagConstraints getGridBagConstraints(int gridx, int gridy) {
        return Fonctions.getGridBagConstraints(gridx, gridy, 1, 1, 1.0, 1.0, 1, -1, null);
    }

    public static String getTypeWording(int type) {
        if (type == 0) {
            return LanguageTranslator.getString("generics.information");
        }
        if (type == 1) {
            return LanguageTranslator.getString("offence.minor");
        }
        if (type == 2) {
            return LanguageTranslator.getString("offence.serious");
        }
        if (type == 3) {
            return LanguageTranslator.getString("offence.verySerious");
        }
        return LanguageTranslator.getString("generics.unknown");
    }

    public static void generateReport(Accident toSave, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles) {
        Report offenceReport = new Report(0, LanguageTranslator.getString("report.accident"), LanguageTranslator.getString("report.accident"), System.getProperty("accident.report", "accident"), "transport.report.AccidentReport.java", 1, -1, 1);
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (System.getProperty("URL") != null) {
                params.put("SERVEUR", System.getProperty("HOME_PATH"));
            } else {
                params.put("SERVEUR", "");
            }
            params.put("ACCIDENT", toSave);
            params.put("RESOLUTION", 1);
            params.put("DETAIL", false);
            params.put("BRUTE", "1");
            params.put("OUT", "imprimer");
            AccidentReport mr = null;
            mr = new AccidentReport();
            ((MasterReport)mr).setValues(null, offenceReport, agencies, drivers, vehicles, params);
            ((MasterReport)mr).process();
            TimsLogger.debug("offence file " + mr.reportName() + ".pdf");
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            TimsLogger.warn("#Fonctions.generateReport()# error during report process");
            ex.printStackTrace();
        }
    }

    public static JComboBox setCbEditor(TableColumn col, Vector<String> list) {
        JComboBox cb = Fonctions.getCustomizedCB();
        cb.setModel(new ComboBoxModel((Vector<?>)list));
        col.setCellEditor(new DefaultCellEditor(cb));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Selection");
        col.setCellRenderer(renderer);
        return cb;
    }

    public static JComboBox setCbEditor(TableColumn col, String[] list) {
        JComboBox cb = Fonctions.getCustomizedCB();
        cb.setModel(new DefaultComboBoxModel<String>(list));
        col.setCellEditor(new DefaultCellEditor(cb));
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setToolTipText("Selection");
        col.setCellRenderer(renderer);
        return cb;
    }

    public static void lookForFiles(Conducteur driver) {
        File[] c1b = new File(Transport.savePath).listFiles(Fonctions.getC1BDetector(driver.getNumeroCarte().substring(0, 12)));
        if (c1b.length == 0) {
            return;
        }
        Vector<CardDownload> list = CardDownload.loadList("CLE_CHAUFFEUR = " + driver.getCleConducteur() + " AND MISSING=1");
        for (CardDownload missing : list) {
            String name = missing.getFichier();
            File[] fileArray = c1b;
            int n = c1b.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().equals(name) && FileManager.moveFile(driver, file) != null) {
                    TimsLogger.debug("#Fonctions.lookForFiles# " + file.getName() + " r\u00e9cup\u00e9r\u00e9");
                }
                ++n2;
            }
        }
    }

    public static void lookForFiles(Vehicule vehicle) {
        File[] v1b = new File(Transport.savePath).listFiles(Fonctions.getV1BDetector(vehicle.getRegistrationNumber()));
        if (v1b.length == 0) {
            return;
        }
        Vector<UevDownload> list = UevDownload.loadList("CLE_VEHICULE = " + vehicle.getCleVehicule() + " AND MISSING=1");
        for (UevDownload missing : list) {
            String name = missing.getFichier();
            File[] fileArray = v1b;
            int n = v1b.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().equals(name) && FileManager.moveFile(vehicle, file) != null) {
                    TimsLogger.debug("#Fonctions.lookForFiles# " + file.getName() + " r\u00e9cup\u00e9r\u00e9");
                }
                ++n2;
            }
        }
    }

    public static FilenameFilter getC1BDetector(final String card) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(card) && name.toUpperCase().endsWith(".C1B");
            }
        };
    }

    public static FilenameFilter getV1BDetector(final String imm) {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains(imm) && name.toUpperCase().endsWith(".V1B");
            }
        };
    }

    public static int offenceCalculation(Conducteur conducteur, Date begin, Date end, boolean brut) {
        TimsLogger.debug("#Fonctions.offenceRecalculation# dernier calcul " + (brut ? conducteur.getDernierCalculBrut() : conducteur.getDernierCalculModifie()) + ". Calcul de " + begin + " \u00e0 " + end);
        if (begin.compareTo(ConversionTime.stringToDate(conducteur.getDernierCalculBrut(), "yyyy-MM-dd")) < 0) {
            Offence.delete(0, conducteur.getCleConducteur(), begin, end, brut);
            Transport.bdd.updateDriverOffenceDate(ConversionTime.dateToString(begin, "yyyy-MM-dd"), 0, conducteur.getCleConducteur(), true);
        }
        Vector<Conducteur> toCal = new Vector<Conducteur>();
        toCal.add(conducteur);
        CalculInfractionPrincipal cip = new CalculInfractionPrincipal(ConversionTime.dateToString(end, "yyyy-MM-dd"), toCal, 1);
        cip.setUI(false);
        cip.run();
        return cip.getStatus();
    }

    public static boolean isFault(Service timsService, ExternalDay ieService) {
        int negDeltaEnd;
        int fault = Integer.parseInt(System.getProperty("FAULT_GAP_THRESHOLD", "2"));
        int total = Integer.parseInt(System.getProperty("TOTAL_GAP_THRESHOLD", "2"));
        int negDeltaBegin = timsService.getBeginTime() - ieService.getBeginTime();
        if (negDeltaBegin - (negDeltaEnd = timsService.getEndTime() - ieService.getEndTime()) > fault) {
            Log.debug((Object)("isFault# start fault detected" + timsService.toString() + " " + ieService.toString()));
            return true;
        }
        int deltaRest = timsService.getRest() - ieService.getRest();
        if (deltaRest > total) {
            Log.debug((Object)("isFault# rest fault detected" + timsService.toString() + " " + ieService.toString()));
            return true;
        }
        return true;
    }

    public static JButton getUndecoratedBtn(String icon, String tooltip) {
        JButton toReturn = new JButton();
        toReturn.setIcon(Fonctions.getIcon(icon));
        toReturn.setPreferredSize(new Dimension(25, 25));
        toReturn.setContentAreaFilled(false);
        toReturn.setBorderPainted(false);
        toReturn.setToolTipText(LanguageTranslator.getString("button.show"));
        return toReturn;
    }

    public static ImageIcon getIcon(String string) {
        URL url = Fonctions.class.getClassLoader().getResource(string);
        ImageIcon image = null;
        try {
            image = url == null ? new ImageIcon(string) : new ImageIcon(url);
        }
        catch (Exception e) {
            System.err.println("Couldn't creat image: " + string + " (" + url + ")");
            TimsLogger.error("Couldn't creat image: " + string + " (" + url + ")");
            e.printStackTrace();
        }
        return image;
    }

    public static ImageIcon getIcon(String filePath, int finalWidth, int finalHeight) {
        TimsLogger.debug("Fonctions.getIcon# load icon from " + filePath + " with required width,height = " + finalWidth + "," + finalHeight);
        BufferedImage image = null;
        ImageIcon imageIcon = null;
        try {
            if (filePath.startsWith("http://")) {
                URL url = Fonctions.getURL(null, filePath);
                image = ImageIO.read(url);
            } else {
                image = ImageIO.read(new File(filePath));
            }
            if (image != null) {
                BufferedImage img = new BufferedImage(finalWidth, finalHeight, 2);
                Graphics2D g = (Graphics2D)img.getGraphics();
                g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g.drawImage(image, 0, 0, finalWidth, finalHeight, null);
                g.dispose();
                imageIcon = new ImageIcon(img);
            }
        }
        catch (Exception e) {
            System.err.println("Couldn't creat image: " + filePath);
            TimsLogger.error("Couldn't creat image: " + filePath);
            e.printStackTrace();
        }
        return imageIcon;
    }

    public static String HtoIConverter(String cmd) {
        String convertedCmd = "";
        int x = 0;
        while (x < cmd.length()) {
            int car = Integer.parseInt(cmd.substring(x, x + 2), 16);
            char toSend = (char)car;
            convertedCmd = String.valueOf(convertedCmd) + toSend;
            x += 2;
        }
        return convertedCmd;
    }

    public static String ItoHConverter(String cmd) {
        String convertedCmd = "";
        String hexCmd = "";
        int x = 0;
        while (x < cmd.length()) {
            hexCmd = Integer.toHexString(cmd.charAt(x));
            while (hexCmd.length() < 2) {
                hexCmd = "0" + hexCmd;
            }
            convertedCmd = String.valueOf(convertedCmd) + hexCmd;
            ++x;
        }
        return convertedCmd.toUpperCase();
    }

    public static int getAvgValue(Conducteur driver, Date begin, Date end) {
        Vector<Service> tmpS = Service.getService(0, driver.getCleConducteur(), begin, end);
        int total = 0;
        int day = 0;
        for (Service s : tmpS) {
            total += s.getService();
            ++day;
        }
        int toReturn = day > 0 ? total / day : 0;
        TimsLogger.debug("average value for " + driver.getNom() + " => " + toReturn);
        return toReturn;
    }

    public static String getDateHeure() {
        return ConversionTime.dateToString(new Date(), "dd/MM/yyyy HH:mm");
    }

    public static String getSenorityWording() {
        String accuracy = LanguageTranslator.getString("generics.months");
        int senorityAccuracy = Integer.parseInt(System.getProperty("senority.accuracy", "1"));
        if (senorityAccuracy == 0) {
            accuracy = LanguageTranslator.getString("generics.days");
        } else if (senorityAccuracy == 2) {
            accuracy = LanguageTranslator.getString("generics.years");
        }
        return LanguageTranslator.getString("generics.senority", accuracy);
    }

    public static void showSuccessMessage(String title, String content) {
        Fonctions.showMessage(title == null ? LanguageTranslator.getString("message.done") : title, content == null ? LanguageTranslator.getString("message.saveSucceed") : content, Fonctions.getIcon(Transport.res.getResourceString("icone_valid")));
    }

    public static void showErrorMessage(String title, String content) {
        Fonctions.showMessage(title == null ? LanguageTranslator.getString("message.error") : title, content == null ? LanguageTranslator.getString("message.saveError") : content, Fonctions.getIcon(Transport.res.getResourceString("icone_sup")));
    }

    public static void showMessage(String title, String content, ImageIcon icon) {
        JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT).addMessage(title, new JLabel(content), icon);
        JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT).showNotification(6);
    }

    public static boolean checkFileSize(File selectedFile) {
        long sizeMax = Long.parseLong(System.getProperty("attachment.size.max", "1000000"));
        if (selectedFile.length() > sizeMax) {
            MessageSystemManager.error((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("attachment.size.exceeded", String.valueOf(sizeMax / 1000L)), LanguageTranslator.getString("message.saveError"));
            return false;
        }
        return true;
    }

    public static void analyseUevSession(String begin, String testThis) {
        if (begin == null) {
            begin = "01/01/2021";
        }
        if ("1".equals(testThis) || "true".equals(testThis)) {
            test = true;
        }
        Transport.bdd.startTransaction();
        boolean valid = true;
        Date beginAnalyse = ConversionTime.stringToDateFr(begin);
        String errFile = String.valueOf(Transport.savePath) + "\\err.txt";
        FileWriter err = null;
        try {
            err = new FileWriter(errFile);
            if (err != null) {
                err.write("fichiers manquants");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CustomReport crManque = CustomReportFactory.getGeneric(String.valueOf(ConversionTime.dateToString(new Date(), "yyyy-MM-dd")) + " - Analyse donn\u00e9es v\u00e9hicules - donn\u00e9es manquantes");
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, "IMMATRICULATION", String.class.getName(), "", 20, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "AGENCE", String.class.getName(), "", 10, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "DEBUT", String.class.getName(), "", 5, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "FIN", String.class.getName(), "", 5, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "DUREE", Integer.class.getName(), "", 5, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "KM", Integer.class.getName(), "", 5, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "SESSION", String.class.getName(), "", 40, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "DATE ENTREE", String.class.getName(), "", 40, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "DATE SORTIE", String.class.getName(), "", 40, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "DEJA CONNU", String.class.getName(), "", 40, column.size() + 1));
        crManque.setColumn(column);
        CustomReport crSessionOuverte = CustomReportFactory.getGeneric(String.valueOf(ConversionTime.dateToString(new Date(), "yyyy-MM-dd")) + " - Analyse donn\u00e9es v\u00e9hicules - sessions ouverte");
        Vector<CustomReportColumn> column2 = new Vector<CustomReportColumn>();
        column2.add(new CustomReportColumn(0, 0, "IMMATRICULATION", String.class.getName(), "", 20, column.size() + 1));
        column2.add(new CustomReportColumn(0, 0, "AGENCE", String.class.getName(), "", 10, column.size() + 1));
        column2.add(new CustomReportColumn(0, 0, "DERNIER TELECHARGEMENT", Date.class.getName(), "dd/MM/yyyy HH:mm", 10, column.size() + 1));
        column2.add(new CustomReportColumn(0, 0, "SESSION", String.class.getName(), "", 40, column.size() + 1));
        column2.add(new CustomReportColumn(0, 0, "DATE ENTREE", String.class.getName(), "", 40, column.size() + 1));
        column2.add(new CustomReportColumn(0, 0, "DATE SORTIE", String.class.getName(), "", 40, column.size() + 1));
        crSessionOuverte.setColumn(column2);
        ArrayList dataManque = new ArrayList();
        ArrayList dataSession = new ArrayList();
        ArrayList<String> missingDownload = new ArrayList<String>();
        Vector<UevDownload> to = UevDownload.loadList("(BEGIN_ACTIVITY < \"2021-01-01\" AND END_ACTIVITY >= \"2021-01-01\") OR (BEGIN_ACTIVITY < \"2021-01-01\" AND END_ACTIVITY > \"2021-12-01\") OR (BEGIN_ACTIVITY > \"2021-01-01\" AND END_ACTIVITY < \"2021-12-01\")");
        Vehicule current = null;
        Vector<UevSession> lastSessionList = null;
        ArrayList<UevEventsFaults> interruption = new ArrayList<UevEventsFaults>();
        TreeMap<Date, Integer> activeDay = new TreeMap<Date, Integer>();
        Date lastDownload = null;
        for (UevDownload d : to) {
            try {
                Vehicule v = d.getVehicle();
                File file = new File(String.valueOf(Transport.savePath) + v.getRegistrationNumber() + "\\" + d.getFichier());
                if (!file.exists()) {
                    file.getParentFile().mkdir();
                    File tmp = FileManager.getFile(v, d.getFichier());
                    if (tmp == null) {
                        if (err == null) continue;
                        err.write(String.valueOf(d.getVehicle().getAgencyId()) + " - " + d.getFichier() + "\r\n");
                        continue;
                    }
                    tmp.renameTo(file);
                }
                if (current == null || !current.equals(v)) {
                    if (current != null) {
                        TimsLogger.debug("Processed " + current.getRegistrationNumber() + " next " + v.getRegistrationNumber());
                        Date entry = ConversionTime.stringToDateDb(current.getDateEntree());
                        if (activeDay.size() != 0) {
                            ArrayList l = new ArrayList(activeDay.keySet());
                            while (((Date)l.get(0)).before(beginAnalyse) || entry != null && ((Date)l.get(0)).before(entry)) {
                                activeDay.remove(l.get(0));
                                l.remove(0);
                                if (activeDay.size() == 0) break;
                            }
                            current.loadById(current.getCleVehicule());
                            Date toAdd = ConversionTime.addDay(beginAnalyse, -1);
                            if (entry != null && toAdd.before(entry)) {
                                toAdd = ConversionTime.addDay(entry, -1);
                            }
                            activeDay.put(toAdd, 0);
                            Fonctions.sort(dataManque, dataSession, current, activeDay, lastSessionList, lastDownload, interruption);
                        } else {
                            TimsLogger.debug("Pas de jours \u00e0 traiter pour " + current.getRegistrationNumber());
                        }
                    }
                    current = v;
                    lastSessionList = null;
                    interruption = new ArrayList();
                    activeDay = new TreeMap();
                    lastDownload = null;
                    missingDownload.clear();
                }
                VuProcessingG1 uevdp = new VuProcessingG1(file);
                lastSessionList = uevdp.getSessionList();
                for (UevEventsFaults toAdd : uevdp.getInterruption()) {
                    if (interruption.contains(toAdd)) continue;
                    interruption.add(toAdd);
                }
                if (lastDownload != null && !lastDownload.equals(d.getPreviousDownload())) {
                    missingDownload.add(ConversionTime.dateToStringFr(d.getPreviousDownload()));
                }
                lastDownload = d.getTelechargement();
                TimsLogger.debug(activeDay.size() + " " + d.getTelechargement());
                HashMap<Date, Integer> days = uevdp.getActiveDay();
                if (days == null) continue;
                activeDay.putAll(days);
            }
            catch (Exception e) {
                valid = false;
                e.printStackTrace();
            }
        }
        try {
            Date entry = ConversionTime.stringToDateDb(current.getDateEntree());
            if (activeDay.size() != 0) {
                ArrayList l = new ArrayList(activeDay.keySet());
                while (((Date)l.get(0)).before(beginAnalyse) || entry != null && ((Date)l.get(0)).before(entry)) {
                    activeDay.remove(l.get(0));
                    l.remove(0);
                    if (activeDay.size() == 0) break;
                }
                current.loadById(current.getCleVehicule());
                Date toAdd = ConversionTime.addDay(beginAnalyse, -1);
                if (entry != null && toAdd.before(entry)) {
                    toAdd = ConversionTime.addDay(entry, -1);
                }
                activeDay.put(toAdd, 0);
                Fonctions.sort(dataManque, dataSession, current, activeDay, lastSessionList, lastDownload, interruption);
            } else {
                TimsLogger.debug("Pas de jours \u00e0 traiter pour " + current.getRegistrationNumber());
            }
        }
        catch (Exception ex) {
            valid = false;
            ex.printStackTrace();
        }
        try {
            if (err != null) {
                err.flush();
                err.close();
            }
        }
        catch (IOException e) {
            valid = false;
            e.printStackTrace();
        }
        try {
            TimsLogger.info("Trous r\u00e9solus :");
            Statement req = BddTransport.getInstance().getConnection().createStatement();
            ResultSet rs = req.executeQuery("select * from activity_hole where detection<\"" + ConversionTime.dateToStringDb(ConversionTime.addDay(new Date(), -1)) + "\"");
            while (rs.next()) {
                TimsLogger.info(String.valueOf(rs.getInt("VEHICLE_ID")) + " " + rs.getDate("BEGIN") + " " + rs.getDate("END") + " " + rs.getDate("DETECTION"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (valid && !test) {
            Transport.bdd.commit();
        } else {
            Transport.bdd.commit();
            TimsLogger.debug("Erreur rencontr\u00e9s, rollback...");
        }
        Fonctions.tblToReport(crManque, new DJGenerator(), dataManque, "xls", Transport.savePath);
        Fonctions.tblToReport(crSessionOuverte, new DJGenerator(), dataSession, "xls", Transport.savePath);
    }

    public static void analyseVitesse(String begin, String testThis) {
        Transport.debug = 0;
        if (begin == null) {
            begin = "01/09/2023";
        }
        if ("1".equals(testThis) || "true".equals(testThis)) {
            test = true;
        }
        String errFile = String.valueOf(Transport.savePath) + "\\err.txt";
        FileWriter err = null;
        try {
            err = new FileWriter(errFile);
            if (err != null) {
                err.write("fichiers manquants");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList data = new ArrayList();
        Vector<UevDownload> to = UevDownload.loadList("END_ACTIVITY >= \"2023-09-01\"");
        Vehicule current = null;
        ArrayList<UevSpeed> foundedSpeed = new ArrayList<UevSpeed>();
        ArrayList<UevSpeed> finalSpeed = new ArrayList<UevSpeed>();
        int x = 0;
        for (UevDownload d : to) {
            TimsLogger.info("Free memory (bytes): " + Runtime.getRuntime().freeMemory() + " of " + Runtime.getRuntime().maxMemory() + " (used " + Runtime.getRuntime().totalMemory() + ")");
            TimsLogger.info(String.valueOf(x++) + " of " + to.size());
            if (Runtime.getRuntime().freeMemory() < 100000L) {
                System.exit(0);
            }
            try {
                Object uevdp;
                Vehicule v = d.getVehicle();
                File file = new File("E:\\FICHIER VIAL\\" + d.getFichier());
                if (!file.exists()) {
                    File tmp = FileManager.getFile(v, d.getFichier());
                    if (tmp == null) {
                        if (err == null) continue;
                        err.write(String.valueOf(d.getVehicle().getAgencyId()) + " - " + d.getFichier() + "\r\n");
                        continue;
                    }
                    tmp.renameTo(file);
                }
                if (current == null || !current.equals(v)) {
                    if (current != null) {
                        ArrayList<UevSpeed> existing = UevSpeed.load(current.getCleVehicule(), begin, "2022-11-09", 0);
                        TimsLogger.debug("Processed " + current.getRegistrationNumber() + " next " + v.getRegistrationNumber());
                        for (UevSpeed toCheck : foundedSpeed) {
                            boolean found = false;
                            if (toCheck.getVitesseMax() >= 100) {
                                finalSpeed.add(toCheck);
                            }
                            for (UevSpeed exist : existing) {
                                if (!toCheck.like(exist)) continue;
                                found = true;
                            }
                            if (found) continue;
                            HashMap<String, Object> toAdd = new HashMap<String, Object>();
                            toAdd.put("CONDUCTEUR", toCheck.getNumeroCarteConducteur());
                            toAdd.put("IMMATRICULATION", current.getRegistrationNumber());
                            toAdd.put("DEBUT", toCheck.getDateDebut());
                            toAdd.put("FIN", toCheck.getDateFin());
                            toAdd.put("KM", toCheck.getVitesseMax());
                            data.add(toAdd);
                        }
                    }
                    current = v;
                    foundedSpeed = null;
                    System.gc();
                    foundedSpeed = new ArrayList();
                }
                if (UEVProperty.getVuGeneration(file.getAbsolutePath()) == 1) {
                    uevdp = new VuProcessingG1(file);
                    for (UevSpeed s : ((VuProcessingG1)uevdp).getOverSpeed()) {
                        if (foundedSpeed.contains(s)) continue;
                        foundedSpeed.add(s);
                    }
                    uevdp = null;
                    System.gc();
                    continue;
                }
                uevdp = new VuProcessingG2(file);
                for (UevSpeed s : ((VuProcessingG2)uevdp).getOverSpeed()) {
                    if (foundedSpeed.contains(s)) continue;
                    foundedSpeed.add(s);
                }
                uevdp = null;
                System.gc();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            FileWriter fileWriter = null;
            fileWriter = new FileWriter(String.valueOf(Transport.savePath) + "\\csv.csv");
            for (Conducteur toPrint : Conducteur.loadList(new Integer[0])) {
                boolean none = true;
                fileWriter.write(String.valueOf(toPrint.getNom()) + " " + toPrint.getPrenom() + ";");
                for (UevSpeed toCheck : finalSpeed) {
                    if (toPrint.getNumeroCarte() == null || toCheck.getNumeroCarteConducteur() == null || !toPrint.getNumeroCarte().substring(0, 14).equals(toCheck.getNumeroCarteConducteur().substring(0, 14))) continue;
                    fileWriter.write(";" + toCheck.getVitesseMax() + " le " + ConversionTime.dateToString(toCheck.getDateDebut(), "dd/MM HH:mm") + " (" + Vehicule.getVehicule(null, toCheck.getCleVehicule()).getRegistrationNumber() + ")");
                    none = false;
                }
                fileWriter.write(String.valueOf(none ? ";Pas de survitesses" : "") + "\r\n");
                fileWriter.flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        CustomReport crManque = CustomReportFactory.getGeneric(String.valueOf(ConversionTime.dateToString(new Date(), "yyyy-MM-dd")) + " - Vitesses");
        Vector<CustomReportColumn> column = new Vector<CustomReportColumn>();
        column.add(new CustomReportColumn(0, 0, "CONDUCTEUR", String.class.getName(), "", 20, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "IMMATRICULATION", String.class.getName(), "", 20, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "DEBUT", Date.class.getName(), "", 5, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "FIN", Date.class.getName(), "", 5, column.size() + 1));
        column.add(new CustomReportColumn(0, 0, "KM", Integer.class.getName(), "", 5, column.size() + 1));
        crManque.setColumn(column);
        Fonctions.tblToReport(crManque, new DJGenerator(), data, "xls", Transport.savePath);
    }

    public static void sort(ArrayList<Map<String, ?>> dataManque, ArrayList<Map<String, ?>> dataSession, Vehicule current, SortedMap<Date, Integer> activeDay, Vector<UevSession> sessionList, Date lastDownload, ArrayList<UevEventsFaults> interruption) throws ParseException, SQLException {
        TimsLogger.debug("On traite  " + current.getRegistrationNumber() + ", " + sessionList.size() + " sessions (" + current.getDateEntree() + " " + current.getDateSortie() + ")");
        Date entry = current.getDateEntree() == null || current.getDateEntree().equals("") ? null : ConversionTime.stringToDateDb(current.getDateEntree());
        Date exit = current.getDateSortie() == null || current.getDateSortie().equals("") ? null : ConversionTime.stringToDateDb(current.getDateSortie());
        PreparedStatement req = BddTransport.getInstance().getConnection().prepareStatement("select * from activity_hole where vehicle_id = ? and (begin = ? or end = ?)");
        String agence = Agence.find(null, current.getAgencyId()).getDescription();
        if ((exit == null || exit.after(new Date())) && dataSession != null) {
            String comp = "AUCUNE";
            if (sessionList.size() != 0) {
                comp = sessionList.get(sessionList.size() - 1).getCompany();
            }
            if (!comp.startsWith("XPO TRANSPORT LOCATION FRANCE")) {
                HashMap<String, Object> hm = new HashMap<String, Object>();
                dataSession.add(hm);
                hm.put("IMMATRICULATION", current.getRegistrationNumber());
                hm.put("AGENCE", agence);
                hm.put("DERNIER TELECHARGEMENT", lastDownload);
                hm.put("SESSION", comp);
                hm.put("DATE ENTREE", ConversionTime.dateFromBDDToFrance(current.getDateEntree(), false, true));
                hm.put("DATE SORTIE", ConversionTime.dateFromBDDToFrance(current.getDateSortie(), false, true));
                hm.put("SESSION", sessionList.size() > 0 ? String.valueOf(sessionList.get(sessionList.size() - 1).getCompany()) + " " + sessionList.get(sessionList.size() - 1).getCompanyCard() : "INCONNU");
            }
        }
        if (activeDay.size() != 0) {
            if (entry != null) {
                ArrayList<Date> l = new ArrayList<Date>(activeDay.keySet());
                while (((Date)l.get(0)).before(entry)) {
                    activeDay.remove(l.get(0));
                    l.remove(0);
                    if (activeDay.size() == 0) break;
                }
                if (activeDay.size() == 0) {
                    TimsLogger.debug("Pas de jours \u00e0 traiter");
                    return;
                }
            }
            ArrayList<Date> days = new ArrayList<Date>(activeDay.keySet());
            Date expected = (Date)days.get(0);
            int lastKnownkm = (Integer)activeDay.get(expected);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date defaultDate = sdf.parse("1970-01-02");
            for (Date j : days) {
                if (exit != null && j.after(exit)) break;
                if (!expected.equals(j) && !expected.after(j)) {
                    int connu;
                    ResultSet rs;
                    HashMap<String, Object> line;
                    int kmDiff = (Integer)activeDay.get(j) - lastKnownkm;
                    Date end = ConversionTime.addDay(j, -1);
                    String log = "Du " + sdf.format(expected) + " au " + sdf.format(end);
                    Date searchOpen = ConversionTime.addDay(expected, 1);
                    boolean found = false;
                    boolean electrical = false;
                    for (UevEventsFaults inter : interruption) {
                        if (!inter.getBegin().before(expected) || !inter.getEnd().after(ConversionTime.addDay(end, -1))) continue;
                        electrical = true;
                        TimsLogger.debug(String.valueOf(log) + " interruption \u00e9lectrique nb km " + kmDiff);
                        if (kmDiff == 0) break;
                        line = new HashMap();
                        dataManque.add(line);
                        line.put("IMMATRICULATION", current.getRegistrationNumber());
                        line.put("AGENCE", agence);
                        line.put("SESSION", "interruption \u00e9lectrique");
                        line.put("DATE ENTREE", ConversionTime.dateFromBDDToFrance(current.getDateEntree(), false, true));
                        line.put("DATE SORTIE", ConversionTime.dateFromBDDToFrance(current.getDateSortie(), false, true));
                        line.put("DEBUT", sdf.format(expected));
                        line.put("FIN", sdf.format(end));
                        line.put("DUREE", ConversionTime.getDaysBetween(expected, end) + 1);
                        line.put("KM", kmDiff);
                        req.setObject(1, (Object)current.getCleVehicule(), 4);
                        req.setObject(2, (Object)ConversionTime.dateToStringDb(expected), 12);
                        req.setObject(3, (Object)ConversionTime.dateToStringDb(end), 12);
                        rs = req.executeQuery();
                        connu = 0;
                        if (rs.next()) {
                            line.put("DEJA CONNU", "1");
                            connu = 1;
                            if (!test) {
                                Transport.bdd.executeCmd("DELETE FROM activity_hole where id =" + rs.getInt("ID"));
                            }
                        } else {
                            line.put("DEJA CONNU", "0");
                        }
                        if (test) break;
                        Transport.bdd.executeCmd("INSERT INTO activity_hole (begin, end, session, vehicle_id, deja_connu) values (\"" + ConversionTime.dateToStringDb(expected) + "\",\"" + ConversionTime.dateToStringDb(end) + "\",\"INTERRUPTION\"," + current.getCleVehicule() + "," + connu + ")");
                        break;
                    }
                    if (!electrical) {
                        for (UevSession s : sessionList) {
                            if (s.getOpen().before(searchOpen) && (s.getClose().after(end) || s.getClose().before(defaultDate))) {
                                found = true;
                                if (kmDiff == 0) break;
                                line = new HashMap<String, Object>();
                                dataManque.add(line);
                                line.put("IMMATRICULATION", current.getRegistrationNumber());
                                line.put("AGENCE", agence);
                                line.put("SESSION", String.valueOf(s.getCompany()) + " " + s.getCompanyCard());
                                line.put("DATE ENTREE", ConversionTime.dateFromBDDToFrance(current.getDateEntree(), false, true));
                                line.put("DATE SORTIE", ConversionTime.dateFromBDDToFrance(current.getDateSortie(), false, true));
                                TimsLogger.debug(String.valueOf(log) + " enti\u00e8re avec " + s.getCompany() + " " + s.getCompanyCard() + " (" + sdf.format(s.getOpen()) + " " + sdf.format(s.getClose()) + ")");
                                line.put("DEBUT", sdf.format(expected));
                                line.put("FIN", sdf.format(end));
                                line.put("DUREE", ConversionTime.getDaysBetween(expected, end) + 1);
                                line.put("KM", kmDiff);
                                req.setObject(1, (Object)current.getCleVehicule(), 4);
                                req.setObject(2, (Object)ConversionTime.dateToStringDb(expected), 12);
                                req.setObject(3, (Object)ConversionTime.dateToStringDb(end), 12);
                                rs = req.executeQuery();
                                connu = 0;
                                if (rs.next()) {
                                    connu = 1;
                                    line.put("DEJA CONNU", "1");
                                    if (!test) {
                                        Transport.bdd.executeCmd("DELETE FROM activity_hole where id =" + rs.getInt("ID"));
                                    }
                                } else {
                                    line.put("DEJA CONNU", "0");
                                }
                                if (test) break;
                                Transport.bdd.executeCmd("INSERT INTO activity_hole (begin, end, session, vehicle_id,deja_connu) values (\"" + ConversionTime.dateToStringDb(expected) + "\",\"" + ConversionTime.dateToStringDb(end) + "\",\"" + s.getCompany() + "\"," + current.getCleVehicule() + "," + connu + ")");
                                break;
                            }
                            if (s.getOpen().before(searchOpen) && s.getClose().after(searchOpen)) {
                                found = true;
                                if (kmDiff == 0) continue;
                                line = new HashMap();
                                dataManque.add(line);
                                line.put("IMMATRICULATION", current.getRegistrationNumber());
                                line.put("AGENCE", agence);
                                line.put("SESSION", String.valueOf(s.getCompany()) + " " + s.getCompanyCard());
                                line.put("DATE ENTREE", ConversionTime.dateFromBDDToFrance(current.getDateEntree(), false, true));
                                line.put("DATE SORTIE", ConversionTime.dateFromBDDToFrance(current.getDateSortie(), false, true));
                                TimsLogger.debug(String.valueOf(log) + " partiel (" + sdf.format(searchOpen) + "=>" + sdf.format(s.getClose()) + ") avec " + s.getCompany() + " " + s.getCompanyCard() + " (" + sdf.format(s.getOpen()) + " " + sdf.format(s.getClose()) + ")");
                                line.put("DEBUT", sdf.format(searchOpen));
                                line.put("FIN", sdf.format(s.getClose()));
                                line.put("DUREE", ConversionTime.getDaysBetween(searchOpen, s.getClose()) + 1);
                                line.put("KM", kmDiff);
                                req.setObject(1, (Object)current.getCleVehicule(), 4);
                                req.setObject(2, (Object)ConversionTime.dateToStringDb(searchOpen), 12);
                                req.setObject(3, (Object)ConversionTime.dateToStringDb(s.getClose()), 12);
                                rs = req.executeQuery();
                                connu = 0;
                                if (rs.next()) {
                                    connu = 1;
                                    line.put("DEJA CONNU", "1");
                                    if (!test) {
                                        Transport.bdd.executeCmd("DELETE FROM activity_hole where id =" + rs.getInt("ID"));
                                    }
                                } else {
                                    line.put("DEJA CONNU", "0");
                                }
                                if (test) continue;
                                Transport.bdd.executeCmd("INSERT INTO activity_hole (begin, end, session, vehicle_id,deja_connu) values (\"" + ConversionTime.dateToStringDb(searchOpen) + "\",\"" + ConversionTime.dateToStringDb(s.getClose()) + "\",\"" + s.getCompany() + "\"," + current.getCleVehicule() + "," + connu + ")");
                                continue;
                            }
                            if (s.getOpen().after(searchOpen) && s.getClose().before(end) && !s.getClose().before(defaultDate)) {
                                found = true;
                                if (kmDiff == 0) continue;
                                line = new HashMap();
                                dataManque.add(line);
                                line.put("IMMATRICULATION", current.getRegistrationNumber());
                                line.put("AGENCE", agence);
                                line.put("SESSION", String.valueOf(s.getCompany()) + " " + s.getCompanyCard());
                                line.put("DATE ENTREE", ConversionTime.dateFromBDDToFrance(current.getDateEntree(), false, true));
                                line.put("DATE SORTIE", ConversionTime.dateFromBDDToFrance(current.getDateSortie(), false, true));
                                TimsLogger.debug(String.valueOf(log) + " partiel (" + sdf.format(s.getOpen()) + "=>" + sdf.format(s.getClose()) + ") avec " + s.getCompany() + " " + s.getCompanyCard() + " (" + sdf.format(s.getOpen()) + " " + sdf.format(s.getClose()) + ")");
                                line.put("DEBUT", sdf.format(s.getOpen()));
                                line.put("FIN", sdf.format(s.getClose()));
                                line.put("DUREE", ConversionTime.getDaysBetween(s.getOpen(), s.getClose()) + 1);
                                line.put("KM", kmDiff);
                                req.setObject(1, (Object)current.getCleVehicule(), 4);
                                req.setObject(2, (Object)ConversionTime.dateToStringDb(s.getOpen()), 12);
                                req.setObject(3, (Object)ConversionTime.dateToStringDb(s.getClose()), 12);
                                rs = req.executeQuery();
                                connu = 0;
                                if (rs.next()) {
                                    connu = 1;
                                    line.put("DEJA CONNU", "1");
                                    if (!test) {
                                        Transport.bdd.executeCmd("DELETE FROM activity_hole where id =" + rs.getInt("ID"));
                                    }
                                } else {
                                    line.put("DEJA CONNU", "0");
                                }
                                if (test) continue;
                                Transport.bdd.executeCmd("INSERT INTO activity_hole (begin, end, session, vehicle_id,deja_connu) values (\"" + ConversionTime.dateToStringDb(s.getOpen()) + "\",\"" + ConversionTime.dateToStringDb(s.getClose()) + "\",\"" + s.getCompany() + "\"," + current.getCleVehicule() + "," + connu + ")");
                                continue;
                            }
                            if (!s.getOpen().before(end) || !s.getClose().after(end) && !s.getClose().before(defaultDate)) continue;
                            found = true;
                            if (kmDiff == 0) continue;
                            line = new HashMap();
                            dataManque.add(line);
                            line.put("IMMATRICULATION", current.getRegistrationNumber());
                            line.put("AGENCE", agence);
                            line.put("SESSION", String.valueOf(s.getCompany()) + " " + s.getCompanyCard());
                            line.put("DATE ENTREE", ConversionTime.dateFromBDDToFrance(current.getDateEntree(), false, true));
                            line.put("DATE SORTIE", ConversionTime.dateFromBDDToFrance(current.getDateSortie(), false, true));
                            TimsLogger.debug(String.valueOf(log) + " partiel (" + sdf.format(s.getOpen()) + "=>" + sdf.format(end) + ") avec " + s.getCompany() + " " + s.getCompanyCard() + " (" + sdf.format(s.getOpen()) + " " + sdf.format(s.getClose()) + ")");
                            line.put("DEBUT", sdf.format(s.getOpen()));
                            line.put("FIN", sdf.format(end));
                            line.put("DUREE", ConversionTime.getDaysBetween(s.getOpen(), end) + 1);
                            line.put("KM", kmDiff);
                            req.setObject(1, (Object)current.getCleVehicule(), 4);
                            req.setObject(2, (Object)ConversionTime.dateToStringDb(s.getOpen()), 12);
                            req.setObject(3, (Object)ConversionTime.dateToStringDb(end), 12);
                            rs = req.executeQuery();
                            connu = 0;
                            if (rs.next()) {
                                connu = 1;
                                line.put("DEJA CONNU", "1");
                                if (!test) {
                                    Transport.bdd.executeCmd("DELETE FROM activity_hole where id =" + rs.getInt("ID"));
                                }
                            } else {
                                line.put("DEJA CONNU", "0");
                            }
                            if (test) continue;
                            Transport.bdd.executeCmd("INSERT INTO activity_hole (begin, end, session, vehicle_id,deja_connu) values (\"" + ConversionTime.dateToStringDb(s.getOpen()) + "\",\"" + ConversionTime.dateToStringDb(end) + "\",\"" + s.getCompany() + "\"," + current.getCleVehicule() + "," + connu + ")");
                        }
                        if (!found) {
                            if (kmDiff == 0) continue;
                            HashMap<String, Object> line2 = new HashMap<String, Object>();
                            dataManque.add(line2);
                            TimsLogger.debug(String.valueOf(log) + " non trouv\u00e9 (" + sdf.format(expected) + "=>" + sdf.format(end) + ")");
                            line2.put("IMMATRICULATION", current.getRegistrationNumber());
                            line2.put("AGENCE", agence);
                            line2.put("DEBUT", sdf.format(expected));
                            line2.put("FIN", sdf.format(end));
                            line2.put("DUREE", ConversionTime.getDaysBetween(expected, end) + 1);
                            line2.put("SESSION", "AUCUNE");
                            line2.put("DATE ENTREE", ConversionTime.dateFromBDDToFrance(current.getDateEntree(), false, true));
                            line2.put("DATE SORTIE", ConversionTime.dateFromBDDToFrance(current.getDateSortie(), false, true));
                            line2.put("KM", kmDiff);
                            req.setObject(1, (Object)current.getCleVehicule(), 4);
                            req.setObject(2, (Object)ConversionTime.dateToStringDb(expected), 12);
                            req.setObject(3, (Object)ConversionTime.dateToStringDb(end), 12);
                            ResultSet rs2 = req.executeQuery();
                            int connu2 = 0;
                            if (rs2.next()) {
                                connu2 = 1;
                                line2.put("DEJA CONNU", "1");
                                if (!test) {
                                    Transport.bdd.executeCmd("DELETE FROM activity_hole where id =" + rs2.getInt("ID"));
                                }
                            } else {
                                line2.put("DEJA CONNU", "0");
                            }
                            if (!test) {
                                Transport.bdd.executeCmd("INSERT INTO activity_hole (begin, end, session, vehicle_id,deja_connu) values (\"" + ConversionTime.dateToStringDb(expected) + "\",\"" + ConversionTime.dateToStringDb(end) + "\",\"AUCUNE\"," + current.getCleVehicule() + "," + connu2 + ")");
                            }
                        }
                    }
                }
                lastKnownkm = (Integer)activeDay.get(j);
                expected = ConversionTime.addDay(j, 1);
            }
        } else {
            TimsLogger.debug("Pas de jours actifs \u00e0 traiter");
        }
    }

    public static ArrayList<Date> getAllDay(Date lastDay) throws ParseException {
        ArrayList<Date> allDay = new ArrayList<Date>();
        Date comp = new SimpleDateFormat("yyyy-MM-dd").parse("2018-01-01");
        while (comp.before(lastDay)) {
            allDay.add(comp);
            comp = ConversionTime.addDay(comp, 1);
        }
        TimsLogger.debug("getAllDay until " + ConversionTime.dateToString(lastDay, "dd/MM/yyyy") + " (" + allDay.size() + " jours)");
        return allDay;
    }

    public static void versionning(Vector<Societe> tmp) {
        if (tmp == null) {
            tmp = Societe.loadList(null);
        }
        int x = 0;
        while (x < tmp.size()) {
            String[] cmds;
            String base = tmp.get(x).getNomBase().toLowerCase();
            String[] stringArray = cmds = new String[]{"ALTER TABLE " + base + ".uev_offence MODIFY COLUMN ID INT(11) UNSIGNED NOT NULL AUTO_INCREMENT;", "CREATE TABLE " + base + ".DRIVER_LOAD (ID INTEGER UNSIGNED NOT NULL AUTO_INCREMENT, DRIVER_ID INTEGER(5) NOT NULL, DATE_LOAD DATETIME, TYPE_LOAD TINYINT, PRIMARY KEY (`ID`)) ENGINE = InnoDB;", "ALTER TABLE " + base + ".DRIVER_LOAD ADD FOREIGN KEY (DRIVER_ID) REFERENCES `t_conducteur`(CLE_CHAUFFEUR) ON DELETE CASCADE;"};
            int n = cmds.length;
            int n2 = 0;
            while (n2 < n) {
                String cmd = stringArray[n2];
                System.out.println(cmd);
                ++n2;
            }
            ++x;
        }
    }

    private static void doQuery(String[] query) {
        int x = 1;
        while (x < query.length) {
            BddTransport.getInstance().queryAndPrint(query[x]);
            ++x;
        }
    }

    public static void majActivityV4(Vector<Societe> tmp) {
        if (tmp == null) {
            tmp = Societe.loadList(null);
        }
        boolean forceToAll = false;
        int x = 0;
        while (x < tmp.size()) {
            int option;
            TimsLogger.debug(tmp.get(x).getUserDBPwd());
            Transport.bdd.changeDB(tmp.get(x).getNomSociete(), false);
            TimsLogger.debug("\r\nSoci\u00e9t\u00e9 " + tmp.get(x).getNomSociete());
            int n = option = forceToAll ? 0 : JOptionPane.showOptionDialog(null, String.valueOf(tmp.get(x).getNomSociete()) + " : ex\u00e9cutez la mise \u00e0 jour ?", "Confirmer ?", -1, 3, null, new Object[]{"Oui", "Non", "Oui pour tous"}, "Non");
            if (option == 2) {
                option = 0;
                forceToAll = true;
            }
            if (option == 0) {
                Fonctions.refreshActivityInDayTable(null, null);
                System.gc();
            }
            ++x;
        }
    }

    public static void majUpdate(Vector<Societe> tmp) {
        try {
            long mil = System.currentTimeMillis();
            int days = 0;
            Vector<Jour> actss = BddTransport.getInstance().getJourDebug(0, "2018-02-06", "2019-06-06");
            Vector<Integer> modified = new Vector<Integer>();
            for (Jour ddd : actss) {
                if (modified.contains(ddd.getDriverId())) continue;
                modified.add(ddd.getDriverId());
            }
            for (Conducteur driver : Conducteur.loadListWithArchive(new Integer[0])) {
                Vector<Jour> acts;
                if (!modified.contains(driver.getCleConducteur()) || (acts = BddTransport.getInstance().getJourDebug(driver.getCleConducteur(), "2018-02-06", "2019-06-06")).size() == 0) continue;
                String toAff = String.valueOf(driver.getNom()) + " " + driver.getPrenom();
                String not = "";
                String firstUpdated = null;
                for (Jour d : acts) {
                    boolean toUpdate = false;
                    int last = 0;
                    for (ActiviteConducteur act : d.getActivity()) {
                        if (act.getHeureDebut() < last) {
                            toAff = String.valueOf(toAff) + " - " + d.getDate();
                            d.setActivity(Fonctions.sortActivitiesList(d.getActivity()));
                            if (firstUpdated == null) {
                                firstUpdated = d.getDate();
                            }
                            toUpdate = true;
                            break;
                        }
                        last = act.getHeureDebut();
                    }
                    if (!toUpdate) {
                        not = String.valueOf(not) + "/" + d.getDate();
                    }
                    ++days;
                }
                TimsLogger.debug(String.valueOf(toAff) + " /// OK :" + not);
            }
            TimsLogger.debug(String.valueOf(days) + " days done in " + (System.currentTimeMillis() - mil));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void maintenance() {
        String sOption = JOptionPane.showInputDialog("S\u00e9lectionner l'option de maintenance");
        String[] split = sOption.split(";");
        switch (split[0]) {
            case "g2v2": {
                Fonctions.searchG2V2();
                break;
            }
            case "majactivity": {
                Fonctions.refreshActivityInDayTable(split.length > 1 ? split[1] : null, split.length > 2 ? split[2] : null);
                break;
            }
            case "doForAllCond": {
                Fonctions.doForAllCond();
                break;
            }
            case "doForAllSociete": {
                Fonctions.doForAllSociete(null);
                break;
            }
            case "reloadService": {
                Fonctions.reloadService(Integer.parseInt(split[1]), split[2], split[3]);
                break;
            }
            case "all": {
                Fonctions.doForAllSociete(null);
                break;
            }
            case "missing": {
                Fonctions.readMissing();
                break;
            }
            case "analyseSession": 
            case "1": {
                Fonctions.analyseUevSession(split.length > 1 ? split[1] : null, split.length > 2 ? split[2] : null);
                break;
            }
            case "2": 
            case "analyseVitesse": {
                Fonctions.analyseVitesse(split.length > 1 ? split[1] : null, split.length > 2 ? split[2] : null);
                break;
            }
            case "versionning": {
                Fonctions.versionning(null);
                break;
            }
            case "exec-script-maj": {
                Fonctions.doForAllSociete(split[1]);
                break;
            }
            case "majupdate": {
                Fonctions.majUpdate(null);
                break;
            }
            case "c": {
                Fonctions.correctionuev2(split[1], split[2], split.length > 3 ? split[3] : "0");
                break;
            }
            case "export": {
                Fonctions.exportAll();
                break;
            }
            case "exportt": {
                Fonctions.exportAllTims();
                break;
            }
            case "importf": {
                Fonctions.importAll("D:\\TIMS\\WEBFILES\\", Fonctions.getoff(), null);
                break;
            }
            case "import": {
                Fonctions.importAll("E:\\DATABASE\\ORACLE\\export\\", Fonctions.getFullMap(), null);
                break;
            }
            case "importt": {
                Fonctions.importAll("E:\\DATABASE\\ORACLE\\export\\tims\\", Fonctions.getTimsMap(), "timsl");
                break;
            }
            case "importfiche": {
                Fonctions.importAll("E:\\DATABASE\\ORACLE\\export\\tims\\", Fonctions.getTmp(), "tims");
                break;
            }
            case "getMax": {
                Fonctions.getMax();
                break;
            }
            case "getCount": {
                Fonctions.getCount();
                break;
            }
            case "getUnreadedFile": {
                Fonctions.getUnreadedFile(null, "2011-10-01");
                break;
            }
            case "getFiles": {
                Fonctions.getFiles(260582, 104269);
                break;
            }
            case "query": {
                if (split.length != 2) break;
                Fonctions.doQuery(split);
                break;
            }
            case "test": {
                Fonctions.test();
                break;
            }
            case "attachment": {
                Fonctions.attach();
                break;
            }
            case "tgd": {
                Fonctions.tgdTo1b();
                break;
            }
            case "s": {
                Fonctions.smcorrection();
                break;
            }
            case "app": {
                Fonctions.getNewApp();
                break;
            }
            case "nightHourCheck": {
                Fonctions.nightHourCheck();
                break;
            }
            case "speed": {
                Fonctions.speedCorrection(Integer.parseInt(split[1]));
                break;
            }
            default: {
                JOptionPane.showMessageDialog(null, "Pas d'op\u00e9ration de maintenance correspondante");
            }
        }
    }

    private static void searchG2V2() {
        ArrayList<String> list = new ArrayList<String>();
        Vector<Societe> tmp = Societe.loadList(null);
        for (Societe comp : tmp) {
            Transport.bdd.changeDB(comp, false);
            for (Vehicule v : Vehicule.loadUnrestrictedList(new Integer[0])) {
                if (!"4126".equals(v.getVuVersion())) continue;
                TimsLogger.debug(String.valueOf(v.getRegistrationNumber()) + " is new");
                list.add(String.valueOf(Transport.bdd.getCompany().getNomSociete()) + " " + v.getRegistrationNumber());
            }
        }
        for (String l : list) {
            System.out.println(l);
        }
    }

    private static void getNewApp() {
        BddTransport db = BddTransport.getInstance();
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            try {
                statement = db.getConnection().prepareStatement("select * from tims_app_dev.days where idDay = ?");
                statement.setObject(1, (Object)19, 4);
                rs = statement.executeQuery();
                while (rs.next()) {
                    Blob act = rs.getBlob("activity");
                    byte[] acts = rs.getBytes("activity");
                    int i = 0;
                    while (i < acts.length) {
                        TimsLogger.debug(Integer.toHexString(acts[i]));
                        ++i;
                    }
                    TimsLogger.debug("#Fonctions.getNewApp# " + rs.getDate("date") + " " + rs.getString("user") + " => " + rs.getInt("counterDriving") + "," + rs.getInt("counterOther") + "," + rs.getInt("counterResting") + " :: " + Fonctions.parseNewAct(act.getBytes(1L, (int)act.length())));
                }
            }
            catch (CommunicationsException ex) {
                BddTransport.getInstance().showTimeout();
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
            catch (SQLException ex) {
                TimsLogger.error("#Conducteur.loadId()#  sql = " + ex.getMessage());
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private static String parseNewAct(byte[] newAct) {
        String toReturn = "";
        boolean hasMore = newAct.length > 2;
        TimsLogger.debug("Fonctions.parseNewAct# parsing " + Fonctions.parseHexAscii(newAct, 0, newAct.length - 1));
        int offset = 0;
        while (hasMore) {
            int tag = Fonctions.bytesToInt(newAct, offset, 1);
            int length = Fonctions.bytesToInt(newAct, offset + 1, 1);
            byte[] data = Arrays.copyOfRange(newAct, offset + 2, offset + 2 + length);
            String hexa = Fonctions.parseHexAscii(data, 0, -1);
            offset += 2 + length;
            TimsLogger.debug(String.valueOf(tag) + " " + length + " " + hexa);
            String verb = "";
            if (tag == 1) {
                verb = Fonctions.appAct(data);
            }
            if (tag == 2) {
                verb = Fonctions.appPos(data);
            }
            if (tag == 3 || tag == 4) {
                Fonctions.appVeh(data);
            }
            toReturn = String.valueOf(toReturn) + tag + " " + length + " " + hexa + " => " + verb + "\r\n";
            boolean bl = hasMore = offset < newAct.length;
        }
        return toReturn;
    }

    private static String appAct(byte[] tmp) {
        String sTmp = Integer.toBinaryString(Fonctions.bytesToInt(tmp, 0, 2));
        while (sTmp.length() < 16) {
            sTmp = "0" + sTmp;
        }
        int time = Integer.parseInt(sTmp.substring(5, 16), 2);
        int activity = Integer.parseInt(sTmp.substring(1, 4), 2);
        return "< act " + activity + " at " + ConversionTime.heureIntToString(time, "h") + ">";
    }

    private static String appPos(byte[] tmp) {
        String sTmp = Integer.toBinaryString(Fonctions.bytesToInt(tmp, 0, 2));
        while (sTmp.length() < 16) {
            sTmp = "0" + sTmp;
        }
        int time = Integer.parseInt(sTmp.substring(5, 16), 2);
        int sign = Integer.parseInt(sTmp.substring(2, 4), 2);
        int latitude = Fonctions.bytesToInt(tmp, 2, 1);
        int latitudeR = Fonctions.bytesToInt(tmp, 3, 2);
        int longitude = Fonctions.bytesToInt(tmp, 5, 1);
        int longitudeR = Fonctions.bytesToInt(tmp, 6, 2);
        Float finalLatitude = Float.valueOf(Float.parseFloat(String.valueOf(sign << 1 == 1 ? "-" : "") + String.valueOf(latitude) + "," + latitudeR));
        Float finalLongitude = Float.valueOf(Float.parseFloat(String.valueOf(sign << 0 == 1 ? "-" : "") + String.valueOf(longitude) + "," + longitudeR));
        return "< pos <" + finalLatitude + " / " + finalLongitude + "> at " + time + ">";
    }

    private static String appVeh(byte[] tmp) {
        int vehicleId = Fonctions.bytesToInt(tmp, 0, 2);
        int km = Fonctions.bytesToInt(tmp, 2, 3);
        return "< veh " + vehicleId + " " + km + ">";
    }

    private static void smcorrection() {
        Vector<Societe> tmp = Societe.loadList(null);
        boolean found = false;
        boolean comp = false;
        String finalR = "";
        try {
            FileWriter fluxDay = new FileWriter("E:\\correction.log");
            int x = 0;
            while (x < tmp.size()) {
                boolean count = false;
                if (tmp.get(x).getNomSociete().equals("TFT")) {
                    comp = true;
                } else if (comp) {
                    Transport.bdd.changeDB(tmp.get(x).getNomSociete(), false);
                    Vector<Jour> jours = Transport.bdd.getJourByInsertion(0, "2022-03-04", 1, false);
                    TimsLogger.debug(String.valueOf(jours.size()) + " jours a v\u00e9rifier");
                    fluxDay.write(String.valueOf(jours.size()) + " jours a v\u00e9rifier sur " + tmp.get(x).getNomSociete() + "\r\n");
                    int currentDriver = -1;
                    Vector<Jour> driverDays = new Vector<Jour>();
                    block3: for (Jour jour : jours) {
                        if (currentDriver != jour.getDriverId()) {
                            if (currentDriver != -1) {
                                if (driverDays.size() != 0) {
                                    Conducteur driver = Conducteur.getDriver(null, currentDriver);
                                    fluxDay.write("On doit corriger pour " + driver.getLibelle() + " => ");
                                    Vector<CardDownload> cards = CardDownload.getTelechargement(0, currentDriver, "2022-02-15", null);
                                    if (cards.size() == 0) {
                                        fluxDay.write("Pas de fichier, c'est \u00e9trange ?");
                                        found = true;
                                    } else {
                                        CardDownload card = cards.get(cards.size() - 1);
                                        fluxDay.write(String.valueOf(card.getFichier()) + " : ");
                                        File toRead = FileManager.getFile(driver, card.getFichier());
                                        DriverCardSaving dcs = new DriverCardSaving(toRead);
                                        Vector<Jour> cardDays = dcs.getDays(currentDriver);
                                        block4: for (Jour day : driverDays) {
                                            fluxDay.write(String.valueOf(day.getDate()) + " / ");
                                            for (Jour cardDay : cardDays) {
                                                if (!day.getDate().equals(cardDay.getDate())) continue;
                                                cardDay.setUserId(day.getUserId());
                                                cardDay.setSourceName(day.getSourceName());
                                                String origin = day.getSQLInsert().substring(0, day.getSQLInsert().indexOf(String.valueOf(day.getUserId()) + "\t"));
                                                String cardS = cardDay.getSQLInsert().substring(0, cardDay.getSQLInsert().indexOf(String.valueOf(day.getUserId()) + "\t"));
                                                fluxDay.write(String.valueOf(cardDay.getActivity().size()) + " activities");
                                                fluxDay.write("\r\n");
                                                fluxDay.write(day.getSQLInsert());
                                                fluxDay.write("\r\n");
                                                fluxDay.write(cardDay.getSQLInsert());
                                                fluxDay.write("\r\n");
                                                fluxDay.flush();
                                                if (!origin.equals(cardS)) {
                                                    fluxDay.write("probl\u00e8mes, les jours ne semblent pas identiques");
                                                    fluxDay.flush();
                                                    found = true;
                                                    continue block4;
                                                }
                                                day.setActivity(cardDay.getActivity());
                                                day.setManualInput(cardDay.isManualInput());
                                                day.update();
                                                continue block4;
                                            }
                                        }
                                    }
                                    fluxDay.write("\r\n");
                                }
                                fluxDay.flush();
                                driverDays.clear();
                            }
                            currentDriver = jour.getDriverId();
                        }
                        for (ActiviteConducteur act : jour.getActivity()) {
                            if (!act.isManualInput() || act.getCleType() != 1) continue;
                            driverDays.add(jour);
                            continue block3;
                        }
                    }
                    fluxDay.flush();
                    if (found) {
                        System.exit(0);
                    }
                }
                ++x;
            }
            fluxDay.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void tgdTo1b() {
        String file = "C:\\Users\\Seb.DESKTOP-V4EH37M\\Desktop\\FICHIERS\\bayard\\V_GE-352-LT_E___20220221_0758";
        File[] fileArray = new File(file).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                Fonctions.convertTo1B(f);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
    }

    private static void attach() {
        String r = "";
        Vector<Vehicule> list = Vehicule.loadList(new Integer[0]);
        for (VehicleAttachment da : VehicleAttachment.loadList(-1)) {
            if (Charset.forName("US-ASCII").newEncoder().canEncode(da.getDocumentName())) continue;
            try {
                String path = Vehicule.getVehicule(list, da.getVehicleId()).getDataDirName().replace(" ", "\\ ");
                String old = da.getDocumentName().replace("\u00e9", "?").replace(" ", "\\ ");
                String newNa = da.getDocumentName().replace(" ", "\\ ");
                r = String.valueOf(r) + "sudo mv /var/www/PGH/web/tims/data/" + path + old + " /var/www/PGH/web/tims/data/" + path + newNa + "\r\n";
            }
            catch (Exception e) {
                TimsLogger.error(String.valueOf(da.getDocumentName()) + " vehicule nom trouv\u00e9 " + da.getVehicleId());
            }
        }
        TimsLogger.debug(r);
    }

    private static void test() {
        String dir = "C:\\Users\\Seb.DESKTOP-V4EH37M\\Desktop\\FICHIERS\\sogran\\210429\\files\\";
        File[] fileArray = new File(dir).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.isDirectory()) {
                if (CardDownload.exists(f.getName())) {
                    TimsLogger.debug(String.valueOf(f.getName()) + " ever read");
                } else {
                    TimsLogger.debug(String.valueOf(f.getName()) + " not read");
                    f.renameTo(new File(String.valueOf(dir) + "\\not\\" + f.getName()));
                }
            }
            ++n2;
        }
        Fonctions.testCheck();
    }

    private static void testCheck() {
        for (String m : Conducteur.getDriverCardNumberList("bayard")) {
            TimsLogger.debug(m);
        }
        for (String m : Vehicule.getRegistrationsList("bayard")) {
            TimsLogger.debug(m);
        }
    }

    private static void getFiles(int maxCard, int maxUev) {
        File fichier;
        String dir = "E:\\loomis\\files";
        for (CardDownload cardDownload : CardDownload.loadList("CLE_TELECHARGEMENT>" + maxCard)) {
            fichier = FileManager.getFile(cardDownload.getDriver(), cardDownload.getFichier());
            if (fichier == null) {
                TimsLogger.debug(String.valueOf(cardDownload.getFichier()) + " non r\u00e9cup\u00e9rable.");
                continue;
            }
            Fonctions.copyLocalFile(fichier, new File(String.valueOf(dir) + "\\" + cardDownload.getFichier()), false);
        }
        for (UevDownload uevDownload : UevDownload.loadList("CLE_TELECHARGEMENT>" + maxUev)) {
            fichier = FileManager.getFile(uevDownload.getVehicle(), uevDownload.getFichier());
            if (fichier == null) {
                TimsLogger.debug(String.valueOf(uevDownload.getFichier()) + " non r\u00e9cup\u00e9rable.");
                continue;
            }
            Fonctions.copyLocalFile(fichier, new File(String.valueOf(dir) + "\\" + uevDownload.getFichier()), false);
        }
    }

    private static void exportAllTims() {
        Fonctions.export("automatic_warning", "ID;NAME;CALCULATION_CLASS;FREQUENCY;EXECUTION_DATE", "1;0;0;1;1", "ID", null);
        Fonctions.export("company_warning_activation", "ID;ID_WARNING;ID_COMPANY", "1;1;1", "ID", null);
        Fonctions.export("droit_rapport", "CLE;CLE_PROFIL;CLE_RAPPORT;ENABLE", "1;1;1;1", "CLE", null);
        Fonctions.export("report", "ID;TRANSLATION_ID;CUSTOMIZED_NAME;FILE_NAME;MINIMUM_VERSION;CLASS;TYPE;MODULE", "1;1;0;0;1;0;1;1", "ID", null);
        Fonctions.export("t_droit", "CLE_DROIT;CLE_PROFIL;CLE_FICHE;ECRITURE;MODIFICATION;SUPPRESSION;CONSULTATION", "1;1;1;1;1;1;1", "CLE_DROIT", null);
        Fonctions.export("t_fiche", "CLE_FICHE;NOM_FICHE;DESCRIPTION_FICHE;DROIT_DEFAUT", "1;0;0;0", "CLE_FICHE", null);
        Fonctions.export("t_profil", "CLE_PROFIL;NOM_PROFIL;DESCRIPTION_PROFIL;DEFAUT", "1;0;0;1", "CLE_PROFIL", null);
        Fonctions.export("t_restriction", "CLE_RESTRICTION;CLE_USER;CLE_AGENCE;CLE_SOCIETE", "1;1;1;1", "CLE_RESTRICTION", null);
        Fonctions.export("t_societe", "CLE_SOCIETE;COMPANY_NAME;BASE_NAME;CODE;CONTACT;PHONE;FAX;MAIL;ADDRESS;CITY;POSTAL_CODE;COUNTRY;FIRST_NAME;LAST_NAME;FTP_DIRECTORY", "1;0;0;0;0;0;0;0;0;0;0;1;0;0;0", "CLE_SOCIETE", null);
        Fonctions.export("t_utilisateur", "CLE_UTILISATEUR;CLE_CHAUFFEUR;CLE_PROFIL;NOM_SOCIETE;LOGIN_UTILISATEUR;PASSWORD_UTILISATEUR;NOM_UTILISATEUR;PRENOM_UTILISATEUR;CLE_AGENCE;ADRESSE;TELEPHONE;VILLE;CODE_POSTAL;CHANGEMENT_PASSE;ANCIEN_PASSE;EMAIL;RESTRICTION_SOCIETE;RESTRICTION_AGENCE;RESTRICTION_CONDUCTEUR;ENABLE;ALERTED;LAST_ACTIVATION_ACTION", "1;1;1;0;0;0;0;0;1;0;0;0;0;4;0;0;1;1;1;1;1;4", "CLE_UTILISATEUR", null);
        Fonctions.export("user_message", "ID;NAME;MESSAGE;CREATION_DATE", "1;0;0;4", "ID", null);
        Fonctions.export("user_message_activation", "ID;MESSAGE_ID;USER_ID;VALIDATED;VALIDATION_DATE", "1;1;1;1;4", "ID", null);
        Fonctions.export("user_warning_activation", "ID;ID_WARNING;ID_USER", "1;1;1", "ID", null);
        Fonctions.export("ws_user", "ID;USER_ID;SELECTED_COMPANY_ID;IP;AUTH;ENABLE", "1;1;1;0;4;1", "ID", null);
    }

    private static void exportAll() {
        Fonctions.export("accident", "ID;IDENTIFICATION_NUMBER;INSURANCE_NUMBER;INSURANCE_TYPE;INSURANCE_CODE;CONVENTION_TYPE;AGENCY_ID;DRIVER_ID;VEHICLE_ID;DAY;PLACE;TYPE;INJURY;STEAL;DESCRIPTION;BIG_DAMAGES;RESPONSABILITY;GARAGE_ID;GARAGE_IN;GARAGE_OUT;TOWING;RC_COST;RC_EXCESS;INSURANCE_RECOURSE;COMPANY_RECOURSE;DAMAGE_EXCESS;VAT;DILAPIDATION;SELF_INSURANCE;EXPERT_COST;FIXING_COST;COMPANY_FIXING_COST;LOCATION_DEBT;COMPANY_LOCATION_DEBT;GUARDING;TOTAL_COST;TOTAL_INSURANCE;IN_TRAFFIC;OPENED", "1;0;0;0;0;0;1;1;1;4;0;1;1;1;0;1;1;1;4;4;1;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;2;0;0", "ID", "DAY>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("agency_type", "ID;NAME;CODE;ARCHIVED", "1;0;0;1", "ID", null);
        Fonctions.export("body_type", "ID;CODE;NAME;ARCHIVED", "1;0;0;1", "ID", null);
        Fonctions.export("calendar", "ID;NAME;ENABLE", "1;0;1", "ID", null);
        Fonctions.export("calendar_day", "ID;CALENDAR_ID;DAY_TYPE_ID;DAY_DATE", "1;1;1;3", "ID", "DAY_DATE>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("configuration", "ID;VALUE;EVAL;ENABLED;EDITABLE", "1;0;0;1;1", "ID", null);
        Fonctions.export("custom_report", "ID;NAME;TYPE", "1;0;1", "ID", null);
        Fonctions.export("custom_report_column", "ID;CUSTOM_REPORT_ID;NAME;VISIBLE_NAME;TYPE;EXPRESSION;WIDTH;POSITION", "1;1;0;0;0;0;1;1", "ID", null);
        Fonctions.export("custom_report_parameter", "ID;CUSTOM_REPORT_ID;NAME;VALUE;TYPE", "1;1;0;0;0", "ID", null);
        Fonctions.export("daily_vehicle_comment", "ID;VEHICLE_ID;DAY;COMM", "1;1;3;0", "ID", "DAY>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("driver_analytic_code", "ID;CODE;NAME;ARCHIVED", "1;0;0;1", "ID", null);
        Fonctions.export("driver_attachment", "ID;DRIVER_ID;DOCUMENT_NAME", "1;1;0", "ID", null);
        Fonctions.export("driver_vehicle_used", "CLE;CLE_CHAUFFEUR;CLE_VEHICULE;DATE_DEBUT;DATE_FIN;KM_DEBUT;KM_FIN;KM_EFFECTUE;SOURCE;NOM;PRENOM;NUMERO_CARTE;IMMATRICULATION;MANUAL_INPUT;LECTEUR", "1;1;1;4;4;1;1;1;1;0;0;0;0;1;1", "CLE", "DATE_DEBUT>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("employee_obligation", "ID;TYPE_ID;DRIVER_ID;DAY;PLACE;LENGTH;COST;STATE;ATTACHMENT", "1;1;1;3;0;1;2;1;0", "ID", "DAY>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("employee_obligation_attachment", "ID;EMPLOYEE_OBLIGATION_ID;DOCUMENT_NAME", "1;1;0", "ID", null);
        Fonctions.export("employee_obligation_type", "ID;CODE;LENGTH;NAME;PERIOD_EXPIRATION;DEFAULT_COST;WARNING_THRESHOLD;ERROR_THRESHOLD;ARCHIVED;GROUP_ID;PERMISSION_REQUIRED", "1;0;1;0;1;2;1;1;1;1;1", "ID", null);
        Fonctions.export("employee_obligation_type_group", "ID;NAME;CODE;ARCHIVED", "1;0;0;1", "ID", null);
        Fonctions.export("employee_type", "ID;NAME;CODE;ARCHIVED", "1;0;0;1", "ID", null);
        Fonctions.export("garage", "ID;AGENCY_ID;NAME;CODE;CONTACT;ADDRESS;CITY;POSTAL_CODE;PHONE;FAX;ARCHIVE", "1;1;0;0;0;0;0;0;0;0;1", "ID", null);
        Fonctions.export("injured", "ID;ACCIDENT_ID;EMPLOYEE;FIRST_NAME;LAST_NAME;ADDRESS;CITY;POSTAL_CODE;PHONE", "1;1;1;0;0;0;0;0;0", "ID", null);
        Fonctions.export("intervention", "ID;TYPE_ID;VEHICLE_ID;DAY;PERFORMER;MO_COST;COST;KM;STATE;ATTACHMENT", "1;1;1;3;0;2;2;1;1;0", "ID", null);
        Fonctions.export("intervention_type", "ID;CODE;NAME;KM_EXPIRATION;PERIOD_EXPIRATION;DEFAULT_COST;MO_COST;ARCHIVED", "1;0;0;1;1;2;2;1", "ID", null);
        Fonctions.export("offence", "ID;DRIVER_ID;DAY;HOUR;OFFENCE_PART_ID;THRESHOLD;ON_UPDATED;TYPE", "1;1;3;1;1;1;1;1", "ID", "DAY>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("offence_part", "ID;OFFENCE_TYPE_ID;NAME", "1;1;0", "ID", null);
        Fonctions.export("offence_threshold", "ID;OFFENCE_PART_ID;THRESHOLD;NAME", "1;1;1;0", "ID", null);
        Fonctions.export("offence_type", "ID;NAME;CLASS;MEMBER_STATE;COMPANY_TYPE;ENABLE", "1;0;0;1;1;1", "ID", null);
        Fonctions.export("place", "ID;DRIVER_ID;TYPE;DATE_CHANGE;COUNTRY;REGION;KM", "1;1;1;4;1;1;1", "ID", "DATE_CHANGE>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("region", "ID;COUNTRY_ID;NAME;CODE", "1;1;0;0", "ID", null);
        Fonctions.export("specific_condition", "ID;DRIVER_ID;SPECIFIC_TIMESTAMP;SPECIFIC_TYPE", "1;1;4;1", "ID", "SPECIFIC_TIMESTAMP>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_activite", "CLE_ACTIVITE;CLE_CHAUFFEUR;CLE_JOUR;HEURE_DEBUT;HEURE_FIN;DUREE_EN_MINUTE;FICHIER_IMPORT;SOURCE;ETAT_CARTE;ETAT_CONDUITE;LECTEUR;ANNEE_ACTIVITE;CLE_TYPE_ACTIV;ARCHIVAGE;CLE_DISQUE;NOM_SOURCE;SUPPRESSION;MODIFICATION", "1;1;1;1;1;1;0;0;0;0;0;3;1;1;1;0;1;1", "CLE_ACTIVITE", "ANNEE_ACTIVITE>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_activite_conflit_analyse", "CLE_ACTIVITE;CLE_CHAUFFEUR;CLE_JOUR;HEURE_DEBUT;HEURE_FIN;DUREE_EN_MINUTE;FICHIER_IMPORT;SOURCE;ETAT_CARTE;ETAT_CONDUITE;LECTEUR;ANNEE_ACTIVITE;CLE_TYPE_ACTIV;ARCHIVAGE;CLE_DISQUE;NOM_SOURCE;SUPPRESSION;MODIFICATION", "1;1;1;1;1;1;0;0;0;0;0;3;1;1;1;0;1;1", "CLE_ACTIVITE", "ANNEE_ACTIVITE>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_activite_conflit_base", "CLE_ACTIVITE;CLE_CHAUFFEUR;CLE_JOUR;HEURE_DEBUT;HEURE_FIN;DUREE_EN_MINUTE;FICHIER_IMPORT;SOURCE;ETAT_CARTE;ETAT_CONDUITE;LECTEUR;ANNEE_ACTIVITE;CLE_TYPE_ACTIV;ARCHIVAGE;CLE_DISQUE;NOM_SOURCE;SUPPRESSION;MODIFICATION", "1;1;1;1;1;1;0;0;0;0;0;3;1;1;1;0;1;1", "CLE_ACTIVITE", "ANNEE_ACTIVITE>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_activite_modifie", "CLE_ACTIVITE;CLE_CHAUFFEUR;CLE_JOUR;HEURE_DEBUT;HEURE_FIN;DUREE_EN_MINUTE;FICHIER_IMPORT;SOURCE;ETAT_CARTE;ETAT_CONDUITE;LECTEUR;ANNEE_ACTIVITE;CLE_TYPE_ACTIV;ARCHIVAGE;CLE_DISQUE;NOM_SOURCE;SUPPRESSION;MODIFICATION", "1;1;1;1;1;1;0;0;0;0;0;3;1;1;1;0;1;1", "CLE_ACTIVITE", "ANNEE_ACTIVITE>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_activite_uev", "CLE_ACTIVITE_UEV;CLE_VEHICULE;JOUR_TELECHARGE;HEURE_DEBUT;HEURE_FIN;ETAT_CARTE;ETAT_CONDUITE;LECTEUR;TYPE_ACTIV;DUREE", "1;1;3;1;1;0;0;0;0;1", "CLE_ACTIVITE_UEV", "JOUR_TELECHARGE>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_agence", "CLE_AGENCE;CLE_PAYS;DES_AGENCE;CODE_POSTAL;VILLE;TEL2;FAX;EMAIL;CLE_INTERNE_AGENCE;COMMENTAIRE;FICHIER_ASSOCIE;DATE_DEBUT;DATE_FIN;ADRESSE;TEL1;LOGO;CLE_TYPE_AGENCE;CLE_TAILLE_AGENCE;ARCHIVAGE;REGION_ID;DEFAULT_CALENDAR_ID;SAT_WORKING;CONSUMPTION_TARGET", "1;1;0;0;0;0;0;0;0;0;0;3;3;0;0;0;1;1;1;1;1;1;2", "CLE_AGENCE", null);
        Fonctions.export("t_anomalie_parent", "CLE_ANOMALIE_PARENT;CODE_ANOMALIE_PARENT;TYPE_ANOMALIE_PARENT", "1;0;0", "CLE_ANOMALIE_PARENT", null);
        Fonctions.export("t_conducteur", "CLE_CHAUFFEUR;TAUX_HORAIRE;DATE_NAISSANCE;CLE_AGENCE;CLE_TYPE_PAYE;CLE_PROFIL;NOM_CONDUCTEUR;PRENOM_CONDUCTEUR;MATRICULE_CHAUFFEUR;NUM_CARTE_CHAUFFEUR;MEMBER_STATE;REPLACEMENT;RENEWAL;RENEWAL_PENDING;NUM_CARTE_CHAUFFEUR_14;NUM_IMPORT_CHAUFFEUR;ADRESSE;CODE_POSTAL;VILLE;TEL1;TEL2;DATE_ENTREE_SOCIETE;DATE_DEBUT_VALIDITE_CARTE;DATE_EXPIRATION_CARTE;COMMENTAIRE;FICHIER_ASSOCIE;DATE_DERNIERE_VISITE_MEDICALE;TYPE_CONDUCTEUR;NUM_SECURITE_SOCIALE;ARCHIVAGE;CLE_TYPE_CHAUFFEUR;CALENDAR_ID;LOGO;DATE_DERNIER_CHANGEMENT;DATE_DERNIER_TELECHARGEMENT;DATE_SORTIE;DATE_CALCUL_BRUT;DATE_CALCUL_MODIFIE;IO_COUNTER;TRAVAIL_NUIT;FIMO_FCO;REGION_ID;TRAGEO_ID;DALLAS_KEY_ID;NIGHT_DAY;NUMERO_PERMIS;DATE_VISITE_PERMIS;DATE_DELIVRANCE_PERMIS;A;B;C;D;E;QUALIFICATION_CARD_NUMBER;ADR;CACES;LAST_EXPORT;ANALYTIC_CODE_ID;CONSUMPTION_TARGET;PAY_PERIOD_TYPE;EXPENSES_ALLOWANCE", "1;2;3;1;1;1;0;0;0;0;1;1;1;1;0;0;0;0;0;0;0;3;3;3;0;0;3;0;0;1;1;1;0;4;4;3;3;3;1;1;3;1;1;0;1;0;3;3;1;1;1;1;1;0;3;3;3;1;2;1;1", "CLE_CHAUFFEUR", null);
        Fonctions.export("t_conflit", "CLE_CONFLIT;CLE_CHAUFFEUR;CLE_USER;DATE_CONFLIT;TRAITE;CLE_TRAITANT;KM_ANALYSE;KM_BASE;DATE_CREATION;DATE_PROCESSION", "1;1;1;3;1;1;1;1;3;3", "CLE_CONFLIT", "DATE_CONFLIT>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_etalonnage", "CLE_ETALONNAGE;CLE_VEHICULE;TYPE;NOM_MAGASIN;ADRESSE_MAGASIN;TYPE_CARTE;NUMERO_CARTE;EXPIRATION_CARTE;IDENTIFICATION_VEHICULE;CLE_PAYS;ENREGISTREMENT_VEHICULE;W_VEHICULE;K_VEHICULE;L_VEHICULE;TYRE_SIZE;AUTHORIZED_SPEED;ANCIEN_KM;NOUVEAU_KM;ANCIENNE_DATE;NOUVELLE_DATE;PROCHAIN_ETALONNAGE", "1;1;1;0;0;1;0;3;0;1;0;1;1;1;0;1;1;1;3;3;3", "CLE_ETALONNAGE", null);
        Fonctions.export("t_event_uev", "CLE_EVENT_UEV;CLE_VEHICULE;DATE_DEBUT;DATE_FIN;TYPE_EVENT;RAISON_EVENT;NUM_CARTE_COND_DEBUT;NUM_CARTE_CONV_DEBUT;NUM_CARTE_COND_FIN;NUM_CARTE_CONV_FIN;NBR_SIMILAIRE", "1;1;4;4;0;0;0;0;0;0;0", "CLE_EVENT_UEV", "DATE_DEBUT>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_frais", "CLE;DESIGNATION;TYPE_DEBUT;HEURE_DEBUT;TYPE_FIN;HEURE_FIN;CUMUL_SERVICE;CUMUL_AVANT;CUMUL_APRES;MONTANT_FRANCE;MONTANT_ETRANGER;ACTIF;CODE;QUENCHER;ENABLED_DAY;BEGIN_AFTER;BEGIN_BEFORE;END_AFTER;END_BEFORE;HOUR;ARCHIVED;FAST_VIEW;BEGIN_VIEW;END_VIEW", "1;0;1;1;1;1;1;1;1;2;2;1;0;0;0;1;1;1;1;1;1;1;1;1", "CLE", null);
        Fonctions.export("t_anomalie_uev", "CLE_ANOMALIE_UEV;CLE_VEHICULE;DATE_DEBUT;DATE_FIN;TYPE_ANOMALIE;RAISON_ANOMALIE;NUM_CARTE_COND_DEBUT;NUM_CARTE_CONV_DEBUT;NUM_CARTE_COND_FIN;NUM_CARTE_CONV_FIN", "1;1;4;4;0;0;0;0;0;0", "CLE_ANOMALIE_UEV", "DATE_DEBUT>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_infractions", "CLE;CLE_CHAUFFEUR;\"DATE\";HEURE_DEPASSEMENT;NUM_INFRACTIONS;SEUIL_CONSTATE;BRUTE", "1;1;3;1;0;1;1", "CLE", "\"DATE\">TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_jour_uev", "ID;VEHICLE_ID;USER_ID;DATE_USE;KM;TOTAL;ACTIVITIES;DAILY_KM;DAY_COMMENT", "1;1;1;3;1;1;0;1;0", "ID", "DATE_USE>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_lien_jour_frais", "CLE_LIEN_JOUR_FRAIS;CLE_CHAUFFEUR;DATE_JOUR;CLE_FRAIS;ETRANGER;MONTANT;BASE;TAUX;FORFAIT;AUTOMATIC", "1;1;3;1;1;2;2;2;1;1", "CLE_LIEN_JOUR_FRAIS", "DATE_JOUR>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_io_uev", "CLE_IO_UEV;JOUR_TELECHARGE;CLE_VEHICULE;NOM;PRENOM;NUM_CARTE;DATE_INSERTION;DATE_RETRAIT;KM_INSERTION;KM_RETRAIT;MANUAL_INPUT;LECTEUR", "1;3;1;0;0;0;3;3;0;0;0;1", "CLE_IO_UEV", "JOUR_TELECHARGE>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_jour", "CLE;DATE_JOUR;CLE_CHAUFFEUR;CONDUITE;TRAVAIL;DISPO;REPOS;DOUBLE_EQUIP;EVENEMENT;AUTRE;CUMUL_T_C_D_DE;HEURE_DEBUT;HEURE_FIN;HEURE_NUIT;DISTANCE;MODIFICATION;SUPPRESSION;CLE_USER;DATE_INSERTION", "1;3;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;1;4", "CLE", "DATE_JOUR>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_jour_modifie", "CLE;DATE_JOUR;CLE_CHAUFFEUR;CLE_USER;CLE_AGENCE;CONDUITE;TRAVAIL;DISPO;REPOS;DOUBLE_EQUIP;EVENEMENT;AUTRE;CUMUL_T_C_D_DE;SEMAINE;ANNEE;NUM_JOUR;JOUR;DISTANCE;ARCHIVAGE;HEURE_DEBUT;HEURE_FIN;HEURE_NUIT;MODIFICATION;SUPPRESSION;DATE_INSERTION;CURRENT_VALUE", "1;3;1;1;1;1;1;1;1;1;1;1;1;1;1;1;0;1;1;1;1;1;1;1;4;1", "CLE", "DATE_JOUR>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_jour_type", "CLE;DESIGNATION;SERVICE;PAYE;GENERE_HS;GENERE_RC;SUPPRESSION;CODE;COLOR;FUTURE_SERVICE;WILL_BE_PAID;WILL_GENERATE_RC;WILL_GENERATE_HS;EXPORT;NO_SERVICE;AVG_VALUE;SENORITY", "1;0;1;1;1;1;1;0;1;1;1;1;1;1;1;1;1", "CLE", null);
        Fonctions.export("t_lien_jour_commass", "CLE_LIEN_JOUR_COMMASS;CLE_CHAUFFEUR;DATE_JOUR;COMM_ASS;CLE_COMMENT", "1;1;3;0;1", "CLE_LIEN_JOUR_COMMASS", "DATE_JOUR>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_lien_jour_conducteur", "CLE;CLE_CHAUFFEUR;CLE_JOUR_TYPE;CLE_USER;DATE_JOUR;HEURE_DEBUT;HEURE_FIN;DUREE;COMPLETE;TYPE", "1;1;1;1;3;1;1;1;1;1", "CLE", "DATE_JOUR>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_pays", "CLE_PAYS;CODE_PAYS;PREFIXE_PAYS;DES_PAYS", "1;1;0;0", "CLE_PAYS", null);
        Fonctions.export("t_raison_anomalie", "CLE_RAISON_ANOMALIE;CODE_RAISON;TYPE_RAISON", "1;0;0", "CLE_RAISON_ANOMALIE", null);
        Fonctions.export("t_service", "CLE_SERVICE;CLE_CHAUFFEUR;DATE_DEBUT;DATE_FIN;HEURE_DEBUT;HEURE_FIN;CONDUITE;TRAVAIL;DISPO;REPOS;DOUBLE_EQUIPAGE;INCONNU;EVENEMENT;SERVICE;AMPLITUDE;DISTANCE;HEURE_NUIT;NUIT_PENIBILITE;FRAIS;REPOS_JOURNALIER;FIRST_WORK;LAST_WORK;FIRST_WORK_AFTER_REST;SECOND_WORK_AFTER_REST;COUPURE;ROUND_ID;THEORIC_SERVICE_POINT;CALCULATED_SERVICE_POINT;FAULT", "1;1;4;4;1;1;1;1;1;1;1;1;1;1;1;1;1;1;2;1;1;1;1;1;1;1;1;1;1", "CLE_SERVICE", "DATE_DEBUT>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_speed_uev", "CLE_SPEED_UEV;CLE_VEHICULE;DATE_DEBUT;DATE_FIN;TYPE_SPEED;RAISON_SPEED;NUM_CARTE_COND;SPEED_MAX;SPEED_MOY;NBR_SIMILAIRE", "1;1;4;4;0;0;0;0;0;0", "CLE_SPEED_UEV", "DATE_DEBUT>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_suppression", "CLE_SUPPRESSION;CLE_JOUR;DATE_SUPPRESSION;COMMENTAIRE;CLE_USER", "1;1;4;0;1", "CLE_SUPPRESSION", "DATE_SUPPRESSION>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_taille_agence", "CLE_TAILLE_AGENCE;DESIGNATION_TAILLE", "1;0", "CLE_TAILLE_AGENCE", null);
        Fonctions.export("t_telechargement", "CLE_TELECHARGEMENT;CLE_CHAUFFEUR;CLE_USER;DATE_TELECHARGEMENT;NOM_FICHIER;MISSING", "1;1;1;4;0;1", "CLE_TELECHARGEMENT", "DATE_TELECHARGEMENT>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_telechargement_uev", "CLE_TELECHARGEMENT;CLE_VEHICULE;CLE_USER;DATE_TELECHARGEMENT;NOM_FICHIER;MISSING;BEGIN_ACTIVITY;END_ACTIVITY;PREVIOUS_DOWNLOAD", "1;1;1;4;0;1;3;3;4", "CLE_TELECHARGEMENT", "DATE_TELECHARGEMENT>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_type_activite", "ID;CODE;DESIGNATION;PERCENTAGE;PAYER;COULEUR;GENERE_HS;GENERE_RC;MODIFIABLE;MODIFICATION_LEVEL;REST;DELETED;SHOW_PAID", "1;0;0;1;1;1;1;1;1;1;1;1;1", "ID", null);
        Fonctions.export("t_type_anomalie", "CLE_TYPE_ANOMALIE;ANOMALIE_PARENT;CODE_ANOMALIE;TYPE_ANOMALIE", "1;0;0;0", "CLE_TYPE_ANOMALIE", null);
        Fonctions.export("t_type_paye", "CLE_TYPE_PAYE;DES_TYPE_PAYE", "1;0", "CLE_TYPE_PAYE", null);
        Fonctions.export("t_uev", "CLE_UEV;CLE_VEHICULE;DATE_MIN;DATE_MAX", "1;0;3;3", "CLE_UEV", "DATE_MIN>TO_DATE('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("t_vehicule", "CLE_VEHICULE;DESIGNATION_VEHICULE;Famille;Marque;N_IMMATRICULATION;IDENTIFICATION;NB_PLACES;NB_PLACES_CV;KM_DERNIER_RELEVE_COMPTEUR;DATE_CONTROLE1;DATE_CONTROLE2;DATE_CONTROLE3;DATE_VERIFICATION_EXTINCTEUR;DATE_CONTROLE_MINES;DATE_CONTROLE_TACHY;DATE_DERNIER_RELEVE_COMPTEUR;DERNIER_TELECHARGEMENT;REMARQUES;DATE_ENTREE;DATE_SORTIE;ARCHIVAGE;COMMENTAIRE;CLE_AGENCE;DATE_TECHNICAL;DATE_CALIBRATION;LOCATION_LIMIT;GUARANTEE;LOCATION_KM;DAILY_KM;LAST_KNOWN_KM;LOCATION_PRICE;OWNER;TYPE_ID;BODY_ID;AFFECTATION_ID;ANALYTIC_CODE_ID;MODEL_ID;CONSUMPTION_TARGET", "1;0;0;0;0;0;0;0;0;3;3;3;3;3;3;3;3;0;3;3;1;0;1;3;3;3;3;1;1;1;2;0;1;1;1;1;1;2", "CLE_VEHICULE", null);
        Fonctions.export("taux_base", "CLE;T115M;T118M;T120M;T128M;T138M;T150M;DATE_INSERTION;DATE_DEBUT", "1;2;2;2;2;2;2;4;3", "CLE", null);
        Fonctions.export("uev_event_fault", "ID;TYPE_ID;PURPOSE_ID;VEHICLE_ID;BEGIN;END;DRIVER_CARD_BEGIN;DRIVER_CARD_END;CODRIVER_CARD_BEGIN;CODRIVER_CARD_END;SIMILAR", "1;1;1;1;4;4;0;0;0;0;1", "ID", "BEGIN>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("uev_offence", "ID;OFFENCE_TYPE_ID;VEHICLE_ID;DRIVER_ID;BEGIN;END;LENGTH;THRESHOLD;GRAVITY", "1;1;1;1;4;4;1;1;1", "ID", "BEGIN>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("uev_session", "ID;VEHICLE_ID;OPEN;CLOSE;COMPANY;COMPANY_ADDRESS;COMPANY_CARD", "1;1;4;4;0;0;0", "ID", "OPEN>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
        Fonctions.export("vehicle_affectation", "ID;CODE;NAME;ARCHIVED", "1;0;0;1", "ID", null);
        Fonctions.export("vehicle_analytic_code", "ID;CODE;NAME;ARCHIVED", "1;0;0;1", "ID", null);
        Fonctions.export("vehicle_attachment", "ID;VEHICLE_ID;DOCUMENT_NAME", "1;0;0", "ID", null);
        Fonctions.export("vehicle_model", "ID;CODE;NAME;ARCHIVED", "1;0;0;1", "ID", null);
        Fonctions.export("vehicle_type", "ID;CODE;NAME;ARCHIVED", "1;0;0;1", "ID", null);
        Fonctions.export("vehicle_used", "CLE;CLE_CHAUFFEUR;CLE_VEHICULE;DATE_DEBUT;DATE_FIN;KM_DEBUT;KM_FIN;KM_EFFECTUE;MANUAL_INPUT;LECTEUR;SOURCE;NOM;PRENOM;NUMERO_CARTE;IMMATRICULATION", "1;1;1;4;4;1;1;1;0;1;1;0;0;0;0", "CLE", "DATE_DEBUT>TO_TIMESTAMP('2016-01-01','yyyy-mm-dd')");
    }

    private static void export(String table, String fields, String types, String orderField, String where) {
        boolean dryRun = false;
        String path = "E:\\DATABASE\\ORACLE\\export\\tims\\";
        if (table == null) {
            return;
        }
        String sql = "";
        String line = "";
        try {
            String[] fieldsArray = fields.split(";");
            String[] typesArray = types.split(";");
            int fieldCount = fieldsArray.length + 1;
            int typeCount = typesArray.length + 1;
            if (fieldCount != typeCount) {
                TimsLogger.error("#Fonctions.export# fieldCount and typeCount doesn't match");
                return;
            }
            String fieldsRequest = "";
            int x = 0;
            while (x < fieldsArray.length) {
                String type;
                String field = fieldsArray[x];
                switch (type = typesArray[x]) {
                    case "0": {
                        TimsLogger.debug("header " + table + " - get " + field + " (STRING)");
                        fieldsRequest = String.valueOf(fieldsRequest) + "," + field;
                        break;
                    }
                    case "1": {
                        TimsLogger.debug("header " + table + " - get " + field + " (INT)");
                        fieldsRequest = String.valueOf(fieldsRequest) + "," + field;
                        break;
                    }
                    case "2": {
                        TimsLogger.debug("header " + table + " - get " + field + " (FLOAT)");
                        fieldsRequest = String.valueOf(fieldsRequest) + "," + field;
                        break;
                    }
                    case "3": {
                        TimsLogger.debug("header " + table + " - get " + field + " (DATE)");
                        fieldsRequest = String.valueOf(fieldsRequest) + ",TO_CHAR(" + field + ",'yyyy-mm-dd') as " + field;
                        break;
                    }
                    case "4": {
                        TimsLogger.debug("header " + table + " - get " + field + " (DATETIME)");
                        fieldsRequest = String.valueOf(fieldsRequest) + ",TO_CHAR(" + field + ",'yyyy-mm-dd hh24:mi:ss') as " + field;
                    }
                }
                ++x;
            }
            sql = "SELECT " + fieldsRequest.substring(1) + " FROM " + table + (where == null ? "" : " WHERE " + where) + " ORDER BY " + orderField;
            if (dryRun) {
                sql = "select count(*) as nb from " + table + (where == null ? "" : " WHERE " + where);
            }
            TimsLogger.debug("header " + table + " - request " + sql);
            Statement stm = BddTransport.getInstance().getConnection().createStatement();
            ResultSet rs = stm.executeQuery(sql);
            FileWriter fw = null;
            BufferedWriter bw = null;
            if (dryRun) {
                rs.next();
                TimsLogger.debug(String.valueOf(table) + " has " + rs.getInt("nb") + " lines");
                rs.close();
                stm.close();
                return;
            }
            int counter = 0;
            while (rs.next()) {
                ++counter;
                if (fw == null) {
                    fw = new FileWriter(String.valueOf(path) + table + ".txt");
                    bw = new BufferedWriter(fw);
                }
                int x2 = 0;
                while (x2 < fieldsArray.length) {
                    String type;
                    String field = fieldsArray[x2];
                    switch (type = typesArray[x2]) {
                        case "0": {
                            line = String.valueOf(line) + ";\"" + (rs.getString(field) == null ? "\"" : String.valueOf(rs.getString(field).replace("\"", "\\\"")) + "\"");
                            break;
                        }
                        case "3": 
                        case "4": {
                            line = String.valueOf(line) + ";" + (rs.getString(field) == null ? "" : rs.getString(field));
                            break;
                        }
                        case "1": {
                            line = String.valueOf(line) + ";" + rs.getInt(field);
                            break;
                        }
                        case "2": {
                            line = String.valueOf(line) + ";" + rs.getFloat(field);
                            break;
                        }
                    }
                    ++x2;
                }
                bw.write("#!#" + line.substring(1));
                bw.newLine();
                line = "";
                if (counter % 50000 != 0) continue;
                TimsLogger.debug(String.valueOf(counter / 50000) + " - Free before flush " + Runtime.getRuntime().freeMemory());
                bw.flush();
                fw.flush();
                System.gc();
                TimsLogger.debug("Free after flush" + Runtime.getRuntime().freeMemory());
            }
            TimsLogger.debug(String.valueOf(table) + " => " + counter + " lines");
            if (counter > 0) {
                bw.flush();
                bw.close();
            }
            rs.close();
            stm.close();
        }
        catch (CommunicationsException ex) {
            ex.printStackTrace();
            BddTransport.getInstance().showTimeout();
        }
        catch (Exception ex) {
            TimsLogger.error("#Fonctions.export()# Erreur " + ex.getMessage() + " - sql = " + sql);
            ex.printStackTrace();
        }
    }

    private static void importAll(String sPath, HashMap<String, String> map, String prefix) {
        boolean dryRun = false;
        File path = new File(sPath);
        File[] fileArray = path.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File filetoinsert = fileArray[n2];
            TimsLogger.debug(String.valueOf(filetoinsert.getName()) + " process");
            String tableName = filetoinsert.getName().replaceFirst("[.][^.]+$", "");
            String fields = map.get(tableName);
            if (fields != null) {
                String sql = "load data local infile '" + BddTransport.addSlashes(filetoinsert.getAbsolutePath()) + "' into table " + (prefix == null ? "" : String.valueOf(prefix) + ".") + tableName + " FIELDS TERMINATED BY ';' (" + fields + ")";
                TimsLogger.debug(String.valueOf(tableName) + " => " + sql);
                if (!dryRun) {
                    BddTransport.getInstance().loadFile(sql);
                }
            } else {
                TimsLogger.debug(String.valueOf(filetoinsert.getName()) + " not found");
            }
            ++n2;
        }
    }

    private static HashMap<String, String> getTmp() {
        HashMap<String, String> map = new HashMap<String, String>();
        String t_fiche = "CLE_FICHE,NOM_FICHE,DESCRIPTION_FICHE,DROIT_DEFAUT";
        map.put("t_fiche", t_fiche);
        return map;
    }

    private static HashMap<String, String> getTimsMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String automatic_warning = "ID,NAME,CALCULATION_CLASS,FREQUENCY,EXECUTION_DATE";
        map.put("automatic_warning", automatic_warning);
        String company_warning_activation = "ID,ID_WARNING,ID_COMPANY";
        map.put("company_warning_activation", company_warning_activation);
        String droit_rapport = "CLE,CLE_PROFIL,CLE_RAPPORT,ENABLE";
        map.put("droit_rapport", droit_rapport);
        String report = "ID,TRANSLATION_ID,CUSTOMIZED_NAME,FILE_NAME,MINIMUM_VERSION,CLASS,TYPE,MODULE";
        map.put("report", report);
        String t_droit = "CLE_DROIT,CLE_PROFIL,CLE_FICHE,ECRITURE,MODIFICATION,SUPPRESSION,CONSULTATION";
        map.put("t_droit", t_droit);
        String t_fiche = "CLE_FICHE,NOM_FICHE,DESCRIPTION_FICHE,DROIT_DEFAUT";
        map.put("t_fiche", t_fiche);
        String t_profil = "CLE_PROFIL,NOM_PROFIL,DESCRIPTION_PROFIL,DEFAUT";
        map.put("t_profil", t_profil);
        String t_restriction = "CLE_RESTRICTION,CLE_USER,CLE_AGENCE,CLE_SOCIETE";
        map.put("t_restriction", t_restriction);
        String t_societe = "CLE_SOCIETE,COMPANY_NAME,BASE_NAME,CODE,CONTACT,PHONE,FAX,MAIL,ADDRESS,CITY,POSTAL_CODE,COUNTRY,FIRST_NAME,LAST_NAME,FTP_DIRECTORY";
        map.put("t_societe", t_societe);
        String t_utilisateur = "CLE_UTILISATEUR,CLE_CHAUFFEUR,CLE_PROFIL,NOM_SOCIETE,LOGIN_UTILISATEUR,PASSWORD_UTILISATEUR,NOM_UTILISATEUR,PRENOM_UTILISATEUR,CLE_AGENCE,ADRESSE,TELEPHONE,VILLE,CODE_POSTAL,CHANGEMENT_PASSE,ANCIEN_PASSE,EMAIL,RESTRICTION_SOCIETE,RESTRICTION_AGENCE,RESTRICTION_CONDUCTEUR,ENABLE,ALERTED,LAST_ACTIVATION_ACTION";
        map.put("t_utilisateur", t_utilisateur);
        String user_message = "ID,NAME,MESSAGE,CREATION_DATE";
        map.put("user_message", user_message);
        String user_message_activation = "ID,MESSAGE_ID,USER_ID,VALIDATED,VALIDATION_DATE";
        map.put("user_message_activation", user_message_activation);
        String user_warning_activation = "ID,ID_WARNING,ID_USER";
        map.put("user_warning_activation", user_warning_activation);
        String ws_user = "ID,USER_ID,SELECTED_COMPANY_ID,IP,AUTH,ENABLE";
        map.put("ws_user", ws_user);
        return map;
    }

    private static HashMap<String, String> getoff() {
        HashMap<String, String> map = new HashMap<String, String>();
        String uev_offence = "ID,OFFENCE_TYPE_ID,VEHICLE_ID,DRIVER_ID,BEGIN,END,LENGTH,THRESHOLD,GRAVITY";
        map.put("uev_offence", uev_offence);
        return map;
    }

    private static HashMap<String, String> getFullMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        String accident = "ID,IDENTIFICATION_NUMBER,INSURANCE_NUMBER,INSURANCE_TYPE,INSURANCE_CODE,CONVENTION_TYPE,AGENCY_ID,DRIVER_ID,VEHICLE_ID,DAY,PLACE,TYPE,INJURY,STEAL,DESCRIPTION,BIG_DAMAGES,RESPONSABILITY,GARAGE_ID,GARAGE_IN,GARAGE_OUT,TOWING,RC_COST,RC_EXCESS,INSURANCE_RECOURSE,COMPANY_RECOURSE,DAMAGE_EXCESS,VAT,DILAPIDATION,SELF_INSURANCE,EXPERT_COST,FIXING_COST,COMPANY_FIXING_COST,LOCATION_DEBT,COMPANY_LOCATION_DEBT,GUARDING,TOTAL_COST,TOTAL_INSURANCE,IN_TRAFFIC,OPENED";
        map.put("accident", accident);
        String accident_action = "ID,USER_ID,INSERTION_DATE,ACCIDENT_ID,PURPOSE";
        map.put("accident_action", accident_action);
        String agency_type = "ID,NAME,CODE,ARCHIVED";
        map.put("agency_type", agency_type);
        String body_type = "ID,CODE,NAME,ARCHIVED";
        map.put("body_type", body_type);
        String calendar = "ID,NAME,ENABLE";
        map.put("calendar", calendar);
        String calendar_day = "ID,CALENDAR_ID,DAY_TYPE_ID,DAY_DATE";
        map.put("calendar_day", calendar_day);
        String close_pay_period = "ID,PAY_PERIOD_ID,AGENCY_ID,USER_ID,CLOTURE,EXPORTED,CLOTURE_DATE,ACTIVE";
        map.put("close_pay_period", close_pay_period);
        String comment = "CLE,DESIGNATION";
        map.put("comment", comment);
        String company_card = "ID,AGENCY_ID,CARD_NUMBER,MEMBER_STATE,ISSUE_DATE,VALIDITY_BEGIN,EXPIRY,COMPANY_NAME,COMPANY_ADDRESS,PREFERRED_LANGUAGE,ARCHIVED,OWNER";
        map.put("company_card", company_card);
        String configuration = "ID,VALUE,EVAL,ENABLED,EDITABLE";
        map.put("configuration", configuration);
        String consumption_criteria = "ID,NAME";
        map.put("consumption_criteria", consumption_criteria);
        String consumption_eval = "ID,NAME,PERCENTAGE,COLOR";
        map.put("consumption_eval", consumption_eval);
        String consumption_mark = "ID,DRIVER_ID,CRITERIA_ID,CONSUMPTION_EVAL_ID";
        map.put("consumption_mark", consumption_mark);
        String custom_report = "ID,NAME,TYPE";
        map.put("custom_report", custom_report);
        String custom_report_column = "ID,CUSTOM_REPORT_ID,NAME,VISIBLE_NAME,TYPE,EXPRESSION,WIDTH,POSITION";
        map.put("custom_report_column", custom_report_column);
        String custom_report_parameter = "ID,CUSTOM_REPORT_ID,NAME,VALUE,TYPE";
        map.put("custom_report_parameter", custom_report_parameter);
        String daily_vehicle_comment = "ID,VEHICLE_ID,DAY,COMM";
        map.put("daily_vehicle_comment", daily_vehicle_comment);
        String driver_analytic_code = "ID,CODE,NAME,ARCHIVED";
        map.put("driver_analytic_code", driver_analytic_code);
        String driver_attachment = "ID,DRIVER_ID,DOCUMENT_NAME";
        map.put("driver_attachment", driver_attachment);
        String driver_vehicle_used = "CLE,CLE_CHAUFFEUR,CLE_VEHICULE,DATE_DEBUT,DATE_FIN,KM_DEBUT,KM_FIN,KM_EFFECTUE,SOURCE,NOM,PRENOM,NUMERO_CARTE,IMMATRICULATION,MANUAL_INPUT,LECTEUR";
        map.put("driver_vehicle_used", driver_vehicle_used);
        String employee_obligation = "ID,TYPE_ID,DRIVER_ID,DAY,PLACE,LENGTH,COST,STATE,ATTACHMENT";
        map.put("employee_obligation", employee_obligation);
        String employee_obligation_attachment = "ID,EMPLOYEE_OBLIGATION_ID,DOCUMENT_NAME";
        map.put("employee_obligation_attachment", employee_obligation_attachment);
        String employee_obligation_type = "ID,CODE,LENGTH,NAME,PERIOD_EXPIRATION,DEFAULT_COST,WARNING_THRESHOLD,ERROR_THRESHOLD,ARCHIVED,GROUP_ID,PERMISSION_REQUIRED";
        map.put("employee_obligation_type", employee_obligation_type);
        String employee_obligation_type_group = "ID,NAME,CODE,ARCHIVED";
        map.put("employee_obligation_type_group", employee_obligation_type_group);
        String employee_type = "ID,NAME,CODE,ARCHIVED";
        map.put("employee_type", employee_type);
        String expenses_validation = "ID,DRIVER_ID,DAY,VALID_DATE,USER_VALID,UNVALID_DATE,USER_UNVALID";
        map.put("expenses_validation", expenses_validation);
        String external_data_fault = "ID,DRIVER_ID,DAY,USER_ID";
        map.put("external_data_fault", external_data_fault);
        String external_day = "ID,DRIVER_ID,BEGIN_DATE,END_DATE,ACTIVITIES,DRIVING,WORK,AVAILABILITY,REST,CREW,EVENT,OTHER,TOTAL,DISTANCE,BEGIN_TIME,END_TIME,USER_ID,DATE_INSERTION";
        map.put("external_day", external_day);
        String fault = "ID,DRIVER_ID,DAY,TYPE,USER_ID";
        map.put("fault", fault);
        String fuel_consumption = "ID,AGENCY_ID,DRIVER_ID,VEHICLE_ID,DATE,CONSUMPTION,LITERS,LENGTH,KM,STOP_LENGTH,STOP_LENGTH_STRENGTH,STOP_LENGTH_IN_TRAFFIC,LENGTH_BRAKE,REG_DELTA,CO2,TRAVEL_NOTATION";
        map.put("fuel_consumption", fuel_consumption);
        String garage = "ID,AGENCY_ID,NAME,CODE,CONTACT,ADDRESS,CITY,POSTAL_CODE,PHONE,FAX,ARCHIVE";
        map.put("garage", garage);
        String hardness = "ID,NAME,CODE,CALCULATOR_CLASS,WARNING_THRESHOLD,ATTRIBUTION_THRESHOLD";
        map.put("hardness", hardness);
        String hardness_attribution = "ID,DRIVER_ID,HARDNESS_ID,YEAR,ATTRIBUTION,USER_ID,CREATION,ENABLE,COUNTER,RECALCULATION";
        map.put("hardness_attribution", hardness_attribution);
        String import_field = "ID,IMPORT_MODULE_ID,NAME,FIELD_VALUE";
        map.put("import_field", import_field);
        String import_module = "ID,NAME";
        map.put("import_module", import_module);
        String injured = "ID,ACCIDENT_ID,EMPLOYEE,FIRST_NAME,LAST_NAME,ADDRESS,CITY,POSTAL_CODE,PHONE";
        map.put("injured", injured);
        String intervention = "ID,TYPE_ID,VEHICLE_ID,DAY,PERFORMER,MO_COST,COST,KM,STATE,ATTACHMENT";
        map.put("intervention", intervention);
        String intervention_type = "ID,CODE,NAME,KM_EXPIRATION,PERIOD_EXPIRATION,DEFAULT_COST,MO_COST,ARCHIVED";
        map.put("intervention_type", intervention_type);
        String irregularity = "CLE_ACTIVITE,CLE_CHAUFFEUR,CLE_JOUR,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE,FICHIER_IMPORT,SOURCE,ETAT_CARTE,ETAT_CONDUITE,LECTEUR,ANNEE_ACTIVITE,CLE_TYPE_ACTIV,ARCHIVAGE,CLE_DISQUE,NOM_SOURCE,SUPPRESSION,MODIFICATION";
        map.put("irregularity", irregularity);
        String offence = "ID,DRIVER_ID,DAY,HOUR,OFFENCE_PART_ID,THRESHOLD,ON_UPDATED,TYPE";
        map.put("offence", offence);
        String offence_part = "ID,OFFENCE_TYPE_ID,NAME";
        map.put("offence_part", offence_part);
        String offence_threshold = "ID,OFFENCE_PART_ID,THRESHOLD,NAME";
        map.put("offence_threshold", offence_threshold);
        String offence_type = "ID,NAME,CLASS,MEMBER_STATE,COMPANY_TYPE,ENABLE";
        map.put("offence_type", offence_type);
        String pay_period = "ID,NAME,BEGIN,END";
        map.put("pay_period", pay_period);
        String place = "ID,DRIVER_ID,TYPE,DATE_CHANGE,COUNTRY,REGION,KM";
        map.put("place", place);
        String region = "ID,COUNTRY_ID,NAME,CODE";
        map.put("region", region);
        String repairing = "ID,DAY,ACCIDENT_ID,GARAGE_ID,PURPOSE,TOTAL_COST,MO_COST";
        map.put("repairing", repairing);
        String round_affectation = "ID,ROUND_ID,DRIVER_ID,VEHICLE_ID,ROUND_DATE,SERVICE_POINT,CLIENT_COUNT,DELIVERY_PARCEL,PICKING_PARCEL,DONE,BEGIN_TIME,LOAD_TIME,TOTAL_CUT_TIME,DELIVERY_TIME,RETURN_TIME,UNLOAD_TIME,TOTAL_TIME,STOP_SERVICE_POINT,DELIVERED_PARCEL,UNDELIVERED_PARCEL,PICKED_PARCEL,CLIENT_DELIVERED,KM";
        map.put("round_affectation", round_affectation);
        String round_type = "ID,ROUND_CODE,DESCRIPTION,MAX_SERVICE_POINT,MAX_PARCEL,BEGIN_TIME,LOAD_TIME,TOTAL_CUT_TIME,RETURN_TIME,UNLOAD_TIME,TOTAL_TIME,AVG_DELIVERY_TIME,KM,ARCHIVED";
        map.put("round_type", round_type);
        String specific_condition = "ID,DRIVER_ID,SPECIFIC_TIMESTAMP,SPECIFIC_TYPE";
        map.put("specific_condition", specific_condition);
        String t_activite_conflit_analyse = "CLE_ACTIVITE,CLE_CHAUFFEUR,CLE_JOUR,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE,FICHIER_IMPORT,SOURCE,ETAT_CARTE,ETAT_CONDUITE,LECTEUR,ANNEE_ACTIVITE,CLE_TYPE_ACTIV,ARCHIVAGE,CLE_DISQUE,NOM_SOURCE,SUPPRESSION,MODIFICATION";
        map.put("t_activite_conflit_analyse", t_activite_conflit_analyse);
        String t_activite_conflit_base = "CLE_ACTIVITE,CLE_CHAUFFEUR,CLE_JOUR,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE,FICHIER_IMPORT,SOURCE,ETAT_CARTE,ETAT_CONDUITE,LECTEUR,ANNEE_ACTIVITE,CLE_TYPE_ACTIV,ARCHIVAGE,CLE_DISQUE,NOM_SOURCE,SUPPRESSION,MODIFICATION";
        map.put("t_activite_conflit_base", t_activite_conflit_base);
        String t_activite_modifie = "CLE_ACTIVITE,CLE_CHAUFFEUR,CLE_JOUR,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE,FICHIER_IMPORT,SOURCE,ETAT_CARTE,ETAT_CONDUITE,LECTEUR,ANNEE_ACTIVITE,CLE_TYPE_ACTIV,ARCHIVAGE,CLE_DISQUE,NOM_SOURCE,SUPPRESSION,MODIFICATION";
        map.put("t_activite_modifie", t_activite_modifie);
        String t_agence = "CLE_AGENCE,CLE_PAYS,DES_AGENCE,CODE_POSTAL,VILLE,TEL2,FAX,EMAIL,CLE_INTERNE_AGENCE,COMMENTAIRE,FICHIER_ASSOCIE,DATE_DEBUT,DATE_FIN,ADRESSE,TEL1,LOGO,CLE_TYPE_AGENCE,CLE_TAILLE_AGENCE,ARCHIVAGE,REGION_ID,DEFAULT_CALENDAR_ID,SAT_WORKING,CONSUMPTION_TARGET";
        map.put("t_agence", t_agence);
        String t_anomalie_parent = "CLE_ANOMALIE_PARENT,CODE_ANOMALIE_PARENT,TYPE_ANOMALIE_PARENT";
        map.put("t_anomalie_parent", t_anomalie_parent);
        String t_anomalie_uev = "CLE_ANOMALIE_UEV,CLE_VEHICULE,DATE_DEBUT,DATE_FIN,TYPE_ANOMALIE,RAISON_ANOMALIE,NUM_CARTE_COND_DEBUT,NUM_CARTE_CONV_DEBUT,NUM_CARTE_COND_FIN,NUM_CARTE_CONV_FIN";
        map.put("t_anomalie_uev", t_anomalie_uev);
        String t_conflit = "CLE_CONFLIT,CLE_CHAUFFEUR,CLE_USER,DATE_CONFLIT,TRAITE,CLE_TRAITANT,KM_ANALYSE,KM_BASE,DATE_CREATION,DATE_PROCESSION";
        map.put("t_conflit", t_conflit);
        String t_etalonnage = "CLE_ETALONNAGE,CLE_VEHICULE,TYPE,NOM_MAGASIN,ADRESSE_MAGASIN,TYPE_CARTE,NUMERO_CARTE,EXPIRATION_CARTE,IDENTIFICATION_VEHICULE,CLE_PAYS,ENREGISTREMENT_VEHICULE,W_VEHICULE,K_VEHICULE,L_VEHICULE,TYRE_SIZE,AUTHORIZED_SPEED,ANCIEN_KM,NOUVEAU_KM,ANCIENNE_DATE,NOUVELLE_DATE,PROCHAIN_ETALONNAGE";
        map.put("t_etalonnage", t_etalonnage);
        String t_event_uev = "CLE_EVENT_UEV,CLE_VEHICULE,DATE_DEBUT,DATE_FIN,TYPE_EVENT,RAISON_EVENT,NUM_CARTE_COND_DEBUT,NUM_CARTE_CONV_DEBUT,NUM_CARTE_COND_FIN,NUM_CARTE_CONV_FIN,NBR_SIMILAIRE";
        map.put("t_event_uev", t_event_uev);
        String t_export = "CLE_EXPORT,CLE_CHAUFFEUR,TIMESTAMP_EXPORT,TYPE_FLAG";
        map.put("t_export", t_export);
        String t_export_update = "CLE_EXPORT_UPDATE,CLE_CHAUFFEUR,TIMESTAMP_EXPORT,USER_ID,AUTO_UPDATE";
        map.put("t_export_update", t_export_update);
        String t_frais = "CLE,DESIGNATION,TYPE_DEBUT,HEURE_DEBUT,TYPE_FIN,HEURE_FIN,CUMUL_SERVICE,CUMUL_AVANT,CUMUL_APRES,MONTANT_FRANCE,MONTANT_ETRANGER,ACTIF,CODE,QUENCHER,ENABLED_DAY,BEGIN_AFTER,BEGIN_BEFORE,END_AFTER,END_BEFORE,HOUR,ARCHIVED,FAST_VIEW,BEGIN_VIEW,END_VIEW";
        map.put("t_frais", t_frais);
        String t_historique_activite = "CLE_ACTIVITE,CLE_CHAUFFEUR,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE,SOURCE,ETAT_CARTE,ETAT_CONDUITE,LECTEUR,ANNEE_ACTIVITE,CLE_TYPE_ACTIV,VERSION_MODIFICATION";
        map.put("t_historique_activite", t_historique_activite);
        String t_infractions = "CLE,CLE_CHAUFFEUR,DATE,HEURE_DEPASSEMENT,NUM_INFRACTIONS,SEUIL_CONSTATE,BRUTE";
        map.put("t_infractions", t_infractions);
        String t_io_uev = "CLE_IO_UEV,JOUR_TELECHARGE,CLE_VEHICULE,NOM,PRENOM,NUM_CARTE,DATE_INSERTION,DATE_RETRAIT,KM_INSERTION,KM_RETRAIT,MANUAL_INPUT,LECTEUR";
        map.put("t_io_uev", t_io_uev);
        String t_jour = "CLE,DATE_JOUR,CLE_CHAUFFEUR,CONDUITE,TRAVAIL,DISPO,REPOS,DOUBLE_EQUIP,EVENEMENT,AUTRE,CUMUL_T_C_D_DE,HEURE_DEBUT,HEURE_FIN,HEURE_NUIT,DISTANCE,MODIFICATION,SUPPRESSION,CLE_USER,DATE_INSERTION,ACTIVITIES";
        map.put("t_jour", t_jour);
        String t_jour_modifie = "CLE,DATE_JOUR,CLE_CHAUFFEUR,CLE_USER,CLE_AGENCE,CONDUITE,TRAVAIL,DISPO,REPOS,DOUBLE_EQUIP,EVENEMENT,AUTRE,CUMUL_T_C_D_DE,SEMAINE,ANNEE,NUM_JOUR,JOUR,DISTANCE,ARCHIVAGE,HEURE_DEBUT,HEURE_FIN,HEURE_NUIT,MODIFICATION,SUPPRESSION,DATE_INSERTION,CURRENT_VALUE,ACTIVITIES";
        map.put("t_jour_modifie", t_jour_modifie);
        String t_jour_type = "CLE,DESIGNATION,SERVICE,PAYE,GENERE_HS,GENERE_RC,SUPPRESSION,CODE,COLOR,FUTURE_SERVICE,WILL_BE_PAID,WILL_GENERATE_RC,WILL_GENERATE_HS,EXPORT,NO_SERVICE,AVG_VALUE,SENORITY";
        map.put("t_jour_type", t_jour_type);
        String t_jour_uev = "ID,VEHICLE_ID,USER_ID,DATE_USE,KM,TOTAL,ACTIVITIES,DAILY_KM,DAY_COMMENT";
        map.put("t_jour_uev", t_jour_uev);
        String t_lien_jour_commass = "CLE_LIEN_JOUR_COMMASS,CLE_CHAUFFEUR,DATE_JOUR,COMM_ASS,CLE_COMMENT";
        map.put("t_lien_jour_commass", t_lien_jour_commass);
        String t_lien_jour_conducteur = "CLE,CLE_CHAUFFEUR,CLE_JOUR_TYPE,CLE_USER,DATE_JOUR,HEURE_DEBUT,HEURE_FIN,DUREE,COMPLETE,TYPE";
        map.put("t_lien_jour_conducteur", t_lien_jour_conducteur);
        String t_lien_jour_frais = "CLE_LIEN_JOUR_FRAIS,CLE_CHAUFFEUR,DATE_JOUR,CLE_FRAIS,ETRANGER,MONTANT,BASE,TAUX,FORFAIT,AUTOMATIC";
        map.put("t_lien_jour_frais", t_lien_jour_frais);
        String t_pays = "CLE_PAYS,CODE_PAYS,PREFIXE_PAYS,DES_PAYS";
        map.put("t_pays", t_pays);
        String t_raison_anomalie = "CLE_RAISON_ANOMALIE,CODE_RAISON,TYPE_RAISON";
        map.put("t_raison_anomalie", t_raison_anomalie);
        String t_regle_frais = "CLE_REGLE_FRAIS,BORNE1,BORNE2,CHOIX,BORNE3,BORNE4,BORNE5,BORNE6,DESIGNATION,ARCHIVAGE";
        map.put("t_regle_frais", t_regle_frais);
        String t_scan_image = "CLE,CLE_USER,DATE_SCAN,DATE_PROCESSION,NOM,NUMERO,PATH,PROCESSED";
        map.put("t_scan_image", t_scan_image);
        String t_service = "CLE_SERVICE,CLE_CHAUFFEUR,DATE_DEBUT,DATE_FIN,HEURE_DEBUT,HEURE_FIN,CONDUITE,TRAVAIL,DISPO,REPOS,DOUBLE_EQUIPAGE,INCONNU,EVENEMENT,SERVICE,AMPLITUDE,DISTANCE,HEURE_NUIT,NUIT_PENIBILITE,FRAIS,REPOS_JOURNALIER,FIRST_WORK,LAST_WORK,FIRST_WORK_AFTER_REST,SECOND_WORK_AFTER_REST,COUPURE,ROUND_ID,THEORIC_SERVICE_POINT,CALCULATED_SERVICE_POINT,FAULT";
        map.put("t_service", t_service);
        String t_speed_uev = "CLE_SPEED_UEV,CLE_VEHICULE,DATE_DEBUT,DATE_FIN,TYPE_SPEED,RAISON_SPEED,NUM_CARTE_COND,SPEED_MAX,SPEED_MOY,NBR_SIMILAIRE";
        map.put("t_speed_uev", t_speed_uev);
        String t_suppression = "CLE_SUPPRESSION,CLE_JOUR,DATE_SUPPRESSION,COMMENTAIRE,CLE_USER";
        map.put("t_suppression", t_suppression);
        String t_taille_agence = "CLE_TAILLE_AGENCE,DESIGNATION_TAILLE";
        map.put("t_taille_agence", t_taille_agence);
        String t_tbl_infractions = "CLE,DESIGNATION,TYPE_REGLE,SEUIL,AFFICHABLE,TYPE_REGLE_E_V,CLE_DESIGNATION";
        map.put("t_tbl_infractions", t_tbl_infractions);
        String t_telechargement = "CLE_TELECHARGEMENT,CLE_CHAUFFEUR,CLE_USER,DATE_TELECHARGEMENT,NOM_FICHIER,MISSING";
        map.put("t_telechargement", t_telechargement);
        String t_telechargement_uev = "CLE_TELECHARGEMENT,CLE_VEHICULE,CLE_USER,DATE_TELECHARGEMENT,NOM_FICHIER,MISSING,BEGIN_ACTIVITY,END_ACTIVITY,PREVIOUS_DOWNLOAD";
        map.put("t_telechargement_uev", t_telechargement_uev);
        String t_tournee = "CLE,DESIGNATION,BEGIN_TIME,BEGIN_PLACE,END_TIME,END_PLACE,DRIVING,WORK,AVAILABILITY,REST,SERVICE_COUNT,KM,COMMENT";
        map.put("t_tournee", t_tournee);
        String t_type_activite = "ID,CODE,DESIGNATION,PERCENTAGE,PAYER,COULEUR,GENERE_HS,GENERE_RC,MODIFIABLE,MODIFICATION_LEVEL,REST,DELETED,SHOW_PAID";
        map.put("t_type_activite", t_type_activite);
        String t_type_anomalie = "CLE_TYPE_ANOMALIE,ANOMALIE_PARENT,CODE_ANOMALIE,TYPE_ANOMALIE";
        map.put("t_type_anomalie", t_type_anomalie);
        String t_type_paye = "CLE_TYPE_PAYE,DES_TYPE_PAYE";
        map.put("t_type_paye", t_type_paye);
        String t_uev = "CLE_UEV,CLE_VEHICULE,DATE_MIN,DATE_MAX";
        map.put("t_uev", t_uev);
        String t_vehicule = "CLE_VEHICULE,DESIGNATION_VEHICULE,Famille,Marque,N_IMMATRICULATION,IDENTIFICATION,NB_PLACES,NB_PLACES_CV,KM_DERNIER_RELEVE_COMPTEUR,DATE_CONTROLE1,DATE_CONTROLE2,DATE_CONTROLE3,DATE_VERIFICATION_EXTINCTEUR,DATE_CONTROLE_MINES,DATE_CONTROLE_TACHY,DATE_DERNIER_RELEVE_COMPTEUR,DERNIER_TELECHARGEMENT,REMARQUES,DATE_ENTREE,DATE_SORTIE,ARCHIVAGE,COMMENTAIRE,CLE_AGENCE,DATE_TECHNICAL,DATE_CALIBRATION,LOCATION_LIMIT,GUARANTEE,LOCATION_KM,DAILY_KM,LAST_KNOWN_KM,LOCATION_PRICE,OWNER,TYPE_ID,BODY_ID,AFFECTATION_ID,ANALYTIC_CODE_ID,MODEL_ID,CONSUMPTION_TARGET";
        map.put("t_vehicule", t_vehicule);
        String taux_base = "CLE,T115M,T118M,T120M,T128M,T138M,T150M,DATE_INSERTION,DATE_DEBUT";
        map.put("taux_base", taux_base);
        String tracking = "ID,USER_ID,ACTION_TYPE,ACTION_DATE,CONTENT,TABLE_CHANGED";
        map.put("tracking", tracking);
        String type_contrat = "CLE,DESIGNATION,HEURE_CONTRAT,HEURE_MAXIMUM,SEUIL_HN,SEUIL_HE,SEUIL_HS25,CALCULATION_TYPE,GARANTIE,DAILY_VALUE";
        map.put("type_contrat", type_contrat);
        String uev_event_fault = "ID,TYPE_ID,PURPOSE_ID,VEHICLE_ID,BEGIN,END,DRIVER_CARD_BEGIN,DRIVER_CARD_END,CODRIVER_CARD_BEGIN,CODRIVER_CARD_END,SIMILAR";
        map.put("uev_event_fault", uev_event_fault);
        String uev_offence = "ID,OFFENCE_TYPE_ID,VEHICLE_ID,DRIVER_ID,BEGIN,END,LENGTH,THRESHOLD,GRAVITY";
        map.put("uev_offence", uev_offence);
        String uev_session = "ID,VEHICLE_ID,OPEN,CLOSE,COMPANY,COMPANY_ADDRESS,COMPANY_CARD";
        map.put("uev_session", uev_session);
        String vehicle_affectation = "ID,CODE,NAME,ARCHIVED";
        map.put("vehicle_affectation", vehicle_affectation);
        String vehicle_analytic_code = "ID,CODE,NAME,ARCHIVED";
        map.put("vehicle_analytic_code", vehicle_analytic_code);
        String vehicle_attachment = "ID,VEHICLE_ID,DOCUMENT_NAME";
        map.put("vehicle_attachment", vehicle_attachment);
        String vehicle_model = "ID,CODE,NAME,ARCHIVED";
        map.put("vehicle_model", vehicle_model);
        String vehicle_type = "ID,CODE,NAME,ARCHIVED";
        map.put("vehicle_type", vehicle_type);
        String vehicle_used = "CLE,CLE_CHAUFFEUR,CLE_VEHICULE,DATE_DEBUT,DATE_FIN,KM_DEBUT,KM_FIN,KM_EFFECTUE,MANUAL_INPUT,LECTEUR,SOURCE,NOM,PRENOM,NUMERO_CARTE,IMMATRICULATION";
        map.put("vehicle_used", vehicle_used);
        String waiting = "CLE,CLE_USER,NOM,DATE_SCAN,PROCESSED";
        map.put("waiting", waiting);
        String t_activite = "CLE_ACTIVITE,CLE_CHAUFFEUR,CLE_JOUR,HEURE_DEBUT,HEURE_FIN,DUREE_EN_MINUTE,FICHIER_IMPORT,SOURCE,ETAT_CARTE,ETAT_CONDUITE,LECTEUR,ANNEE_ACTIVITE,CLE_TYPE_ACTIV,ARCHIVAGE,CLE_DISQUE,NOM_SOURCE,SUPPRESSION,MODIFICATION";
        map.put("t_activite", t_activite);
        String t_activite_uev = "CLE_ACTIVITE_UEV,CLE_VEHICULE,JOUR_TELECHARGE,HEURE_DEBUT,HEURE_FIN,ETAT_CARTE,ETAT_CONDUITE,LECTEUR,TYPE_ACTIV,DUREE";
        map.put("t_activite_uev", t_activite_uev);
        String t_conducteur = "CLE_CHAUFFEUR,TAUX_HORAIRE,DATE_NAISSANCE,CLE_AGENCE,CLE_TYPE_PAYE,CLE_PROFIL,NOM_CONDUCTEUR,PRENOM_CONDUCTEUR,MATRICULE_CHAUFFEUR,NUM_CARTE_CHAUFFEUR,MEMBER_STATE,REPLACEMENT,RENEWAL,RENEWAL_PENDING,NUM_CARTE_CHAUFFEUR_14,NUM_IMPORT_CHAUFFEUR,ADRESSE,CODE_POSTAL,VILLE,TEL1,TEL2,DATE_ENTREE_SOCIETE,DATE_DEBUT_VALIDITE_CARTE,DATE_EXPIRATION_CARTE,COMMENTAIRE,FICHIER_ASSOCIE,DATE_DERNIERE_VISITE_MEDICALE,TYPE_CONDUCTEUR,NUM_SECURITE_SOCIALE,ARCHIVAGE,CLE_TYPE_CHAUFFEUR,CALENDAR_ID,LOGO,DATE_DERNIER_CHANGEMENT,DATE_DERNIER_TELECHARGEMENT,DATE_SORTIE,DATE_CALCUL_BRUT,DATE_CALCUL_MODIFIE,IO_COUNTER,TRAVAIL_NUIT,FIMO_FCO,REGION_ID,TRAGEO_ID,DALLAS_KEY_ID,NIGHT_DAY,NUMERO_PERMIS,DATE_VISITE_PERMIS,DATE_DELIVRANCE_PERMIS,A,B,C,D,E,QUALIFICATION_CARD_NUMBER,ADR,CACES,LAST_EXPORT,ANALYTIC_CODE_ID,CONSUMPTION_TARGET,PAY_PERIOD_TYPE,EXPENSES_ALLOWANCE";
        map.put("t_conducteur", t_conducteur);
        return map;
    }

    private static void getMax() {
        try {
            FileReader reader = null;
            BufferedReader br = null;
            String ligne = null;
            reader = new FileReader("E:\\MASTER\\TIMS\\3.10.2 - 2016-11-08\\NSIS\\Tims\\version\\TimsStructure.txt");
            br = new BufferedReader(reader);
            ligne = "";
            ligne = br.readLine();
            while (ligne != null) {
                String[] val = ligne.split(";");
                int max = BddTransport.getInstance().getMax(val[0], val[1]);
                if (max != 0) {
                    System.out.println("ALTER TABLE " + val[0] + " AUTO_INCREMENT=" + (max + 1) + ";");
                }
                ligne = br.readLine();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void getCount() {
        try {
            FileReader reader = null;
            BufferedReader br = null;
            String ligne = null;
            reader = new FileReader("E:\\MASTER\\TIMS\\3.10.2 - 2016-11-08\\NSIS\\Tims\\version\\DBStructure.txt");
            br = new BufferedReader(reader);
            ligne = "";
            ligne = br.readLine();
            while (ligne != null) {
                String[] val = ligne.split(";");
                int max = BddTransport.getInstance().getCount(val[0], val[1]);
                if (max != 0) {
                    System.out.println(String.valueOf(val[0]) + "\t" + max);
                }
                ligne = br.readLine();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void correctionDirectory() {
        if (System.getProperty("URL") != null) {
            return;
        }
        for (Conducteur c : Conducteur.loadListWithArchive(0)) {
            new File(String.valueOf(FileManager.ARCHIVE_DIRECTORY) + c.getDataDirName());
        }
    }

    private static boolean correctionuev2(String debut, String fin, String vehicleId) {
        boolean toReturn = true;
        try {
            for (UevDownload file : UevDownload.getTelechargementUEV(0, Integer.valueOf(vehicleId), debut, fin)) {
                TimsLogger.debug("on traite " + file.getFichier());
                File toRead = FileManager.getFile(file.getVehicle(), file.getFichier());
                if (toRead == null) {
                    TimsLogger.error(String.valueOf(file.getFichier()) + " introuvable");
                    continue;
                }
                String fileName = toRead.getName();
                if (!fileName.endsWith("V1B")) continue;
                new UEVCORRECTION(toRead).run();
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("Fonctions.correctionuev(  )  : " + ex);
            toReturn = false;
            ex.printStackTrace();
        }
        return toReturn;
    }

    public static void doForAllSociete(String version) {
        Transport.bdd.reloadConnection("sgobert", "Lod$69jm42");
        Vector<Societe> tmp = Societe.loadList(null);
        for (Societe comp : tmp) {
            if (comp.getCleSociete() == 38 || comp.getCleSociete() == 509) continue;
            Fonctions.reinitUserDbRight(comp);
        }
    }

    private static boolean reinitUserDbRight(Societe comp) {
        String user = String.valueOf(comp.getNomBase().length() > 12 ? comp.getNomBase().substring(0, 12) : comp.getNomBase()) + "_utl";
        int random = ThreadLocalRandom.current().nextInt(100000, 999999);
        String pwd = String.valueOf(comp.getNomBase()) + random;
        String encryptedPwd = Fonctions.encryptPassword(pwd, Fonctions.getDecryptKey());
        System.out.println("CREATE USER '" + user + "'@'%' identified by '" + pwd + "';");
        System.out.println("GRANT SELECT, INSERT, UPDATE, DELETE, LOCK TABLES ON tims.* TO '" + user + "'@'%';");
        System.out.println("GRANT SELECT, INSERT, UPDATE, DELETE, LOCK TABLES ON " + comp.getNomBase() + ".* TO '" + user + "'@'%';");
        System.out.println("UPDATE tims.t_societe set user_db_pwd = '" + encryptedPwd + "' where cle_societe = " + comp.getCleSociete() + ";");
        return true;
    }

    public static void nightHourCheck() {
        String begin = "2022-02-01";
        String end = "2022-04-01";
        for (Jour jour : BddTransport.getInstance().getJourNew(0, begin, end, 1, false)) {
            int nuit = Fonctions.calculHeureNuit(jour.getActivity());
            if (nuit == jour.getNight()) continue;
            TimsLogger.debug(String.valueOf(jour.getDate()) + " " + Conducteur.getDriverLibelle(jour.getDriverId()) + " => " + nuit + " != " + jour.getNight());
        }
    }

    public static String findAccent(String company) {
        String dbR = String.valueOf(company) + "\r\n";
        for (DriverAttachment da : DriverAttachment.loadList(-1)) {
            if (Charset.forName("US-ASCII").newEncoder().canEncode(da.getDocumentName())) continue;
            try {
                dbR = String.valueOf(dbR) + Conducteur.getDriver(null, da.getDriverId()).getDataDirName() + " " + da.getDocumentName() + "\r\n";
            }
            catch (DriverNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (!dbR.equals(String.valueOf(company) + "\r\n")) {
            return dbR;
        }
        return "";
    }

    public void getStats() {
        String errFile = String.valueOf(Transport.savePath) + "\\" + System.getProperty("BASE") + ".txt";
        FileWriter err = null;
        try {
            err = new FileWriter(errFile);
            if (err != null) {
                err.write("fichiers manquants");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int totalDriver = 0;
        int totalVehicle = 0;
        int totalJour = 0;
        Vector<Societe> tmp = Societe.loadList(null);
        int x = 0;
        while (x < tmp.size()) {
            Transport.bdd.changeDB(tmp.get(x).getNomSociete(), false);
            int driver = Conducteur.loadList(new Integer[0]).size();
            int vehicle = Vehicule.loadList(new Integer[0]).size();
            int jour = BddTransport.getInstance().countJour();
            TimsLogger.debug(String.valueOf(driver) + " " + vehicle + " " + jour);
            totalDriver += driver;
            totalVehicle += vehicle;
            totalJour += jour;
            if (err != null) {
                try {
                    err.write(String.valueOf(tmp.get(x).getNomSociete()) + " => conducteur : " + driver + " - vehicule : " + vehicle + " - jour : " + jour + "\r\n");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++x;
        }
        try {
            if (err != null) {
                err.write("TOTAL => conducteur : " + totalDriver + " - vehicule : " + totalVehicle + " - jour : " + totalJour + "\r\n");
                err.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void readMissing() {
        String dir = "E:\\FICHIERS CAYON";
        File directory = new File(dir);
        Vector<UevDownload> udl = UevDownload.loadList("DATE_TELECHARGEMENT > \"2018-01-01\"");
        ArrayList<String> uevFileNameList = new ArrayList<String>();
        for (UevDownload uevdl : udl) {
            uevFileNameList.add(uevdl.getFichier());
        }
        ArrayList<String> v1bToRead = new ArrayList<String>();
        File[] listV1B = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".V1B");
            }
        });
        TimsLogger.debug(String.valueOf(listV1B.length) + " fichiers V1B");
        File[] fileArray = listV1B;
        int n = listV1B.length;
        int n2 = 0;
        while (n2 < n) {
            File V1BFile = fileArray[n2];
            if (!uevFileNameList.contains(V1BFile.getName())) {
                v1bToRead.add(V1BFile.getName());
                V1BFile.renameTo(new File(String.valueOf(dir) + "\\TO READ\\" + V1BFile.getName()));
            }
            ++n2;
        }
        TimsLogger.debug(String.valueOf(v1bToRead.size()) + " fichiers \u00e0 lire");
    }

    public static void doForAllCond() {
        for (Conducteur driver : Conducteur.loadList(new Integer[0])) {
            TimsLogger.debug("reload " + driver.getNom());
            try {
                Fonctions.activiteCorrection(driver.getCleConducteur(), "2020-01-01", "2021-05-15");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void speedCorrection(int startAt) {
        boolean started = startAt == 0;
        String errFile = String.valueOf(Transport.savePath) + "\\err.txt";
        FileWriter err = null;
        try {
            err = new FileWriter(errFile);
            if (err != null) {
                err.write("fichiers manquants");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (Vehicule vehicle : Vehicule.loadList(new Integer[0])) {
            try {
                TimsLogger.debug("process " + vehicle.getRegistrationNumber() + " :: " + vehicle.getCleVehicule());
                if (startAt != 0 && vehicle.getCleVehicule() == startAt) {
                    started = true;
                }
                if (!started) {
                    err.write("not started\r\n");
                    continue;
                }
                Vector<UevDownload> toProcess = UevDownload.getTelechargementUEV(0, vehicle.getCleVehicule(), "2022-06-01", "2023-11-01");
                err.write(String.valueOf(ConversionTime.dateToString(new Date(), " dd/MM/yyyy HH:mm:ss")) + " process " + vehicle.getRegistrationNumber() + " (" + vehicle.getCleVehicule() + ")=> " + toProcess.size() + " fichiers \u00e0 g\u00e9rer\r\n");
                if (toProcess.size() != 0) {
                    BddTransport.getInstance().executeCmd("DELETE FROM UEV_OFFENCE WHERE VEHICLE_ID =" + vehicle.getCleVehicule() + " AND BEGIN > \"2022-06-01\" AND OFFENCE_TYPE_ID = 2");
                    BddTransport.getInstance().executeCmd("DELETE FROM T_SPEED_UEV WHERE CLE_VEHICULE =" + vehicle.getCleVehicule() + " AND DATE_DEBUT > \"2022-06-01\"");
                }
                ArrayList<UevSpeed> inserted = new ArrayList<UevSpeed>();
                for (UevDownload d : toProcess) {
                    int length;
                    long ms;
                    Conducteur tmpC;
                    AbstractList speeds;
                    Object uevdp;
                    Vehicule v = d.getVehicle();
                    File file = new File("D:\\TEMP\\" + d.getFichier());
                    if (!file.exists()) {
                        File tmp = FileManager.getFile(v, d.getFichier());
                        if (tmp == null) {
                            if (err == null) continue;
                            err.write(String.valueOf(d.getVehicle().getAgencyId()) + " - " + d.getFichier() + "\r\n");
                            continue;
                        }
                        tmp.renameTo(file);
                    }
                    err.write(String.valueOf(d.getFichier()) + " : ");
                    if (UEVProperty.getVuGeneration(file.getAbsolutePath()) == 1) {
                        uevdp = new VuProcessingG1(file);
                        speeds = ((VuProcessingG1)uevdp).getSpeed(v, ConversionTime.stringToDateDb("2022-01-06"));
                        for (UevSpeed s : speeds) {
                            if (inserted.contains(s)) {
                                err.write("d\u00e9j\u00e0 connue " + s.getDateDebut() + "    ");
                                continue;
                            }
                            s.insert();
                            inserted.add(s);
                            tmpC = null;
                            try {
                                if (s.getNumeroCarteConducteur() != null) {
                                    tmpC = Conducteur.getDriver(null, s.getNumeroCarteConducteur(), -1);
                                }
                            }
                            catch (Exception ex) {
                                TimsLogger.debug("#VuPG1.saveInfos# unknow driver " + s.getNumeroCarteConducteur());
                            }
                            ms = s.getDateFin().getTime() - s.getDateDebut().getTime();
                            length = (int)(ms / 60000L);
                            new UevOffence(v.getCleVehicule(), tmpC != null ? tmpC.getCleConducteur() : 0, s.getDateDebut(), s.getDateFin(), length, s.getVitesseMax(), 0, 2).insert();
                        }
                        err.write(String.valueOf(((ArrayList)speeds).size()) + " survitesses g\u00e9r\u00e9es (G1)\r\n");
                        uevdp = null;
                        System.gc();
                        continue;
                    }
                    uevdp = new VuProcessingG2(file);
                    speeds = ((VuProcessingG2)uevdp).getSpeed(v);
                    for (UevSpeed s : ((VuProcessingG2)uevdp).getSpeed(v)) {
                        if (inserted.contains(s)) {
                            err.write("d\u00e9j\u00e0 connue " + s.getDateDebut() + "    ");
                            continue;
                        }
                        s.insert();
                        inserted.add(s);
                        tmpC = null;
                        try {
                            if (s.getNumeroCarteConducteur() != null) {
                                tmpC = Conducteur.getDriver(null, s.getNumeroCarteConducteur(), -1);
                            }
                        }
                        catch (Exception ex) {
                            TimsLogger.debug("#VuPG1.saveInfos# unknow driver " + s.getNumeroCarteConducteur());
                        }
                        ms = s.getDateFin().getTime() - s.getDateDebut().getTime();
                        length = (int)(ms / 60000L);
                        new UevOffence(v.getCleVehicule(), tmpC != null ? tmpC.getCleConducteur() : 0, s.getDateDebut(), s.getDateFin(), length, s.getVitesseMax(), 0, 2).insert();
                    }
                    err.write(String.valueOf(((Vector)speeds).size()) + " survitesses g\u00e9r\u00e9es (G2)\r\n");
                    uevdp = null;
                    System.gc();
                }
                err.flush();
            }
            catch (Exception ex) {
                try {
                    err.write("erreur rencontr\u00e9e " + ex.getMessage() + "\r\n");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ex.printStackTrace();
            }
        }
        try {
            err.flush();
            err.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean refreshActivityInDayTable(String begin, String end) {
        boolean toReturn = true;
        try {
            long mil = System.currentTimeMillis();
            int days = 0;
            Statement stm = BddTransport.getInstance().getConnection().createStatement();
            if (begin == null) {
                begin = "2008-01-01";
            }
            if (end == null) {
                end = "2040-12-31";
            }
            Vector<ActiviteConducteur> dayActs = new Vector<ActiviteConducteur>();
            Vector<String> sources = new Vector<String>();
            String sSources = "";
            boolean exitOnFirst = false;
            FileWriter log = new FileWriter("log4.txt");
            for (Conducteur driver : Conducteur.loadListWithArchive(new Integer[0])) {
                try {
                    TimsLogger.info("#Fonctions.refreshActivityInDayTable# Mise \u00e0 jour des activit\u00e9s de la fiche de " + driver.getPrenom() + " " + driver.getNom());
                    String sql = "UPDATE t_jour SET ACTIVITIES = ?, SOURCE_NAME = ? WHERE CLE_CHAUFFEUR = ? AND DATE_JOUR = ?";
                    PreparedStatement pStatement = BddTransport.getInstance().getConnection().prepareStatement(sql);
                    Vector<ActiviteConducteur> acts = BddTransport.getInstance().getActiviteOldTActivite(driver.getCleConducteur(), begin, end, 1, stm);
                    String dayOfAct = null;
                    TimsLogger.debug(String.valueOf(acts.size()) + " activit\u00e9s brutes \u00e0 g\u00e9rer");
                    for (ActiviteConducteur act : acts) {
                        if (dayOfAct == null) {
                            dayOfAct = act.getDateJour();
                        }
                        if (!dayOfAct.equals(act.getDateJour())) {
                            for (String s : sources) {
                                sSources = String.valueOf(sSources) + ";" + s;
                            }
                            System.out.print(String.valueOf(dayOfAct) + " / ");
                            BddTransport.getInstance().updateJour(pStatement, driver.getCleConducteur(), dayOfAct, ActiviteConducteur.toCondensed(dayActs), sSources.equals("") ? "" : sSources.substring(1));
                            ++days;
                            dayActs.clear();
                            sources.clear();
                            sSources = "";
                            dayOfAct = act.getDateJour();
                        }
                        dayActs.add(act);
                        if (act.getNomSource() == null || act.getNomSource().equals("") || sources.contains(act.getNomSource())) continue;
                        sources.add(act.getNomSource());
                    }
                    if (dayOfAct != null) {
                        for (String s : sources) {
                            sSources = String.valueOf(sSources) + ";" + s;
                        }
                        BddTransport.getInstance().updateJour(pStatement, driver.getCleConducteur(), dayOfAct, ActiviteConducteur.toCondensed(dayActs), sSources.equals("") ? "" : sSources.substring(1));
                        ++days;
                        dayActs.clear();
                        sources.clear();
                        sSources = "";
                        dayOfAct = null;
                    }
                    acts = BddTransport.getInstance().getActiviteOldTActiviteUpdated(driver.getCleConducteur(), begin, end, stm);
                    dayOfAct = null;
                    for (ActiviteConducteur act : acts) {
                        if (dayOfAct == null) {
                            dayOfAct = act.getDateJour();
                        }
                        if (!dayOfAct.equals(act.getDateJour())) {
                            for (String s : sources) {
                                sSources = String.valueOf(sSources) + ";" + s;
                            }
                            BddTransport.getInstance().updateJour(pStatement, driver.getCleConducteur(), dayOfAct, ActiviteConducteur.toCondensed(dayActs), sSources.equals("") ? "" : sSources.substring(1));
                            ++days;
                            dayActs.clear();
                            sources.clear();
                            sSources = "";
                            dayOfAct = act.getDateJour();
                        }
                        dayActs.add(act);
                        if (act.getNomSource() == null || act.getNomSource().equals("") || sources.contains(act.getNomSource())) continue;
                        sources.add(act.getNomSource());
                    }
                    if (dayOfAct != null) {
                        for (String s : sources) {
                            sSources = String.valueOf(sSources) + ";" + s;
                        }
                        BddTransport.getInstance().updateJour(pStatement, driver.getCleConducteur(), dayOfAct, ActiviteConducteur.toCondensed(dayActs), sSources.equals("") ? "" : sSources.substring(1));
                        ++days;
                        dayActs.clear();
                        sources.clear();
                        sSources = "";
                        dayOfAct = null;
                    }
                    sql = "UPDATE t_jour_modifie SET ACTIVITIES = ?, SOURCE_NAME = ? WHERE CLE_CHAUFFEUR = ? AND DATE_JOUR = ? AND CURRENT_VALUE=1";
                    pStatement = BddTransport.getInstance().getConnection().prepareStatement(sql);
                    acts = BddTransport.getInstance().getActiviteOldTActiviteM(driver.getCleConducteur(), begin, end, -1, stm);
                    TimsLogger.debug(String.valueOf(acts.size()) + " activit\u00e9s modifi\u00e9es \u00e0 g\u00e9rer");
                    for (ActiviteConducteur act : acts) {
                        if (dayOfAct == null) {
                            dayOfAct = act.getDateJour();
                        }
                        if (!dayOfAct.equals(act.getDateJour())) {
                            for (String s : sources) {
                                sSources = String.valueOf(sSources) + ";" + s;
                            }
                            BddTransport.getInstance().updateJour(pStatement, driver.getCleConducteur(), dayOfAct, ActiviteConducteur.toCondensed(dayActs), sSources.equals("") ? "" : sSources.substring(1));
                            ++days;
                            dayActs.clear();
                            sources.clear();
                            sSources = "";
                            dayOfAct = act.getDateJour();
                        }
                        dayActs.add(act);
                        if (act.getNomSource() == null || act.getNomSource().equals("") || sources.contains(act.getNomSource())) continue;
                        sources.add(act.getNomSource());
                    }
                    if (dayOfAct != null) {
                        for (String s : sources) {
                            sSources = String.valueOf(sSources) + ";" + s;
                        }
                        BddTransport.getInstance().updateJour(pStatement, driver.getCleConducteur(), dayOfAct, ActiviteConducteur.toCondensed(dayActs), sSources.equals("") ? "" : sSources.substring(1));
                        ++days;
                        dayActs.clear();
                        sources.clear();
                        sSources = "";
                    }
                    acts = null;
                    if (exitOnFirst) {
                        System.exit(0);
                    }
                    log.write(" OK " + driver.getNom() + "\r\n");
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    log.write(" ERREUR " + driver.getNom() + "\r\n");
                }
                log.flush();
            }
            log.close();
            TimsLogger.debug(String.valueOf(days) + " days done in " + (System.currentTimeMillis() - mil));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            toReturn = false;
        }
        return toReturn;
    }

    public static boolean refreshOriginalActivityInDayTable() {
        boolean toReturn = true;
        try {
            long mil = System.currentTimeMillis();
            int days = 0;
            Statement stm = BddTransport.getInstance().getConnection().createStatement();
            String begin = "2008-10-19";
            String end = "2018-10-20";
            Vector<ActiviteConducteur> dayActs = new Vector<ActiviteConducteur>();
            Vector<String> sources = new Vector<String>();
            String sSources = "";
            for (Conducteur driver : Conducteur.loadListWithArchive(new Integer[0])) {
                String sql = "UPDATE t_jour SET ACTIVITIES = ?, SOURCE_NAME = ? WHERE CLE_CHAUFFEUR = ? AND DATE_JOUR = ? AND MODIFICATION=1 AND SUPPRESSION=0";
                PreparedStatement pStatement = BddTransport.getInstance().getConnection().prepareStatement(sql);
                Vector<ActiviteConducteur> acts = BddTransport.getInstance().getActiviteOldTActiviteUpdated(driver.getCleConducteur(), begin, end, stm);
                String dayOfAct = null;
                for (ActiviteConducteur act : acts) {
                    if (dayOfAct == null) {
                        dayOfAct = act.getDateJour();
                    }
                    if (!dayOfAct.equals(act.getDateJour())) {
                        for (String s : sources) {
                            sSources = String.valueOf(sSources) + ";" + s;
                        }
                        BddTransport.getInstance().updateJour(pStatement, driver.getCleConducteur(), dayOfAct, ActiviteConducteur.toCondensed(dayActs), sSources.equals("") ? "" : sSources.substring(1));
                        ++days;
                        dayActs.clear();
                        sources.clear();
                        sSources = "";
                        dayOfAct = act.getDateJour();
                    }
                    dayActs.add(act);
                    if (act.getNomSource() == null || act.getNomSource().equals("") || sources.contains(act.getNomSource())) continue;
                    sources.add(act.getNomSource());
                }
                if (dayOfAct == null) continue;
                for (String s : sources) {
                    sSources = String.valueOf(sSources) + ";" + s;
                }
                BddTransport.getInstance().updateJour(pStatement, driver.getCleConducteur(), dayOfAct, ActiviteConducteur.toCondensed(dayActs), sSources.equals("") ? "" : sSources.substring(1));
                ++days;
                dayActs.clear();
                sources.clear();
                sSources = "";
                dayOfAct = null;
            }
            TimsLogger.debug(String.valueOf(days) + " days done in " + (System.currentTimeMillis() - mil));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            toReturn = false;
        }
        return toReturn;
    }

    public static void setGraphicOrigin(ActiviteConducteur toUpdate) {
        toUpdate.setTypeSource(LanguageTranslator.getString("generics.graphic"));
        toUpdate.setEtatCarte("");
        toUpdate.setEtatConduite("");
        toUpdate.setLecteur("");
    }

    public static int moveDir(String from, String to) throws IOException {
        int toReturn = 0;
        File fFrom = new File(from);
        String[] stringArray = fFrom.list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String toMove = stringArray[n2];
            File fToMove = new File(String.valueOf(fFrom.getAbsolutePath()) + "\\" + toMove);
            File fTo = new File(String.valueOf(to) + fToMove.getName());
            if (fToMove.isDirectory()) {
                TimsLogger.info("create " + fTo.getAbsolutePath());
                fTo.mkdirs();
                Fonctions.moveDir(String.valueOf(fToMove.getAbsolutePath()) + "\\", String.valueOf(fTo.getAbsolutePath()) + "\\");
            } else {
                if (!fToMove.renameTo(fTo)) {
                    toReturn = -1;
                    TimsLogger.error("Impossible de d\u00e9placer " + fToMove.getAbsolutePath() + " vers " + fTo.getAbsolutePath());
                    break;
                }
                ++toReturn;
            }
            ++n2;
        }
        return toReturn;
    }

    public static boolean checkAccess(File toCheck) {
        boolean toReturn = true;
        try {
            TimsLogger.info("checkAccess# check " + toCheck.getAbsolutePath());
            File check = new File(String.valueOf(toCheck.getAbsolutePath()) + "\\testSecurity.uu");
            if (check.createNewFile()) {
                check.delete();
            }
        }
        catch (Exception ex) {
            TimsLogger.warn("#checkAccess# impossible d'acc\u00e9der au r\u00e9pertoire de donn\u00e9es (" + toCheck.getAbsolutePath() + ")");
            toReturn = false;
        }
        return toReturn;
    }

    public static File convertTo1B(File file) throws Exception {
        if (file.getName().toUpperCase().endsWith("DDD") && file.getName().startsWith("C_")) {
            return Fonctions.convertDDDToC1B(file);
        }
        if (file.getName().toUpperCase().endsWith("DDD") && file.getName().startsWith("M_")) {
            return Fonctions.convertDDDToV1B(file);
        }
        if (file.getName().toUpperCase().endsWith("TGD")) {
            return Fonctions.convertTGDTo1B(file);
        }
        if (file.getName().toUpperCase().endsWith("C1C") || file.getName().toUpperCase().endsWith("V1C")) {
            File x1bFile = new File(file.getAbsolutePath().toUpperCase().replace("C1C", "C1B").replace("V1C", "V1B"));
            if (file.renameTo(x1bFile)) {
                return x1bFile;
            }
            throw new Exception("Can't rename to " + x1bFile.getAbsolutePath());
        }
        if (file.getName().toUpperCase().endsWith("ESM")) {
            File x1bFile = new File(file.getAbsolutePath().toUpperCase().replace("ESM", "C1B"));
            if (file.renameTo(x1bFile)) {
                return x1bFile;
            }
            throw new Exception("Can't rename to " + x1bFile.getAbsolutePath());
        }
        throw new Exception("Not a 1B file " + file.getAbsolutePath());
    }

    public static File convertDDDToC1B(File file) {
        DriverCardSaving toConvert = new DriverCardSaving(file);
        String cardNumber = toConvert.getCardNumber();
        String pays = toConvert.getMemberState();
        String nameFile = String.valueOf(pays) + cardNumber.substring(0, 14) + file.getName().substring(4, 10) + file.getName().substring(11, 15) + ".C1B";
        String workFile = String.valueOf(file.getParent()) + "\\" + nameFile;
        File destination = new File(workFile);
        TimsLogger.info("#Fonctions.convertToC1B# rename " + file.getAbsolutePath() + " to " + destination.getAbsolutePath());
        if (!file.renameTo(destination)) {
            TimsLogger.error("#Fonctions.convertToC1B# rename " + file.getAbsolutePath() + " to " + destination.getAbsolutePath() + " failed");
        }
        return destination;
    }

    public static File convertDDDToV1B(File file) throws Exception {
        String fileName = null;
        try {
            if (UEVProperty.getVuGeneration(file.getAbsolutePath()) == 2) {
                String date = file.getName().substring(4, 15).replace("_", "");
                VuProcessingG2 tmp = new VuProcessingG2(file);
                String immat = tmp.getVuFile().getIdentification().getVehicleRegistrationIdentification().getVehicleRegistrationNumber();
                while (immat.length() < 13) {
                    immat = String.valueOf(immat) + "_";
                }
                ArrayList<VuCalibration> list = tmp.getVuFile().getTechnical().getVuCalibrationList();
                int lastKnownCountry = list.size() > 0 ? list.get(list.size() - 1).getVehicleRegistrationIdentification().getNationNumeric() : 0;
                String country = Pays.getCodePays(lastKnownCountry);
                fileName = String.valueOf(country) + immat + date + ".V1B";
                TimsLogger.debug("#Fonctions.convertDDDToV1B# G2 : " + file.getName() + " => " + fileName + ", immat = " + immat + " country " + country + ", date " + date);
            } else {
                VuProcessingG1 tmp = new VuProcessingG1(file);
                fileName = String.valueOf(tmp.extractFileName()) + ".V1B";
                TimsLogger.debug("#Fonctions.convertDDDToV1B# G1 : " + file.getName() + " => " + fileName);
            }
        }
        catch (Exception ex) {
            TimsLogger.error("#Fonctions.convertDDDToV1B# " + ex.getMessage());
            throw ex;
        }
        File destination = new File(String.valueOf(file.getParent()) + "\\" + fileName);
        TimsLogger.info("#Fonctions.convertToV1B# rename " + file.getAbsolutePath() + " to " + destination.getAbsolutePath());
        if (!file.renameTo(destination)) {
            TimsLogger.error("#Fonctions.convertToV1B# rename " + file.getAbsolutePath() + " to " + destination.getAbsolutePath() + " failed");
        }
        return destination;
    }

    public static File convertTGDTo1B(File file) {
        String[] tgdPart = file.getName().split("_");
        String number = tgdPart[1];
        while (number.length() < 13) {
            number = String.valueOf(number) + "_";
        }
        String country = tgdPart[2];
        while (country.length() < 3) {
            country = String.valueOf(country) + "_";
        }
        String day = tgdPart[tgdPart.length - 2];
        String hour = tgdPart[tgdPart.length - 1].substring(0, 4);
        String x1bName = String.valueOf(country) + number + day + hour + (tgdPart[0].equals("V") ? ".V1B" : ".C1B");
        TimsLogger.info("#Fonctions.convertTGDTo1B# number " + number + " country " + country + " day " + day + " hour " + hour);
        File destination = new File(String.valueOf(file.getParent()) + "\\" + x1bName);
        TimsLogger.info("#Fonctions.convertTGDTo1B# rename " + file.getAbsolutePath() + " to " + destination.getAbsolutePath());
        if (!file.renameTo(destination)) {
            TimsLogger.error("#Fonctions.convertTGDTo1B# rename " + file.getAbsolutePath() + " to " + destination.getAbsolutePath() + " failed");
        }
        return destination;
    }

    public static String extractRegistration(String fileName) {
        String toReturn = "";
        if (fileName.toLowerCase().endsWith(".ddd")) {
            toReturn = fileName.substring(16, 25);
        }
        if (fileName.toLowerCase().endsWith(".v1b")) {
            toReturn = fileName.substring(3, 16);
        }
        toReturn = toReturn.replaceAll("_", "");
        return toReturn;
    }

    public static String extractCardNumber(String fileName) {
        String toReturn = "";
        if (fileName.toLowerCase().endsWith(".ddd")) {
            toReturn = fileName.split("_")[5].substring(0, 14);
        }
        if (fileName.toLowerCase().endsWith(".c1b")) {
            toReturn = fileName.substring(3, 17);
        }
        return toReturn;
    }

    public static String extractV1BFileName(byte[] content, String date) throws Exception {
        String toReturn = null;
        if (content[1] >= 32) {
            VuFile vuFile = VuFileParserG2.parseFile(content, null);
            String immat = vuFile.getIdentification().getVehicleRegistrationIdentification().getVehicleRegistrationNumber();
            while (immat.length() < 13) {
                immat = String.valueOf(immat) + "_";
            }
            ArrayList<VuCalibration> list = vuFile.getTechnical().getVuCalibrationList();
            if (list == null) {
                return null;
            }
            int lastKnownCountry = list.size() > 0 ? list.get(list.size() - 1).getVehicleRegistrationIdentification().getNationNumeric() : 0;
            String country = Pays.getCodePays(lastKnownCountry);
            toReturn = String.valueOf(country) + immat + date + ".V1B";
            TimsLogger.debug("#Fonctions.convertDDDToV1B# G2 : extractV1BFileName => " + toReturn + ", immat = " + immat + " country " + country + ", date " + date);
        } else {
            toReturn = UEVProperty.extractFileNameG1(content);
            TimsLogger.debug("#Fonctions.convertDDDToV1B# G1 : extractV1BFileName => " + toReturn);
        }
        return toReturn;
    }

    public static ImageIcon changeDriverPhoto(Conducteur detailConducteur) {
        JFileChooser choix = new JFileChooser(".");
        choix.setApproveButtonText(LanguageTranslator.getString("button.add"));
        if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
            String attached = null;
            boolean saved = false;
            if (!Fonctions.checkFileSize(choix.getSelectedFile())) {
                return null;
            }
            JNotificationFrame frame = JNotificationFrame.getFrame(JNotificationFrame.Corner.BOTTOM_RIGHT);
            File newPhoto = choix.getSelectedFile();
            if (!newPhoto.getName().toLowerCase().endsWith("png") && !newPhoto.getName().toLowerCase().endsWith("jpg")) {
                MessageSystemManager.error((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("attachment.photo.formatError"), LanguageTranslator.getString("attachment.title"));
                return null;
            }
            Transport.bdd.startTransaction();
            DriverAttachment toAdd = new DriverAttachment(0, detailConducteur.getCleConducteur(), attached);
            ImageIcon toReturn = Fonctions.getIcon(newPhoto.getAbsolutePath(), 100, 100);
            attached = FileManager.moveFile(detailConducteur, newPhoto, "photo." + newPhoto.getName().substring(newPhoto.getName().length() - 3).toLowerCase(), true);
            toAdd.setDocumentName(attached);
            saved = toAdd.insert();
            if (attached != null && saved) {
                Transport.bdd.commit();
                MessageSystemManager.information(MainFrameTransport.getInstance(), new StringMessage(LanguageTranslator.getString("attachment.added.photo")), LanguageTranslator.getString("attachment.title"), -1, Fonctions.getSuccessStatusIcon());
                frame.showNotification(6);
                return toReturn;
            }
            Transport.bdd.rollback();
            MessageSystemManager.error((Component)MainFrameTransport.getInstance(), LanguageTranslator.getString("message.detailedError", LanguageTranslator.getString("message.copyError")), LanguageTranslator.getString("attachment.title"));
        }
        return null;
    }

    public static Vector<ActiviteConducteur> sortActivitiesList(Vector<ActiviteConducteur> activiteJour) {
        Collections.sort(activiteJour, new Comparator<ActiviteConducteur>(){

            @Override
            public int compare(ActiviteConducteur o1, ActiviteConducteur o2) {
                int dateCompare = o1.getDate().compareTo(o2.getDate());
                if (dateCompare == 0) {
                    dateCompare = o1.getHeureDebut() - o2.getHeureDebut();
                }
                return dateCompare;
            }
        });
        return activiteJour;
    }

    public static String getVuRecordTypeLibelle(int recordType) {
        switch (recordType) {
            case 1: {
                return "ActivityChangeInfo";
            }
            case 2: {
                return "CardSlotStatus";
            }
            case 3: {
                return "CurrentDateTime";
            }
            case 4: {
                return "MemberStateCertificate";
            }
            case 5: {
                return "OdometerValueMidnight";
            }
            case 6: {
                return "DateOfDayDonwloaded";
            }
            case 7: {
                return "SensorPaired";
            }
            case 8: {
                return "Signature";
            }
            case 9: {
                return "SpecificConditionRecord";
            }
            case 10: {
                return "VehicleIdentificationNumber";
            }
            case 11: {
                return "VehicleRegistrationNumber";
            }
            case 12: {
                return "VuCalibrationRecord";
            }
            case 13: {
                return "VuCardIWRecord";
            }
            case 14: {
                return "VuCardRecord";
            }
            case 15: {
                return "VuCertificate";
            }
            case 16: {
                return "VuCompanyLockRecord";
            }
            case 17: {
                return "VuControlActivityRecord";
            }
            case 18: {
                return "VuDetailedSpeedBlock";
            }
            case 19: {
                return "VuDownloadablePeriod";
            }
            case 20: {
                return "VuDownloadActivityData";
            }
            case 21: {
                return "VuEventRecord";
            }
            case 22: {
                return "VuGNSSCDRecord";
            }
            case 23: {
                return "VuITSConsentRecord";
            }
            case 24: {
                return "VuFaultRecord";
            }
            case 25: {
                return "VuIdentification";
            }
            case 26: {
                return "VuOverSpeedingControlData";
            }
            case 27: {
                return "VuOverSpeedingEventRecord";
            }
            case 28: {
                return "VuPlaceDailyWorkPeriodRecord";
            }
            case 29: {
                return "VuTimeAdjustmentGNSSRecord";
            }
            case 30: {
                return "VuTimeAdjustmentRecord";
            }
            case 31: {
                return "VuPowerSupplyInterruptionRecord";
            }
            case 32: {
                return "SensorPairedRecord";
            }
            case 34: {
                return "VuBorderCrossingRecord";
            }
            case 35: {
                return "VuLoadUnloadRecord";
            }
            case 36: {
                return "VehicleRegistrationIdentification";
            }
        }
        return "UnknownRecordType";
    }

    public static boolean isJava64() {
        return System.getProperty("os.arch").contains("64");
    }

    public static String prettyHexify(byte[] buffer) {
        return Fonctions.hexify(buffer, true, true);
    }

    public static String hexify(byte[] buffer) {
        return Fonctions.hexify(buffer, false, false);
    }

    public static String hexify(byte[] buffer, boolean withSpace, boolean withInt) {
        String toReturn = "";
        String onInt = "";
        if (buffer == null) {
            return toReturn;
        }
        byte[] byArray = buffer;
        int n = buffer.length;
        int n2 = 0;
        while (n2 < n) {
            int b = byArray[n2];
            int toConvert = b;
            if (toConvert < 0) {
                toConvert += 256;
            }
            onInt = String.valueOf(onInt) + toConvert + " ";
            String toAdd = Integer.toHexString(toConvert);
            if (toAdd.length() == 1) {
                toAdd = "0" + toAdd;
            }
            toReturn = String.valueOf(toReturn) + toAdd.toUpperCase() + " ";
            ++n2;
        }
        return String.valueOf(withSpace ? toReturn : toReturn.replace(" ", "")) + (withInt ? " (" + onInt + ")" : "");
    }

    public static int getGeneration(Vehicule vehicle) {
        if (vehicle.getVuBrand().startsWith("Continental")) {
            int majorVersion = Integer.parseInt(vehicle.getVuVersion().substring(0, 1));
            if (majorVersion >= 4) {
                return 2;
            }
            return 1;
        }
        if (vehicle.getVuBrand().startsWith("Stoneridge")) {
            String version = vehicle.getVuVersion().substring(0, 2);
            if (version.equals("P4") || version.equals("P5") || version.equals("P8")) {
                return 1;
            }
            if (version.startsWith("PA") || version.startsWith("04")) {
                return 2;
            }
            return 0;
        }
        return 1;
    }

    public static float[] getCoordinates(String address) {
        try {
            String url = "http://api-adresse.data.gouv.fr/search/?q=" + URLEncoder.encode(address, StandardCharsets.UTF_8.toString());
            System.out.println("#Fonctions.getCoordinates# " + url);
            String posReturn = Fonctions.getExternalWSResponse(url, null, null);
            int idx = posReturn.indexOf("coordinates");
            if (idx == 0) {
                System.out.println("#Fonctions.getCoordinates# not found");
            }
            int begin = posReturn.indexOf("[", idx);
            int end = posReturn.indexOf("]", idx);
            String pos = posReturn.substring(begin + 1, end);
            String[] both = pos.split(",");
            float lon = Float.valueOf(both[0].trim()).floatValue();
            float lat = Float.valueOf(both[1].trim()).floatValue();
            System.out.println("#Fonctions.getCoordinates# " + lon + " / " + lat + " (" + posReturn + ")");
            float[] res = new float[]{lon, lat};
            return res;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getExternalWSResponse(String endpoint, String user, String password) {
        String response = "";
        try {
            String output;
            URL url = new URL(endpoint);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("Accept", "application/json");
            if (conn.getResponseCode() != 200) {
                throw new RuntimeException("Failed : HTTP Error code : " + conn.getResponseCode());
            }
            InputStreamReader in = new InputStreamReader(conn.getInputStream());
            BufferedReader br = new BufferedReader(in);
            while ((output = br.readLine()) != null) {
                response = String.valueOf(response) + output;
            }
            conn.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return response;
    }

    public static File[] selectFile(int selectionMode, String prefDir, String title, String btnLbl, boolean multi) {
        try {
            Preferences prefs = Preferences.userRoot().node("TIMS");
            JFileChooser choix = new JFileChooser(prefDir == null ? System.getProperty("user.home") : prefs.node("DIRECTORY").get(prefDir, System.getProperty("user.home")));
            choix.setFileSelectionMode(selectionMode);
            choix.setMultiSelectionEnabled(multi);
            choix.setDialogTitle(title);
            choix.setApproveButtonText(btnLbl);
            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                if (prefDir != null) {
                    prefs.node("DIRECTORY").put(prefDir, choix.getCurrentDirectory().getAbsolutePath());
                }
                TimsLogger.debug("#Fonctions.selectFile# " + choix.getSelectedFiles().length + " files selected");
                if (multi) {
                    return choix.getSelectedFiles();
                }
                File[] files = new File[]{choix.getSelectedFile()};
                return files;
            }
            return null;
        }
        catch (Exception ex) {
            TimsLogger.warn("#Fonctions.selectFile# exception " + ex);
            ex.printStackTrace();
            return null;
        }
    }

    public static int findOverrunActivities(Vector<ActiviteConducteur> activity, Vector<ActiviteConducteur> activity2) {
        int overruningTime = 0;
        if (activity == null) {
            return overruningTime;
        }
        for (ActiviteConducteur original : activity) {
            if (original.isRest()) continue;
            int toFind = original.getDuree();
            for (ActiviteConducteur newAct : activity2) {
                int over = Fonctions.getTempsCumul(original.getHeureDebut(), original.getHeureFin(), newAct.getHeureDebut(), newAct.getHeureFin());
                toFind -= over;
                if (!newAct.isRest() || over <= 0) continue;
                TimsLogger.debug("overrun detected " + over + " <" + original.getHeureDebut() + ":" + original.getHeureFin() + ">" + " <" + newAct.getHeureDebut() + ":" + newAct.getHeureFin() + ">");
                overruningTime += over;
            }
            if (toFind != 0) continue;
        }
        return overruningTime;
    }

    public static Vector<ActiviteConducteur> mergeForImport(DriverDayAnomaly ano) {
        if (ano.getInitial() == null) {
            return ano.getImported();
        }
        if (ano.getImported() == null) {
            return ano.getInitial();
        }
        Vector<ActiviteConducteur> finalResult = new Vector<ActiviteConducteur>();
        for (ActiviteConducteur initialAct : ano.getInitial()) {
            if (initialAct.isRest()) {
                int begin = initialAct.getHeureDebut();
                int end = initialAct.getHeureFin();
                TimsLogger.debug("#Fonctions.mergeForImport# rest " + begin + " to " + end);
                for (ActiviteConducteur importedAct : ano.getImported()) {
                    if (Fonctions.getTempsCumul(begin, end, importedAct.getHeureDebut(), importedAct.getHeureFin()) != 0) {
                        if (importedAct.getHeureDebut() > begin) {
                            ActiviteConducteur initClone = new ActiviteConducteur(initialAct);
                            initClone.setHeureFin(importedAct.getHeureDebut());
                            finalResult.add(initClone);
                            if (importedAct.getHeureFin() > end) {
                                importedAct.setHeureFin(end);
                            }
                            finalResult.add(importedAct);
                            TimsLogger.debug("#Fonctions.mergeForImport# add (1,2)" + initClone.getHeureDebut() + " to " + initClone.getHeureFin());
                            TimsLogger.debug("#Fonctions.mergeForImport# add (1,2)" + importedAct.getHeureDebut() + " to " + importedAct.getHeureFin());
                            begin = importedAct.getHeureFin();
                            if (begin == end) {
                                break;
                            }
                        } else if (importedAct.getHeureDebut() <= begin) {
                            ActiviteConducteur importedClone = new ActiviteConducteur(importedAct);
                            importedClone.setHeureDebut(begin);
                            if (importedAct.getHeureFin() > end) {
                                importedClone.setHeureFin(end);
                            }
                            finalResult.add(importedClone);
                            TimsLogger.debug("#Fonctions.mergeForImport# add (3,4)" + importedClone.getHeureDebut() + " to " + importedClone.getHeureFin());
                            begin = importedClone.getHeureFin();
                            if (begin == end) break;
                        }
                        TimsLogger.debug("#Fonctions.mergeForImport# left " + begin + " to " + end);
                    }
                    if (importedAct.getHeureDebut() > end) break;
                }
                if (begin == end) continue;
                if (begin == initialAct.getHeureDebut()) {
                    finalResult.add(initialAct);
                    continue;
                }
                ActiviteConducteur clone = new ActiviteConducteur(initialAct);
                clone.setHeureDebut(begin);
                finalResult.add(clone);
                continue;
            }
            finalResult.add(initialAct);
        }
        return finalResult;
    }

    public static void preRenderTiles(int zoomMin, int zoomMax, int beginZoomMinX, int endZoomMinX, int beginZoomMinY, int endZoomMinY) {
        System.out.println("prerender for (" + beginZoomMinX + "," + endZoomMinX + ") (" + beginZoomMinY + "," + endZoomMinY + ") for zoom from " + zoomMin + " to " + zoomMax);
        int totalTile = 0;
        int i = zoomMin;
        while (i <= zoomMax) {
            int factor = (int)Math.pow(2.0, i - zoomMin);
            int beginForZoomX = beginZoomMinX * factor;
            int endForZoomX = endZoomMinX * factor;
            int beginForZoomY = beginZoomMinY * factor;
            int endForZoomY = endZoomMinY * factor;
            int tileCount = (endForZoomX - beginForZoomX) / 7 * (endForZoomY - beginForZoomY) / 7;
            System.out.println("should call (" + beginForZoomX + "," + endForZoomX + ") (" + beginForZoomY + "," + endForZoomY + ") for zoom " + i + " factor " + factor + " => (" + tileCount + " tiles)");
            int ok = 0;
            int tile = 0;
            int j = beginForZoomX;
            while (j < endForZoomX) {
                int k = beginForZoomY;
                while (k < endForZoomY) {
                    System.out.println(String.valueOf(ok) + ". call " + i + "/" + j + "/" + k + ".png");
                    String url = "http://93.9.211.157/hot/" + i + "/" + j + "/" + k + ".png";
                    try {
                        String inputLine;
                        String USER_AGENT = "Mozilla/5.0";
                        URL obj = new URL(url);
                        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
                        con.setRequestProperty("User-Agent", "Mozilla/5.0");
                        int responseCode = con.getResponseCode();
                        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                        StringBuffer response = new StringBuffer();
                        while ((inputLine = in.readLine()) != null) {
                            response.append(inputLine);
                        }
                        in.close();
                        if (responseCode != 200) {
                            System.out.println("\nSending 'GET' request to URL : " + url + " respond " + responseCode + " response string " + response.toString() + " car");
                        } else {
                            System.out.println("\nSending 'GET' request to URL : " + url + " respond " + responseCode);
                            ++ok;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++tile;
                    ++totalTile;
                    k += 7;
                }
                j += 7;
            }
            System.out.println(String.valueOf(tile) + " call on zoom " + i + "total : " + totalTile + "), " + ok + " ok");
            ++i;
        }
    }

    public static void fileFilter(String path, int dayCount) {
        System.out.println("fileFilter");
        String dir = "C:\\Users\\Seb.DESKTOP-V4EH37M\\Desktop\\FICHIERS\\sogran\\200805\\filter";
        String ignored = "C:\\Users\\Seb.DESKTOP-V4EH37M\\Desktop\\FICHIERS\\sogran\\200805\\ignored";
        File mainFile = new File(path);
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(mainFile.list(Fonctions.getC1BDetector())));
        Collections.sort(list);
        String current = "";
        Date lastDay = null;
        String lastFile = null;
        for (String file : list) {
            int days;
            String driver = file.substring(3, 17);
            Date day = Fonctions.getDownloadDate(file);
            if (!current.equals(driver)) {
                System.out.println("new driver " + driver);
                current = driver;
                lastDay = null;
                if (lastFile != null) {
                    System.out.println("add last file " + lastFile);
                    File las = new File(lastFile);
                    las.renameTo(new File(String.valueOf(dir) + "\\" + las.getName()));
                    lastFile = null;
                }
            }
            int n = days = lastDay == null ? dayCount : ConversionTime.getDaysBetween(lastDay, day);
            if (days >= dayCount) {
                System.out.println("add file " + path + "\\" + file + " on " + dir + "\\" + file);
                Fonctions.copy(new File(String.valueOf(path) + "\\" + file), new File(String.valueOf(dir) + "\\" + file));
                lastDay = day;
                continue;
            }
            System.out.println("don't add file " + file);
            Fonctions.copy(new File(String.valueOf(path) + "\\" + file), new File(String.valueOf(ignored) + "\\" + file));
            lastFile = String.valueOf(ignored) + "\\" + file;
        }
    }

    public static void getUnreadedFile(String path, String minDate) {
        System.out.println("fileFilter");
        if (path == null) {
            return;
        }
        final Vector<CardDownload> cd = CardDownload.getTelechargement(0, 0, null, null);
        final Vector<UevDownload> ud = UevDownload.getTelechargementUEV(0, 0, null, null);
        System.out.println(String.valueOf(cd.size()) + " fichiers C1B et " + ud.size() + " fichiers uev");
        File mainFile = new File(path);
        try {
            Files.walkFileTree(mainFile.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!file.getFileName().toString().toUpperCase().endsWith("C1B") && !file.getFileName().toString().toUpperCase().endsWith("V1B")) {
                        return FileVisitResult.CONTINUE;
                    }
                    if (file.toString().contains(" - DELETED")) {
                        return FileVisitResult.CONTINUE;
                    }
                    for (CardDownload card : cd) {
                        if (!card.getFichier().equals(file.getFileName().toString())) continue;
                        return FileVisitResult.CONTINUE;
                    }
                    for (UevDownload uev : ud) {
                        if (!uev.getFichier().equals(file.getFileName().toString())) continue;
                        return FileVisitResult.CONTINUE;
                    }
                    System.out.println(file + " never read");
                    file.toFile().renameTo(new File("E:\\genex\\toRead\\" + file.getFileName().toString()));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void copy(File source, File destination) {
        FileInputStream sourceFile = null;
        FileOutputStream destinationFile = null;
        if (destination.exists() && destination.length() == source.length()) {
            return;
        }
        try {
            try {
                int nbLecture;
                sourceFile = new FileInputStream(source);
                destinationFile = new FileOutputStream(destination);
                byte[] buffer = new byte[524288];
                while ((nbLecture = sourceFile.read(buffer)) != -1) {
                    destinationFile.write(buffer, 0, nbLecture);
                }
            }
            catch (FileNotFoundException f) {
                System.out.println(f.getMessage());
                try {
                    sourceFile.close();
                    destinationFile.close();
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
                try {
                    sourceFile.close();
                    destinationFile.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                sourceFile.close();
                destinationFile.close();
            }
            catch (Exception exception) {}
        }
    }

    public static Date getDownloadDate(String fileName) {
        String nomFichier = fileName;
        String dateBDD = "";
        String tmp = nomFichier.substring(nomFichier.length() - 14, nomFichier.length() - 4);
        String jour = tmp.substring(4, 6);
        String mois = tmp.substring(2, 4);
        String year = "20";
        if (Integer.parseInt(tmp.substring(0, 2)) >= 70) {
            year = "19";
        }
        String annee = String.valueOf(year) + tmp.substring(0, 2);
        String heure = String.valueOf(tmp.substring(6, 8)) + ":" + tmp.substring(8, 10);
        dateBDD = String.valueOf(annee) + "-" + mois + "-" + jour + " " + heure + ":00";
        return ConversionTime.stringToDateDb(dateBDD);
    }

    public static int getDistanceBetweenGnssPlace(GNSSPlace begin, GNSSPlace end) {
        return Fonctions.getDistanceBetweenGnssPosition(begin.getLongitude(), begin.getLatitude(), end.getLongitude(), end.getLatitude());
    }

    public static int getDistanceBetweenGnssPosition(float bLon, float bLat, float eLon, float eLat) {
        int R = 6371;
        double latDistance = Math.toRadians(eLat - bLat);
        double lonDistance = Math.toRadians(eLon - bLon);
        double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(Math.toRadians(bLat)) * Math.cos(Math.toRadians(eLat)) * Math.sin(lonDistance / 2.0) * Math.sin(lonDistance / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double distance = 6371.0 * c * 1000.0;
        TimsLogger.debug("#Fonctions.getDistanceBetweenGnssPosition# " + bLon + " " + bLat + " / " + eLon + " " + eLat + " => " + distance);
        return (int)Math.round(distance);
    }

    public static boolean shouldAddExpenseByPosition(ExpensesType tf, Service tmp, Conducteur conducteur) {
        if (!tf.isActif() || tf.getMaxDistance() == -1) {
            return false;
        }
        Agence agency = Agence.find(null, conducteur.getCleAgence());
        if (agency == null || agency.getLongitude() == 0.0f || conducteur.getLongitude() == 0.0f) {
            TimsLogger.warn("#Fonctions.shouldAddExpenseByPosition# Missing informations for position expense (agency :" + (agency != null ? String.valueOf(agency.getLongitude()) + " " + agency.getLatitude() : "null") + ") (home : " + conducteur.getLongitude() + " " + conducteur.getLatitude() + ")");
            return false;
        }
        int distanceFromAgency = -1;
        int distanceFromHome = -1;
        String beginH = String.valueOf(ConversionTime.heureIntToString(tmp.getBeginTime(), ":")) + ":00";
        String endH = String.valueOf(ConversionTime.heureIntToString(tmp.getEndTime(), ":")) + ":00";
        Date begin = ConversionTime.stringToDateDb(String.valueOf(tmp.getBeginDate()) + " " + beginH, true);
        Date end = ConversionTime.stringToDateDb(String.valueOf(tmp.getEndDate()) + " " + endH, true);
        end = ConversionTime.add(end, 12, tmp.getDailyRest());
        ArrayList<GNSSPlace> places = GNSSPlace.getGnssDriverPlaces(conducteur.getCleConducteur(), begin, end);
        if (places.size() == 0) {
            TimsLogger.warn("#Fonctions.shouldAddExpenseByPosition# calcul frais / No places between " + beginH + " and " + endH);
            return false;
        }
        GNSSPlace last = places.get(places.size() - 1);
        distanceFromAgency = Fonctions.getDistanceBetweenGnssPosition(agency.getLongitude(), agency.getLatitude(), last.getLongitude(), last.getLatitude());
        distanceFromHome = Fonctions.getDistanceBetweenGnssPosition(conducteur.getLongitude(), conducteur.getLatitude(), last.getLongitude(), last.getLatitude());
        TimsLogger.debug("#Fonctions.shouldAddExpenseByPosition# calcul frais / " + distanceFromAgency + " m from agency " + distanceFromHome + " m from home (agency :" + agency.getLongitude() + "," + agency.getLatitude() + ") (home : " + conducteur.getLongitude() + "," + conducteur.getLatitude() + ") (last : " + last.getLongitude() + "," + last.getLatitude() + ")(service " + beginH + "/" + endH + " GNSS Place " + ConversionTime.dateToString(last.getPointTime(), "dd/MM/yyyy HH:mm"));
        if (distanceFromAgency != -1 && distanceFromAgency < tf.getMaxDistance() || distanceFromHome != -1 && distanceFromHome < tf.getMaxDistance()) {
            TimsLogger.debug("#Fonctions.shouldAddExpenseByPosition# Frais " + tf.getCode() + " non valable");
            return false;
        }
        TimsLogger.debug("#Fonctions.shouldAddExpenseByPosition# Frais " + tf.getCode() + " \u00e0 attribuer");
        return true;
    }

    public static float getLongitudeFromHex(String hexCoordinate) {
        byte[] coordBuf = Fonctions.parseStringToByteArray(hexCoordinate);
        String sexagesimalLongitude = String.valueOf(Fonctions.bytesToInt(coordBuf, 3, 3));
        while (sexagesimalLongitude.length() < 5) {
            sexagesimalLongitude = "0" + sexagesimalLongitude;
        }
        int slLength = sexagesimalLongitude.length();
        String degreLongitude = sexagesimalLongitude.substring(0, slLength - 3);
        String minutLongitude = sexagesimalLongitude.substring(slLength - 3, slLength - 1);
        String secondLongitude = sexagesimalLongitude.substring(slLength - 1);
        TimsLogger.debug("Fonctions.getLongitudeFromHex# " + sexagesimalLongitude + " => " + degreLongitude + " " + minutLongitude + " " + secondLongitude);
        float decimalLongitude = Float.parseFloat(degreLongitude) + Float.parseFloat(minutLongitude) / 60.0f + Float.parseFloat(secondLongitude) / 3600.0f;
        return decimalLongitude;
    }

    public static float getLatitudeFromHex(String hexCoordinate) {
        byte[] coordBuf = Fonctions.parseStringToByteArray(hexCoordinate);
        String sexagesimalLatitude = String.valueOf(Fonctions.bytesToInt(coordBuf, 0, 3));
        while (sexagesimalLatitude.length() < 5) {
            sexagesimalLatitude = "0" + sexagesimalLatitude;
        }
        int sLatLength = sexagesimalLatitude.length();
        String degreLatitude = sexagesimalLatitude.substring(0, sLatLength - 3);
        String minutLatitude = sexagesimalLatitude.substring(sLatLength - 3, sLatLength - 1);
        String secondLatitude = sexagesimalLatitude.substring(sLatLength - 1);
        TimsLogger.debug("Fonctions.getLatitudeFromHex# " + sexagesimalLatitude + " => " + degreLatitude + " " + minutLatitude + " " + secondLatitude);
        float decimalLatitude = Float.parseFloat(degreLatitude) + Float.parseFloat(minutLatitude) / 60.0f + Float.parseFloat(secondLatitude) / 3600.0f;
        return decimalLatitude;
    }

    static class GetFile
    implements Runnable {
        private File path = null;

        GetFile() {
        }

        @Override
        public void run() {
            JFileChooser choix = new JFileChooser();
            choix.setFileSelectionMode(0);
            choix.setMultiSelectionEnabled(false);
            choix.setDialogTitle(LanguageTranslator.getString("message.selectFile"));
            choix.setApproveButtonText(LanguageTranslator.getString("button.valid"));
            if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
                this.path = choix.getSelectedFile();
            }
        }

        public File getPath() {
            return this.path;
        }
    }
}

