/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Activite;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Jour;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;
import javax.swing.JOptionPane;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;

public class GestionChevauchement {
    private Jour jourBase = null;
    private Vector<ActiviteConducteur> activiteJourAnalyse = null;
    private String dateJour = null;
    private int distance = 0;
    private Conducteur detailConducteur = null;
    private int memeActivite = 0;
    private boolean conflit = false;
    private String sourceAnalyse = null;
    private boolean activityAdded = false;
    private boolean onlyCardOnBase = true;
    private boolean onlyCardOnAnalyse = true;

    public GestionChevauchement(Vector<ActiviteConducteur> activ, Conducteur detailCond, String jour, int km, FileWriter fJour, String sourceAnalyse) {
        Transport.ps.startOperation();
        this.dateJour = jour;
        this.distance = km;
        this.detailConducteur = detailCond;
        this.activiteJourAnalyse = activ;
        this.sourceAnalyse = sourceAnalyse;
        this.recupererActiviteJour();
        if (this.jourBase != null && this.jourBase.getActivity().size() != 0 && this.jourBase.getSourceName() != null && !this.jourBase.getSourceName().equals(sourceAnalyse)) {
            this.conflit = this.isConflit();
        }
        TimsLogger.debug("#GestionChevauchement.constr# traitement OK, conflit = " + this.conflit + " (" + this.jourBase.getSourceName() + " / " + sourceAnalyse + ")");
        if (this.memeActivite == this.activiteJourAnalyse.size() && this.memeActivite == this.jourBase.getActivity().size()) {
            TimsLogger.verbose("Aucun changement d'activit\u00e9 detect\u00e9. on quitte sans rien faire.");
            return;
        }
        if (this.jourBase.getSourceName() != null && this.jourBase.getSourceName().equals(sourceAnalyse)) {
            TimsLogger.debug("#GestionChevauchement# meme source, on \u00e9crase la journ\u00e9e");
            try {
                this.activityAdded = true;
                this.saveFinal(activ, fJour);
            }
            catch (IOException e) {
                TimsLogger.warn("Exception stockerSansConflit() dans GestionChevauchement");
            }
        } else if (this.conflit) {
            if (Transport.apiMode == 0) {
                JOptionPane.showMessageDialog(null, LanguageTranslator.getString("conflict.detected", this.dateJour), LanguageTranslator.getString("conflict.exist"), 2);
            }
            this.stockerConflit();
        } else {
            try {
                this.activityAdded = true;
                this.stockerSansConflit(fJour);
            }
            catch (IOException e) {
                TimsLogger.warn("Exception stockerSansConflit() dans GestionChevauchement");
            }
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "chevauchement");
    }

    private boolean isActiv(int cle) {
        return cle != 4 && cle != 7;
    }

    public boolean activityAdded() {
        return this.activityAdded;
    }

    private boolean isConflit() {
        boolean canBeSame = true;
        int i = 0;
        while (i < this.jourBase.getActivity().size()) {
            ActiviteConducteur tmpBase = this.jourBase.getActivity().get(i);
            if (this.jourBase.getSourceName() == null || this.jourBase.getSourceName().toLowerCase().contains(".jpg")) {
                this.onlyCardOnBase = false;
            }
            int j = 0;
            while (j < this.activiteJourAnalyse.size()) {
                ActiviteConducteur tmpAna = this.activiteJourAnalyse.get(j);
                if (tmpAna.getNomSource() == null || tmpAna.getNomSource().toLowerCase().contains("jpg")) {
                    this.onlyCardOnAnalyse = false;
                }
                if (tmpAna.getCleType() == tmpBase.getCleType() && tmpAna.getHeureDebut() == tmpBase.getHeureDebut() && tmpAna.getHeureFin() == tmpBase.getHeureFin()) {
                    if (!canBeSame) break;
                    ++this.memeActivite;
                    break;
                }
                canBeSame = false;
                if (tmpBase.getHeureFin() <= tmpAna.getHeureDebut()) break;
                if (tmpBase.getHeureDebut() < tmpAna.getHeureFin() && this.isActiv(tmpAna.getCleType()) && tmpBase.getCleType() != tmpAna.getCleType() && this.isActiv(tmpBase.getCleType())) {
                    TimsLogger.debug("######Conflit#########");
                    if (Transport.debug >= 1) {
                        tmpBase.affiche();
                    }
                    tmpAna.affiche();
                    TimsLogger.debug("######Conflit#########");
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private boolean recupererActiviteJour() {
        this.jourBase = Transport.bdd.getJourNew(this.detailConducteur.getCleConducteur(), this.dateJour, null, 1, false).get(0);
        TimsLogger.debug("#GestionChevauchement.recupererActiviteJour# tableau d'activite = " + (this.jourBase == null ? "null" : Integer.valueOf(this.jourBase.getActivity().size())));
        return this.jourBase != null && this.jourBase.getActivity().size() != 0;
    }

    private void stockerConflit() {
        try {
            this.stockerActiviteBase();
            this.stockerActiviteAnalyse();
        }
        catch (IOException ex) {
            TimsLogger.warn("Exception dans le stockage des conflits");
        }
        int kmBase = this.jourBase.getKm();
        if (this.memeActivite >= 2) {
            TimsLogger.debug("on a un conflit avec plus de 2 activit\u00e9 identiques au d\u00e9but de la journ\u00e9e");
        }
        Transport.bdd.addConflit(this.dateJour, this.detailConducteur.getCleConducteur(), this.distance, kmBase, ConnexionSettings.getInstance().getUserCle());
    }

    private void stockerActiviteBase() throws IOException {
        int random = (int)(Math.random() * 1000.0);
        String confFn = String.valueOf(Transport.savePath) + "conflit_base" + random + ".txt";
        while (new File(confFn).exists()) {
            random = (int)(Math.random() * 1000.0);
            confFn = String.valueOf(Transport.savePath) + "conflit_base" + random + ".txt";
        }
        FileWriter fConf = new FileWriter(confFn);
        for (ActiviteConducteur tmp : this.jourBase.getActivity()) {
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                tmp.setModification(0);
                tmp.insert("t_activite_conflit_base");
                tmp.closeStatement();
                continue;
            }
            if (!System.getProperty("SGBDR", "mysql").equals("mysql")) continue;
            String sql = String.valueOf(this.detailConducteur.getCleConducteur()) + "\t" + tmp.getCleType() + "\t" + tmp.getHeureDebut() + "\t" + tmp.getHeureFin() + "\t" + tmp.getDuree() + "\t" + tmp.getEtatCarte() + "\t" + tmp.getTypeSource() + "\t" + tmp.getNomSource() + "\t" + this.dateJour + "\t" + tmp.getEtatConduite() + "\t" + tmp.getLecteur();
            fConf.write(sql);
            fConf.write("\n");
        }
        fConf.close();
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            Transport.bdd.loadDriverActivityConflictB(confFn);
        }
        new File(confFn).delete();
    }

    private void stockerActiviteAnalyse() throws IOException {
        int random = (int)(Math.random() * 1000.0);
        String confFn = String.valueOf(Transport.savePath) + "conflit_analyse" + random + ".txt";
        while (new File(confFn).exists()) {
            random = (int)(Math.random() * 1000.0);
            confFn = String.valueOf(Transport.savePath) + "conflit_analyse" + random + ".txt";
        }
        FileWriter fConf = new FileWriter(confFn);
        int x = 0;
        while (x < this.activiteJourAnalyse.size()) {
            ActiviteConducteur tmp = this.activiteJourAnalyse.get(x);
            if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
                tmp.insert("t_activite_conflit_analyse");
                tmp.closeStatement();
            } else if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
                String sql = String.valueOf(this.detailConducteur.getCleConducteur()) + "\t" + tmp.getCleType() + "\t" + tmp.getHeureDebut() + "\t" + tmp.getHeureFin() + "\t" + tmp.getDuree() + "\t" + tmp.getEtatCarte() + "\t" + tmp.getTypeSource() + "\t" + tmp.getNomSource() + "\t" + this.dateJour + "\t" + tmp.getEtatConduite() + "\t" + tmp.getLecteur();
                fConf.write(sql);
                fConf.write("\n");
            }
            ++x;
        }
        fConf.close();
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            Transport.bdd.loadDriverActivityConflictA(confFn);
        }
        new File(confFn).delete();
    }

    private String show(ActiviteConducteur tmp) {
        return String.valueOf(tmp.getCleType()) + " <" + tmp.getHeureDebut() + " " + tmp.getHeureFin() + ">";
    }

    private void stockerSansConflit(FileWriter fluxEcritureJ) throws IOException {
        TimsLogger.debug("#GestionChevauchement.stockerSansConflit# debut stockage");
        boolean baseFinished = false;
        boolean analyseFinished = false;
        int i = 0;
        int j = 0;
        int sourceCurrent = 0;
        Activite current = null;
        Vector<ActiviteConducteur> activiteFusion = new Vector<ActiviteConducteur>();
        SimpleDateFormat dateFormatjour = new SimpleDateFormat("E");
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(ConversionTime.stringToDate(this.dateJour, "yyyy-MM-dd"));
        TimsLogger.debug("GestionChevauchement Base : ");
        for (ActiviteConducteur activ : this.jourBase.getActivity()) {
            if (Transport.debug < 1) continue;
            activ.affiche();
        }
        TimsLogger.debug("Analyse : ");
        int x = 0;
        while (x < this.activiteJourAnalyse.size()) {
            ActiviteConducteur activ = this.activiteJourAnalyse.get(x);
            if (Transport.debug >= 1) {
                activ.affiche();
            }
            ++x;
        }
        if (this.jourBase.getActivity().size() == 0) {
            baseFinished = true;
            analyseFinished = true;
            activiteFusion = this.activiteJourAnalyse;
        }
        while (!baseFinished || !analyseFinished) {
            ActiviteConducteur activBase = this.jourBase.getActivity().get(i);
            ActiviteConducteur activAnalyse = this.activiteJourAnalyse.get(j);
            TimsLogger.debug("cur Base " + this.show(activBase));
            TimsLogger.debug("cur Analyse " + this.show(activAnalyse));
            TimsLogger.debug("current " + (current != null ? this.show((ActiviteConducteur)current) : "null"));
            if (!baseFinished && (activBase.getHeureDebut() < activAnalyse.getHeureDebut() || analyseFinished)) {
                if (current != null && (this.isActiv(current.getCleType()) && current.getHeureFin() > activBase.getHeureFin() || this.isActiv(current.getCleType()) && sourceCurrent == 2)) {
                    if (i == this.jourBase.getActivity().size() - 1) {
                        baseFinished = true;
                    } else {
                        ++i;
                    }
                    TimsLogger.debug("nothing i++(B)");
                    continue;
                }
                activiteFusion.add(activBase);
                current = activBase;
                sourceCurrent = 1;
                TimsLogger.debug("add base (1) => " + this.show(activBase));
                if (i == this.jourBase.getActivity().size() - 1) {
                    baseFinished = true;
                    continue;
                }
                ++i;
                continue;
            }
            if (!analyseFinished && (activAnalyse.getHeureDebut() < activBase.getHeureDebut() || baseFinished)) {
                if (current != null && (this.isActiv(current.getCleType()) && current.getHeureFin() > activAnalyse.getHeureDebut() || this.isActiv(current.getCleType()) && sourceCurrent == 1)) {
                    if (j == this.activiteJourAnalyse.size() - 1) {
                        analyseFinished = true;
                    } else {
                        ++j;
                    }
                    TimsLogger.debug("nothing j++(A)");
                    continue;
                }
                activiteFusion.add(activAnalyse);
                current = activAnalyse;
                sourceCurrent = 2;
                TimsLogger.debug("add analyse (2) => " + this.show(activAnalyse));
                if (j == this.activiteJourAnalyse.size() - 1) {
                    analyseFinished = true;
                    continue;
                }
                ++j;
                continue;
            }
            int baseLevel = this.getNiveauActivite(activBase.getCleType());
            int analyseLevel = this.getNiveauActivite(activAnalyse.getCleType());
            if (analyseLevel > baseLevel || analyseLevel == baseLevel && activAnalyse.getHeureFin() > activBase.getHeureFin()) {
                activiteFusion.add(activAnalyse);
                current = activAnalyse;
                sourceCurrent = 2;
                TimsLogger.debug("add analyse (3) => " + this.show(activAnalyse));
            } else {
                activiteFusion.add(activBase);
                current = activBase;
                sourceCurrent = 1;
                TimsLogger.debug("add base (4) => " + this.show(activBase));
            }
            if (i == this.jourBase.getActivity().size() - 1) {
                baseFinished = true;
            } else {
                ++i;
            }
            if (j == this.activiteJourAnalyse.size() - 1) {
                analyseFinished = true;
                continue;
            }
            ++j;
        }
        this.saveFinal(activiteFusion, fluxEcritureJ);
    }

    private void saveFinal(Vector<ActiviteConducteur> toAdd, FileWriter fluxEcritureJ) throws IOException {
        int km = this.calculKm(this.dateJour, this.distance);
        String comm = Transport.bdd.getCommentJour(this.detailConducteur.getCleConducteur(), this.dateJour);
        Transport.bdd.delJour(this.detailConducteur.getCleConducteur(), this.dateJour);
        int[] cumul = new int[7];
        int finAct = 0;
        int hn = 0;
        boolean manualInput = false;
        int x = 0;
        while (x < toAdd.size()) {
            ActiviteConducteur activ = toAdd.get(x);
            if (activ.isManualInput()) {
                manualInput = true;
            }
            finAct = 1440;
            if (x < toAdd.size() - 1) {
                ActiviteConducteur activ_suiv = toAdd.get(x + 1);
                finAct = activ_suiv.getHeureDebut();
            }
            activ.setHeureFin(finAct);
            if (activ.getDuree() != 0) {
                switch (activ.getCleType()) {
                    case 1: {
                        cumul[0] = cumul[0] + activ.getDuree();
                        hn += Fonctions.getTempsNuit(activ);
                        break;
                    }
                    case 2: {
                        cumul[1] = cumul[1] + activ.getDuree();
                        hn += Fonctions.getTempsNuit(activ);
                        break;
                    }
                    case 3: {
                        cumul[2] = cumul[2] + activ.getDuree();
                        hn += Fonctions.getTempsNuit(activ);
                        break;
                    }
                    case 4: {
                        cumul[3] = cumul[3] + activ.getDuree();
                        break;
                    }
                    case 5: {
                        cumul[4] = cumul[4] + activ.getDuree();
                        hn += Fonctions.getTempsNuit(activ);
                        break;
                    }
                    case 7: {
                        cumul[5] = cumul[5] + activ.getDuree();
                        break;
                    }
                    default: {
                        cumul[6] = cumul[6] + activ.getDuree();
                        TimsLogger.warn("activit\u00e9s inconnue " + activ.getCleType());
                    }
                }
            }
            ++x;
        }
        int cumulJ = cumul[0] + cumul[1] + cumul[2] + cumul[4];
        String hd = Fonctions.getHeureDebut(toAdd);
        String hf = Fonctions.getHeureFin(toAdd);
        String source = this.jourBase.getSourceName();
        if (source == null) {
            source = this.sourceAnalyse;
        } else if (this.sourceAnalyse != null && !this.sourceAnalyse.equals(source)) {
            source = String.valueOf(source) + ";" + this.sourceAnalyse;
        }
        TimsLogger.debug("Km : " + this.distance + " " + km);
        Jour tmpJour = new Jour(0, this.detailConducteur.getCleConducteur(), this.dateJour, cumul[0], cumul[1], cumul[2], cumul[3], cumul[4], cumul[5], cumul[6], cumulJ, Integer.parseInt(hd), Integer.parseInt(hf), hn, km, 0, false, toAdd, comm, ConnexionSettings.getInstance().getUserCle(), source, manualInput);
        if (System.getProperty("SGBDR", "mysql").equals("oracle")) {
            tmpJour.insert();
        }
        if (System.getProperty("SGBDR", "mysql").equals("mysql")) {
            fluxEcritureJ.write(tmpJour.getSQLInsert());
            fluxEcritureJ.write("\n");
        }
        if (System.getProperty("horoquartz", "0").equals("1")) {
            Date lastExport = BddTransport.getInstance().getLastExport(this.detailConducteur.getCleConducteur());
            Date jour = ConversionTime.stringToDate(this.dateJour, "yyyy-MM-dd");
            if (lastExport != null && (jour.before(lastExport) || jour.equals(lastExport))) {
                BddTransport.getInstance().updateExportHoroquartz(this.detailConducteur.getCleConducteur(), this.dateJour);
            }
        }
        if (!comm.equals("")) {
            Transport.bdd.addComment(this.detailConducteur.getCleConducteur(), this.dateJour, comm);
        }
    }

    private int calculKm(String jour, int km) {
        int oldKm = 0;
        if (this.onlyCardOnBase && this.onlyCardOnAnalyse) {
            TimsLogger.debug("lecture carte par dessus un jour d\u00e9j\u00e0 integr\u00e9 en partie le " + jour);
            oldKm = km;
        } else {
            oldKm = this.jourBase.getKm();
            oldKm += km;
        }
        return oldKm;
    }

    int getNiveauActivite(int cle) {
        if (cle == 7) {
            return 0;
        }
        if (cle == 4) {
            return 1;
        }
        if (cle == 6) {
            return 2;
        }
        if (cle == 5) {
            return 3;
        }
        if (cle == 3) {
            return 4;
        }
        if (cle == 2) {
            return 5;
        }
        if (cle == 1) {
            return 6;
        }
        return -1;
    }
}

