/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Rate;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.DayTypeNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class HourCalculator {
    int hnG = 0;
    int he125G = 0;
    int hs125G = 0;
    int hs150G = 0;
    int hnV = 0;
    int he125V = 0;
    int hs125V = 0;
    int hs150V = 0;
    Date begin;
    Date end;

    public HourCalculator(Date begin, Date end) {
        this.begin = begin;
        this.end = end;
    }

    /*
     * Unable to fully structure code
     */
    public HashMap<Conducteur, ArrayList<Integer>> getData() {
        result = new LinkedHashMap<Conducteur, ArrayList<Integer>>();
        taux150m = 0.0f;
        actual = new Rate();
        if (actual.loadCurrent()) {
            taux150m = actual.getT150M();
        }
        drivers = Conducteur.loadList(new Integer[0]);
        tmpS = Service.getService(null, drivers, this.begin, this.end);
        tmpL = LienJourConducteur.loadList(null, drivers, this.begin, this.end);
        TimsLogger.info("#DriverHourWidget.process()# " + tmpS.size() + " services, " + tmpL.size() + " jours");
        currentContract = null;
        defaultDayLength = 0;
        x = 0;
        while (x < drivers.size()) {
            block35: {
                totalWorkedTime = 0;
                totalWorkedDay = 0;
                totalAltPaidHour = 0;
                totalAltGenerateHSHour = 0;
                totalAltDayCount = 0;
                totalNightTime = 0;
                totalAmplitude = 0;
                totalDrive = 0;
                totalWork = 0;
                totalAvailability = 0;
                totalCrew = 0;
                totalUnk = 0;
                periodWorkedTime = 0;
                periodAltPaidHour = 0;
                periodAltGenerateHSHour = 0;
                week = ConversionTime.getWeek(this.begin);
                currentDriver = drivers.get(x);
                TimsLogger.debug("#DriverHourWidget.process# process " + currentDriver.getLibelle());
                requirements = true;
                try {
                    currentContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                    if (System.getProperty("contract_day_length_reference", "0").equals("1") && currentContract != null) {
                        defaultDayLength = currentContract.getDailyValue();
                    }
                }
                catch (TypeContratNotFoundException ex) {
                    requirements = false;
                    System.err.println("#DriverHourWidget.process# unable to retrieve contract type " + currentDriver.getCleTypeContrat());
                    if (Transport.debug < 1) break block35;
                    ex.printStackTrace();
                }
            }
            tmpC = null;
            if (currentDriver.getCalendarId() != 0) {
                tmpC = GlobalCalendarDay.loadList(currentDriver.getCalendarId(), this.begin, this.end);
            }
            serviceLeft = true;
            ljcLeft = true;
            day = this.begin;
            while (day.compareTo(this.end) <= 0) {
                block36: {
                    if (serviceLeft && tmpS.size() != 0) {
                        if (tmpS.get(0).getDriverId() != currentDriver.getCleConducteur()) {
                            TimsLogger.debug("#DriverHourWidget.process# no more service ");
                            tmpS.get(0).affiche();
                            serviceLeft = false;
                        } else if (day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd"))) {
                            TimsLogger.debug("#DriverHourWidget.process# add ");
                            tmpS.get(0).affiche();
                            periodWorkedTime += tmpS.get(0).getService();
                            totalAmplitude += tmpS.get(0).getAmplitude();
                            totalNightTime += tmpS.get(0).getNight();
                            totalDrive += tmpS.get(0).getDriving();
                            totalWork += tmpS.get(0).getWork();
                            totalAvailability += tmpS.get(0).getAvailability();
                            totalCrew += tmpS.get(0).getCrew();
                            totalUnk += tmpS.get(0).getUnk();
                            ++totalWorkedDay;
                            tmpS.remove(0);
                            if (tmpS.size() != 0 && day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd")) && tmpS.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                                TimsLogger.debug("#DriverHourWidget.process# 2 services sur le m\u00eame jour ");
                                tmpS.get(0).affiche();
                                periodWorkedTime += tmpS.get(0).getService();
                                totalAmplitude += tmpS.get(0).getAmplitude();
                                totalNightTime += tmpS.get(0).getNight();
                                tmpS.remove(0);
                            }
                        }
                    }
                    if (!ljcLeft || tmpL.size() == 0) break block36;
                    if (tmpL.get(0).getCleConducteur() == currentDriver.getCleConducteur()) ** GOTO lbl100
                    ljcLeft = false;
                    break block36;
lbl-1000:
                    // 1 sources

                    {
                        try {
                            jt = JourType.getDayType(tmpL.get(0).getCleJourType());
                            shouldPay = jt.shouldPay(currentDriver, tmpL.get(0).getDateJour());
                            if (ConversionTime.getDayOfWeek(tmpL.get(0).getDateJour(), false) == 7 && jt.getCode().equals("CP")) {
                                TimsLogger.debug("#DriverHourWidget.process# CP le samedi, on ignore");
                            } else {
                                if (jt.isPaid() && shouldPay) {
                                    periodAltPaidHour += tmpL.get(0).getDuree(defaultDayLength);
                                }
                                if (jt.isGenerateHS() && shouldPay) {
                                    periodAltGenerateHSHour += tmpL.get(0).getDuree(defaultDayLength);
                                }
                                if (tmpL.get(0).getType() == 2) {
                                    ++totalAltDayCount;
                                }
                            }
                        }
                        catch (DayTypeNotFoundException ex) {
                            TimsLogger.debug("type d'absence non trouv\u00e9, on ignore " + tmpL.get(0).getCleJourType());
                        }
                        tmpL.remove(0);
lbl100:
                        // 2 sources

                        ** while (tmpL.size() != 0 && day.equals((Object)tmpL.get((int)0).getDateJour()) && tmpL.get((int)0).getCleConducteur() == currentDriver.getCleConducteur())
                    }
                }
                if (tmpC != null) {
                    y = 0;
                    while (y < tmpC.size()) {
                        if (day.equals(tmpC.get(y).getDate())) {
                            toAdd = new LienJourConducteur();
                            toAdd.setValues(-1, currentDriver.getCleConducteur(), tmpC.get(y).getDayTypeId(), 0, day, 0, 0, 2);
                            try {
                                jt = JourType.getDayType(toAdd.getCleJourType());
                                shouldPay = jt.shouldPay(currentDriver, toAdd.getDateJour());
                                if (ConversionTime.getDayOfWeek(toAdd.getDateJour(), false) == 7 && jt.getCode().equals("CP")) {
                                    TimsLogger.debug("#TimeToCcmxCayon.process# CP le samedi, on ignore");
                                } else {
                                    if (jt.isPaid() && shouldPay) {
                                        periodAltPaidHour += toAdd.getDuree(defaultDayLength);
                                    }
                                    if (jt.isGenerateHS() && shouldPay) {
                                        periodAltGenerateHSHour += toAdd.getDuree(defaultDayLength);
                                    }
                                    if (toAdd.getType() == 2) {
                                        ++totalAltDayCount;
                                    }
                                }
                            }
                            catch (DayTypeNotFoundException ex) {
                                TimsLogger.warn("type d'absence non trouv\u00e9, on ignore " + tmpL.get(0).getCleJourType());
                            }
                            tmpC.remove(y);
                            break;
                        }
                        ++y;
                    }
                }
                if (requirements && currentContract.getCalculationType() == 1 && ConversionTime.getWeek(ConversionTime.addDay(day, 1)) != week) {
                    totalWorkedTime += periodWorkedTime;
                    totalAltPaidHour += periodAltPaidHour;
                    totalAltGenerateHSHour += periodAltGenerateHSHour;
                    this.hsCalculation(currentContract, periodWorkedTime, periodAltGenerateHSHour);
                    periodWorkedTime = 0;
                    periodAltPaidHour = 0;
                    periodAltGenerateHSHour = 0;
                    week = ConversionTime.getWeek(ConversionTime.addDay(day, 1));
                }
                day = ConversionTime.addDay(day, 1);
            }
            if (requirements && currentContract.getCalculationType() == 2) {
                totalWorkedTime = periodWorkedTime;
                totalAltPaidHour = periodAltPaidHour;
                totalAltGenerateHSHour = periodAltGenerateHSHour;
                this.hsCalculation(currentContract, periodWorkedTime, periodAltGenerateHSHour);
            }
            if (requirements && totalWorkedTime > 0) {
                tmp = new HashMap<String, Object>();
                tmp.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                tmp.put("NOM_CONDUCTEUR", currentDriver.getNom());
                tmp.put("PRENOM_CONDUCTEUR", currentDriver.getPrenom());
                tmp.put("DESIGNATION", currentContract.getDesignation());
                tmp.put("HEURE_CONTRAT", currentContract.getContractHour());
                tmp.put("GARANTIE", currentContract.isGuaranteed() != false ? 1 : 0);
                tmp.put("TAUX_HORAIRE", Float.valueOf(currentDriver.getTaux()));
                tmp.put("TRAVAIL_NUIT", currentDriver.isNightWorker() != false ? 1 : 0);
                tmp.put("150M", Float.valueOf(taux150m));
                fNight = (float)totalNightTime / 60.0f;
                fHnV = (float)this.hnV / 60.0f;
                amplitude63 = totalAmplitude - 3780;
                amplitude75 = (int)((double)totalAmplitude * 0.75);
                fAmplitude = Math.max(amplitude63, amplitude75) - totalWorkedTime;
                tmp.put("HEURE_SERVICE", Float.valueOf((float)totalWorkedTime / 60.0f));
                tmp.put("HEURE_AMPLITUDE", Float.valueOf(fAmplitude > 0.0f ? (float)totalAmplitude / 60.0f : 0.0f));
                tmp.put("HEURE_NUIT", Float.valueOf(fNight));
                tmp.put("OTHER", totalAltPaidHour);
                tmp.put("OTHER_SERVICE", totalAltGenerateHSHour);
                tmp.put("HN", Float.valueOf(fHnV));
                tmp.put("HE", Float.valueOf((float)this.he125V / 60.0f));
                tmp.put("HS25", Float.valueOf((float)this.hs125V / 60.0f));
                tmp.put("HS50", Float.valueOf((float)this.hs150V / 60.0f));
                tmp.put("HNG", Float.valueOf((float)this.hnG / 60.0f));
                tmp.put("HEG", Float.valueOf((float)this.he125G / 60.0f));
                tmp.put("HS25G", Float.valueOf((float)this.hs125G / 60.0f));
                tmp.put("HS50G", Float.valueOf((float)this.hs150G / 60.0f));
                majoration = currentDriver.isNightWorker() != false ? 25 : 20;
                tauxNuit = taux150m * (float)majoration / 100.0f;
                taux_25 = currentDriver.getTaux() * 1.25f;
                taux_25_MAJ = fHnV == 0.0f ? taux_25 : fNight * tauxNuit / fHnV * 1.25f + taux_25;
                taux_50 = 0.0f;
                if (currentDriver.getTaux() != 0.0f && fHnV != 0.0f) {
                    taux_50 = fNight * tauxNuit / fHnV * 1.5f + currentDriver.getTaux() * 1.5f;
                }
                tmp.put("TAUX_NUIT", Float.valueOf(tauxNuit));
                tmp.put("TAUX_25", Float.valueOf(taux_25));
                tmp.put("TAUX_25_MAJ", Float.valueOf(taux_25_MAJ));
                tmp.put("TAUX_50", Float.valueOf(taux_50));
                TimsLogger.info("\r\n#Prepaie.process# Temps finaux pour " + currentDriver.getNom() + " " + currentDriver.getPrenom() + " :" + (requirements != false ? "" : "Matricule ou type de contrat manquants") + " base r\u00e9mun. contrat = " + (float)currentContract.getContractHour() / 60.0f + ", tps service (CTDDE) = " + (float)totalWorkedTime / 60.0f + " (" + totalWorkedDay + " jrs, C=" + totalDrive + ", T=" + totalWork + ", D=" + totalAvailability + ", DE=" + totalCrew + ")" + "\r\nseuil HN/HM125 = " + (float)currentContract.getSeuilHN(-1) / 60.0f + ", seuil HM125/HS125 = " + (float)currentContract.getSeuilHE(-1) / 60.0f + ", seuil HS125/HS150 = " + (float)currentContract.getSeuilHS25(-1) / 60.0f + "\r\nPartie fixe : heure garantie par le contrat : hn = " + (float)this.hnG / 60.0f + ", hm125G = " + (float)this.he125G / 60.0f + ", hs125G = " + (float)this.hs125G / 60.0f + ", hs150G = " + (float)this.hs150G / 60.0f + "\r\nHeure effectu\u00e9 : hn = " + (float)this.hnV / 60.0f + ", hm125 = " + (float)this.he125V / 60.0f + ", hs125 = " + (float)this.hs125V / 60.0f + ", hs150 = " + (float)this.hs150V / 60.0f + ", heure de nuit = " + (float)totalNightTime / 60.0f + "\r\nTaux : TAUX_NUIT = " + tauxNuit + ", TAUX_25 = " + taux_25 + ", TAUX_25_MAJ = " + taux_25_MAJ + ", TAUX_50 = " + taux_50 + ", TAUX150M = " + taux150m);
                val = new ArrayList<Integer>();
                val.add(this.hnV);
                val.add(this.hnG);
                val.add(this.he125V + this.hs125V);
                val.add(this.he125G + this.hs125G - (this.he125V + this.hs125V));
                val.add(this.hs150V);
                val.add(this.hs150G - this.hs150V);
                result.put(currentDriver, val);
            } else {
                TimsLogger.debug("\r\n#Prepaie.process# " + currentDriver.getNom() + " " + currentDriver.getPrenom() + " missing requirements");
            }
            this.clear();
            ++x;
        }
        return result;
    }

    public void hsCalculation(TypeContrat currentContract, int workedTime, int altGenerateHSHour) {
        int remuneration = workedTime + altGenerateHSHour;
        TimsLogger.debug(" ... on regarde pour la p\u00e9riode si on a des HS. " + remuneration + " travaill\u00e9." + " (seuil " + currentContract.getSeuilHN(-1) + "," + currentContract.getSeuilHE(-1) + "," + currentContract.getSeuilHS25(-1) + ")");
        if (remuneration > currentContract.getSeuilHS25(-1)) {
            TimsLogger.debug(" ... " + (remuneration - currentContract.getSeuilHS25(-1)) + " en hs150.");
            this.hs150V += remuneration - currentContract.getSeuilHS25(-1);
            remuneration = currentContract.getSeuilHS25(-1);
        }
        if (remuneration > currentContract.getSeuilHE(-1)) {
            TimsLogger.debug(" ... " + (remuneration - currentContract.getSeuilHE(-1)) + " en hs125.");
            this.hs125V += remuneration - currentContract.getSeuilHE(-1);
            remuneration = currentContract.getSeuilHE(-1);
        }
        if (remuneration > currentContract.getSeuilHN(-1)) {
            TimsLogger.debug(" ... " + (remuneration - currentContract.getSeuilHN(-1)) + " en he125.");
            this.he125V += remuneration - currentContract.getSeuilHN(-1);
            remuneration = currentContract.getSeuilHN(-1);
        }
        this.hnV += remuneration;
        if (currentContract.isGuaranteed() && remuneration < currentContract.getContractHour()) {
            int time;
            int garantuee = currentContract.getContractHour();
            int paid = remuneration;
            int toDispatch = garantuee - remuneration;
            TimsLogger.debug(" ... on a une garantie de " + garantuee + ". reste " + toDispatch + " \u00e0 dispatcher car on a pay\u00e9 que " + remuneration);
            if (paid < currentContract.getSeuilHN(-1) && toDispatch > 0) {
                time = currentContract.getSeuilHN(-1) - paid;
                if (time > toDispatch) {
                    time = toDispatch;
                }
                this.hnG += time;
                TimsLogger.debug(" ... " + time + " en hnG. reste " + (toDispatch -= time) + " \u00e0 dispatcher. Total pay\u00e9 jusque l\u00e0 " + (paid += time));
            }
            if (paid < currentContract.getSeuilHE(-1) && toDispatch > 0) {
                time = currentContract.getSeuilHE(-1) - paid;
                if (time > toDispatch) {
                    time = toDispatch;
                }
                this.he125G += time;
                TimsLogger.debug(" ... " + time + " en he125G. reste " + (toDispatch -= time) + " \u00e0 dispatcher. Total pay\u00e9 jusque l\u00e0 " + (paid += time));
            }
            if (paid < currentContract.getSeuilHS25(-1) && toDispatch > 0) {
                time = currentContract.getSeuilHS25(-1) - paid;
                if (time > toDispatch) {
                    time = toDispatch;
                }
                this.hs125G += time;
                TimsLogger.debug(" ... " + time + " en hs125G. reste " + (toDispatch -= time) + " \u00e0 dispatcher. Total pay\u00e9 jusque l\u00e0 " + (paid += time));
            }
            if (toDispatch > 0) {
                this.hs150G += toDispatch;
                TimsLogger.debug(" ... reste " + toDispatch + " en hs150G.");
            }
        }
    }

    public void clear() {
        this.hnG = 0;
        this.he125G = 0;
        this.hs125G = 0;
        this.hs150G = 0;
        this.hnV = 0;
        this.he125V = 0;
        this.hs125V = 0;
        this.hs150V = 0;
    }
}

