/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util.messaging;

import fr.pgh.data.BddTransport;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.mail.MailSender;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.views.sync.SynchronizedMessage;
import transpo.system.ui.views.sync.SynchronizedOptionDialog;
import transpo.system.util.messaging.Message;
import transpo.system.util.messaging.StringMessage;

public class MessageSystemManager {
    public static final int CLIENT_LEVEL = 1;
    public static final int API_LEVEL = 2;
    private static int messageLevel = 1;

    public static void setMessageLevel(int messageLevel) {
        MessageSystemManager.messageLevel = messageLevel;
    }

    public static void information(Component parent, Message message, String title) {
        MessageSystemManager.information(parent, message, title, 1, null);
    }

    public static void information(Component parent, String message, String title) {
        MessageSystemManager.information(parent, new StringMessage(message), title, 1, null);
    }

    public static void information(Component parent, Message message, String title, int type, Icon icon) {
        switch (messageLevel) {
            case 2: {
                TimsLogger.info("#MsM.information# " + message.getReadableString());
                break;
            }
            default: {
                if (parent == null) {
                    parent = MainFrameTransport.getInstance();
                }
                if (type == -1) {
                    type = 1;
                }
                TimsLogger.debug("#MsM.information# on envoie une information sur l'\u00e9cran (" + message.getReadableString() + ")");
                new SynchronizedMessage(parent, message, title, type, icon).run();
            }
        }
    }

    public static void error(Component parent, Message message, String title) {
        MessageSystemManager.error(parent, message, title, 0, null);
    }

    public static void error(Component parent, String message, String title) {
        MessageSystemManager.error(parent, new StringMessage(message), title, 0, null);
    }

    /*
     * Unable to fully structure code
     */
    public static void error(Component parent, Message message, String title, int type, Icon icon) {
        switch (MessageSystemManager.messageLevel) {
            case 2: {
                TimsLogger.error(message.getReadableString());
                if (Transport.debug != 0) break;
                to = new ArrayList<String>();
                try {
                    to.add(System.getProperty("admin.mail", "sebastien.gobert@pgh.fr"));
                    if (System.getProperty("admin.mail.sup") != null) {
                        to.add(System.getProperty("admin.mail.sup"));
                    }
                    if ((mail = BddTransport.getInstance().getCompany().getMail()) != null && !mail.equals("") && System.getProperty("msm.sendToUser", "0").equals("1")) {
                        to.add(BddTransport.getInstance().getCompany().getMail());
                    }
                    ms = new MailSender();
                    ms.sendMessage(to, "Erreur TIMS SERVEUR : " + BddTransport.getInstance().getCompany().getNomSociete(), String.valueOf(title) + " " + message.getReadableString(), null, false);
                    break;
                }
                catch (Exception ex) {
                    dest = "";
                    ** for (mail : to)
                }
lbl-1000:
                // 1 sources

                {
                    dest = String.valueOf(dest) + mail + ";";
                    continue;
                }
lbl23:
                // 1 sources

                TimsLogger.warn("#MsM.error# Impossible d'envoyer le mail <" + message.getReadableString() + "> to  " + dest + " : " + ex.getMessage());
                ex.printStackTrace();
                break;
            }
            default: {
                if (parent == null) {
                    parent = MainFrameTransport.getInstance();
                }
                if (type == -1) {
                    type = 0;
                }
                TimsLogger.debug("#MsM.error# on envoie une erreur sur l'\u00e9cran (" + message.getReadableString() + ")");
                new SynchronizedMessage(parent, message, title, type, icon).run();
            }
        }
    }

    public static void warning(Component parent, Message message, String title) {
        MessageSystemManager.warning(parent, message, title, 2, null);
    }

    public static void warning(Component parent, String message, String title) {
        MessageSystemManager.warning(parent, new StringMessage(message), title, 2, null);
    }

    public static void warning(Component parent, Message message, String title, int type, Icon icon) {
        switch (messageLevel) {
            case 2: {
                TimsLogger.warn("#MsM.warning# " + message.getReadableString() + (Transport.debug == 0 ? "" : " debug is ON, don't send mail"));
                if (Transport.debug != 0) break;
                try {
                    String mail;
                    ArrayList<String> to = new ArrayList<String>();
                    to.add(System.getProperty("admin.mail", "sebastien.gobert@pgh.fr"));
                    if (System.getProperty("admin.mail.sup") != null) {
                        to.add(System.getProperty("admin.mail.sup"));
                    }
                    if ((mail = BddTransport.getInstance().getCompany().getMail()) != null && !mail.equals("") && System.getProperty("msm.sendToUser", "0").equals("1")) {
                        to.add(BddTransport.getInstance().getCompany().getMail());
                    }
                    MailSender ms = new MailSender();
                    ms.sendMessage(to, "Avertissement TIMS SERVEUR : " + BddTransport.getInstance().getCompany().getNomSociete(), String.valueOf(title) + " " + message.getReadableString(), null, false);
                }
                catch (Exception ex) {
                    TimsLogger.warn("#MsM.warning# Impossible d'envoyer le mail <" + message.getReadableString() + "> " + ex.getMessage());
                }
                break;
            }
            default: {
                if (parent == null) {
                    parent = MainFrameTransport.getInstance();
                }
                if (type == -1) {
                    type = 2;
                }
                TimsLogger.debug("#MsM.warning# on envoie un avertissement sur l'\u00e9cran (" + title + " : " + message.getReadableString() + ")");
                new SynchronizedMessage(parent, message, title, type, icon).run();
            }
        }
    }

    public static int showConfirm(Component parent, Object message, String title) {
        SynchronizedOptionDialog sod = new SynchronizedOptionDialog(message, title);
        sod.run();
        return sod.getOption();
    }

    public static int showOption(Component parent, Object message, String title) {
        return 0;
    }
}

