/*
 * Decompiled with CFR 0.152.
 */
package transpo.system.util.watcher;

import fr.pgh.data.bdd.Societe;
import java.io.File;
import transpo.system.TimsLogger;
import transpo.system.util.Fonctions;
import transpo.system.util.messaging.MessageSystemManager;
import transpo.system.util.reader.FileReadManager;
import transpo.system.util.watcher.BaseListener;
import transpo.system.util.watcher.DirectoryWatcher;
import transpo.system.util.watcher.IFileListener;

public class FileListener
extends BaseListener
implements IFileListener {
    Societe company = null;

    public FileListener(Societe company) {
        this.company = company;
    }

    @Override
    public void onStart(Object monitoredResource) {
        File resource;
        if (monitoredResource instanceof File && (resource = (File)monitoredResource).isDirectory()) {
            TimsLogger.debug("#FileListener.onStart# Start to monitor " + resource.getAbsolutePath());
        }
    }

    @Override
    public void onStop(Object notMonitoredResource) {
    }

    @Override
    public void onAdd(Object newResource) {
        if (newResource instanceof File) {
            File file = (File)newResource;
            if (file.isFile()) {
                TimsLogger.info(String.valueOf(Fonctions.getDateHeure()) + " #FileListener.onAdd# " + file.getName().toUpperCase() + " queued on " + this.company.getNomSociete());
                FileReadManager.getInstance().addFile(file, this.company);
            } else {
                try {
                    DirectoryWatcher dw = new DirectoryWatcher(this.company, file.getAbsolutePath(), 5, false);
                    dw.addListener(new FileListener(this.company));
                    dw.start();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    TimsLogger.error("#FileListener.onAdd# error on launching new directory watcher on " + file.getAbsolutePath());
                    MessageSystemManager.error(null, "#FileListener.onAdd# error on launching new directory watcher on " + file.getAbsolutePath(), "TIMS-SERVER Error");
                }
            }
        }
    }

    @Override
    public void onChange(Object changedResource) {
        if (changedResource instanceof File) {
            File file = (File)changedResource;
        }
    }

    @Override
    public void onDelete(Object deletedResource) {
        boolean cfr_ignored_0 = deletedResource instanceof String;
    }
}

