/*
 * Decompiled with CFR 0.152.
 */
package transpo.ui.calendrier;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.prefs.Preferences;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class Calendrier {
    public Preferences prefs = null;
    public static String[] MONTH_NAME = new String[]{LanguageTranslator.getString("generics.january"), LanguageTranslator.getString("generics.february"), LanguageTranslator.getString("generics.march"), LanguageTranslator.getString("generics.april"), LanguageTranslator.getString("generics.may"), LanguageTranslator.getString("generics.june"), LanguageTranslator.getString("generics.july"), LanguageTranslator.getString("generics.august"), LanguageTranslator.getString("generics.september"), LanguageTranslator.getString("generics.october"), LanguageTranslator.getString("generics.november"), LanguageTranslator.getString("generics.december")};
    public static String[] DAY_NAME = new String[]{LanguageTranslator.getString("generics.monday"), LanguageTranslator.getString("generics.tuesday"), LanguageTranslator.getString("generics.wednesday"), LanguageTranslator.getString("generics.thursday"), LanguageTranslator.getString("generics.friday"), LanguageTranslator.getString("generics.saturday"), LanguageTranslator.getString("generics.sunday"), LanguageTranslator.getString("generics.notFound")};
    public int premierJour;
    public int nbDayInMonth;
    private GregorianCalendar calendrier = new GregorianCalendar();

    public Calendrier() {
        this.prefs = Preferences.userRoot().node("TIMS");
        int moisPref = this.prefs.getInt("mois", 100);
        int yearPref = this.prefs.getInt("annee", 0);
        if (moisPref != 100) {
            this.calendrier.set(2, moisPref);
            if (yearPref != 0) {
                this.calendrier.set(1, yearPref);
            }
        } else {
            this.calendrier.setTime(new Date());
        }
        this.calendrier.set(5, 1);
        this.nbDayInMonth = this.calendrier.getActualMaximum(5);
        this.getFirstDay();
    }

    public void addMonth(int amount) {
        this.calendrier.add(2, amount);
        this.setDay(1);
        this.nbDayInMonth = this.calendrier.getActualMaximum(5);
        this.getFirstDay();
    }

    public int getDay() {
        return this.calendrier.get(5);
    }

    public void setDay(int intValue) {
        this.calendrier.set(5, intValue);
    }

    public int getMonth() {
        return this.calendrier.get(2);
    }

    public int getYear() {
        return this.calendrier.get(1);
    }

    private void getFirstDay() {
        this.premierJour = this.calendrier.get(7);
    }
}

