/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.TypeActivite;
import transpo.system.TimsLogger;
import transpo.system.util.Fonctions;
import transport.offence.MasterOffence;

public class ContinuousDriveTraveller
extends MasterOffence {
    private OffenceThreshold minor = null;
    private OffenceThreshold serious = null;
    private OffenceThreshold verySerious = null;
    private int interruption = 0;
    private int firstInterruption = 0;
    private int secondInterruption = 0;
    private OffenceThreshold reducedMinor = null;
    private OffenceThreshold reducedSerious = null;
    private OffenceThreshold reducedVerySerious = null;
    private int maxReducedDriving = 0;
    private int beginReduced = 0;
    private int endReduced = 0;

    @Override
    public void process() throws Exception {
        this.minor = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.minor");
        this.serious = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.serious");
        this.verySerious = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.verySerious");
        this.interruption = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.interruption").getThreshold();
        this.firstInterruption = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.firstInterruption").getThreshold();
        this.secondInterruption = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.secondInterruption").getThreshold();
        this.reducedMinor = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.minor");
        this.reducedSerious = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.serious");
        this.reducedVerySerious = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.verySerious");
        this.maxReducedDriving = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.minor").getThreshold();
        this.beginReduced = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.begin").getThreshold();
        this.endReduced = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.end").getThreshold();
        TimsLogger.debug("\t\t#CDT.process# minor = " + this.minor + " , interruption = " + this.interruption + " , firstInterruption = " + this.firstInterruption + " , secondInterruption = " + this.secondInterruption + " , maxReducedDriving = " + this.maxReducedDriving + " , beginReduced = " + this.beginReduced + " , endReduced = " + this.endReduced);
        int interruptionTime = 0;
        int drivingTime = 0;
        int reducedDriving = 0;
        boolean offence = false;
        boolean reducedOffence = false;
        String dateInfraction = null;
        int hour = 0;
        boolean minimum = false;
        int i = this.findFirstRestEnd();
        while (i < this.activities.size()) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(i);
            if (activite.getDescription().equals("CONDUITE")) {
                reducedDriving += Fonctions.getTempsCumul(activite.getHeureDebut(), activite.getHeureFin(), this.beginReduced, this.endReduced);
                if ((drivingTime += activite.getDuree()) > this.minor.getThreshold() && !offence) {
                    offence = true;
                    dateInfraction = activite.getDateJour();
                    hour = activite.getHeureFin() - (drivingTime - this.minor.getThreshold());
                } else if (reducedDriving > this.maxReducedDriving && !reducedOffence) {
                    reducedOffence = true;
                    dateInfraction = activite.getDateJour();
                    hour = activite.getHeureFin() - (drivingTime - this.minor.getThreshold());
                }
                ++i;
                continue;
            }
            if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                int dureeRepos = this.restLength(i);
                i = this.endRestIndex(i);
                if (!minimum && dureeRepos >= this.firstInterruption) {
                    interruptionTime += dureeRepos;
                    minimum = true;
                } else if (dureeRepos >= this.secondInterruption) {
                    interruptionTime += dureeRepos;
                }
                if (interruptionTime < this.interruption) continue;
                if (reducedOffence || offence) {
                    String offencePart;
                    int type = 1;
                    int cost = 0;
                    String string = offencePart = offence ? "offence.basic" : "offence.reduced";
                    if (offencePart.equals("offence.basic")) {
                        if (drivingTime > this.verySerious.getThreshold()) {
                            type = 3;
                            cost = this.verySerious.getInfrigement();
                        } else if (drivingTime > this.serious.getThreshold()) {
                            type = 2;
                            cost = this.serious.getInfrigement();
                        } else {
                            cost = this.minor.getInfrigement();
                        }
                    } else if (drivingTime > this.reducedVerySerious.getThreshold()) {
                        type = 3;
                        cost = this.reducedVerySerious.getInfrigement();
                    } else if (drivingTime > this.reducedSerious.getThreshold()) {
                        type = 2;
                        cost = this.reducedSerious.getInfrigement();
                    } else {
                        cost = this.reducedMinor.getInfrigement();
                    }
                    this.parent.addInfraction(dateInfraction, hour, this.getOffencePart(offencePart).getId(), drivingTime, type, cost);
                    this.parent.addInfraction(dateInfraction, hour, this.getOffencePart(offencePart).getId(), interruptionTime - dureeRepos, 0, 0);
                }
                drivingTime = 0;
                reducedDriving = 0;
                interruptionTime = 0;
                reducedOffence = false;
                offence = false;
                minimum = false;
                continue;
            }
            ++i;
        }
    }

    public int findFirstRestEnd() throws Exception {
        int dureeInterruption = 0;
        boolean minimum = false;
        int i = 0;
        while (i < this.activities.size()) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(i);
            if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                int dureeRepos = 0;
                while (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                    dureeRepos += activite.getDuree();
                    if (++i == this.activities.size()) break;
                    activite = (ActiviteConducteur)this.activities.get(i);
                }
                if (!minimum && dureeRepos >= this.firstInterruption) {
                    dureeInterruption += dureeRepos;
                    minimum = true;
                } else if (dureeRepos >= this.secondInterruption) {
                    dureeInterruption += dureeRepos;
                }
                if (dureeInterruption < this.interruption) continue;
                return i;
            }
            ++i;
        }
        return this.activities.size();
    }
}

