/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.TypeActivite;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Fonctions;
import transport.offence.MasterOffence;

public class DailyManualInput
extends MasterOffence {
    private OffenceThreshold maxUnknown = null;
    private int indexActiviteCourante = 0;
    private int unkAmount = 0;

    @Override
    public void process() throws Exception {
        this.maxUnknown = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold");
        TimsLogger.verbose("#DMI.process()# " + this.activities.size() + " activit\u00e9s. maxUnknown " + this.maxUnknown);
        this.findFirstRest();
        this.dayProcess();
    }

    public void findFirstRest() throws Exception {
        while (this.indexActiviteCourante < this.activities.size()) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                int rest = this.restLength(this.indexActiviteCourante);
                this.indexActiviteCourante = this.endRestIndex(this.indexActiviteCourante);
                if (rest > DAILY_REST_THRESHOLD) break;
                this.unkAmount = 0;
            }
            ++this.indexActiviteCourante;
        }
    }

    public void dayProcess() throws Exception {
        boolean dayAdded = false;
        while (this.indexActiviteCourante < this.activities.size()) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                int repos = this.restLength(this.indexActiviteCourante);
                this.indexActiviteCourante = this.endRestIndex(this.indexActiviteCourante);
                if (this.unkAmount >= this.maxUnknown.getThreshold() && this.indexActiviteCourante < this.activities.size() && !dayAdded) {
                    TimsLogger.verbose("#DMI.dayProcess()# " + ((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).getDateJour() + " : " + this.unkAmount + " *offence*");
                    ActiviteConducteur tmp = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
                    TimsLogger.verbose("#DMI.checkOffence() add offence => " + tmp.getDateJour() + " : " + tmp.getHeureDebut());
                    this.parent.addInfraction(tmp.getDateJour(), tmp.getHeureDebut(), this.getOffencePart("offence.basic").getId(), this.unkAmount, 3, this.maxUnknown.getInfrigement());
                    dayAdded = true;
                }
                if (repos >= DAILY_REST_THRESHOLD || this.indexActiviteCourante == this.activities.size() - 1) {
                    if (this.indexActiviteCourante < this.activities.size() - 1) {
                        TimsLogger.verbose("#DMI.dayProcess()# " + ((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).getDateJour() + " : reinitialisation");
                    }
                    dayAdded = false;
                    this.unkAmount = 0;
                }
            }
            ++this.indexActiviteCourante;
        }
    }

    @Override
    public int restLength(int offsetWeeklyRestBegin) {
        int toReturn = 0;
        ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(offsetWeeklyRestBegin);
        while (offsetWeeklyRestBegin < this.activities.size()) {
            block4: {
                try {
                    if (!TypeActivite.getActivityType(activite.getCleType()).isRest()) break;
                    toReturn += activite.getDuree();
                    if (activite.getCleType() == 7) {
                        this.unkAmount += activite.getDuree();
                    }
                }
                catch (Exception ex) {
                    System.err.println("#DailyManualInput.restLength# unable to find TypeActivite " + activite.getCleType());
                    if (Transport.debug < 1) break block4;
                    ex.printStackTrace();
                }
            }
            if (++offsetWeeklyRestBegin >= this.activities.size()) continue;
            activite = (ActiviteConducteur)this.activities.get(offsetWeeklyRestBegin);
        }
        return toReturn;
    }
}

