/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.exception.ActivityTypeNotFoundException;
import java.util.Vector;
import transpo.system.TimsLogger;
import transport.offence.MasterOffence;

public class DailyOffence
extends MasterOffence {
    private int ConduiteJournaliereMax = 0;
    private int ConduiteJournaliereTolere = 0;
    private int JourTolere = 0;
    private int TEJournaliereMax = 0;
    private int TEJournaliereTolere = 0;
    private int TEJourTolere = 0;
    private int TELimite1 = 0;
    private int ReposMini1 = 0;
    private int TELimite2 = 0;
    private int ReposMini2 = 0;
    private int coupureMiniTE = 0;
    private int seuilReposAucunJournalier = 540;
    private int indexActiviteCourante = 0;
    Vector<Integer> driving = null;
    Vector<Integer> coupure = null;
    Vector<Integer> working = null;
    Vector<String> date = null;
    Vector<String> hour = null;

    @Override
    public void process() throws Exception {
        this.findFirstRest();
        this.dayProcess();
        this.checkOffence();
    }

    public int restLength() throws ActivityTypeNotFoundException {
        int restLength = 0;
        while (this.indexActiviteCourante <= this.activities.size() - 1) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                --this.indexActiviteCourante;
                break;
            }
            restLength += activite.getDuree();
            ++this.indexActiviteCourante;
        }
        return restLength;
    }

    public void findFirstRest() throws Exception {
        while (this.indexActiviteCourante < this.activities.size()) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            if ((activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) && this.restLength() > this.seuilReposAucunJournalier) {
                activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
                ++this.indexActiviteCourante;
                break;
            }
            ++this.indexActiviteCourante;
        }
    }

    public void dayProcess() throws Exception {
        this.driving = new Vector();
        this.coupure = new Vector();
        this.working = new Vector();
        this.date = new Vector();
        this.hour = new Vector();
        String sJour = "";
        String sHeure = "";
        int dureeConduite = 0;
        int dureeCTD = 0;
        int dureeCoupure = 0;
        while (this.indexActiviteCourante < this.activities.size()) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            if (activite.getDescription().equals("CONDUITE")) {
                if (dureeCTD == 0) {
                    sJour = activite.getDateJour();
                    sHeure = String.valueOf(activite.getHeureDebut());
                }
                dureeConduite += activite.getDuree();
                dureeCTD += activite.getDuree();
            }
            if (activite.getDescription().equals("TRAVAIL") || activite.getDescription().equals("DISPO") || activite.getDescription().equals("DOUBLE EQUIPAGE")) {
                if (dureeCTD == 0) {
                    sJour = activite.getDateJour();
                    sHeure = String.valueOf(activite.getHeureDebut());
                }
                dureeCTD += activite.getDuree();
            }
            if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                int repos = this.restLength();
                if (repos >= this.seuilReposAucunJournalier || this.indexActiviteCourante == this.activities.size() - 1) {
                    this.driving.add(dureeConduite);
                    this.working.add(dureeCTD);
                    this.coupure.add(dureeCoupure);
                    this.date.add(sJour);
                    this.hour.add(sHeure);
                    dureeCoupure = 0;
                    dureeConduite = 0;
                    dureeCTD = 0;
                } else if (repos >= this.coupureMiniTE) {
                    dureeCoupure += repos;
                }
            }
            ++this.indexActiviteCourante;
        }
    }

    public void checkOffence() throws Exception {
        int nbJoursTolere = 0;
        int semaineEnCours = 0;
        int i = 0;
        while (i < this.driving.size()) {
            String libelleJour = this.date.get(i);
            int tempsTotalConduite = this.driving.get(i);
            int coupureCTD = this.coupure.get(i);
            int tempsTotalTE = this.working.get(i);
            String libelleHeure = this.hour.get(i);
            TimsLogger.verbose(String.valueOf(libelleJour) + " " + libelleHeure + "==> CT = " + tempsTotalConduite + ", TE = " + tempsTotalTE);
            int semaine = ConversionTime.getWeek(libelleJour, "yyyy-MM-dd");
            if (semaine != semaineEnCours) {
                semaineEnCours = semaine;
                nbJoursTolere = 0;
            }
            for (OffencePart part : this.offence.getParts()) {
                if (!this.shouldCalculate(part)) continue;
                if (part.getName().equals("maxdriving")) {
                    // empty if block
                }
                if (part.getName().equals("toleratedriving") && tempsTotalConduite > this.ConduiteJournaliereMax) {
                    TimsLogger.debug("Conduite journali\u00e8re " + nbJoursTolere + " : " + this.JourTolere);
                    ++nbJoursTolere;
                }
                part.getName().equals("maxworking");
                if (part.getName().equals("tolerateworking")) {
                    // empty if block
                }
                if (!part.getName().equals("restworking1") || tempsTotalTE <= this.TELimite1 || tempsTotalTE < this.TELimite2) {
                    // empty if block
                }
                if (part.getName().equals("restworking2") && tempsTotalTE <= this.TELimite2) continue;
            }
            ++i;
        }
    }
}

