/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.TypeActivite;
import java.util.ArrayList;
import java.util.Arrays;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Fonctions;
import transport.offence.MasterOffence;

public class DailyRest
extends MasterOffence {
    private OffenceThreshold minor = null;
    private OffenceThreshold serious = null;
    private OffenceThreshold verySerious = null;
    private OffenceThreshold reducedMinor = null;
    private OffenceThreshold reducedSerious = null;
    private OffenceThreshold reducedVerySerious = null;
    private int reducedDayCount = 0;
    private int reducedWeek = 0;
    private int totalFractionnedRest = 0;
    private OffenceThreshold splittedMinor = null;
    private OffenceThreshold splittedSerious = null;
    private OffenceThreshold splittedVerySerious = null;
    private int leftRest = 0;
    private OffenceThreshold crewMinor = null;
    private OffenceThreshold crewSerious = null;
    private OffenceThreshold crewVerySerious = null;
    private int crewRestPeriod = 0;
    private int indexActiviteCourante = 0;
    private ArrayList<String[]> dayTable = null;
    private ArrayList<Boolean> restType = null;

    public int restLength(int heureFin, String date) {
        int dureeRepos = 0;
        ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
        try {
            while (TypeActivite.getActivityType(activite.getCleType()).isRest() && this.indexActiviteCourante < this.activities.size()) {
                if (activite.getHeureFin() > heureFin && activite.getDateJour().substring(0, 10).equals(date)) {
                    return dureeRepos += heureFin - activite.getHeureDebut();
                }
                dureeRepos += activite.getDuree();
                ++this.indexActiviteCourante;
                if (this.indexActiviteCourante >= this.activities.size() - 1) continue;
                activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dureeRepos;
    }

    @Override
    public void process() {
        this.dayTable = new ArrayList();
        this.restType = new ArrayList();
        this.minor = Fonctions.getOffenceThreshold(this.offence, "offence.dr.unreduced", "offence.threshold.minor");
        this.serious = Fonctions.getOffenceThreshold(this.offence, "offence.dr.unreduced", "offence.threshold.serious");
        this.verySerious = Fonctions.getOffenceThreshold(this.offence, "offence.dr.unreduced", "offence.threshold.verySerious");
        this.reducedMinor = Fonctions.getOffenceThreshold(this.offence, "offence.dr.reduced", "offence.threshold.minor");
        this.reducedSerious = Fonctions.getOffenceThreshold(this.offence, "offence.dr.reduced", "offence.threshold.serious");
        this.reducedVerySerious = Fonctions.getOffenceThreshold(this.offence, "offence.dr.reduced", "offence.threshold.verySerious");
        this.reducedDayCount = Fonctions.getOffenceThreshold(this.offence, "offence.dr.reduced", "offence.threshold.dayCount").getThreshold();
        this.totalFractionnedRest = Fonctions.getOffenceThreshold(this.offence, "offence.splitted", "offence.threshold").getThreshold();
        this.splittedMinor = Fonctions.getOffenceThreshold(this.offence, "offence.splitted", "offence.threshold.minor");
        this.splittedSerious = Fonctions.getOffenceThreshold(this.offence, "offence.splitted", "offence.threshold.serious");
        this.splittedVerySerious = Fonctions.getOffenceThreshold(this.offence, "offence.splitted", "offence.threshold.verySerious");
        this.leftRest = this.totalFractionnedRest - this.splittedMinor.getThreshold();
        this.crewMinor = Fonctions.getOffenceThreshold(this.offence, "offence.crew", "offence.threshold.minor");
        this.crewSerious = Fonctions.getOffenceThreshold(this.offence, "offence.crew", "offence.threshold.serious");
        this.crewVerySerious = Fonctions.getOffenceThreshold(this.offence, "offence.crew", "offence.threshold.verySerious");
        this.crewRestPeriod = Fonctions.getOffenceThreshold(this.offence, "offence.crew", "offence.threshold.period").getThreshold();
        this.reducedWeek = 1440;
        if (this.minor == null || this.serious == null || this.verySerious == null || this.reducedMinor == null || this.reducedSerious == null || this.reducedVerySerious == null || this.reducedDayCount == -1 || this.totalFractionnedRest == -1 || this.splittedMinor == null || this.splittedSerious == null || this.splittedVerySerious == null || this.leftRest == -1 || this.crewMinor == null || this.crewSerious == null || this.crewVerySerious == null || this.crewRestPeriod == -1) {
            TimsLogger.warn("#DailyRest.process# Missing Threshold");
            return;
        }
        this.indexActiviteCourante = this.findNextRest(this.indexActiviteCourante, false);
        if (this.indexActiviteCourante < this.activities.size() - 1) {
            this.calculReposJour(0);
        }
    }

    public int findNextRest(int index, boolean shouldSaveWeeklyRest) {
        while (index < this.activities.size() - 1) {
            block7: {
                ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(index);
                try {
                    if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                        String[] jour = new String[6];
                        if (jour[0] == null) {
                            jour[0] = activite.getDateJour();
                        }
                        if (jour[1] == null) {
                            jour[1] = String.valueOf(activite.getHeureDebut());
                        }
                        int restLength = this.restLength(index);
                        index = this.endRestIndex(index);
                        if (restLength >= DAILY_MIN_REST_THRESHOLD) {
                            if (restLength < this.reducedWeek || !shouldSaveWeeklyRest) break;
                            jour[3] = String.valueOf(restLength);
                            jour[4] = "0";
                            jour[5] = String.valueOf(restLength);
                            this.dayTable.add(jour);
                            this.restType.add(false);
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    System.err.println("#DailyRest.findFirstRest# unable to find TypeActivite " + activite.getCleType());
                    if (Transport.debug < 1) break block7;
                    ex.printStackTrace();
                }
            }
            ++index;
        }
        return index;
    }

    public void calculReposJour(int x) {
        TimsLogger.verbose("#DailyRest.calculReposJour# new day (" + x + ") on " + this.indexActiviteCourante);
        try {
            boolean DE = false;
            int maxRestAfterRestDay = 0;
            int dureeReposJourMax = 0;
            int prochaineJournee = 0;
            int totalRest = 0;
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            int heureFin = activite.getHeureDebut();
            String[] jour = new String[6];
            String dateLimite = ConversionTime.addDay(activite.getDateJour(), "yyyy-MM-dd", 1);
            jour[0] = activite.getDateJour();
            jour[1] = String.valueOf(heureFin);
            jour[2] = dateLimite;
            TimsLogger.verbose("#DailyRest.calculReposJour# from " + activite.getDateJour() + " (" + heureFin + ") to " + dateLimite);
            while (this.indexActiviteCourante < this.activities.size() - 1) {
                if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                    int begin;
                    int z;
                    if (prochaineJournee == 0 && (z = this.findNextRest(begin = this.indexActiviteCourante, false)) != -1) {
                        prochaineJournee = z;
                    }
                    int repos = this.restLength(heureFin, dateLimite);
                    totalRest = this.restLength(this.indexActiviteCourante);
                    if (repos > dureeReposJourMax) {
                        maxRestAfterRestDay = dureeReposJourMax;
                        dureeReposJourMax = repos;
                    }
                }
                if (this.indexActiviteCourante >= this.activities.size() - 1) break;
                activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
                if (activite.getDescription().equals("DOUBLE EQUIPAGE") && !DE) {
                    dateLimite = ConversionTime.addHeureBDD(dateLimite, heureFin / 60 + this.crewRestPeriod / 60 - 24);
                    heureFin = (heureFin + (this.crewRestPeriod - 1440)) % 1440;
                    DE = true;
                    TimsLogger.verbose("#DailyRest.calculReposJour# DE from " + activite.getDateJour() + " (" + heureFin + ") to " + dateLimite);
                }
                if (activite.getDateJour().substring(0, 10).compareTo(dateLimite) >= 0 && (activite.getHeureFin() >= heureFin || activite.getDateJour().substring(0, 10).compareTo(dateLimite) > 0)) {
                    TimsLogger.verbose("#DailyRest.calculReposJour# breaking (after limit)" + dateLimite + " (" + heureFin + ")");
                    break;
                }
                ++this.indexActiviteCourante;
                activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            }
            if (this.indexActiviteCourante < this.activities.size() - 1) {
                jour[3] = String.valueOf(dureeReposJourMax);
                jour[4] = String.valueOf(maxRestAfterRestDay);
                jour[5] = String.valueOf(totalRest);
                this.dayTable.add(jour);
                this.restType.add(DE);
                if (prochaineJournee == 0) {
                    this.findNextRest(this.indexActiviteCourante, true);
                } else {
                    this.indexActiviteCourante = prochaineJournee;
                }
            }
            if (this.indexActiviteCourante < this.activities.size() - 1) {
                this.calculReposJour(x + 1);
            } else {
                this.checkOffence();
            }
        }
        catch (Exception e) {
            TimsLogger.warn("#DailyRest.calculReposJour# erreur on indexActiviteCourante = " + this.indexActiviteCourante + ", activities.size() = " + this.activities.size());
            e.printStackTrace();
        }
    }

    public void checkOffence() {
        int k = 0;
        while (k < this.dayTable.size()) {
            Object[] jour = this.dayTable.get(k);
            TimsLogger.debug("#DailyRest.checkOffence# " + Arrays.toString(jour));
            ++k;
        }
        int nbJoursTolere = 0;
        int k2 = 0;
        while (k2 < this.dayTable.size()) {
            int cost;
            int type;
            String[] jour = this.dayTable.get(k2);
            int maxRest = Integer.parseInt(jour[3]);
            if (this.restType.get(k2).booleanValue()) {
                if (Integer.parseInt(jour[3]) < this.crewMinor.getThreshold()) {
                    type = 1;
                    cost = 0;
                    if (maxRest < this.crewVerySerious.getThreshold()) {
                        cost = this.crewVerySerious.getInfrigement();
                        type = 3;
                    } else if (maxRest < this.crewSerious.getThreshold()) {
                        cost = this.crewSerious.getInfrigement();
                        type = 2;
                    } else {
                        cost = this.crewMinor.getInfrigement();
                    }
                    TimsLogger.verbose("#DailyRest.checkOffence() add offence => " + jour[0] + " : " + Integer.parseInt(jour[1]));
                    this.parent.addInfraction(jour[0], Integer.parseInt(jour[1]), this.getOffencePart("offence.crew").getId(), maxRest, type, cost);
                }
            } else if (maxRest < this.minor.getThreshold()) {
                if (Integer.parseInt(jour[4]) >= this.leftRest && maxRest >= this.splittedMinor.getThreshold()) {
                    TimsLogger.verbose("#DailyRest.checkOffence# on a un repos fractionn\u00e9 le " + jour[0]);
                } else if (maxRest >= this.reducedMinor.getThreshold() || nbJoursTolere >= this.reducedDayCount) {
                    TimsLogger.verbose("#DailyRest.checkOffence# RJT++ la " + jour[0]);
                    if (++nbJoursTolere >= this.reducedDayCount + 1) {
                        type = 1;
                        if (maxRest < this.verySerious.getThreshold()) {
                            type = 3;
                            cost = this.verySerious.getInfrigement();
                        } else if (maxRest < this.serious.getThreshold()) {
                            type = 2;
                            cost = this.serious.getInfrigement();
                        } else {
                            cost = this.minor.getInfrigement();
                        }
                        TimsLogger.verbose("#DailyRest.checkOffence# offence tolered on " + jour[0]);
                        this.parent.addInfraction(jour[0], Integer.parseInt(jour[1]), this.getOffencePart("offence.dr.unreduced").getId(), maxRest, type, cost);
                    }
                } else {
                    ++nbJoursTolere;
                    type = 1;
                    cost = 0;
                    if (maxRest < this.reducedVerySerious.getThreshold()) {
                        cost = this.reducedVerySerious.getInfrigement();
                        type = 3;
                    } else if (maxRest < this.reducedSerious.getThreshold()) {
                        cost = this.reducedSerious.getInfrigement();
                        type = 2;
                    } else {
                        cost = this.minor.getInfrigement();
                    }
                    TimsLogger.verbose("#DailyRest.checkOffence() add offence => " + jour[0] + " : " + Integer.parseInt(jour[1]));
                    this.parent.addInfraction(jour[0], Integer.parseInt(jour[1]), this.getOffencePart("offence.dr.reduced").getId(), maxRest, type, cost);
                }
            }
            if (Integer.parseInt(jour[5]) > this.reducedWeek) {
                TimsLogger.verbose("#DailyRest.checkOffence# on remet \u00e0 0 le " + jour[0] + " (" + jour[5] + ")");
                nbJoursTolere = 0;
            } else {
                TimsLogger.verbose("#DailyRest.checkOffence# on ne remet pas \u00e0 0 le " + jour[0] + " (" + jour[5] + ")");
            }
            ++k2;
        }
    }
}

