/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.exception.ActivityTypeNotFoundException;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Fonctions;
import transport.offence.MasterOffence;

public class DailyWork
extends MasterOffence {
    private OffenceThreshold minor = null;
    private OffenceThreshold minorReduced = null;
    private int begin = 0;
    private int end = 0;
    private int indexActiviteCourante = 0;

    @Override
    public void process() throws Exception {
        this.minor = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.minor");
        this.minorReduced = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.minor");
        this.begin = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.begin").getThreshold();
        this.end = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.end").getThreshold();
        TimsLogger.debug("#DailyWork.process()# Seeking DailyWork offence minor=" + this.minor + " minorReduced=" + this.minorReduced + " begin=" + this.begin + " end=" + this.end);
        this.findFirstRest();
        this.dayProcess();
    }

    public int restLength() throws ActivityTypeNotFoundException {
        int restLength = 0;
        TypeActivite act = null;
        while (this.indexActiviteCourante <= this.activities.size() - 1) {
            try {
                act = TypeActivite.getActivityType(((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).getCleType());
                if (act == null) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                System.err.println("#DailyWork.process# unable to find TypeActivite " + ((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).getCleType());
                if (Transport.debug < 1) break;
                ex.printStackTrace();
                break;
            }
            if (!act.isRest()) break;
            restLength += ((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).getDuree();
            ++this.indexActiviteCourante;
        }
        return restLength;
    }

    public void findFirstRest() throws Exception {
        while (this.indexActiviteCourante < this.activities.size()) {
            block5: {
                ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
                TypeActivite act = null;
                try {
                    act = TypeActivite.getActivityType(activite.getCleType());
                    if (act == null) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    System.err.println("#DailyWork.process# unable to find TypeActivite " + activite.getCleType());
                    if (Transport.debug >= 1) {
                        ex.printStackTrace();
                    }
                    break block5;
                }
                if (act.isRest() && this.restLength() > DAILY_REST_THRESHOLD) break;
            }
            ++this.indexActiviteCourante;
        }
    }

    public void dayProcess() throws Exception {
        String sJour = "";
        int workTime = 0;
        int hour = 0;
        boolean initialized = false;
        boolean reduced = false;
        while (this.indexActiviteCourante < this.activities.size()) {
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            TypeActivite ta = TypeActivite.getActivityType(activite.getCleType());
            if (ta.getPaidPercentage() != 0) {
                if (!initialized) {
                    sJour = activite.getDateJour();
                    hour = activite.getHeureDebut();
                    TimsLogger.debug("#DailWork.dayProcess()# begin " + this.begin + " ");
                    initialized = true;
                }
                TimsLogger.debug("+" + activite.getDuree());
                if (!reduced) {
                    if (this.begin < this.end && Fonctions.getTimeBetween(activite, this.begin, this.end) != 0 || this.driver.isNightWorker()) {
                        reduced = true;
                    } else if (Fonctions.getTimeBetween(activite, 1440, this.end) + Fonctions.getTimeBetween(activite, 0, this.end) != 0) {
                        reduced = true;
                    }
                }
                workTime += activite.getDuree();
            }
            if (ta.isRest()) {
                int repos = this.restLength();
                if (repos >= DAILY_REST_THRESHOLD || this.indexActiviteCourante == this.activities.size() - 1) {
                    if (reduced && workTime > this.minorReduced.getThreshold()) {
                        this.parent.addInfraction(sJour, hour, this.getOffencePart("offence.reduced").getId(), workTime, 1, this.minorReduced.getInfrigement());
                    } else if (workTime > this.minor.getThreshold()) {
                        this.parent.addInfraction(sJour, hour, this.getOffencePart("offence.basic").getId(), workTime, 1, this.minor.getInfrigement());
                    }
                    workTime = 0;
                    initialized = false;
                    reduced = false;
                    TimsLogger.debug("#dailyWork#end " + sJour);
                }
                if (this.indexActiviteCourante <= this.activities.size() - 1) {
                    --this.indexActiviteCourante;
                }
            }
            ++this.indexActiviteCourante;
        }
    }
}

