/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.exception.ActivityTypeNotFoundException;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Fonctions;
import transport.offence.MasterOffence;

public class DailyWorkR
extends MasterOffence {
    private OffenceThreshold minor = null;
    private int indexActiviteCourante = 0;
    Vector<Integer> work = null;
    Vector<String> date = null;
    Vector<Integer> hours = null;

    @Override
    public void process() throws Exception {
        this.minor = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.minor");
        System.err.println("#DailyWork.process# findFirstRest ");
        this.findFirstRest();
        System.err.println("#DailyWork.process# dayProcess");
        this.dayProcess();
        System.err.println("#DailyWork.process# dayProcess");
        this.checkOffence();
    }

    public int restLength() throws ActivityTypeNotFoundException {
        int restLength = 0;
        TypeActivite act = null;
        while (this.indexActiviteCourante <= this.activities.size() - 1) {
            try {
                act = TypeActivite.getActivityType(((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).getCleType());
                if (act == null) {
                    throw new Exception();
                }
            }
            catch (Exception ex) {
                System.err.println("#DailyWork.process# unable to find TypeActivite " + ((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).getCleType());
                if (Transport.debug < 1) break;
                ex.printStackTrace();
                break;
            }
            if (!act.isRest()) break;
            restLength += ((ActiviteConducteur)this.activities.get(this.indexActiviteCourante)).getDuree();
            ++this.indexActiviteCourante;
        }
        return restLength;
    }

    public void findFirstRest() throws Exception {
        while (this.indexActiviteCourante < this.activities.size()) {
            block5: {
                ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
                TypeActivite act = null;
                try {
                    act = TypeActivite.getActivityType(activite.getCleType());
                    if (act == null) {
                        throw new Exception();
                    }
                }
                catch (Exception ex) {
                    System.err.println("#DailyWork.process# unable to find TypeActivite " + activite.getCleType());
                    if (Transport.debug >= 1) {
                        ex.printStackTrace();
                    }
                    break block5;
                }
                if (act.isRest() && this.restLength() > DAILY_REST_THRESHOLD) break;
            }
            ++this.indexActiviteCourante;
        }
    }

    public void dayProcess() throws Exception {
        this.work = new Vector();
        this.date = new Vector();
        this.hours = new Vector();
        String sJour = "";
        int workTime = 0;
        int hour = 0;
        boolean initialized = false;
        while (this.indexActiviteCourante < this.activities.size()) {
            int repos;
            ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(this.indexActiviteCourante);
            TypeActivite ta = TypeActivite.getActivityType(activite.getCleType());
            if (ta.getPaidPercentage() != 0) {
                if (!initialized) {
                    sJour = activite.getDateJour();
                    hour = activite.getHeureDebut();
                    initialized = true;
                }
                workTime += activite.getDuree();
            }
            if (ta.isRest() && ((repos = this.restLength()) >= DAILY_REST_THRESHOLD || this.indexActiviteCourante == this.activities.size() - 1)) {
                this.work.add(workTime);
                this.date.add(sJour);
                this.hours.add(hour);
                workTime = 0;
                initialized = false;
            }
            ++this.indexActiviteCourante;
        }
    }

    public void checkOffence() throws Exception {
        int i = 0;
        while (i < this.date.size()) {
            String day = this.date.get(i);
            int tempsTotalTE = this.work.get(i);
            int hour = this.hours.get(i);
            TimsLogger.debug("#DailyWork.checkOffence# " + day + " " + hour + "==> total worked = " + tempsTotalTE);
            if (tempsTotalTE > this.minor.getThreshold()) {
                TimsLogger.verbose("#DailyWork.checkOffence() add offence => " + day + " : " + hour);
                this.parent.addInfraction(day, hour, this.getOffencePart("offence.basic").getId(), tempsTotalTE, 1, this.minor.getInfrigement());
            }
            ++i;
        }
    }
}

