/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transport.offence.CalculInfractionPrincipal;

public class InfractionJournaliere {
    private int ConduiteJournaliereMax = 0;
    private int ConduiteJournaliereTolere = 0;
    private int JourTolere = 0;
    private int TEJournaliereMax = 0;
    private int TEJournaliereTolere = 0;
    private int TEJourTolere = 0;
    private int TELimite1 = 0;
    private int ReposMini1 = 0;
    private int TELimite2 = 0;
    private int ReposMini2 = 0;
    private int coupureMiniTE = 0;
    private int seuilReposAucunJournalier = 540;
    private Vector<ActiviteConducteur> calculActivite;
    private int indexActiviteCourante = 0;
    Vector<Integer> duree = null;
    Vector<Integer> coupure = null;
    Vector<Integer> dureeTE = null;
    Vector<String> jour = null;
    Vector<String> heure = null;
    private CalculInfractionPrincipal pere = null;

    public InfractionJournaliere(CalculInfractionPrincipal source) {
        this.recupererSeuil();
        this.pere = source;
    }

    public InfractionJournaliere(Vector<ActiviteConducteur> act, CalculInfractionPrincipal source) {
        this.recupererSeuil();
        this.pere = source;
        this.calculActivite = act;
    }

    public void setActiviteConducteur(Vector<ActiviteConducteur> act) {
        this.indexActiviteCourante = 0;
        this.calculActivite = act;
    }

    public void recupererSeuil() {
        try {
            Vector<Integer> seuilsConduiteJournaliere = Transport.bdd.getSeuilConduiteJournaliere();
            this.ConduiteJournaliereMax = seuilsConduiteJournaliere.get(0);
            this.ConduiteJournaliereTolere = seuilsConduiteJournaliere.get(1);
            this.JourTolere = seuilsConduiteJournaliere.get(2);
            Vector<Integer> seuilsTEJournalier = Transport.bdd.getSeuilTEJournalier();
            this.TEJournaliereMax = seuilsTEJournalier.get(0);
            this.TEJournaliereTolere = seuilsTEJournalier.get(1);
            this.TEJourTolere = seuilsTEJournalier.get(2);
            Vector<Integer> seuilsReposTEJournalier = Transport.bdd.getSeuilTEContinu();
            this.TELimite1 = seuilsReposTEJournalier.get(0);
            this.ReposMini1 = seuilsReposTEJournalier.get(1);
            this.TELimite2 = seuilsReposTEJournalier.get(2);
            this.ReposMini2 = seuilsReposTEJournalier.get(3);
            this.coupureMiniTE = seuilsReposTEJournalier.get(4);
        }
        catch (Exception ex) {
            System.err.println("Impossible de r\u00e9cup\u00e9rer les seuils de l'infraction (Conduite journali\u00e8re/hebdo).");
        }
        TimsLogger.debug("Conduite max :" + this.ConduiteJournaliereMax);
        TimsLogger.debug("Conduite tolere :" + this.ConduiteJournaliereTolere);
        TimsLogger.debug("Jours max :" + this.JourTolere);
    }

    public int tempsRepos() {
        int dureeRepos = 0;
        ActiviteConducteur activite = this.calculActivite.get(this.indexActiviteCourante);
        while ((activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) && this.indexActiviteCourante < this.calculActivite.size() - 1) {
            dureeRepos += activite.getDuree();
            ++this.indexActiviteCourante;
            activite = this.calculActivite.get(this.indexActiviteCourante);
        }
        if (this.indexActiviteCourante == this.calculActivite.size() - 1 && (activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU"))) {
            dureeRepos += activite.getDuree();
        } else {
            --this.indexActiviteCourante;
        }
        return dureeRepos;
    }

    public void trouverDebut() throws Exception {
        while (this.indexActiviteCourante < this.calculActivite.size()) {
            ActiviteConducteur activite = this.calculActivite.get(this.indexActiviteCourante);
            if ((activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) && this.tempsRepos() > this.seuilReposAucunJournalier) {
                activite = this.calculActivite.get(this.indexActiviteCourante);
                ++this.indexActiviteCourante;
                break;
            }
            ++this.indexActiviteCourante;
        }
        this.calculJour();
        this.calculInfraction();
    }

    public void calculJour() throws Exception {
        this.duree = new Vector();
        this.coupure = new Vector();
        this.dureeTE = new Vector();
        this.jour = new Vector();
        this.heure = new Vector();
        String sJour = "";
        String sHeure = "";
        int dureeConduite = 0;
        int dureeCTD = 0;
        int dureeCoupure = 0;
        while (this.indexActiviteCourante < this.calculActivite.size()) {
            ActiviteConducteur activite = this.calculActivite.get(this.indexActiviteCourante);
            if (activite.getDescription().equals("CONDUITE")) {
                if (dureeCTD == 0) {
                    sJour = activite.getDateJour();
                    sHeure = String.valueOf(activite.getHeureDebut());
                }
                dureeConduite += activite.getDuree();
                dureeCTD += activite.getDuree();
            }
            if (activite.getDescription().equals("TRAVAIL") || activite.getDescription().equals("DISPO") || activite.getDescription().equals("DOUBLE EQUIPAGE")) {
                if (dureeCTD == 0) {
                    sJour = activite.getDateJour();
                    sHeure = String.valueOf(activite.getHeureDebut());
                }
                dureeCTD += activite.getDuree();
            }
            if (activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) {
                int repos = this.tempsRepos();
                if (repos >= this.seuilReposAucunJournalier || this.indexActiviteCourante == this.calculActivite.size() - 1) {
                    this.duree.add(dureeConduite);
                    this.dureeTE.add(dureeCTD);
                    this.coupure.add(dureeCoupure);
                    this.jour.add(sJour);
                    this.heure.add(sHeure);
                    dureeCoupure = 0;
                    dureeConduite = 0;
                    dureeCTD = 0;
                } else if (repos >= this.coupureMiniTE) {
                    dureeCoupure += repos;
                }
            }
            ++this.indexActiviteCourante;
        }
    }

    public void calculInfraction() throws Exception {
        int nbJoursTolere = 0;
        int semaineEnCours = 0;
        int i = 0;
        while (i < this.duree.size()) {
            String libelleJour = this.jour.get(i);
            int tempsTotalConduite = this.duree.get(i);
            int coupureCTD = this.coupure.get(i);
            int tempsTotalTE = this.dureeTE.get(i);
            String libelleHeure = this.heure.get(i);
            TimsLogger.debug(String.valueOf(libelleJour) + " " + libelleHeure + "==> CT = " + tempsTotalConduite + ", TE = " + tempsTotalTE);
            int semaine = ConversionTime.getWeek(libelleJour, "yyyy-MM-dd");
            if (semaine != semaineEnCours) {
                semaineEnCours = semaine;
                nbJoursTolere = 0;
            }
            if (tempsTotalConduite > this.ConduiteJournaliereMax) {
                TimsLogger.debug(String.valueOf(nbJoursTolere) + " : " + this.JourTolere);
                ++nbJoursTolere;
            }
            if (tempsTotalTE <= this.TELimite1 || tempsTotalTE < this.TELimite2) {
                // empty if block
            }
            if (tempsTotalTE > this.TELimite2) {
                // empty if block
            }
            ++i;
        }
    }
}

