/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import java.util.Hashtable;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transport.offence.CalculInfractionPrincipal;

public class ReposJournalier {
    private int ReposJournalierMin = 0;
    private int ReposJournalierTolere = 0;
    private int JourTolere = 0;
    private int ReposFractionneTotal = 0;
    private int ReposFractionneConsecutif = 0;
    private int ReposFractionnePeriode = 0;
    private int ReposFractionneNbPeriode = 0;
    private int ReposJournalierDEMin = 0;
    private int AmplitudeDE = 0;
    private int indexActiviteCourante = 0;
    private int nbAct;
    private Vector<ActiviteConducteur> calculActivite;
    private Hashtable<String, String[]> tableauJour;
    private Hashtable<String, Boolean> typeRepos;
    private CalculInfractionPrincipal pere = null;

    public ReposJournalier(CalculInfractionPrincipal source) {
        this.recupererSeuil();
        this.pere = source;
    }

    public ReposJournalier(Vector<ActiviteConducteur> act, CalculInfractionPrincipal source) {
        this.recupererSeuil();
        this.pere = source;
        this.calculActivite = act;
        this.nbAct = this.calculActivite.size();
        this.tableauJour = new Hashtable();
        this.typeRepos = new Hashtable();
    }

    public void setActiviteConducteur(Vector<ActiviteConducteur> act) {
        this.indexActiviteCourante = 0;
        this.calculActivite = act;
        this.nbAct = this.calculActivite.size();
        this.tableauJour = new Hashtable();
        this.typeRepos = new Hashtable();
    }

    public void recupererSeuil() {
        try {
            Vector<Integer> seuils = Transport.bdd.getSeuilReposJournalier();
            this.ReposJournalierMin = seuils.get(0);
            this.ReposJournalierTolere = seuils.get(1);
            this.JourTolere = seuils.get(2);
            this.ReposFractionneTotal = seuils.get(3);
            this.ReposFractionneConsecutif = seuils.get(4);
            this.ReposFractionnePeriode = this.ReposFractionneTotal - this.ReposFractionneConsecutif;
            this.ReposFractionneNbPeriode = seuils.get(5);
            seuils = Transport.bdd.getSeuilReposJournalierDE();
            this.ReposJournalierDEMin = seuils.get(0);
            this.AmplitudeDE = seuils.get(1);
        }
        catch (Exception ex) {
            TimsLogger.warn("Impossible de r\u00e9cup\u00e9rer les seuils de l'infraction (Repos journalier).");
        }
    }

    public String typeRepos() {
        int dureeRepos = 0;
        ActiviteConducteur activite = this.calculActivite.get(this.indexActiviteCourante);
        while ((activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) && this.indexActiviteCourante < this.calculActivite.size() - 1) {
            dureeRepos += activite.getDuree();
            ++this.indexActiviteCourante;
            activite = this.calculActivite.get(this.indexActiviteCourante);
        }
        if (this.indexActiviteCourante == this.calculActivite.size() - 1 && (activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU"))) {
            dureeRepos += activite.getDuree();
        }
        if (dureeRepos > 420 && dureeRepos <= 2880) {
            return "journalier";
        }
        if (dureeRepos > 2880) {
            return "hebdomadaire";
        }
        return "rien";
    }

    public int typeReposIndex() {
        int dureeRepos = 0;
        int index = this.indexActiviteCourante;
        ActiviteConducteur activite = this.calculActivite.get(index);
        try {
            while ((activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) && index < this.calculActivite.size() - 1) {
                dureeRepos += activite.getDuree();
                activite = this.calculActivite.get(++index);
            }
            if (index == this.calculActivite.size() - 1 && (activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU"))) {
                dureeRepos += activite.getDuree();
            }
            if (dureeRepos > 420) {
                return index;
            }
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int tempsRepos(int heureFin, String date) {
        int dureeRepos = 0;
        ActiviteConducteur activite = this.calculActivite.get(this.indexActiviteCourante);
        try {
            while ((activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) && this.indexActiviteCourante < this.calculActivite.size() - 1) {
                if (activite.getHeureFin() > heureFin && activite.getDateJour().substring(0, 10).equals(date)) {
                    return dureeRepos += heureFin - activite.getHeureDebut();
                }
                dureeRepos += activite.getDuree();
                ++this.indexActiviteCourante;
                activite = this.calculActivite.get(this.indexActiviteCourante);
            }
            if (this.indexActiviteCourante == this.calculActivite.size() - 1 && (activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU"))) {
                dureeRepos += activite.getDuree();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dureeRepos;
    }

    public void trouverDebut() throws Exception {
        while (this.indexActiviteCourante < this.nbAct) {
            String repos;
            ActiviteConducteur activite = this.calculActivite.get(this.indexActiviteCourante);
            if ((activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) && ((repos = this.typeRepos()).equals("journalier") || repos.equals("hebdomadaire"))) {
                activite = this.calculActivite.get(this.indexActiviteCourante);
                break;
            }
            ++this.indexActiviteCourante;
        }
        if (this.indexActiviteCourante != this.nbAct) {
            this.calculReposJour(0);
        }
    }

    public void calculReposJour(int x) throws Exception {
        boolean DE = false;
        int dureeReposJour = 0;
        int dureeReposJourMax = 0;
        int prochaineJournee = 0;
        ActiviteConducteur activite = this.calculActivite.get(this.indexActiviteCourante);
        int heureFin = activite.getHeureDebut();
        String[] jour = new String[5];
        String dateLimite = ConversionTime.addDay(activite.getDateJour(), "yyyy-MM-dd", 1);
        jour[0] = activite.getDateJour();
        jour[1] = String.valueOf(heureFin);
        jour[2] = dateLimite;
        while (this.indexActiviteCourante < this.nbAct - 1) {
            try {
                if (activite.getDescription().equals("DOUBLE EQUIPAGE") && !DE) {
                    dateLimite = ConversionTime.addHeureBDD(dateLimite, heureFin / 60 + this.AmplitudeDE / 60 - 24);
                    heureFin = (heureFin + (this.AmplitudeDE - 1440)) % 1440;
                    DE = true;
                }
                if (activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) {
                    int repos;
                    int z;
                    if (prochaineJournee == 0 && (z = this.typeReposIndex()) != -1) {
                        prochaineJournee = z;
                    }
                    if ((repos = this.tempsRepos(heureFin, dateLimite)) > dureeReposJourMax) {
                        dureeReposJourMax = repos;
                    } else if (repos > 180) {
                        dureeReposJour += repos;
                    }
                }
                if ((activite = this.calculActivite.get(this.indexActiviteCourante)).getDateJour().substring(0, 10).compareTo(dateLimite) >= 0 && (activite.getHeureFin() >= heureFin || activite.getDateJour().substring(0, 10).compareTo(dateLimite) > 0)) break;
                ++this.indexActiviteCourante;
                if (this.indexActiviteCourante >= this.nbAct) continue;
                activite = this.calculActivite.get(this.indexActiviteCourante);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.indexActiviteCourante < this.nbAct - 1) {
            jour[3] = String.valueOf(dureeReposJourMax);
            jour[4] = String.valueOf(dureeReposJour);
            this.tableauJour.put(String.valueOf(x), jour);
            this.typeRepos.put(String.valueOf(x), DE);
            if (prochaineJournee == 0) {
                this.trouverProchainDebutService();
            } else {
                this.indexActiviteCourante = prochaineJournee;
            }
        }
        if (this.indexActiviteCourante < this.nbAct - 1) {
            this.calculReposJour(x + 1);
        } else {
            this.analyseTemps();
        }
    }

    public void trouverProchainDebutService() throws Exception {
        while (this.indexActiviteCourante < this.nbAct) {
            ActiviteConducteur activite = this.calculActivite.get(this.indexActiviteCourante);
            if ((activite.getDescription().equals("REPOS") || activite.getDescription().equals("INCONNU")) && this.typeRepos().equals("journalier")) break;
            ++this.indexActiviteCourante;
        }
    }

    public void analyseTemps() throws Exception {
        TimsLogger.debug("seuil : RJM " + this.ReposJournalierMin + " :: " + "RJT " + this.ReposJournalierTolere + " :: " + "RJFC " + this.ReposFractionneConsecutif + " :: " + "RFP " + this.ReposFractionnePeriode);
        int nbJoursTolere = 0;
        int semaineEnCours = 0;
        int k = 0;
        while (k < this.tableauJour.size()) {
            String[] jour = this.tableauJour.get(String.valueOf(k));
            int semaine = ConversionTime.getWeek(jour[0], "yyyy-MM-dd");
            if (semaine != semaineEnCours) {
                semaineEnCours = semaine;
                nbJoursTolere = 0;
            }
            if (this.typeRepos.get(String.valueOf(k)).booleanValue()) {
                Integer.parseInt(jour[3]);
            } else if (Integer.parseInt(jour[3]) >= this.ReposJournalierTolere && Integer.parseInt(jour[3]) < this.ReposJournalierMin && (Integer.parseInt(jour[3]) >= this.ReposFractionneConsecutif || Integer.parseInt(jour[4]) < this.ReposFractionnePeriode)) {
                TimsLogger.debug("RJT++");
                if (++nbJoursTolere == this.JourTolere + 1) {
                    TimsLogger.debug("infraction RJT");
                }
            }
            ++k;
        }
    }
}

