/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.TypeActivite;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.Fonctions;
import transport.offence.MasterOffence;

public class WeeklyRest
extends MasterOffence {
    private OffenceThreshold minor = null;
    private OffenceThreshold serious = null;
    private OffenceThreshold verySerious = null;
    private OffenceThreshold reducedMinor = null;
    private OffenceThreshold reducedSerious = null;
    private OffenceThreshold reducedVerySerious = null;

    @Override
    public void process() {
        this.minor = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.minor");
        this.serious = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.serious");
        this.verySerious = Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.verySerious");
        this.reducedMinor = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.minor");
        this.reducedSerious = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.serious");
        this.reducedVerySerious = Fonctions.getOffenceThreshold(this.offence, "offence.reduced", "offence.threshold.verySerious");
        if (this.minor == null || this.reducedMinor == null) {
            System.err.println("#WeeklyRest.process# unable to retrieve threshold");
            return;
        }
        int x = 0;
        while (x < this.activities.size()) {
            block7: {
                ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(x);
                try {
                    if (TypeActivite.getActivityType(activite.getCleType()).isRest()) {
                        if (this.getRestType(this.restLength(x)) == 3) break;
                        x = this.endRestIndex(x);
                    }
                }
                catch (Exception ex) {
                    System.err.println("#WeeklyRest.process# unable to fin TypeActivite " + activite.getCleType());
                    if (Transport.debug < 1) break block7;
                    ex.printStackTrace();
                }
            }
            ++x;
        }
        if (x >= this.activities.size() - 1) {
            TimsLogger.debug("#WeeklyRest.process# Aucune p\u00e9riode de repos hebdomadaire n'a \u00e9t\u00e9 trouv\u00e9");
        } else {
            TimsLogger.debug("#WeeklyRest.process# start at " + ((ActiviteConducteur)this.activities.get(x)).getDateJour() + " " + ((ActiviteConducteur)this.activities.get(x)).getHeureDebut());
            this.checkOffense(x);
        }
    }

    public void checkOffense(int offsetWeeklyRestBegin) {
        if (offsetWeeklyRestBegin >= this.activities.size()) {
            TimsLogger.debug("#WeeklyRest.checkOffense()# On est apr\u00e8s la derni\u00e8re activit\u00e9, c'est pas logique tout ca.... ");
            return;
        }
        boolean isReduct = false;
        int weeklyRest = this.restLength(offsetWeeklyRestBegin);
        int nbAct = this.activities.size();
        if (Transport.debug >= 1) {
            TimsLogger.debug("#WeeklyRest.checkOffense()# new RH at " + ((ActiviteConducteur)this.activities.get(offsetWeeklyRestBegin)).getDateJour() + " " + ConversionTime.heureIntToString(((ActiviteConducteur)this.activities.get(offsetWeeklyRestBegin)).getHeureDebut(), "h") + " (" + offsetWeeklyRestBegin + ") = " + weeklyRest);
        }
        if ((offsetWeeklyRestBegin = this.endRestIndex(offsetWeeklyRestBegin)) >= this.activities.size()) {
            TimsLogger.debug("#WeeklyRest.checkOffense()# On fini par un repos hebdo.... ");
            return;
        }
        ActiviteConducteur activity = (ActiviteConducteur)this.activities.get(offsetWeeklyRestBegin);
        String dateDebut = activity.getDateJour();
        String dateLimite = ConversionTime.addDay(activity.getDateJour(), "yyyy-MM-dd", 6);
        int heureLimite = activity.getHeureDebut();
        activity = (ActiviteConducteur)this.activities.get(offsetWeeklyRestBegin);
        if (weeklyRest < this.minor.getThreshold()) {
            TimsLogger.debug("#WeeklyRest.checkOffense()# Repos r\u00e9duit");
            isReduct = true;
        }
        int maxWeeklyRest = 0;
        int offsetMaxWeeklyRest = 0;
        TimsLogger.debug("#WeeklyRest.checkOffense()# On calcul le prochain RH \u00e0 partir de (" + offsetWeeklyRestBegin + ") " + dateDebut + " " + heureLimite + "jusqu'\u00e0 " + dateLimite);
        while (offsetWeeklyRestBegin < nbAct - 1) {
            try {
                int type;
                if (TypeActivite.getActivityType(activity.getCleType()).isRest()) {
                    int rest = this.restLength(offsetWeeklyRestBegin);
                    TimsLogger.debug("#WeeklyRest.checkOffense()# Rest detected on " + activity.getDateJour() + " " + activity.getHeureDebut() + " length = " + rest + ". Replace ? " + (rest > maxWeeklyRest) + " || " + (this.getRestType(rest) >= 2) + " && " + (this.getRestType(rest) == maxWeeklyRest));
                    if (rest > maxWeeklyRest || this.getRestType(rest) >= 2 && this.getRestType(rest) == this.getRestType(maxWeeklyRest)) {
                        maxWeeklyRest = rest;
                        offsetMaxWeeklyRest = offsetWeeklyRestBegin;
                    }
                    offsetWeeklyRestBegin = this.endRestIndex(offsetWeeklyRestBegin);
                } else {
                    ++offsetWeeklyRestBegin;
                }
                if (offsetWeeklyRestBegin >= nbAct) {
                    TimsLogger.debug("#WeeklyRest.checkOffense()# Last activity reached. stop calculation");
                    return;
                }
                activity = (ActiviteConducteur)this.activities.get(offsetWeeklyRestBegin);
                if (activity.getDateJour().substring(0, 10).compareTo(dateLimite) < 0 || activity.getHeureDebut() <= heureLimite && activity.getDateJour().substring(0, 10).compareTo(dateLimite) <= 0) continue;
                TimsLogger.debug("#WeeklyRest.checkOffense()# End period : on est au " + activity.getDateJour() + " " + activity.getHeureDebut() + " maxRest = " + maxWeeklyRest + " since " + ((ActiviteConducteur)this.activities.get(offsetMaxWeeklyRest)).getDateJour() + " " + ((ActiviteConducteur)this.activities.get(offsetMaxWeeklyRest)).getHeureDebut() + " : offsetWeeklyRestBegin = " + offsetWeeklyRestBegin + " of " + nbAct);
                if (this.getRestType(maxWeeklyRest) != 3 && this.getRestType(maxWeeklyRest) != 2) {
                    type = 1;
                    int cost = this.minor.getInfrigement();
                    if (maxWeeklyRest > this.verySerious.getThreshold()) {
                        cost = this.verySerious.getInfrigement();
                        type = 3;
                    } else if (maxWeeklyRest > this.serious.getThreshold()) {
                        cost = this.serious.getInfrigement();
                        type = 2;
                    }
                    TimsLogger.verbose("#WeeklyRest.checkOffence() add offence => " + activity.getDateJour() + " : " + activity.getHeureDebut());
                    this.parent.addInfraction(activity.getDateJour(), activity.getHeureDebut(), this.getOffencePart("offence.basic").getId(), maxWeeklyRest, type, cost);
                    offsetMaxWeeklyRest = this.findNextWeeklyRest(offsetWeeklyRestBegin);
                    TimsLogger.debug("#WeeklyRest.checkOffense()# NO RH FOUND. GENERATING INFRACTION. RESTART AT NEW RH ON " + offsetMaxWeeklyRest);
                    if (offsetMaxWeeklyRest >= nbAct) {
                        TimsLogger.debug("#WeeklyRest.checkOffense()# Last activity reached. no new RH after infraction. stop calculation");
                        return;
                    }
                } else if (isReduct && this.getRestType(maxWeeklyRest) == 2) {
                    TimsLogger.debug("#WeeklyRest.checkOffense()# 2 REDUCED RH FOUND. GENERATING INFRACTION");
                    type = 1;
                    int cost = this.reducedMinor.getInfrigement();
                    if (maxWeeklyRest > this.reducedVerySerious.getThreshold()) {
                        cost = this.reducedVerySerious.getInfrigement();
                        type = 3;
                    }
                    if (maxWeeklyRest > this.reducedSerious.getThreshold()) {
                        cost = this.reducedSerious.getInfrigement();
                        type = 2;
                    }
                    TimsLogger.verbose("#WeeklyRest.checkOffence() add offence => " + activity.getDateJour() + " : " + activity.getHeureDebut());
                    this.parent.addInfraction(activity.getDateJour(), activity.getHeureDebut(), this.getOffencePart("offence.reduced").getId(), maxWeeklyRest, type, cost);
                }
                TimsLogger.debug("#WeeklyRest.checkOffense()# on lance un nouveau calcul \u00e0 l'offset " + offsetMaxWeeklyRest);
                this.checkOffense(offsetMaxWeeklyRest);
                return;
            }
            catch (Exception e) {
                System.err.println("#WeeklyRest.checkOffense# an error has occured during calculation");
                if (Transport.debug < 1) continue;
                e.printStackTrace();
            }
        }
    }

    public int getRestType(int length) {
        if (length > 420 && length <= this.reducedMinor.getThreshold()) {
            return 1;
        }
        if (length > this.reducedMinor.getThreshold()) {
            if (length < this.minor.getThreshold()) {
                return 2;
            }
            return 3;
        }
        return 0;
    }

    public int findNextWeeklyRest(int offsetSearchBegin) {
        while (offsetSearchBegin < this.activities.size()) {
            block4: {
                ActiviteConducteur activite = (ActiviteConducteur)this.activities.get(offsetSearchBegin);
                try {
                    if (TypeActivite.getActivityType(activite.getCleType()).isRest() && this.getRestType(this.restLength(offsetSearchBegin)) == 3) {
                        break;
                    }
                }
                catch (Exception ex) {
                    System.err.println("#WeeklyRest.findNextWeeklyRest# unable to find TypeActivite " + activite.getCleType());
                    if (Transport.debug < 1) break block4;
                    ex.printStackTrace();
                }
            }
            ++offsetSearchBegin;
        }
        return offsetSearchBegin;
    }
}

