/*
 * Decompiled with CFR 0.152.
 */
package transport.offence;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.TypeActivite;
import java.util.Vector;
import transpo.system.TimsLogger;
import transpo.system.util.Fonctions;
import transport.offence.MasterOffence;

public class WeeklyWork
extends MasterOffence {
    private Vector<Integer> weeklyWork;
    private Vector<String> jour;

    @Override
    public void process() throws Exception {
        int beginOffset = this.findFirstFullWeek();
        int workAmount = 0;
        if (beginOffset == 0) {
            TimsLogger.debug("#WeeklyDriving.process()# no full week found");
        }
        this.weeklyWork = new Vector();
        this.jour = new Vector();
        this.jour.add(((ActiviteConducteur)this.activities.get(beginOffset)).getDateJour());
        int currentWeek = ConversionTime.getWeek(((ActiviteConducteur)this.activities.get(beginOffset)).getDateJour(), "yyyy-MM-dd");
        int x = beginOffset;
        while (x < this.activities.size()) {
            ActiviteConducteur activity = (ActiviteConducteur)this.activities.get(x);
            int activityWeek = ConversionTime.getWeek(activity.getDateJour(), "yyyy-MM-dd");
            if (activityWeek != currentWeek) {
                TimsLogger.verbose("#end " + workAmount);
                this.weeklyWork.add(workAmount);
                workAmount = 0;
                this.jour.add(activity.getDateJour());
                TimsLogger.verbose("#WeeklyWork.checkOffence# begin " + activity.getDateJour());
                currentWeek = activityWeek;
            }
            if (TypeActivite.getActivityType(activity.getCleType()).getPaidPercentage() != 0) {
                workAmount += activity.getDuree();
            }
            ++x;
        }
        this.weeklyWork.add(workAmount);
        this.checkOffence();
    }

    public int findFirstFullWeek() {
        int week = this.activities.size() != 0 ? ConversionTime.getWeek(((ActiviteConducteur)this.activities.get(0)).getDateJour(), "yyyy-MM-dd") : 0;
        int x = 0;
        while (x < this.activities.size()) {
            if (week != ConversionTime.getWeek(((ActiviteConducteur)this.activities.get(x)).getDateJour(), "yyyy-MM-dd")) {
                return x;
            }
            ++x;
        }
        return 0;
    }

    public void checkOffence() {
        OffenceThreshold threshold = this.driver.getCleTypeConducteur() == 1 ? Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.GR") : (this.driver.getCleTypeConducteur() == 2 ? Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.ZC") : Fonctions.getOffenceThreshold(this.offence, "offence.basic", "offence.threshold.ME"));
        TimsLogger.debug("#WeeklyWork.checkOffence# " + this.weeklyWork.size() + " s\u00e9quences \u00e0 v\u00e9rifier");
        int x = 0;
        while (x < this.weeklyWork.size()) {
            TimsLogger.debug("#WeeklyWork.checkOffence# " + threshold + " " + this.weeklyWork.get(x));
            if (this.weeklyWork.get(x) > threshold.getThreshold()) {
                int day = 8 - ConversionTime.getDayOfWeek(this.jour.get(x), "yyyy-MM-dd", false);
                String sDay = ConversionTime.addDay(this.jour.get(x), "yyyy-MM-dd", day);
                TimsLogger.verbose("#weeklyWork.checkOffence() add offence => " + sDay + " : 0");
                this.parent.addInfraction(sDay, 0, this.getOffencePart("offence.basic").getId(), this.weeklyWork.get(x), 1, threshold.getInfrigement());
            }
            ++x;
        }
    }
}

