/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.bdd.Accident;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.AgencyType;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverAnalyticCode;
import fr.pgh.data.bdd.EmployeeType;
import fr.pgh.data.bdd.Garage;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.VehicleAnalyticCode;
import fr.pgh.data.bdd.VehicleModel;
import fr.pgh.data.bdd.VehicleType;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.MasterReport;

public class AccidentReport
extends MasterReport {
    private ArrayList<Map<String, ?>> data = null;
    private Accident toPrint = null;

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        Object acc = params.get("ACCIDENT");
        if (acc != null && acc instanceof Accident) {
            this.toPrint = (Accident)params.get("ACCIDENT");
        }
    }

    @Override
    public void process() {
        this.data = new ArrayList();
        if (this.toPrint != null) {
            try {
                Agence agency = (Agence)this.agencies.get(0);
                Conducteur driver = (Conducteur)this.drivers.get(0);
                Vehicule vehicle = (Vehicule)this.vehicles.get(0);
                Garage garage = null;
                AgencyType agencyType = null;
                EmployeeType driverType = null;
                VehicleType vehicleType = null;
                VehicleModel vehicleModel = null;
                VehicleAnalyticCode vehicleAc = null;
                DriverAnalyticCode driverAc = null;
                Region region = Region.find(Region.loadList(0), agency.getRegionId());
                try {
                    agencyType = AgencyType.get(agency.getCleTypeAgence());
                }
                catch (DBObjectNotFoundException e) {
                    TimsLogger.warn("#AccidentReport.process()# AgencyType has not been found " + agency.getCleTypeAgence());
                }
                try {
                    driverType = EmployeeType.get(driver.getCleTypePersonnel());
                }
                catch (DBObjectNotFoundException e) {
                    TimsLogger.warn("#AccidentReport.process()# EmployeeType has not been found " + driver.getCleTypePersonnel());
                }
                try {
                    vehicleType = VehicleType.get(vehicle.getTypeId());
                }
                catch (DBObjectNotFoundException e) {
                    TimsLogger.warn("#AccidentReport.process()# VehicleType has not been found " + vehicle.getTypeId());
                }
                try {
                    vehicleModel = VehicleModel.get(vehicle.getModelId());
                }
                catch (DBObjectNotFoundException e) {
                    TimsLogger.warn("#AccidentReport.process()# VehicleModel has not been found " + vehicle.getModelId());
                }
                try {
                    vehicleAc = VehicleAnalyticCode.get(vehicle.getAnalyticCodeId());
                }
                catch (DBObjectNotFoundException e) {
                    TimsLogger.warn("#AccidentReport.process()# VehicleModel has not been found " + vehicle.getModelId());
                }
                try {
                    driverAc = DriverAnalyticCode.get(driver.getAnalyticCodeId());
                }
                catch (DBObjectNotFoundException e) {
                    TimsLogger.warn("#AccidentReport.process()# VehicleModel has not been found " + vehicle.getModelId());
                }
                try {
                    garage = Garage.get(this.toPrint.getGarageId());
                }
                catch (DBObjectNotFoundException e) {
                    TimsLogger.warn("#AccidentReport.process()# Garage has not been found " + this.toPrint.getGarageId());
                }
                TimsLogger.debug("#AccidentReport.process()# generating a report... ");
                HashMap<String, Object> tmp = new HashMap<String, Object>();
                tmp.put("REGION", region != null ? region.getName() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("AGENCY", agency.getDescription() != null ? agency.getDescription() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("AGENCY_ADDRESS", agency.getAdresse() != null ? agency.getAdresse() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("AGENCY_CITY", agency.getVille() != null ? agency.getVille() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("AGENCY_CP", agency.getCodePostal() != null ? agency.getCodePostal() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("AGENCY_PHONE", agency.getTel1() != null ? agency.getTel1() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("AGENCY_TYPE", agencyType != null ? agencyType.getName() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("DRIVER", String.valueOf(driver.getNom()) + " " + driver.getPrenom());
                tmp.put("DRIVER_TYPE", driverType != null ? driverType.getName() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("DRIVER_AC", driverAc != null ? driverAc.getName() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("VEHICLE", vehicle.getRegistrationNumber());
                tmp.put("VEHICLE_BRAND", vehicle.getBrand() != null && !vehicle.getBrand().equals("") ? vehicle.getBrand() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("VEHICLE_FAMILY", vehicle.getCategory() != null && !vehicle.getCategory().equals("") ? vehicle.getCategory() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("VEHICLE_MODEL", vehicleModel != null ? vehicleModel.getName() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("VEHICLE_TYPE", vehicleType != null ? vehicleType.getName() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("VEHICLE_AC", vehicleAc != null ? vehicleAc.getName() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("DATE", this.toPrint.getDay());
                tmp.put("PLACE", this.toPrint.getPlace());
                tmp.put("DESCRIPTION", this.toPrint.getDescription());
                tmp.put("TYPE", this.toPrint.getType());
                tmp.put("INJURIED", this.toPrint.getInjuried());
                tmp.put("INJURED", this.toPrint.getInjury());
                tmp.put("STEAL", this.toPrint.getSteal());
                tmp.put("BIG_DAMAGES", this.toPrint.isBigDamages());
                tmp.put("RESPONSABILITY", this.toPrint.getResponsability());
                tmp.put("NUMBER", this.toPrint.getIdentificationNumber());
                tmp.put("GARAGE", garage != null ? garage.getName() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("GARAGE_ADDRESS", garage != null ? garage.getAddress() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("GARAGE_CITY", garage != null ? garage.getCity() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("GARAGE_CP", garage != null ? garage.getPostalCode() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("GARAGE_PHONE", garage != null ? garage.getPhone() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("GARAGE_FAX", garage != null ? garage.getFax() : LanguageTranslator.getString("generics.unknown"));
                tmp.put("GARAGE_ENTRY", this.toPrint.getGarageIn());
                tmp.put("TOWING", this.toPrint.isTowing());
                this.data.add(tmp);
                this.load(new JRMapCollectionDataSource(this.data), LanguageTranslator.getString("report.accident"));
                this.data.clear();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.generate();
    }
}

