/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.bdd.Accident;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.VehicleAnalyticCode;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGenerator;

public class AccidentReportList
extends DynamicGeneric {
    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
    }

    @Override
    public void process() {
        this.customReport = CustomReportFactory.getAccidentReportList();
        this.customReport.setName(this.report.getCustomizedName());
        this.setGenerator(new DJGenerator());
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        this.data = new ArrayList();
        Vector<Accident> tmp = Accident.loadList(this.agencies.size() == 1 ? (Agence)this.agencies.get(0) : null, this.begin, this.end);
        String unk = LanguageTranslator.getString("generics.unknown");
        for (Accident toAdd : tmp) {
            VehicleAnalyticCode vehicleAc = null;
            Vehicule vehicle = null;
            Conducteur driver = null;
            try {
                vehicle = Vehicule.getVehicule((Vector<Vehicule>)this.vehicles, toAdd.getVehicleId());
                vehicleAc = VehicleAnalyticCode.get(vehicle.getAnalyticCodeId());
            }
            catch (DBObjectNotFoundException e) {
                TimsLogger.warn("#AccidentReport.process()# Vehicle or VehicleAnalyticCode has not been found ");
            }
            try {
                driver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, toAdd.getDriverId());
            }
            catch (DriverNotFoundException e) {
                TimsLogger.warn("#AccidentReport.process()# Vehicle or Driver has not been found ");
            }
            HashMap<String, Object> acc = new HashMap<String, Object>();
            acc.put(LanguageTranslator.getString("vehicle.registrationNumber"), vehicle == null ? unk : vehicle.getRegistrationNumber());
            acc.put(LanguageTranslator.getString("generics.analyticCode"), vehicleAc == null ? unk : vehicleAc.getCode());
            acc.put(LanguageTranslator.getString("generics.driver"), driver == null ? unk : String.valueOf(driver.getNom()) + " " + driver.getPrenom());
            acc.put(LanguageTranslator.getString("generics.date"), toAdd.getDay());
            acc.put(LanguageTranslator.getString("generics.responsability"), toAdd.getResponsability() == -1 ? LanguageTranslator.getString("generics.unknown") : Accident.RESPONSABILITY_WORDING[toAdd.getResponsability()]);
            acc.put(LanguageTranslator.getString("generics.cost"), Float.valueOf(toAdd.getTotalCost()));
            acc.put(LanguageTranslator.getString("accident.totalInsurance"), Float.valueOf(toAdd.getTotalInsurance()));
            this.data.add(acc);
        }
        try {
            this.load(new JRMapCollectionDataSource((Collection)this.data), LanguageTranslator.getString("report.accident"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.generate();
    }

    public void afficheData() {
        for (Map tmp : this.data) {
            System.out.print("\nnew line : ");
            for (Object value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "   ");
            }
        }
    }
}

