/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.bdd.Accident;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.VehicleAnalyticCode;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGenerator;

public class AccidentSynthesis
extends DynamicGeneric {
    private ArrayList<Map<String, ?>> data = null;

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
    }

    @Override
    public void process() {
        this.customReport = CustomReportFactory.getAccidentSynthesis();
        this.setGenerator(new DJGenerator());
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        this.data = new ArrayList();
        Vector<Accident> tmp = Accident.loadList(this.agencies.size() == 1 ? (Agence)this.agencies.get(0) : null, this.begin, this.end);
        String total = LanguageTranslator.getString("generics.total");
        String unk = LanguageTranslator.getString("generics.unknown");
        HashMap<String, Object> first = new HashMap<String, Object>();
        HashMap<String, Object> second = new HashMap<String, Object>();
        HashMap<String, Object> third = new HashMap<String, Object>();
        HashMap<String, Object> fourth = new HashMap<String, Object>();
        this.data.add(first);
        this.data.add(second);
        this.data.add(third);
        this.data.add(fourth);
        first.put(LanguageTranslator.getString("generics.responsability"), LanguageTranslator.getString("accident.0"));
        second.put(LanguageTranslator.getString("generics.responsability"), LanguageTranslator.getString("accident.50"));
        third.put(LanguageTranslator.getString("generics.responsability"), LanguageTranslator.getString("accident.100"));
        fourth.put(LanguageTranslator.getString("generics.responsability"), LanguageTranslator.getString("generics.total"));
        first.put(total, 0);
        first.put(unk, 0);
        first.put(String.valueOf(unk) + "_COST", new Float(0.0));
        first.put(String.valueOf(unk) + "_INS_COST", new Float(0.0));
        second.put(total, 0);
        second.put(unk, 0);
        second.put(String.valueOf(unk) + "_COST", new Float(0.0));
        second.put(String.valueOf(unk) + "_INS_COST", new Float(0.0));
        third.put(total, 0);
        third.put(unk, 0);
        third.put(String.valueOf(unk) + "_COST", new Float(0.0));
        third.put(String.valueOf(unk) + "_INS_COST", new Float(0.0));
        fourth.put(total, 0);
        fourth.put(unk, 0);
        fourth.put(String.valueOf(unk) + "_COST", new Float(0.0));
        fourth.put(String.valueOf(unk) + "_INS_COST", new Float(0.0));
        for (VehicleAnalyticCode vac : VehicleAnalyticCode.getList()) {
            if (vac.getCode().length() != 6) continue;
            String workCode = vac.getCode().substring(3);
            first.put(workCode, 0);
            first.put(String.valueOf(workCode) + "_COST", new Float(0.0));
            first.put(String.valueOf(workCode) + "_INS_COST", new Float(0.0));
            second.put(workCode, 0);
            second.put(String.valueOf(workCode) + "_COST", new Float(0.0));
            second.put(String.valueOf(workCode) + "_INS_COST", new Float(0.0));
            third.put(workCode, 0);
            third.put(String.valueOf(workCode) + "_COST", new Float(0.0));
            third.put(String.valueOf(workCode) + "_INS_COST", new Float(0.0));
            fourth.put(workCode, 0);
            fourth.put(String.valueOf(workCode) + "_COST", new Float(0.0));
            fourth.put(String.valueOf(workCode) + "_INS_COST", new Float(0.0));
        }
        for (Accident toAdd : tmp) {
            Map<String, ?> toFill = this.data.get(toAdd.getResponsability());
            VehicleAnalyticCode vehicleAc = null;
            try {
                vehicleAc = VehicleAnalyticCode.get(Vehicule.getVehicule((Vector<Vehicule>)this.vehicles, toAdd.getVehicleId()).getAnalyticCodeId());
            }
            catch (DBObjectNotFoundException e) {
                TimsLogger.warn("#AccidentReport.process()# VehicleAnalyticCode has not been found ");
            }
            String vac = vehicleAc == null || vehicleAc.getCode().length() != 6 ? LanguageTranslator.getString("generics.unknown") : vehicleAc.getCode().substring(3);
            Integer existingCount = (Integer)toFill.get(vac);
            Float existingCost = (Float)toFill.get(String.valueOf(vac) + "_COST");
            Float existingInsCost = (Float)toFill.get(String.valueOf(vac) + "_INS_COST");
            toFill.put(vac, existingCount == null ? 1 : existingCount + 1);
            toFill.put(String.valueOf(vac) + "_COST", Float.valueOf(existingCost == null ? toAdd.getTotalCost() : existingCost.floatValue() + toAdd.getTotalCost()));
            toFill.put(String.valueOf(vac) + "_INS_COST", Float.valueOf(existingInsCost == null ? toAdd.getTotalInsurance() : existingInsCost.floatValue() + toAdd.getTotalInsurance()));
            toFill.put(total, (Integer)toFill.get(total) + 1);
        }
        try {
            this.load(new JRMapCollectionDataSource(this.data), LanguageTranslator.getString("report.accident"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.generate();
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\nnew line : ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "   ");
            }
        }
    }
}

