/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.connexion.ConnexionSettings;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Profil;
import fr.pgh.data.bdd.Societe;
import fr.pgh.data.bdd.Utilisateur;
import fr.pgh.exception.DriverNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.MasterReport;

public class Attestation
extends MasterReport {
    private ArrayList<Map<String, ?>> data = null;
    Vector<Profil> profils = Profil.list();

    @Override
    public void process() {
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        if (this.drivers.size() == 1 && !this.getUserParameter().get("BEGIN_TIME").equals("") && !this.getUserParameter().get("END_TIME").equals("")) {
            this.data = new ArrayList();
            String reason = this.getUserParameter().get("REASON") == null ? null : this.getUserParameter().get("REASON").toString();
            String beginTime = this.getUserParameter().get("BEGIN_TIME").toString();
            String endTime = this.getUserParameter().get("END_TIME").toString();
            String sBegin = String.valueOf(ConversionTime.dateToString(this.begin, "yyyy-MM-dd")) + " " + beginTime;
            String sEnd = String.valueOf(ConversionTime.dateToString(this.end, "yyyy-MM-dd")) + " " + endTime;
            this.loadReport(ConversionTime.stringToDate(sBegin, "yyyy-MM-dd HH'h'mm"), ConversionTime.stringToDate(sEnd, "yyyy-MM-dd HH'h'mm"), reason, (Conducteur)this.drivers.get(0));
        } else {
            Vector<LienJourConducteur> tmpL = LienJourConducteur.loadList(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
            TimsLogger.info("#Attestation.process()# " + tmpL.size() + " jours");
            Conducteur currentDriver = null;
            this.data = new ArrayList();
            Date begin = null;
            LienJourConducteur lastDate = null;
            int y = 0;
            while (y < tmpL.size()) {
                block15: {
                    LienJourConducteur tmp = tmpL.get(y);
                    if (currentDriver == null || tmp.getCleConducteur() != currentDriver.getCleConducteur()) {
                        if (currentDriver != null && lastDate != null) {
                            this.loadReport(begin, this.getFullEndDate(lastDate), lastDate.getDayType().getDesignation(), currentDriver);
                        }
                        begin = null;
                        lastDate = null;
                        try {
                            currentDriver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, tmp.getCleConducteur());
                        }
                        catch (DriverNotFoundException e) {
                            TimsLogger.warn("#Attestation# driver not found " + tmp.getCleConducteur());
                            break block15;
                        }
                    }
                    if (tmp.getType() != 2) {
                        if (lastDate != null) {
                            this.loadReport(begin, this.getFullEndDate(lastDate), lastDate.getDayType().getDesignation(), currentDriver);
                        }
                        this.loadReport(this.getFullBeginDate(tmp), this.getFullEndDate(tmp), tmp.getDayType().getDesignation(), currentDriver);
                        begin = null;
                        lastDate = null;
                    } else if (lastDate == null) {
                        begin = this.getFullBeginDate(tmp);
                        lastDate = tmp;
                    } else if (ConversionTime.getDaysBetween(lastDate.getDateJour(), tmp.getDateJour()) <= 1 && lastDate.getDayType().getCle() == tmp.getDayType().getCle()) {
                        lastDate = tmp;
                    } else {
                        this.loadReport(begin, this.getFullEndDate(lastDate), lastDate.getDayType().getDesignation(), currentDriver);
                        begin = this.getFullBeginDate(tmp);
                        lastDate = tmp;
                    }
                }
                ++y;
            }
            if (lastDate != null) {
                this.loadReport(begin, this.getFullEndDate(lastDate), lastDate.getDayType().getDesignation(), currentDriver);
            }
        }
        this.generate();
    }

    public void loadReport(Date begin, Date end, String reason, Conducteur currentDriver) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        Utilisateur toFill = null;
        Object profil = null;
        if (System.getProperty("URL") != null) {
            toFill = ConnexionSettings.getInstance().user;
        }
        Societe toPrint = Transport.bdd.getCompany();
        tmp.put("COMPANY", toPrint.getNomSociete());
        tmp.put("STREET", toPrint.getAddress());
        tmp.put("POSTAL_CODE", toPrint.getPostalCode());
        tmp.put("CITY", toPrint.getCity());
        tmp.put("PHONE", toPrint.getPhone());
        tmp.put("FAX", toPrint.getFax());
        tmp.put("MAIL", toPrint.getMail());
        tmp.put("COUNTRY", Pays.LIBELLE[toPrint.getCountry()][1]);
        if (System.getProperty("attestation.agency", "0").equals("1")) {
            Agence agency = Agence.find(null, currentDriver.getCleAgence());
            tmp.put("COMPANY", agency.getDescription());
            tmp.put("STREET", agency.getAdresse().replace("\r\n", ", ").replace("\n", ", "));
            tmp.put("POSTAL_CODE", agency.getCodePostal());
            tmp.put("CITY", agency.getVille());
            tmp.put("PHONE", agency.getTel1());
            tmp.put("FAX", agency.getFax());
            tmp.put("COUNTRY", Pays.LIBELLE[agency.getClePays()][1]);
            tmp.put("MAIL", agency.getEmail());
        }
        tmp.put("RESPONSABLE_NAME", toFill == null ? String.valueOf(toPrint.getDirectorLastName()) + " " + toPrint.getDirectorFirstName() : String.valueOf(toFill.getNom()) + " " + toFill.getPrenom());
        tmp.put("FUNCTION", toFill == null ? LanguageTranslator.getString("generics.responsible") : toFill.getFunction());
        tmp.put("DRIVER_NAME", String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
        tmp.put("DATE_OF_BIRTH", ConversionTime.stringToDate(currentDriver.getDateNaissance(), "yyyy-MM-dd"));
        tmp.put("HIRING_DATE", ConversionTime.stringToDate(currentDriver.getDateEntree(), "yyyy-MM-dd"));
        tmp.put("DRIVING_LICENSE", currentDriver.getNumeroPermis());
        tmp.put("BEGIN", begin);
        tmp.put("END", end);
        tmp.put("REASON", reason);
        this.data.add(tmp);
        try {
            this.loadReport(currentDriver, new JRMapCollectionDataSource(this.data));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.data.clear();
    }

    public Date getFullBeginDate(LienJourConducteur toGet) {
        String HHmm = ConversionTime.heureIntToString(toGet.getHeureDebut(), ".");
        String yyyyMMddHHmm = String.valueOf(ConversionTime.dateToString(toGet.getDateJour(), "yyyy-MM-dd")) + " " + HHmm;
        return ConversionTime.stringToDate(yyyyMMddHHmm, "yyyy-MM-dd HH.mm");
    }

    public Date getFullEndDate(LienJourConducteur toGet) {
        String HHmm = null;
        String yyyyMMddHHmm = null;
        if (toGet.getType() == 2) {
            HHmm = ConversionTime.heureIntToString(toGet.getHeureDebut(), ".");
            yyyyMMddHHmm = String.valueOf(ConversionTime.dateToString(ConversionTime.addDay(toGet.getDateJour(), 1), "yyyy-MM-dd")) + " " + HHmm;
        } else {
            HHmm = ConversionTime.heureIntToString(toGet.getHeureDebut() + toGet.getDuree(toGet.getType() == 1 ? 240 : 0), ".");
            yyyyMMddHHmm = String.valueOf(ConversionTime.dateToString(toGet.getDateJour(), "yyyy-MM-dd")) + " " + HHmm;
        }
        return ConversionTime.stringToDate(yyyyMMddHHmm, "yyyy-MM-dd HH.mm");
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\nnew line : ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "   ");
            }
        }
    }
}

