/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.Pays;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;

public class CardDetail
extends DynamicGeneric {
    public static final String MATRICULE = "user.registration";
    public static final String LAST_NAME = "user.lastName";
    public static final String FIRST_NAME = "user.firstName";
    public static final String CARD = "generics.card";
    public static final String DELIVERY = "generics.delivery";
    public static final String EXPIRATION = "generics.expiry";
    public static final String COUNTRY = "generics.country";
    public static final String LICENSE = "driver.licence.number";
    public static final String LICENSE_DELIVERY = "d\u00e9livrance permis";
    public static final String LICENSE_VISIT = "visite permis";

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicDriverExpenses.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        CustomReport cr = CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.driver"));
        Vector<CustomReportColumn> columns = new Vector<CustomReportColumn>();
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString(MATRICULE), String.class.getName(), "", 30, 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString(LAST_NAME), String.class.getName(), "", 30, 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString(FIRST_NAME), String.class.getName(), "", 30, 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString(CARD), String.class.getName(), "", 30, 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString(DELIVERY), String.class.getName(), "", 30, 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString(EXPIRATION), String.class.getName(), "", 30, 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString(COUNTRY), String.class.getName(), "", 30, 1));
        columns.add(new CustomReportColumn(0, 0, LanguageTranslator.getString(LICENSE), String.class.getName(), "", 30, 1));
        columns.add(new CustomReportColumn(0, 0, LICENSE_DELIVERY, String.class.getName(), "", 30, 1));
        columns.add(new CustomReportColumn(0, 0, LICENSE_VISIT, String.class.getName(), "", 30, 1));
        cr.setColumn(columns);
        this.getGenerator().setReport(cr);
        this.getGenerator().getReport().getProperties().clear();
        this.getGenerator().getReport().getProperties().putAll(params);
    }

    @Override
    public void process() {
        block7: {
            this.data = new ArrayList();
            this.getGenerator().prebuild();
            this.userParameters.put("TITLE", this.getGenerator().getReport().getName());
            this.userParameters.put("DEBUT", this.begin);
            this.userParameters.put("FIN", this.end);
            if (this.pb != null) {
                this.pb.getBar().setMaximum(this.drivers.size());
            }
            if (this.pb != null) {
                this.pb.getBar().setMinimum(0);
            }
            for (Conducteur driver : this.drivers) {
                if (this.pb != null) {
                    this.pb.getBar().setString(String.valueOf(driver.getNom()) + " " + driver.getPrenom());
                }
                if (this.pb != null) {
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                }
                HashMap<String, String> toAdd = new HashMap<String, String>();
                toAdd.put(LanguageTranslator.getString(MATRICULE), driver.getMatricule());
                toAdd.put(LanguageTranslator.getString(LAST_NAME), driver.getNom());
                toAdd.put(LanguageTranslator.getString(FIRST_NAME), driver.getPrenom());
                toAdd.put(LanguageTranslator.getString(CARD), driver.getNumeroCarte());
                toAdd.put(LanguageTranslator.getString(DELIVERY), ConversionTime.dateFromBDDToFrance(driver.getDateDebutValiditeCarte(), false, true));
                toAdd.put(LanguageTranslator.getString(EXPIRATION), ConversionTime.dateFromBDDToFrance(driver.getDateFinValiditeCarte(), false, true));
                toAdd.put(LanguageTranslator.getString(COUNTRY), Pays.getLibellePays(driver.getMemberState()));
                toAdd.put(LanguageTranslator.getString(LICENSE), driver.getNumeroPermis());
                toAdd.put(LICENSE_VISIT, ConversionTime.dateFromBDDToFrance(driver.getDateVisitePermis(), false, true));
                this.data.add(toAdd);
            }
            try {
                this.load(new JRMapCollectionDataSource((Collection)this.data), null);
                this.data.clear();
            }
            catch (Exception ex) {
                if (Transport.debug < 1) break block7;
                ex.printStackTrace();
            }
        }
        this.generate();
    }
}

