/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;

public class CardRenewal
extends DynamicGeneric {
    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicDriverExpenses.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        this.getGenerator().setReport(CustomReportFactory.getCardRenewalReport());
        this.getGenerator().getReport().getProperties().clear();
        this.getGenerator().getReport().getProperties().putAll(params);
    }

    @Override
    public void process() {
        block7: {
            this.data = new ArrayList();
            this.getGenerator().prebuild();
            this.userParameters.put("TITLE", this.getGenerator().getReport().getName());
            this.userParameters.put("DEBUT", this.begin);
            this.userParameters.put("FIN", this.end);
            if (this.pb != null) {
                this.pb.getBar().setMaximum(this.drivers.size());
            }
            if (this.pb != null) {
                this.pb.getBar().setMinimum(0);
            }
            for (Conducteur driver : this.drivers) {
                Date expiration;
                if (this.pb != null) {
                    this.pb.getBar().setString(String.valueOf(driver.getNom()) + " " + driver.getPrenom());
                }
                if (this.pb != null) {
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                }
                if (!this.begin.before(expiration = ConversionTime.stringToDate(driver.getDateFinValiditeCarte(), "yyyy-MM-dd")) || !this.end.after(expiration)) continue;
                TimsLogger.debug("#card.process# " + driver.getNom() + " est a expiration");
                HashMap<String, String> toAdd = new HashMap<String, String>();
                toAdd.put("numCarte", driver.getNumeroCarte());
                toAdd.put("nomConducteur", driver.getNom());
                toAdd.put("permisConducteur", driver.getNumeroPermis());
                this.data.add(toAdd);
            }
            try {
                this.load(new JRMapCollectionDataSource((Collection)this.data), null);
                this.data.clear();
            }
            catch (Exception ex) {
                if (Transport.debug < 1) break block7;
                ex.printStackTrace();
            }
        }
        this.generate();
    }
}

