/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Jour;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transport.report.MasterReport;

public class DayPrint
extends MasterReport {
    final Collection<Map<String, ?>> datas = new ArrayList();

    @Override
    public void process() {
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        int x = 0;
        while (x < this.drivers.size()) {
            Conducteur currentDriver = (Conducteur)this.drivers.get(x);
            this.pb.getBar().setString(String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            try {
                for (Jour day : BddTransport.getInstance().getJourNew(currentDriver.getCleConducteur(), this.begin, this.end, 1, false)) {
                    if (day.getActivity() == null) continue;
                    this.pb.getBar().setString(String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom() + " : " + day.getDate());
                    HashMap<String, Object> dayP = new HashMap<String, Object>();
                    BufferedImage bi = new BufferedImage(500, 40, 1);
                    Graphics2D g = bi.createGraphics();
                    this.fillGraph(g, day.getActivity(), 500, 40);
                    dayP.put("GRAPH", bi);
                    dayP.put("DAY", ConversionTime.stringToDateDb(day.getDate()));
                    this.datas.add(dayP);
                }
                this.loadReport(currentDriver, new JRMapCollectionDataSource(this.datas));
                this.datas.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++x;
        }
        this.generate();
    }

    public void fillGraph(Graphics g, Vector<ActiviteConducteur> act, int width, int height) {
        int xPos;
        g.setColor(Color.white);
        g.fillRect(0, 0, width, height);
        float minuteWidth = (float)width / 1440.0f;
        int dayHeight = height;
        g.setColor(Color.black);
        g.setFont(g.getFont().deriveFont(9.0f));
        g.setColor(Color.lightGray);
        int x = 0;
        while (x < 24) {
            xPos = (int)((float)x * minuteWidth * 60.0f + 30.0f * minuteWidth);
            g.drawLine(xPos, 0, xPos, 7 * dayHeight);
            ++x;
        }
        g.setColor(Color.BLACK);
        x = 0;
        while (x <= 24) {
            xPos = (int)((float)x * minuteWidth * 60.0f);
            if (x == 0) {
                g.drawString("0", xPos, 10);
            } else if (x == 24) {
                g.drawString("24", xPos - 10, 10);
            } else {
                g.drawString(String.valueOf(x), xPos - 2, 10);
            }
            g.drawLine(xPos, 15, xPos, 7 * dayHeight);
            ++x;
        }
        g.drawLine(0, dayHeight, (int)(24.0f * minuteWidth), dayHeight);
        if (act == null) {
            return;
        }
        for (ActiviteConducteur tmp : act) {
            g.setColor(new Color(Integer.parseInt(tmp.getCouleur())));
            int hauteur = 8;
            if (tmp.getCleType() == 1) {
                hauteur = 20;
            }
            if (tmp.getCleType() == 2 || tmp.getCleType() == 6) {
                hauteur = 15;
            }
            if (tmp.getCleType() == 3 || tmp.getCleType() == 5) {
                hauteur = 11;
            }
            if (tmp.getCleType() == 4 || tmp.getCleType() == 7) {
                hauteur = 5;
            }
            int beginX = (int)((float)tmp.getHeureDebut() * minuteWidth);
            int beginY = dayHeight - hauteur;
            int widthAct = (float)tmp.getDuree() * minuteWidth == 0.0f ? 1 : (int)((float)tmp.getDuree() * minuteWidth);
            int hightAct = hauteur;
            g.fillRect(beginX, beginY, widthAct, hightAct);
            if (!tmp.isManualInput()) continue;
            g.setColor(Color.BLACK);
            g.fillRect(beginX, beginY - 5, widthAct, 2);
        }
    }
}

