/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.ContractNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.MasterReport;
import transport.report.generator.DJGenerator;

public class DayToCcmxCayon
extends DynamicGeneric {
    public static final String DAY_CCMX_FILE = "evenements-ccmx.txt";
    private PrintWriter file = null;
    private DecimalFormat df = new DecimalFormat("##.00");
    private String destinationPath = null;
    private ArrayList<Map<String, ?>> data = null;

    public DayToCcmxCayon() {
        this.destinationPath = System.getProperty("export_default_path");
        if (this.destinationPath == null || this.destinationPath.equals("") || !new File(this.destinationPath).exists()) {
            MasterReport.GetFile tmp = new MasterReport.GetFile(this, DAY_CCMX_FILE);
            if (SwingUtilities.isEventDispatchThread()) {
                tmp.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(tmp);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.destinationPath = tmp.getCheminSave();
        }
        this.setCustomReport(this.getCR());
        this.setGenerator(new DJGenerator());
    }

    public DayToCcmxCayon(String destinationPath) {
        this.destinationPath = destinationPath;
        this.setCustomReport(this.getCR());
        this.setGenerator(new DJGenerator());
    }

    @Override
    public void process() throws Exception {
        this.getGenerator().setReport(this.getCR());
        this.getGenerator().prebuild();
        try {
            this.file = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(this.destinationPath) + "\\" + DAY_CCMX_FILE, false)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        Vector<LienJourConducteur> tmpL = LienJourConducteur.loadList(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
        TimsLogger.debug("#DayToCcmxCayon.process()# " + tmpL.size() + " jours");
        Conducteur currentDriver = null;
        TypeContrat contrat = null;
        int defaultDayLength = 0;
        this.data = new ArrayList();
        Vector<LienJourConducteur> periodList = new Vector<LienJourConducteur>();
        ArrayList<LienJourConducteur> globalCal = null;
        boolean requirements = true;
        int y = 0;
        while (y < tmpL.size()) {
            block23: {
                LienJourConducteur tmp;
                block25: {
                    block26: {
                        boolean close;
                        block28: {
                            LienJourConducteur last;
                            block27: {
                                block24: {
                                    tmp = tmpL.get(y);
                                    if (ConversionTime.getDayOfWeek(tmp.getDateJour(), false) == 7 && tmp.getDayType().getCode().equals("CP")) break block23;
                                    if (currentDriver == null || tmp.getCleConducteur() != currentDriver.getCleConducteur()) {
                                        if (currentDriver != null && periodList.size() != 0) {
                                            if (requirements) {
                                                this.loadPeriod(periodList, currentDriver, defaultDayLength);
                                            }
                                            periodList.clear();
                                        }
                                        requirements = true;
                                        try {
                                            currentDriver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, tmp.getCleConducteur());
                                            globalCal = GlobalCalendarDay.toLJC(GlobalCalendarDay.loadList(currentDriver.getCalendarId(), this.begin, this.end), currentDriver.getCleConducteur());
                                            contrat = TypeContrat.getContractType(TypeContrat.getList(), currentDriver.getCleTypeContrat());
                                            if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                                                defaultDayLength = contrat.getDailyValue();
                                            }
                                            TimsLogger.warn("#DayToCcmxCayon.process# new driver " + currentDriver.getNom());
                                        }
                                        catch (DriverNotFoundException e) {
                                            TimsLogger.warn("#DayToCcmxCayon.process# driver not found " + tmp.getCleConducteur());
                                            break block23;
                                        }
                                        catch (ContractNotFoundException e) {
                                            TimsLogger.warn("#DayToCcmxCayon.process# contract not found " + tmp.getCleConducteur());
                                            requirements = false;
                                            this.warningList.add(currentDriver);
                                        }
                                    }
                                    if (tmp.getType() == 2) break block24;
                                    if (periodList.size() != 0) {
                                        if (requirements) {
                                            this.loadPeriod(periodList, currentDriver, defaultDayLength);
                                        }
                                        periodList.clear();
                                    }
                                    this.loadOneDay(tmp, currentDriver, defaultDayLength);
                                    break block25;
                                }
                                if (periodList.size() == 0) break block26;
                                last = periodList.get(periodList.size() - 1);
                                close = true;
                                if (last.getDayType().isPaid() || !tmp.getDayType().getCode().equals("JF")) break block27;
                                TimsLogger.debug("On est sur JF... (avant " + last.getDayType().getCode() + ")");
                                if (y == tmpL.size() - 1) break block23;
                                LienJourConducteur next = tmpL.get(y + 1);
                                TimsLogger.debug("suivant " + next.getDayType().getCode() + " : " + ConversionTime.getWorkday(last.getDateJour(), next.getDateJour()));
                                if (last.getDayType().getCle() == next.getDayType().getCle() && ConversionTime.getWorkday(last.getDateJour(), next.getDateJour()) == 3) {
                                    TimsLogger.debug("on ne ferme pas la p\u00e9riode");
                                    periodList.add(tmp);
                                    tmp = next;
                                    ++y;
                                    close = false;
                                }
                                break block28;
                            }
                            if (last.getDayType().getCle() == tmp.getDayType().getCle()) {
                                int nbJour = ConversionTime.getWorkday(last.getDateJour(), tmp.getDateJour());
                                if (nbJour == 2) {
                                    close = false;
                                } else if (nbJour < 2 && !tmp.getDayType().isPaid()) {
                                    close = false;
                                }
                            }
                        }
                        if (close) {
                            if (requirements) {
                                this.loadPeriod(periodList, currentDriver, defaultDayLength);
                            }
                            periodList.clear();
                        }
                    }
                    periodList.add(tmp);
                }
                if (globalCal != null && globalCal.size() != 0 && y < tmpL.size() - 1) {
                    for (LienJourConducteur tmpG : globalCal) {
                        if (!tmp.getDateJour().before(tmpG.getDateJour()) || !tmpL.get(y + 1).getDateJour().after(tmpG.getDateJour())) continue;
                        TimsLogger.debug("#dayToCcmxCayon.process# add " + tmpG.getDayType().getCode() + " on " + tmpG.getDateJour() + " (between " + tmp.getDateJour() + " and " + tmpL.get(y + 1).getDateJour() + ")");
                        tmpL.add(y + 1, tmpG);
                    }
                }
            }
            ++y;
        }
        if (periodList.size() != 0) {
            if (requirements) {
                this.loadPeriod(periodList, currentDriver, defaultDayLength);
            }
            periodList.clear();
        }
        this.load(new JRMapCollectionDataSource(this.data), "rapport");
        this.generate();
        this.file.close();
        this.pb.dispose();
    }

    public void loadOneDay(LienJourConducteur day, Conducteur currentDriver, int defaultDayLength) {
        TimsLogger.debug("#loadOneDay#");
        String societeCode = Transport.bdd.getCompany().getCode();
        JourType tmpJT = day.getDayType();
        if (tmpJT.getExport() == 0) {
            return;
        }
        double length = (float)day.getDuree(defaultDayLength) / 60.0f;
        String sCode = tmpJT.getCode();
        while (sCode.length() != 4) {
            sCode = " " + sCode;
        }
        Date end = day.getDateJour();
        if (ConversionTime.getDayOfWeek(day.getDateJour(), false) == 6 && tmpJT.getCode().equals("CP")) {
            end = ConversionTime.addDay(end, 1);
        }
        String amount = day.getType() == 2 ? "1,00" : (day.getType() == 1 ? "0,50" : "0,00");
        this.write(this.file, this.data, societeCode, currentDriver, sCode, day.getDateJour(), amount, length == 0.0 ? "0,00" : this.df.format(length), day.getDateJour(), end, tmpJT.isPaid() ? null : "1,00");
        if (ConversionTime.getDayOfWeek(day.getDateJour(), false) == 6 && tmpJT.getCode().equals("CP")) {
            this.write(this.file, this.data, societeCode, currentDriver, sCode, ConversionTime.addDay(day.getDateJour(), 1), tmpJT.isPaid() ? "1,00" : "0,00", "0,00", day.getDateJour(), end, null);
        }
    }

    public void loadPeriod(Vector<LienJourConducteur> periodList, Conducteur currentDriver, int defaultDayLength) {
        TimsLogger.debug("#loadPeriod#");
        if (periodList.size() == 0) {
            return;
        }
        if (periodList.size() == 1) {
            this.loadOneDay(periodList.get(0), currentDriver, defaultDayLength);
        } else {
            String societeCode = Transport.bdd.getCompany().getCode();
            Date begin = periodList.get(0).getDateJour();
            Date end = periodList.get(periodList.size() - 1).getDateJour();
            JourType tmpJT = periodList.get(0).getDayType();
            if (ConversionTime.getDayOfWeek(end, false) == 6 && tmpJT.getCode().equals("CP")) {
                end = ConversionTime.addDay(end, 1);
            }
            if (tmpJT.getExport() == 0) {
                return;
            }
            String sCode = tmpJT.getCode();
            while (sCode.length() != 4) {
                sCode = " " + sCode;
            }
            int x = 0;
            while (x < periodList.size()) {
                String other;
                LienJourConducteur tmp = periodList.get(x);
                TimsLogger.debug("Process " + tmp.getDateJour());
                double length = (float)tmp.getDuree(defaultDayLength) / 60.0f;
                String amount = tmp.getType() == 2 ? "1,00" : (tmp.getType() == 1 ? "0,50" : "0,00");
                String sLength = length == 0.0 ? "0,00" : this.df.format(length);
                String string = other = tmpJT.isPaid() ? null : "1,00";
                if (tmp.getDayType().getCode().equals("JF")) {
                    amount = "0,00";
                    sLength = "0,00";
                    other = "1,00";
                }
                if (ConversionTime.isWE(tmp.getDateJour()) && !tmpJT.isPaid()) {
                    TimsLogger.debug("On met length \u00e0 0 (week end et jour non pay\u00e9) " + tmp.getDateJour());
                    sLength = "0,00";
                }
                this.write(this.file, this.data, societeCode, currentDriver, sCode, tmp.getDateJour(), amount, sLength, begin, end, other);
                if (ConversionTime.getDayOfWeek(tmp.getDateJour(), false) == 6) {
                    if (x == periodList.size() - 1) {
                        if (tmpJT.getCode().equals("CP")) {
                            this.write(this.file, this.data, societeCode, currentDriver, sCode, ConversionTime.addDay(tmp.getDateJour(), 1), "1,00", "0,00", begin, end, other);
                        }
                    } else if (ConversionTime.getDayOfWeek(periodList.get(x + 1).getDateJour(), false) == 2) {
                        if (tmpJT.getCode().equals("CP") || !tmpJT.isPaid()) {
                            this.write(this.file, this.data, societeCode, currentDriver, sCode, ConversionTime.addDay(tmp.getDateJour(), 1), "1,00", "0,00", begin, end, other);
                        }
                        if (!tmpJT.isPaid()) {
                            this.write(this.file, this.data, societeCode, currentDriver, sCode, ConversionTime.addDay(tmp.getDateJour(), 2), "1,00", "0,00", begin, end, tmpJT.isPaid() ? null : "1,00");
                        }
                    }
                }
                ++x;
            }
        }
    }

    private void write(PrintWriter file, ArrayList<Map<String, ?>> map, String company, Conducteur driver, String code, Date day, String amount, String length, Date begin, Date end, String other) {
        while (length.length() < 5) {
            length = "0" + length;
        }
        String sDay = ConversionTime.dateToString(day, "dd/MM/yyyy");
        String sBegin = ConversionTime.dateToString(begin, "dd/MM/yyyy");
        String sEnd = ConversionTime.dateToString(end, "dd/MM/yyyy");
        if (file != null) {
            file.write(this.getFileLine(company, driver.getMatricule(), code, sDay, amount, length, sBegin, sEnd, other));
        }
        if (map != null) {
            map.add(this.getReportLine(company, driver.getNom(), code, sDay, amount, length, sBegin, sEnd, other));
        }
    }

    private String getFileLine(String company, String driver, String code, String day, String amount, String length, String begin, String end, String other) {
        return String.valueOf(company) + "\t" + driver + "\t" + code + "\t" + day + "\t" + amount + "\t" + length + "\t" + begin + "\t" + end + (other == null ? "\r\n" : "\t" + other + "\r\n");
    }

    private Map<String, Object> getReportLine(String company, String driver, String code, String day, String amount, String length, String begin, String end, String other) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SOCIETE", company);
        map.put(LanguageTranslator.getString("generics.driver"), driver);
        map.put(LanguageTranslator.getString("generics.code"), code);
        map.put(LanguageTranslator.getString("generics.date"), day);
        map.put("DEBUT PERIODE", begin);
        map.put("FIN PERIODE", end);
        map.put(LanguageTranslator.getString("generics.amount"), amount);
        map.put(LanguageTranslator.getString("generics.length"), length);
        map.put(LanguageTranslator.getString("generics.other"), other);
        return map;
    }

    private CustomReport getCR() {
        CustomReport toReturn = CustomReportFactory.getGeneric("Evenements");
        toReturn.setColumn(this.getColumn());
        return toReturn;
    }

    private Vector<CustomReportColumn> getColumn() {
        Vector<CustomReportColumn> toReturn = new Vector<CustomReportColumn>();
        toReturn.add(new CustomReportColumn(0, 0, "SOCIETE", String.class.getName(), "", 0, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 0, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.code"), String.class.getName(), "", 0, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.date"), String.class.getName(), "", 0, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.amount"), String.class.getName(), "", 0, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.length"), String.class.getName(), "", 0, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "DEBUT PERIODE", String.class.getName(), "", 0, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "FIN PERIODE", String.class.getName(), "", 0, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.other"), String.class.getName(), "", 0, toReturn.size() + 1));
        return toReturn;
    }
}

