/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DriverNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGenerator;

public class DriverKmSynthesis
extends DynamicGeneric {
    private ArrayList<Map<String, ?>> data = null;

    public DriverKmSynthesis() {
        this.setGenerator(new DJGenerator());
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicService.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getDriverKmSynthesis();
        this.userParameters.putAll(this.customReport.getProperties());
        this.customReport.getProperties().clear();
        this.customReport.getProperties().putAll(params);
        this.customReport.getProperties().put("TEMPLATE", "report/" + report.getFileName());
    }

    @Override
    public void process() {
        if (this.getGenerator() == null) {
            TimsLogger.debug("#DynService.process# no generator defined, set DJServiceGenerator");
            this.setGenerator(new DJGenerator());
        }
        boolean needBuild = false;
        if (this.data == null || this.data.size() == 0) {
            TimsLogger.debug("#DynamicService.process# Build during process");
            needBuild = true;
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.drivers.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        try {
            this.getGenerator().compile(this.userParameters);
        }
        catch (Exception ex) {
            TimsLogger.warn("#DynamucService.process# error on compilation");
            ex.printStackTrace();
            return;
        }
        HashMap<String, Integer> kms = new HashMap<String, Integer>();
        HashMap<String, Integer> days = new HashMap<String, Integer>();
        Vector<Service> tmpS = Service.getService(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
        Vector<Integer> orderedDriverId = Fonctions.reorder(tmpS, null);
        Conducteur currentDriver = null;
        this.pb.getBar().setMaximum(orderedDriverId.size());
        this.pb.getBar().setMinimum(0);
        if (this.data == null) {
            this.data = new ArrayList();
        }
        for (Integer n : orderedDriverId) {
            int dayCount = 0;
            int totalKm = 0;
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            boolean serviceLeft = true;
            try {
                currentDriver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, n);
                this.pb.getBar().setString(String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                Date day = this.begin;
                while (day.compareTo(this.end) <= 0) {
                    TimsLogger.debug("#ServiceReport.process# (" + n + ") " + ConversionTime.dateToString(day, "dd/MM/yyyy"));
                    if (serviceLeft) {
                        int x = 0;
                        while (x < tmpS.size()) {
                            if (tmpS.get(x).getDriverId() != n.intValue()) {
                                if (x != 0) break;
                                serviceLeft = false;
                                System.out.print("#ServiceReport.process# endOfService ");
                                tmpS.get(x).affiche();
                                break;
                            }
                            if (day.equals(ConversionTime.stringToDate(tmpS.get(x).getBeginDate().substring(0, 10), "yyyy-MM-dd"))) {
                                System.out.print("#ServiceReport.process# found ");
                                tmpS.get(x).affiche();
                                totalKm += tmpS.get(x).getDistance();
                                ++dayCount;
                                tmpS.remove(x);
                                if (x >= tmpS.size() || tmpS.get(x).getDriverId() != n.intValue() || !day.equals(ConversionTime.stringToDate(tmpS.get(x).getBeginDate().substring(0, 10), "yyyy-MM-dd"))) break;
                                System.out.print("#ServiceReport.process# 2 services sur le m\u00eame jour ");
                                tmpS.get(x).affiche();
                                totalKm += tmpS.get(x).getDistance();
                                tmpS.remove(x);
                                break;
                            }
                            ++x;
                        }
                    }
                    day = ConversionTime.addDay(day, 1);
                }
                TimsLogger.debug("#ServiceReport.process# C'est la fin du conducteur " + currentDriver.getNom());
            }
            catch (DriverNotFoundException ex) {
                TimsLogger.warn("Unable to find driver " + n);
            }
            catch (Exception ex) {
                TimsLogger.warn("Erreur sur conducteur " + n);
                ex.printStackTrace();
            }
            String driverAgency = Agence.find(null, currentDriver.getCleAgence()).getDescription();
            int km = kms.get(driverAgency) == null ? 0 : (Integer)kms.get(driverAgency);
            int day = days.get(driverAgency) == null ? 0 : (Integer)days.get(driverAgency);
            kms.put(driverAgency, km + totalKm);
            days.put(driverAgency, day + dayCount);
        }
        for (Map.Entry entry : kms.entrySet()) {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            tmp.put(LanguageTranslator.getString("generics.agency"), entry.getKey());
            tmp.put(LanguageTranslator.getString("generics.workedDay"), days.get(entry.getKey()));
            tmp.put(LanguageTranslator.getString("generics.km"), entry.getValue());
            this.data.add(tmp);
        }
        try {
            this.load(new JRMapCollectionDataSource(this.data), this.customReport.getName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.generate();
    }
}

