/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.EmployeeObligation;
import fr.pgh.data.bdd.EmployeeObligationType;
import fr.pgh.data.bdd.EmployeeObligationTypeGroup;
import fr.pgh.data.bdd.Societe;
import fr.pgh.exception.DBObjectNotFoundException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import org.jfree.util.Log;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.util.FileManager;
import transpo.system.util.Fonctions;
import transport.report.MasterReport;

public class DrivingPermission
extends MasterReport {
    private ArrayList<Map<String, ?>> data = null;

    @Override
    public void process() {
        Societe company = BddTransport.getInstance().getCompany();
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        this.userParameters.put("TITLE", this.report.getCustomizedName());
        this.userParameters.put("PO", System.getProperty("po_driving_permission", "non renseign\u00e9"));
        this.userParameters.put("IMAGE", System.getProperty("autocond_image", "images/tims.png"));
        this.userParameters.put("COMPANY", company.getNomSociete());
        this.userParameters.put("ADDRESS", String.valueOf(company.getAddress()) + ", " + company.getPostalCode() + " " + company.getCity() + ", " + company.getPhone());
        this.userParameters.put("PLACE", company.getCity());
        if (this.data == null) {
            this.data = new ArrayList();
        }
        int x = 0;
        while (x < this.drivers.size()) {
            Conducteur currentDriver;
            block31: {
                currentDriver = (Conducteur)this.drivers.get(x);
                String photo = String.valueOf(FileManager.getFilePath(currentDriver)) + "photo.jpg";
                if (photo.startsWith("http")) {
                    try {
                        photo = Fonctions.getURL(null, photo).toString();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                this.userParameters.put("PHOTO", photo);
                TimsLogger.verbose("#DrivingPermission.process# PHOTO : " + photo);
                Vector<EmployeeObligation> eo = EmployeeObligation.loadLastList(0, currentDriver.getCleConducteur());
                TimsLogger.debug("#DrivingPermission.process# on traite " + eo.size() + " obligations");
                this.pb.getBar().setString(String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                HashMap<String, String> driverData = new HashMap<String, String>();
                driverData.put("FIRST_NAME", currentDriver.getPrenom());
                driverData.put("LAST_NAME", currentDriver.getNom());
                driverData.put("VM_DATE", ConversionTime.dateFromBDDToFrance(currentDriver.getDateVisite(), false, true));
                driverData.put("COMPANY_NAME", company.getNomSociete());
                driverData.put("CITY", company.getCity());
                driverData.put("DATE", ConversionTime.dateToString(new Date(), "dd/MM/yyyy"));
                for (EmployeeObligationType eot : EmployeeObligationType.getList()) {
                    if (eot.getPermissionRequired() == 0) continue;
                    try {
                        EmployeeObligationTypeGroup eotg = EmployeeObligationTypeGroup.get(eot.getGroupId());
                        driverData.put("FIELD_" + eot.getPermissionRequired(), eotg.getName());
                    }
                    catch (DBObjectNotFoundException ex) {
                        TimsLogger.error("#DrivingPermission.process# groupe d'obligation " + eot.getGroupId() + " introuvable");
                    }
                }
                if (driverData.get("FIELD2_1") == null) {
                    driverData.put("FIELD2_1", "Permis de conduire");
                    if (!currentDriver.getDateVisitePermis().equals("")) {
                        int day = Integer.parseInt(System.getProperty("medical_visit_driving_expiration", "1826"));
                        Date tmp = ConversionTime.stringToDate2(currentDriver.getDateVisitePermis(), "yyyy-MM-dd");
                        driverData.put("DATE2_1", ConversionTime.dateToString(ConversionTime.addDay(tmp, day), "dd/MM/yyyy"));
                        TimsLogger.debug("date permis : " + driverData.get("DATE2_1").toString());
                    }
                }
                String drivingCat = "";
                if (!currentDriver.getBDelivery().equals("")) {
                    drivingCat = String.valueOf(drivingCat) + "/B";
                }
                if (!currentDriver.getCDelivery().equals("")) {
                    drivingCat = String.valueOf(drivingCat) + "/C";
                }
                if (!currentDriver.getCEDelivery().equals("")) {
                    drivingCat = String.valueOf(drivingCat) + "/CE";
                }
                if (!currentDriver.getDDelivery().equals("")) {
                    drivingCat = String.valueOf(drivingCat) + "/D";
                }
                if (!currentDriver.getDEDelivery().equals("")) {
                    drivingCat = String.valueOf(drivingCat) + "/DE";
                }
                if (!drivingCat.equals("")) {
                    driverData.put("CAT2_1", drivingCat.substring(1));
                } else {
                    driverData.put("CAT2_1", "--------------");
                    driverData.put("DATE2_1", "------------");
                }
                HashMap<String, String> habilitationList = new HashMap<String, String>();
                for (EmployeeObligation e : eo) {
                    try {
                        EmployeeObligationType eot = EmployeeObligationType.getObligationType(e.getTypeId());
                        if (eot.getPermissionRequired() != 0) {
                            Date future = e.getExpiration();
                            if (future == null) {
                                future = ConversionTime.addDay(e.getDay(), eot.getPeriodExpiration());
                            }
                            if (future.after(new Date())) {
                                try {
                                    Date date;
                                    EmployeeObligationTypeGroup eotg = EmployeeObligationTypeGroup.get(eot.getGroupId());
                                    Object currentCat = driverData.get("CAT_" + eot.getPermissionRequired());
                                    Object currentDate = driverData.get("DATE_" + eot.getPermissionRequired());
                                    TimsLogger.verbose("#DrivingPermission.process# obligation : " + eot.getCode() + " (" + eotg.getName() + ")");
                                    Date date2 = date = currentDate == null ? null : ConversionTime.stringToDate(currentDate.toString(), "dd/MM/yyyy");
                                    if (date == null || future.before(date)) {
                                        driverData.put("DATE_" + eot.getPermissionRequired(), ConversionTime.dateToString(future, "dd/MM/yyyy"));
                                        TimsLogger.verbose("#DrivingPermission.process# update date for " + eotg.getName() + " -> " + ConversionTime.dateToString(future, "dd/MM/yyyy"));
                                    }
                                    driverData.put("CAT_" + eot.getPermissionRequired(), currentCat == null ? eot.getCode() : String.valueOf(currentCat.toString()) + "/" + eot.getCode());
                                    TimsLogger.verbose("#DrivingPermission.process# update cat for " + eotg.getName() + " -> " + (currentCat == null ? eot.getCode() : String.valueOf(currentCat.toString()) + "/" + eot.getCode()));
                                }
                                catch (DBObjectNotFoundException ex) {
                                    Log.warn((Object)("#DrivingPermission.process# No group found for " + eot.getName()));
                                }
                            }
                        }
                        if (!eot.isHabilitation()) continue;
                        EmployeeObligationTypeGroup eotg = EmployeeObligationTypeGroup.get(eot.getGroupId());
                        TimsLogger.verbose("#DrivingPermission.process# habilitation : " + eot.getCode() + " (" + eotg.getName() + ")");
                        String field = eotg.getName();
                        Date future = e.getExpiration();
                        if (future == null) {
                            future = ConversionTime.addDay(e.getDay(), eot.getPeriodExpiration());
                        }
                        if (!future.after(new Date())) continue;
                        if (habilitationList.containsKey(eotg.getName())) {
                            String line = (String)habilitationList.get(field);
                            String cat = String.valueOf(driverData.get("CAT2_" + line));
                            driverData.put("CAT2_" + line, String.valueOf(cat) + "/" + eot.getCode());
                            Date date = ConversionTime.stringToDate(String.valueOf(driverData.get("DATE2_" + line)), "dd/MM/yyyy");
                            if (!future.before(date)) continue;
                            driverData.put("DATE2_" + line, ConversionTime.dateToString(e.getExpiration(), "dd/MM/yyyy"));
                            continue;
                        }
                        int habNum = habilitationList.size() + 1 + 1;
                        if (habNum > 10) {
                            TimsLogger.warn("#DrivingPermission.process# Max habilitation count reached");
                        }
                        habilitationList.put(eotg.getName(), String.valueOf(habNum));
                        driverData.put("FIELD2_" + habNum, field);
                        driverData.put("CAT2_" + habNum, eot.getCode());
                        driverData.put("DATE2_" + habNum, ConversionTime.dateToString(future, "dd/MM/yyyy"));
                    }
                    catch (DBObjectNotFoundException ex) {
                        TimsLogger.error("#DrivingPermission.process# type d'obligation " + e.getTypeId() + " ou groupe introuvable");
                    }
                }
                this.data.add(driverData);
                try {
                    this.afficheData();
                    this.loadReport(currentDriver, new JRMapCollectionDataSource(this.data));
                    this.data.clear();
                }
                catch (Exception ex) {
                    TimsLogger.warn("#DrivingPermission.process# An error occured while generating report for " + currentDriver.getNom());
                    if (Transport.debug < 1) break block31;
                    ex.printStackTrace();
                }
            }
            TimsLogger.debug("#DrivingPermission.process# C'est la fin du conducteur " + currentDriver.getNom());
            ++x;
        }
        this.generate();
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\nnew line : ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value) + "   ");
            }
        }
    }
}

