/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.TMDynamicExpenseReport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.Overviewable;
import transport.report.generator.DJExpensesGenerator;

public class DynamicAnalyticExpenses
extends DynamicGeneric
implements Overviewable {
    CustomReport customReport = null;

    public DynamicAnalyticExpenses() {
        this.setGenerator(new DJExpensesGenerator());
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicDriverExpenses.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getAnalyticExpensesDefault();
        this.userParameters.putAll(this.customReport.getProperties());
        this.customReport.getProperties().clear();
        this.customReport.getProperties().putAll(params);
    }

    @Override
    public void setCustomReport(CustomReport customReport) {
        this.customReport = customReport;
    }

    @Override
    public void process() throws Exception {
        boolean needBuild = false;
        if (this.data == null || this.data.size() == 0) {
            TimsLogger.debug("#DynamicDriverExpenses.process# Build during process");
            needBuild = true;
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.drivers.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        try {
            this.getGenerator().compile(this.userParameters);
        }
        catch (Exception ex) {
            TimsLogger.warn("#DynamicDriverExpenses.process# error on compilation");
            ex.printStackTrace();
            return;
        }
        Vector<Conducteur> toProcess = this.drivers.size() == 1 ? this.drivers : Conducteur.loadListWithArchive(this.agencies.size() != 1 ? 0 : ((Agence)this.agencies.get(0)).getCleAgence());
        int x = 0;
        while (x < toProcess.size()) {
            Conducteur conducteur = (Conducteur)toProcess.get(x);
            if (this.pb != null) {
                this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.process")) + " : " + conducteur.getNom() + " " + conducteur.getPrenom());
                this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            }
            if (needBuild) {
                this.buildOneDriver(conducteur);
            }
            ++x;
        }
        this.userParameters.put("NOM_CONDUCTEUR", LanguageTranslator.getString("generics.all"));
        this.userParameters.put("PRENOM_CONDUCTEUR", "");
        this.userParameters.put("AGENCE", LanguageTranslator.getString("generics.all"));
        this.load(new JRMapCollectionDataSource((Collection)this.data), this.reportName());
        if (this.pb != null) {
            this.pb.getBar().setString(LanguageTranslator.getString("generics.generation"));
        }
        this.generate();
        this.jasperPrintList.clear();
        this.data.clear();
    }

    public void buildOneDriver(Conducteur driver) {
        Transport.ps.startOperation();
        Vector<Service> serviceList = Service.getService(0, driver.getCleConducteur(), this.begin, this.end);
        Vector<DriverExpenses> expensesList = DriverExpenses.loadList(0, driver.getCleConducteur(), this.begin, this.end);
        Vector<VehicleUsed> vehicleUsed = VehicleUsed.loadListDriver(driver.getCleConducteur(), 0, this.begin, ConversionTime.addDay(this.end, 1));
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DDES.loadDriverExpenses# requ\u00eate DriverExpenses.loadList : " + expensesList.size() + " frais r\u00e9cup\u00e9r\u00e9s");
        Transport.ps.startOperation();
        if (this.data == null) {
            this.data = new ArrayList();
        }
        if (expensesList.size() != 0) {
            this.orderExpenses(serviceList, expensesList, vehicleUsed, driver);
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#TTS.loadActivite# calcul service");
    }

    public void orderExpenses(Vector<Service> services, Vector<DriverExpenses> list, Vector<VehicleUsed> vehicleUsed, Conducteur conducteur) {
        Agence agency = Agence.find(this.agencies, conducteur.getCleAgence());
        Transport.ps.startOperation();
        try {
            Date day = (Date)this.begin.clone();
            while (day.compareTo(this.end) <= 0) {
                int counter = 0;
                Float amount = Float.valueOf("0");
                HashMap<String, Object> deDetails = new HashMap<String, Object>();
                for (DriverExpenses toSet : DriverExpenses.find(list, conducteur.getCleConducteur(), day)) {
                    ExpensesType expenseType = ExpensesType.getExpenses(toSet.getExpensesId());
                    int currentValue = deDetails.get(String.valueOf(expenseType.getCode()) + "_COUNT") == null ? 0 : Integer.parseInt(deDetails.get(String.valueOf(expenseType.getCode()) + "_COUNT").toString());
                    deDetails.put(String.valueOf(expenseType.getCode()) + "_COUNT", currentValue + 1);
                    Float currentAmount = Float.valueOf(deDetails.get(String.valueOf(expenseType.getCode()) + "_AMOUNT") == null ? 0.0f : Float.parseFloat(deDetails.get(String.valueOf(expenseType.getCode()) + "_AMOUNT").toString()));
                    deDetails.put(String.valueOf(expenseType.getCode()) + "_AMOUNT", Float.valueOf(currentAmount.floatValue() + toSet.getAmount()));
                    ++counter;
                    amount = Float.valueOf(amount.floatValue() + toSet.getAmount());
                }
                if (counter != 0) {
                    Vector<Service> onDate = Service.find(services, conducteur.getCleConducteur(), day);
                    String borne = "";
                    for (Service serv : onDate) {
                        borne = String.valueOf(borne) + "<" + serv.getBeginDate() + ":::" + serv.getEndDate() + ">";
                    }
                    TimsLogger.debug("sur " + borne + "on a " + counter + " frais");
                    String immat = "";
                    for (VehicleUsed toSet : this.getVehicleUsedDuringService(onDate, vehicleUsed)) {
                        if (immat.contains(toSet.getImmatriculation())) continue;
                        immat = String.valueOf(immat) + ", " + toSet.getImmatriculation();
                    }
                    if (!immat.equals("")) {
                        deDetails.put(LanguageTranslator.getString("vehicle.registrationNumber"), immat.substring(2));
                    }
                    deDetails.put(LanguageTranslator.getString("generics.agency"), agency.getDescription());
                    deDetails.put(LanguageTranslator.getString("generics.driver"), String.valueOf(conducteur.getNom()) + " " + conducteur.getPrenom());
                    deDetails.put(LanguageTranslator.getString("user.registration"), conducteur.getMatricule());
                    deDetails.put(LanguageTranslator.getString("generics.date"), day);
                    deDetails.put(String.valueOf(LanguageTranslator.getString("generics.total")) + "_COUNT", counter);
                    deDetails.put(String.valueOf(LanguageTranslator.getString("generics.total")) + "_AMOUNT", amount);
                    this.data.add(deDetails);
                }
                day = ConversionTime.addDay(day, 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DDES.orderExpenses# end process");
    }

    public Vector<VehicleUsed> getVehicleUsedDuringService(Vector<Service> onDate, Vector<VehicleUsed> vehicleUsed) {
        String format = "yyyy-MM-dd HH:mm:ss";
        Vector<VehicleUsed> toReturn = new Vector<VehicleUsed>();
        block0: for (VehicleUsed toCheck : vehicleUsed) {
            for (Service service : onDate) {
                if (toCheck.getDateFin().getTime() < ConversionTime.stringToDate(service.getBeginDate(), format).getTime()) {
                    TimsLogger.debug(toCheck.getDateFin() + " avant " + service.getBeginDate());
                    continue;
                }
                if (toCheck.getDateDebut().getTime() - 60000L > ConversionTime.stringToDate(service.getEndDate(), format).getTime()) {
                    TimsLogger.debug(toCheck.getDateDebut() + " apres " + service.getEndDate());
                    continue block0;
                }
                TimsLogger.debug(toCheck.getDateDebut() + ":" + toCheck.getDateFin() + " is in service");
                toReturn.add(toCheck);
            }
        }
        return toReturn;
    }

    @Override
    public void showOverview(JTable table) {
        int x = 0;
        if (this.data == null || this.data.size() == 0) {
            int count = 0;
            while (count == 0) {
                try {
                    if (x >= this.drivers.size()) {
                        System.err.println("#DynamicDriverExpenses.showOverview# no overviewable datas available");
                        return;
                    }
                    this.buildOneDriver((Conducteur)this.drivers.get(x));
                    count = ((Map)this.data.get(x)).size();
                    ++x;
                }
                catch (Exception ex) {
                    TimsLogger.warn("#DynamicDriverExpenses.showOverview# build Error on ." + ((Conducteur)this.drivers.get(x)).getNom());
                    if (Transport.debug < 1) continue;
                    ex.printStackTrace();
                }
            }
        }
        TMDynamicExpenseReport model = new TMDynamicExpenseReport(this.customReport, this.customReport.getColumn(), this.data);
        table.setModel(model);
        this.data.clear();
    }
}

