/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.TMDynamicExpenseReport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.Overviewable;
import transport.report.generator.DJExpensesGenerator;

public class DynamicDriverExpenses
extends DynamicGeneric
implements Overviewable {
    Vector<ArrayList<Map<String, ?>>> data = null;
    CustomReport customReport = null;

    public DynamicDriverExpenses() {
        this.setGenerator(new DJExpensesGenerator());
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicDriverExpenses.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getDriverExpensesDefault();
        this.userParameters.putAll(this.customReport.getProperties());
        this.customReport.getProperties().clear();
        this.customReport.getProperties().putAll(params);
    }

    @Override
    public void setCustomReport(CustomReport customReport) {
        this.customReport = customReport;
    }

    @Override
    public void process() throws Exception {
        boolean needBuild = false;
        if (this.data == null || this.data.size() == 0) {
            TimsLogger.debug("#DynamicDriverExpenses.process# Build during process");
            needBuild = true;
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.drivers.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        try {
            this.getGenerator().compile(this.userParameters);
        }
        catch (Exception ex) {
            TimsLogger.warn("#DynamicDriverExpenses.process# error on compilation");
            ex.printStackTrace();
            return;
        }
        int x = 0;
        while (x < this.drivers.size()) {
            Conducteur conducteur = (Conducteur)this.drivers.get(x);
            if (needBuild) {
                this.buildOneDriver(conducteur);
            }
            if (this.data.get(x).size() != 0) {
                if (this.pb != null) {
                    this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.generation")) + " : " + conducteur.getNom() + " " + conducteur.getPrenom());
                    if (!needBuild) {
                        this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                    }
                }
                this.userParameters.put("NOM_CONDUCTEUR", conducteur.getNom());
                this.userParameters.put("PRENOM_CONDUCTEUR", conducteur.getPrenom());
                Agence driverAgency = Agence.find(this.agencies, conducteur.getCleAgence());
                this.userParameters.put("AGENCE", driverAgency == null ? LanguageTranslator.getString("generics.unknown") : driverAgency.getDescription());
                this.loadReport(conducteur, new JRMapCollectionDataSource((Collection)this.data.get(x)));
            }
            ++x;
        }
        if (this.pb != null) {
            this.pb.getBar().setString(LanguageTranslator.getString("generics.generation"));
        }
        this.generate();
        this.jasperPrintList.clear();
        this.data.clear();
    }

    public void buildData() {
        if (this.begin == null || this.end == null) {
            TimsLogger.warn("missing parameters begin or end");
            return;
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.drivers.size());
            this.pb.getBar().setMinimum(0);
        }
        for (Conducteur conducteur : this.drivers) {
            try {
                this.buildOneDriver(conducteur);
            }
            catch (Exception ex) {
                TimsLogger.warn("build Error on ." + conducteur.getNom());
                ex.printStackTrace();
            }
        }
    }

    public void buildOneDriver(Conducteur driver) {
        if (this.pb != null) {
            this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.process")) + driver.getNom() + " " + driver.getPrenom());
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
        }
        Transport.ps.startOperation();
        Vector<DriverExpenses> expensesList = DriverExpenses.loadList(0, driver.getCleConducteur(), this.begin, this.end);
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DDES.loadDriverExpenses# requ\u00eate DriverExpenses.loadList : " + expensesList.size() + " frais r\u00e9cup\u00e9r\u00e9s");
        Transport.ps.startOperation();
        if (this.data == null) {
            this.data = new Vector();
        }
        ArrayList oneDriverData = new ArrayList();
        this.data.add(oneDriverData);
        if (expensesList.size() != 0) {
            this.orderExpenses(expensesList, driver);
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#TTS.loadActivite# calcul service");
    }

    public void orderExpenses(Vector<DriverExpenses> list, Conducteur conducteur) {
        Transport.ps.startOperation();
        try {
            Date day = (Date)this.begin.clone();
            while (day.compareTo(this.end) <= 0) {
                int counter = 0;
                Float amount = Float.valueOf("0");
                HashMap<String, Comparable<Date>> deDetails = new HashMap<String, Comparable<Date>>();
                deDetails.put(LanguageTranslator.getString("generics.date"), day);
                for (DriverExpenses toSet : DriverExpenses.find(list, conducteur.getCleConducteur(), day)) {
                    ExpensesType expenseType = ExpensesType.getExpenses(toSet.getExpensesId());
                    int currentValue = deDetails.get(String.valueOf(expenseType.getCode()) + "_COUNT") == null ? 0 : Integer.parseInt(deDetails.get(String.valueOf(expenseType.getCode()) + "_COUNT").toString());
                    deDetails.put(String.valueOf(expenseType.getCode()) + "_COUNT", Integer.valueOf(currentValue + 1));
                    Float currentAmount = Float.valueOf(deDetails.get(String.valueOf(expenseType.getCode()) + "_AMOUNT") == null ? 0.0f : Float.parseFloat(deDetails.get(String.valueOf(expenseType.getCode()) + "_AMOUNT").toString()));
                    deDetails.put(String.valueOf(expenseType.getCode()) + "_AMOUNT", Float.valueOf(currentAmount.floatValue() + toSet.getAmount()));
                    ++counter;
                    amount = Float.valueOf(amount.floatValue() + toSet.getAmount());
                }
                deDetails.put(String.valueOf(LanguageTranslator.getString("generics.total")) + "_COUNT", Integer.valueOf(counter));
                deDetails.put(String.valueOf(LanguageTranslator.getString("generics.total")) + "_AMOUNT", amount);
                this.data.get(this.data.size() - 1).add(deDetails);
                day = ConversionTime.addDay(day, 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DDES.orderExpenses# end process");
    }

    @Override
    public void showOverview(JTable table) {
        int x = 0;
        if (this.data == null || this.data.size() == 0) {
            int count = 0;
            while (count == 0) {
                try {
                    if (x >= this.drivers.size()) {
                        TimsLogger.debug("#DynamicDriverExpenses.showOverview# no overviewable datas available");
                        return;
                    }
                    this.buildOneDriver((Conducteur)this.drivers.get(x));
                    count = this.data.get(x).size();
                    ++x;
                }
                catch (Exception ex) {
                    TimsLogger.warn("#DynamicDriverExpenses.showOverview# build Error on ." + ((Conducteur)this.drivers.get(x)).getNom());
                    ex.printStackTrace();
                }
            }
        }
        TMDynamicExpenseReport model = new TMDynamicExpenseReport(this.customReport, this.customReport.getColumn(), this.data.get(x - 1));
        table.setModel(model);
        this.data.clear();
    }
}

