/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.ExpensesNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.TMDynamicReport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.Overviewable;
import transport.report.generator.DJExpensesSynthesisGenerator;

public class DynamicExpenseSynthesis
extends DynamicGeneric
implements Overviewable {
    ArrayList<Map<String, ?>> data = null;
    CustomReport customReport = null;

    public DynamicExpenseSynthesis() {
        this.setGenerator(new DJExpensesSynthesisGenerator());
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicExpenseSynthesis.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getExpenseSynthesisDefault();
        this.userParameters.putAll(this.customReport.getProperties());
        this.customReport.getProperties().clear();
        this.customReport.getProperties().putAll(params);
    }

    @Override
    public void setCustomReport(CustomReport customReport) {
        this.customReport = customReport;
    }

    @Override
    public void process() throws Exception {
        boolean needBuild = false;
        if (this.data == null || this.data.size() == 0) {
            TimsLogger.debug("#DynamicExpensesSynthesis.process# Build during process. (" + this.agencies.size() + " agencies to build)");
            needBuild = true;
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.agencies.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        int x = 0;
        while (x < this.agencies.size()) {
            if (this.pb != null) {
                this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            }
            Agence agency = (Agence)this.agencies.get(x);
            if (needBuild) {
                this.buildOneAgency(agency, null);
            }
            if (this.data.size() != 0) {
                this.userParameters.put("AGENCE", agency.getDescription());
                if (this.pb != null) {
                    this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.generation")) + " : " + agency.getDescription());
                }
                this.loadReport(agency, new JRMapCollectionDataSource(this.data));
            }
            ++x;
        }
        if (this.pb != null) {
            this.pb.getBar().setString(LanguageTranslator.getString("generics.generation"));
        }
        if (this.data.size() == 0) {
            TimsLogger.debug("#DynamicExpensesSynthesis.process# no data");
        }
        this.generate();
        this.jasperPrintList.clear();
        this.data.clear();
    }

    public void buildData() throws Exception {
        if (this.begin == null || this.end == null) {
            TimsLogger.warn("missing parameters begin or end");
            return;
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.agencies.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        for (Agence agency : this.agencies) {
            try {
                this.buildOneAgency(agency, null);
            }
            catch (Exception ex) {
                TimsLogger.warn("build Error on ." + agency.getDescription());
                ex.printStackTrace();
            }
            if (this.data.size() == 0) continue;
            this.userParameters.put("AGENCE", agency.getDescription());
            this.loadReport(agency, new JRMapCollectionDataSource(this.data));
        }
    }

    public void buildOneAgency(Agence agency, Vector<DriverExpenses> expensesList) {
        Vector<Conducteur> toProcess;
        Vector<Conducteur> vector = toProcess = this.drivers.size() == 1 ? this.drivers : Conducteur.loadListWithArchive(agency.getCleAgence());
        if (this.data == null) {
            this.data = new ArrayList();
        }
        this.data.clear();
        if (this.pb != null) {
            this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.process")) + " : " + agency.getDescription());
        }
        if (expensesList == null) {
            Transport.ps.startOperation();
            expensesList = DriverExpenses.loadList(agency.getCleAgence(), toProcess.size() == 1 ? toProcess.get(0).getCleConducteur() : 0, this.begin, this.end);
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DES.buildOneAgency# requ\u00eate DriverExpenses.loadList : " + expensesList.size() + " frais r\u00e9cup\u00e9r\u00e9s");
        }
        Transport.ps.startOperation();
        int x = 0;
        while (x < toProcess.size()) {
            if (expensesList.size() == 0) {
                TimsLogger.debug("#ExpensisSynthesis.process# no expenses left...");
                break;
            }
            if (toProcess.get(x).getCleAgence() == agency.getCleAgence()) {
                Conducteur currentDriver = toProcess.get(x);
                TimsLogger.debug("#ExpensisSynthesis.process# C'est le d\u00e9but du conducteur " + currentDriver.getNom() + " (" + currentDriver.getCleConducteur() + ")");
                this.pb.getBar().setString(agency + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                HashMap<String, Object> driverLine = new HashMap<String, Object>();
                int counter = 0;
                Float amount = Float.valueOf("0");
                driverLine.put(LanguageTranslator.getString("generics.agency"), agency.getDescription());
                driverLine.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                while (expensesList.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                    try {
                        ExpensesType expenseType = ExpensesType.getExpenses(expensesList.get(0).getExpensesId());
                        String expensesName = expenseType.getCode();
                        int currentValue = driverLine.get(String.valueOf(expensesName) + "_COUNT") == null ? 0 : Integer.parseInt(driverLine.get(String.valueOf(expensesName) + "_COUNT").toString());
                        driverLine.put(String.valueOf(expensesName) + "_COUNT", currentValue + 1);
                        Float currentAmount = Float.valueOf(driverLine.get(String.valueOf(expensesName) + "_AMOUNT") == null ? 0.0f : Float.parseFloat(driverLine.get(String.valueOf(expensesName) + "_AMOUNT").toString()));
                        driverLine.put(String.valueOf(expensesName) + "_AMOUNT", Float.valueOf(currentAmount.floatValue() + expensesList.get(0).getAmount()));
                        ++counter;
                        amount = Float.valueOf(amount.floatValue() + expensesList.get(0).getAmount());
                    }
                    catch (ExpensesNotFoundException ex) {
                        TimsLogger.warn("Type de frais non trouv\u00e9 " + expensesList.get(0).getExpensesId());
                    }
                    expensesList.remove(0);
                    if (expensesList.size() == 0) break;
                }
                driverLine.put(String.valueOf(LanguageTranslator.getString("generics.total")) + "_COUNT", counter);
                driverLine.put(String.valueOf(LanguageTranslator.getString("generics.total")) + "_AMOUNT", amount);
                if (counter != 0) {
                    this.data.add(driverLine);
                }
                TimsLogger.debug("#ExpensisSynthesis.process# C'est la fin du conducteur " + currentDriver.getNom());
            }
            ++x;
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DES.buildOneAgency# build one agency");
    }

    @Override
    public void showOverview(JTable table) {
        int x = 0;
        if (this.data == null || this.data.size() == 0) {
            int count = 0;
            while (count == 0) {
                try {
                    if (x >= this.agencies.size()) {
                        System.err.println("#DynamicDriverExpenses.showOverview# no overviewable datas available");
                        return;
                    }
                    this.buildOneAgency((Agence)this.agencies.get(x), null);
                    count = this.data.get(x).size();
                    ++x;
                }
                catch (Exception ex) {
                    TimsLogger.warn("#DynamicDriverExpenses.showOverview# build Error on ." + ((Conducteur)this.drivers.get(x)).getNom());
                    ex.printStackTrace();
                }
            }
        }
        TMDynamicReport model = new TMDynamicReport(this.customReport, this.customReport.getColumn(), this.data);
        table.setModel(model);
        this.data.clear();
    }
}

