/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.MasterReport;
import transport.report.generator.DJGenerator;

public class DynamicGeneric
extends MasterReport {
    protected ArrayList<Map<String, ?>> data = null;
    protected CustomReport customReport = null;

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicDriverExpenses.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        if (this.customReport == null) {
            this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getGeneric(LanguageTranslator.getString("generics.customReport"));
        }
    }

    @Override
    public String reportName() {
        if (this.report == null) {
            return String.valueOf(this.customReport.getName()) + (this.agencies == null || this.agencies.size() != 1 ? "" : " - " + ((Agence)this.agencies.get(0)).getDescription()) + (this.drivers == null || this.drivers.size() != 1 ? "" : " - " + ((Conducteur)this.drivers.get(0)).getNom() + " " + ((Conducteur)this.drivers.get(0)).getPrenom());
        }
        return super.reportName();
    }

    public CustomReport getCustomReport() {
        return this.customReport;
    }

    public void setCustomReport(CustomReport customReport) {
        this.customReport = customReport;
        if (customReport != null && customReport.getProperties() != null) {
            this.getUserParameter().putAll(customReport.getProperties());
        }
    }

    public void setData(ArrayList<Map<String, ?>> data) {
        this.data = data;
    }

    public void setGenerator(DJGenerator generator) {
        this.generator = generator;
    }

    @Override
    public void process() throws Exception {
        if (this.data == null || this.data.size() == 0) {
            TimsLogger.info("#DynamicGeneric.process# no datas, we don't know what to build");
            return;
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        this.getUserParameter().put("TITLE", this.getCustomReport().getName());
        this.getGenerator().setReport(this.getCustomReport());
        this.getGenerator().prebuild();
        if (this.pb != null) {
            this.pb.getBar().setString(LanguageTranslator.getString("generics.generation"));
        }
        this.load(new JRMapCollectionDataSource(this.data), this.getCustomReport().getName());
        this.generate();
        this.jasperPrintList.clear();
        this.data.clear();
    }

    public void print() {
        if (this.data == null) {
            TimsLogger.warn("#DynamicGeneric.print# nothing to print");
            return;
        }
        int x = 0;
        while (x < this.data.size()) {
            Map<String, ?> datas = this.data.get(x);
            for (Map.Entry<String, ?> tmp : datas.entrySet()) {
                System.out.print(String.valueOf(tmp.getKey()) + " => " + tmp.getValue() + " ; ");
            }
            ++x;
        }
    }
}

