/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.Hardness;
import fr.pgh.data.bdd.HardnessAttribution;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGenerator;

public class DynamicHardnessCounter
extends DynamicGeneric {
    private Vector<HardnessAttribution> attributions = null;

    public DynamicHardnessCounter() {
        this.setGenerator(new DJGenerator());
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicService.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getDefaultHardnessReport();
        this.userParameters.putAll(this.customReport.getProperties());
        this.customReport.getProperties().clear();
        this.customReport.getProperties().putAll(params);
        this.customReport.getProperties().put("TEMPLATE", "report/" + report.getFileName());
    }

    @Override
    public void setCustomReport(CustomReport customReport) {
        this.customReport = customReport;
    }

    public void showOverview(JTable table) {
        int x = 0;
        if (this.data == null || this.data.size() == 0) {
            this.dataInitialization();
            int serviceCount = 0;
            while (serviceCount == 0) {
                try {
                    if (x >= this.drivers.size()) {
                        System.err.println("#DynamicHardness.showOverview# no overviewable datas available");
                        return;
                    }
                    this.buildOneDriver((Conducteur)this.drivers.get(x));
                    serviceCount = this.data.size();
                    ++x;
                }
                catch (Exception ex) {
                    TimsLogger.warn("#DynamicHardness.showOverview# build Error on ." + ((Conducteur)this.drivers.get(x)).getNom());
                    ex.printStackTrace();
                }
            }
        }
        this.data.clear();
    }

    @Override
    public void process() throws Exception {
        if (this.getGenerator() == null) {
            TimsLogger.debug("#DynService.process# no generator defined, set DJServiceGenerator");
            this.setGenerator(new DJGenerator());
        }
        boolean needBuild = false;
        if (this.data == null || this.data.size() == 0) {
            TimsLogger.debug("#DynamicService.process# Build during process");
            needBuild = true;
        }
        if (needBuild) {
            this.dataInitialization();
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.drivers.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        try {
            this.getGenerator().compile(this.userParameters);
        }
        catch (Exception ex) {
            TimsLogger.warn("#DynamucService.process# error on compilation");
            ex.printStackTrace();
            return;
        }
        int x = 0;
        while (x < this.drivers.size()) {
            Conducteur conducteur = (Conducteur)this.drivers.get(x);
            if (needBuild) {
                try {
                    this.buildOneDriver(conducteur);
                }
                catch (Exception ex) {
                    TimsLogger.warn("build Error on ." + conducteur.getNom());
                    ex.printStackTrace();
                }
            }
            if (this.pb != null) {
                this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.generation")) + " : " + conducteur.getNom() + " " + conducteur.getPrenom());
                if (!needBuild) {
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                }
            }
            ++x;
        }
        if (this.pb != null) {
            this.pb.getBar().setString(LanguageTranslator.getString("generics.generation"));
        }
        TimsLogger.debug("on va construire le rapport " + this.customReport.getName());
        this.load(new JRMapCollectionDataSource((Collection)this.data), this.customReport.getName());
        this.print();
        this.generate();
        this.jasperPrintList.clear();
        this.data.clear();
    }

    public void buildData() {
        if (this.begin == null || this.end == null) {
            TimsLogger.warn("missing parameters begin or end");
            return;
        }
        this.dataInitialization();
        for (Conducteur conducteur : this.drivers) {
            try {
                this.buildOneDriver(conducteur);
            }
            catch (Exception ex) {
                TimsLogger.warn("build Error on ." + conducteur.getNom());
                ex.printStackTrace();
            }
        }
    }

    public void dataInitialization() {
        this.attributions = HardnessAttribution.loadList(ConversionTime.dateToString(this.begin, "yyyy"));
    }

    public int buildOneDriver(Conducteur toBuild) throws Exception {
        if (this.pb != null) {
            this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.process")) + toBuild.getNom() + " " + toBuild.getPrenom());
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
        }
        if (this.data == null) {
            this.data = new ArrayList();
        }
        int count = 0;
        HashMap<String, Object> toPut = new HashMap<String, Object>();
        toPut.put(LanguageTranslator.getString("generics.driver"), String.valueOf(toBuild.getNom()) + " " + toBuild.getPrenom());
        for (Hardness hardness : Hardness.getList()) {
            toPut.put(hardness.getCode(), 0);
        }
        for (HardnessAttribution attribution : this.attributions) {
            if (attribution.getDriverId() != toBuild.getCleConducteur()) continue;
            Hardness toFill = Hardness.find(null, attribution.getHardnessId());
            toPut.put(toFill.getCode(), attribution.getCounter());
            if (!attribution.isAttribution()) continue;
            ++count;
        }
        toPut.put(LanguageTranslator.getString("generics.total"), count);
        this.data.add(toPut);
        return this.data.size();
    }
}

