/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceType;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.TMDynamicReport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.Overviewable;
import transport.report.generator.DJGenerator;

public class DynamicOffenceChallenge
extends DynamicGeneric
implements Overviewable {
    ArrayList<Map<String, ?>> data = null;
    CustomReport customReport = null;

    public DynamicOffenceChallenge() {
        this.setGenerator(new DJGenerator());
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicOffenceChallenge.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getOffenceChallengeDefault();
        this.userParameters.putAll(this.customReport.getProperties());
        this.customReport.getProperties().clear();
        this.customReport.getProperties().putAll(params);
        TimsLogger.debug("DynamicOffenceChallenge.setValues#" + report.getFileName());
        this.customReport.getProperties().put("TEMPLATE", "report/" + report.getFileName());
    }

    @Override
    public void setCustomReport(CustomReport customReport) {
        this.customReport = customReport;
    }

    @Override
    public void process() throws Exception {
        boolean needBuild = false;
        if (this.data == null || this.data.size() == 0) {
            TimsLogger.debug("#DynamicOffenceChallenge.process# Build during process. (" + this.agencies.size() + " agencies to build)");
            needBuild = true;
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.agencies.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        int x = 0;
        while (x < this.agencies.size()) {
            if (this.pb != null) {
                this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            }
            Agence agency = (Agence)this.agencies.get(x);
            if (needBuild) {
                this.buildOneAgency(agency, null);
            }
            if (this.data.size() != 0) {
                this.userParameters.put("AGENCE", agency.getDescription());
                if (this.pb != null) {
                    this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.generation")) + " : " + agency.getDescription());
                }
                this.loadReport(agency, new JRMapCollectionDataSource(this.data));
            }
            ++x;
        }
        if (this.pb != null) {
            this.pb.getBar().setString(LanguageTranslator.getString("generics.generation"));
        }
        if (this.data.size() == 0) {
            TimsLogger.debug("#DynamicOffenceChallenge.process# no data");
        }
        this.generate();
        this.jasperPrintList.clear();
        this.data.clear();
    }

    public void buildData() throws Exception {
        if (this.begin == null || this.end == null) {
            TimsLogger.warn("DynamicOffenceChallenge # missing parameters begin or end");
            return;
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.agencies.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        for (Agence agency : this.agencies) {
            try {
                this.buildOneAgency(agency, null);
            }
            catch (Exception ex) {
                TimsLogger.warn("DynamicOffenceChallenge # build Error on ." + agency.getDescription());
                ex.printStackTrace();
            }
            if (this.data.size() == 0) continue;
            this.userParameters.put("AGENCE", agency.getDescription());
            this.loadReport(agency, new JRMapCollectionDataSource(this.data));
        }
    }

    public void buildOneAgency(Agence agency, Vector<Offence> offences) {
        Vector<Conducteur> toProcess;
        Vector<Conducteur> vector = toProcess = this.drivers.size() == 1 ? this.drivers : Conducteur.loadListWithArchive(agency.getCleAgence());
        if (this.data == null) {
            this.data = new ArrayList();
        }
        this.data.clear();
        if (this.pb != null) {
            this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.process")) + " : " + agency.getDescription());
        }
        if (offences == null) {
            Transport.ps.startOperation();
            offences = Offence.loadList(agency.getCleAgence(), this.drivers.size() == 1 ? ((Conducteur)this.drivers.get(0)).getCleConducteur() : 0, ConversionTime.dateToString(this.begin, "yyyy-MM-dd"), ConversionTime.dateToString(this.end, "yyyy-MM-dd"), "1".equals(this.userParameters.get("BRUTE")), true);
            TimsLogger.debug("#OffenceChallenge.buildOneAgency# brute = " + this.userParameters.get("BRUTE"));
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "#OffenceSynthesis.buildOneAgency# " + offences.size() + " infractions r\u00e9cup\u00e9r\u00e9s");
        }
        Transport.ps.startOperation();
        int x = 0;
        while (x < toProcess.size()) {
            if (toProcess.get(x).getCleAgence() == agency.getCleAgence()) {
                Conducteur currentDriver = toProcess.get(x);
                TimsLogger.debug("#DynamicOffenceChallenge.process# C'est le d\u00e9but du conducteur " + currentDriver.getNom() + " (" + currentDriver.getCleConducteur() + ")");
                this.pb.getBar().setString(agency + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                HashMap<String, Object> driverLine = new HashMap<String, Object>();
                int driverTotal = 0;
                driverLine.put(LanguageTranslator.getString("generics.agency"), agency.getDescription());
                driverLine.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                driverLine.put(LanguageTranslator.getString("user.registration"), currentDriver.getMatricule());
                for (OffenceType tmp : OffenceType.getList()) {
                    driverLine.put(LanguageTranslator.getString(tmp.getName()), 0);
                }
                if (offences.size() != 0) {
                    while (offences.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                        try {
                            Offence off = offences.get(0);
                            if (off.getType() != 0) {
                                OffencePart part = OffencePart.getOffencePart(off.getOffencePartId());
                                OffenceType type = OffenceType.getOffenceType(part.getOffenceTypeId());
                                String offenceName = LanguageTranslator.getString(type.getName());
                                driverLine.put(offenceName, Integer.parseInt(driverLine.get(offenceName).toString()) + 1);
                                ++driverTotal;
                            }
                        }
                        catch (Exception ex) {
                            TimsLogger.warn("Type d'infractions non trouv\u00e9 " + offences.get(0).getOffencePartId());
                            ex.printStackTrace();
                        }
                        offences.remove(0);
                        if (offences.size() == 0) break;
                    }
                }
                driverLine.put(LanguageTranslator.getString("generics.total"), driverTotal);
                Fonctions.afficheMap(driverLine);
                if (!currentDriver.isArchive() || driverTotal != 0) {
                    this.data.add(driverLine);
                } else {
                    TimsLogger.debug("#DynamicOffenceChallenge.process# on ignore, (archive et 0 infractions)");
                }
                TimsLogger.debug("#DynamicOffenceChallenge.process# C'est la fin du conducteur " + currentDriver.getNom());
            }
            ++x;
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DES.buildOneAgency# build one agency");
    }

    @Override
    public void showOverview(JTable table) {
        int x = 0;
        if (this.data == null || this.data.size() == 0) {
            int count = 0;
            while (count == 0) {
                try {
                    if (x >= this.agencies.size()) {
                        TimsLogger.error("#DynamicOffenceChallenge.showOverview# no overviewable datas available");
                        return;
                    }
                    this.buildOneAgency((Agence)this.agencies.get(x), null);
                    count = this.data.get(x).size();
                    ++x;
                }
                catch (Exception ex) {
                    TimsLogger.warn("#DynamicOffenceChallenge.showOverview# build Error on ." + ((Conducteur)this.drivers.get(x)).getNom());
                    ex.printStackTrace();
                }
            }
        }
        TMDynamicReport model = new TMDynamicReport(this.customReport, this.customReport.getColumn(), this.data);
        table.setModel(model);
        this.data.clear();
    }
}

