/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.data.bdd.Vehicule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.modele.TMDynamicReport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJServiceGenerator;

public class DynamicService
extends DynamicGeneric {
    public static final int SEUIL_RJ = 540;
    public static final int DAY = 7;
    private String analysisBegin = null;
    private String analysisEnd = null;
    private Vector<ActiviteConducteur> activities = null;
    private Vector<LienJourConducteur> missing = null;
    private Vector<DriverExpenses> expenses = null;
    boolean lastActivityProcessed = false;
    private Vector<ArrayList<Map<String, ?>>> data = null;
    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    GregorianCalendar calendrier = new GregorianCalendar();
    private int avgValue = -1;

    public DynamicService() {
        this.setGenerator(new DJServiceGenerator());
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicService.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getDriverServiceDefault();
        this.userParameters.putAll(this.customReport.getProperties());
        this.customReport.getProperties().clear();
        this.customReport.getProperties().putAll(params);
    }

    @Override
    public void setCustomReport(CustomReport customReport) {
        this.customReport = customReport;
    }

    public void showOverview(JTable table) {
        int x = 0;
        if (this.data == null || this.data.size() == 0) {
            this.dataInitialization();
            int serviceCount = 0;
            while (serviceCount == 0) {
                try {
                    if (x >= this.drivers.size()) {
                        System.err.println("#DynamicService.showOverview# no overviewable datas available");
                        return;
                    }
                    TypeContrat driverContract = TypeContrat.getContractType(TypeContrat.getList(), ((Conducteur)this.drivers.get(x)).getCleTypeContrat());
                    this.buildOneDriver((Conducteur)this.drivers.get(x), driverContract);
                    serviceCount = this.data.get(x).size();
                    ++x;
                }
                catch (Exception ex) {
                    TimsLogger.warn("#DynamicService.showOverview# build Error on ." + ((Conducteur)this.drivers.get(x)).getNom());
                    ex.printStackTrace();
                }
            }
        }
        TMDynamicReport model = new TMDynamicReport(this.customReport, this.customReport.getColumn(), this.data.get(x - 1));
        table.setModel(model);
        this.data.clear();
    }

    @Override
    public void process() throws Exception {
        if (this.getGenerator() == null) {
            TimsLogger.debug("#DynService.process# no generator defined, set DJServiceGenerator");
            this.setGenerator(new DJServiceGenerator());
        }
        boolean needBuild = false;
        if (this.data == null || this.data.size() == 0) {
            TimsLogger.debug("#DynamicService.process# Build during process");
            needBuild = true;
        }
        if (needBuild) {
            this.dataInitialization();
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.drivers.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        try {
            this.getGenerator().compile(this.userParameters);
        }
        catch (Exception ex) {
            TimsLogger.warn("#DynamucService.process# error on compilation");
            ex.printStackTrace();
            return;
        }
        int x = 0;
        while (x < this.drivers.size()) {
            block13: {
                Conducteur conducteur = (Conducteur)this.drivers.get(x);
                if (this.pb != null) {
                    this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.generation")) + " : " + conducteur.getNom() + " " + conducteur.getPrenom());
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                }
                if (needBuild) {
                    try {
                        TypeContrat driverContract = TypeContrat.getContractType(TypeContrat.getList(), conducteur.getCleTypeContrat());
                        this.buildOneDriver(conducteur, driverContract);
                    }
                    catch (Exception ex) {
                        TimsLogger.warn("No contract type for " + conducteur.getNom());
                        this.drivers.remove(x);
                        this.warningList.add(conducteur);
                        --x;
                        break block13;
                    }
                }
                if (this.data.get(x).size() != 0) {
                    TimsLogger.debug("on va construire le rapport " + this.customReport.getName());
                    this.getUserParameter().put("HN_THRESHOLD", 100);
                    this.getUserParameter().put("HE_THRESHOLD", 1000);
                    this.getUserParameter().put("HS_THRESHOLD", 5000);
                    this.loadReport(conducteur, new JRMapCollectionDataSource((Collection)this.data.get(x)));
                }
            }
            ++x;
        }
        if (this.pb != null) {
            this.pb.getBar().setString(LanguageTranslator.getString("generics.generation"));
        }
        this.print();
        this.generate();
        this.jasperPrintList.clear();
        this.data.clear();
    }

    public void buildData() {
        if (this.begin == null || this.end == null) {
            TimsLogger.warn("missing parameters begin or end");
            return;
        }
        this.dataInitialization();
        for (Conducteur conducteur : this.drivers) {
            if (this.pb != null) {
                this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.generation")) + " : " + conducteur.getNom() + " " + conducteur.getPrenom());
                this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            }
            try {
                TypeContrat driverContract = TypeContrat.getContractType(TypeContrat.getList(), conducteur.getCleTypeContrat());
                this.buildOneDriver(conducteur, driverContract);
            }
            catch (Exception ex) {
                TimsLogger.warn("build Error on ." + conducteur.getNom());
                this.drivers.remove(conducteur);
                this.warningList.add(conducteur);
                ex.printStackTrace();
            }
        }
    }

    public void dataInitialization() {
        this.expenses = new Vector();
        this.activities = new Vector();
        this.missing = new Vector();
        this.calendrier.setTime(this.begin);
        this.calendrier.add(5, -7);
        this.analysisBegin = this.dateFormat.format(this.calendrier.getTime());
        this.calendrier.setTime(this.end);
        this.calendrier.add(5, 7);
        this.analysisEnd = this.dateFormat.format(this.calendrier.getTime());
    }

    public int buildOneDriver(Conducteur toBuild, TypeContrat driverContract) throws Exception {
        if (this.data == null) {
            this.data = new Vector();
        }
        ArrayList serviceList = new ArrayList();
        this.data.add(serviceList);
        this.activities.clear();
        Vector<ActiviteConducteur> calculActiviteTmp = Transport.bdd.getActivite(toBuild.getCleConducteur(), this.analysisBegin, this.analysisEnd, -1, 0);
        Transport.ps.startOperation();
        this.missing = LienJourConducteur.loadList(0, toBuild.getCleConducteur(), this.begin, this.end);
        if (toBuild.getCalendarId() != 0) {
            this.missing.addAll(GlobalCalendarDay.toLJC(GlobalCalendarDay.loadList(toBuild.getCalendarId(), this.begin, this.end), toBuild.getCleConducteur()));
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DynamicService.buildData()# requ\u00eate LienJourConducteur : " + this.missing.size() + " jours r\u00e9cup\u00e9r\u00e9s", "#DynamicService.buildData()# requ\u00eate LienJourConducteur : " + this.missing.size() + " jours r\u00e9cup\u00e9r\u00e9s", 1);
        Transport.ps.startOperation();
        this.expenses = DriverExpenses.loadList(0, toBuild.getCleConducteur(), this.begin, this.end);
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DynamicService.buildData()# requ\u00eate DriverExpenses : " + this.expenses.size() + " frais r\u00e9cup\u00e9r\u00e9s", "#DynamicService.buildData()# requ\u00eate DriverExpenses : " + this.expenses.size() + " frais r\u00e9cup\u00e9r\u00e9s", 1);
        if (calculActiviteTmp.size() != 0) {
            Transport.ps.startOperation();
            this.calendrier.setTime(this.dateFormat.parse(this.analysisBegin));
            ActiviteConducteur act = null;
            int i = 0;
            while (i < calculActiviteTmp.size() - 1) {
                act = calculActiviteTmp.get(i);
                while (this.calendrier.getTime().compareTo(act.getDate()) < 0) {
                    this.activities.add(new ActiviteConducteur(0, toBuild.getCleConducteur(), 0, 4, "REPOS", "", 0, 1440, 1440, this.dateFormat.format(this.calendrier.getTime()), "", "", "", "", "", 0, 0, 0));
                    this.calendrier.add(5, 1);
                }
                while (act.getDate().equals(this.calendrier.getTime()) && i < calculActiviteTmp.size() - 1) {
                    this.activities.add(act);
                    act = calculActiviteTmp.get(++i);
                }
                this.calendrier.add(5, 1);
            }
            this.activities.add(act);
            while (this.calendrier.getTime().compareTo(ConversionTime.stringToDate(this.analysisEnd, "yyyy-MM-dd")) < 0) {
                this.activities.add(new ActiviteConducteur(0, toBuild.getCleConducteur(), 0, 4, "REPOS", "", 0, 1440, 1440, this.dateFormat.format(this.calendrier.getTime()), "", "", "", "", "", 0, 0, 0));
                this.calendrier.add(5, 1);
            }
            TimsLogger.debug(String.valueOf(this.activities.size()) + " activit\u00e9s");
            this.calculService(0, toBuild, null, driverContract);
            this.avgValue = -1;
            Transport.ps.endOperation(PerformanceScanner.PROCESS, "#TTS.loadActivite# calcul service");
        }
        return this.data.get(this.data.size() - 1).size();
    }

    /*
     * Unable to fully structure code
     */
    public void calculService(int beginOffset, Conducteur conducteur, Date previousServiceBegin, TypeContrat contract) {
        TimsLogger.info("\r\n#DS.calculService#new service at " + beginOffset + " ==>");
        activitiesDetails = new HashMap<String, Object>();
        forceLast = false;
        Transport.ps.startOperation();
        try {
            numActiviteFin = this.activities.size() - 1;
            amplitude = 0;
            heureNuit = 0;
            repos = 0;
            service = 0;
            missingHS = 0;
            missingPaid = 0;
            x = beginOffset;
            while (x < this.activities.size()) {
                block48: {
                    TimsLogger.debug(" :: x=" + x);
                    if (x == this.activities.size() - 1) {
                        this.lastActivityProcessed = true;
                    }
                    currentValue = activitiesDetails.get((typeAct = TypeActivite.getActivityType((activite = this.activities.get(x)).getCleType())).getName()) == null ? 0 : Integer.parseInt(activitiesDetails.get(typeAct.getName()).toString());
                    activitiesDetails.put(typeAct.getName(), currentValue + activite.getDuree());
                    if (!typeAct.isRest()) {
                        heureNuit += Fonctions.getTempsNuit(activite);
                        numActiviteFin = x;
                    }
                    if (typeAct.isRest() && !forceLast) {
                        TimsLogger.debug(", rest x=" + x);
                        repos = this.restLength(x);
                        TimsLogger.debug(" (" + repos + ") ");
                    }
                    if (repos < 540 && x != this.activities.size() - 1) break block48;
                    TimsLogger.info("\r\nService end at " + x + ". service detail => begin " + this.activities.get(beginOffset).getDateJour() + " " + this.activities.get(beginOffset).getHeureDebut() + ", end " + this.activities.get(numActiviteFin).getDateJour() + " " + this.activities.get(numActiviteFin).getHeureFin() + " :: ");
                    x = this.endRestIndex(x);
                    if (x != this.activities.size() - 1 || repos >= 540 || forceLast) ** GOTO lbl37
                    if (!this.lastActivityProcessed) {
                        forceLast = true;
                        --x;
                    } else {
                        numActiviteFin = this.activities.size() - 1;
lbl37:
                        // 2 sources

                        heureDebut = this.activities.get(beginOffset).getHeureDebut();
                        heureFin = this.activities.get(numActiviteFin).getHeureFin();
                        serviceBegin = String.valueOf(this.activities.get(beginOffset).getDateJour()) + " " + ConversionTime.heureIntToString(heureDebut, ":");
                        serviceEnd = String.valueOf(this.activities.get(numActiviteFin).getDateJour()) + " " + ConversionTime.heureIntToString(heureFin, ":");
                        truncatedBegin = ConversionTime.stringToDate(this.activities.get(beginOffset).getDateJour(), "yyyy-MM-dd");
                        begin = ConversionTime.stringToDate(serviceBegin, "yyyy-MM-dd HH:mm");
                        end = ConversionTime.stringToDate(serviceEnd, "yyyy-MM-dd HH:mm");
                        if (heureFin == 1440) {
                            serviceEnd = String.valueOf(ConversionTime.addDay(serviceEnd, "yyyy-MM-dd", 1)) + " 00:00";
                            heureFin = 0;
                        }
                        if (begin.compareTo(ConversionTime.addDay(this.end, 1)) >= 0) {
                            x = this.activities.size();
                            truncatedBegin = ConversionTime.dateTruncate(previousServiceBegin);
                            TimsLogger.debug(" :: on est \u00e0 la fin (service apr\u00e8s end) :: ");
                        } else if (begin.before(this.begin)) {
                            TimsLogger.debug(" :: on n'est pas encore au d\u00e9but, on n'enregistre pas : " + begin + " < " + this.begin + " :: ");
                        } else {
                            for (TypeActivite act : TypeActivite.getList()) {
                                v0 = val = activitiesDetails.get(act.getName()) == null ? 0 : Integer.parseInt(activitiesDetails.get(act.getName()).toString());
                                if (val == 0 || act.getPaidPercentage() == 0) continue;
                                activitiesDetails.put(act.getName(), act.isShowPaid() != false ? val * act.getPaidPercentage() / 100 : val);
                                if (act.isRest()) continue;
                                service += act.getPaidPercentage() * val / 100;
                            }
                            amplitude = heureFin - heureDebut;
                            distance = Transport.bdd.getKmJour(serviceBegin, conducteur.getCleConducteur(), 0);
                            activitiesDetails.put(LanguageTranslator.getString("generics.km"), distance);
                            activitiesDetails.put(LanguageTranslator.getString("activity.amplitude"), amplitude += ConversionTime.getNbJourBetween(serviceBegin, serviceEnd, "yyyy-MM-dd") * 1440);
                            activitiesDetails.put(LanguageTranslator.getString("generics.serviceTotal"), service);
                            activitiesDetails.put(LanguageTranslator.getString("generics.nightTime"), heureNuit);
                            activitiesDetails.put(LanguageTranslator.getString("generics.begin"), begin);
                            activitiesDetails.put(LanguageTranslator.getString("generics.end"), end);
                            activitiesDetails.put("SEMAINE", ConversionTime.getWeek(serviceBegin, "yyyy-MM-dd HH:mm"));
                            if (System.getProperty("company.type", "1").equals("2")) {
                                deName = TypeActivite.getActivityType(5).getName();
                                de = activitiesDetails.get(deName) == null ? 0 : Integer.parseInt(activitiesDetails.get(deName).toString());
                                ampliRem = amplitude > 720 && de == 0 ? amplitude - 720 : 0;
                                activitiesDetails.put(LanguageTranslator.getString("activity.deIndemnisation"), de);
                                activitiesDetails.put(LanguageTranslator.getString("activity.amplitudeIndemnisation"), ampliRem);
                            }
                            if (previousServiceBegin == null || !previousServiceBegin.equals(truncatedBegin)) {
                                TimsLogger.debug(" : seek expenses on this day " + truncatedBegin);
                                missingDesignation = "";
                                missingTime = 0;
                                expenseAmount = new Float(0.0f);
                                for (DriverExpenses de : DriverExpenses.find(this.expenses, conducteur.getCleConducteur(), truncatedBegin)) {
                                    expenseAmount = Float.valueOf(expenseAmount.floatValue() + de.getAmount());
                                }
                                toAdd = LienJourConducteur.find(this.missing, conducteur.getCleConducteur(), truncatedBegin);
                                if (toAdd.size() != 0) {
                                    for (LienJourConducteur ljc : toAdd) {
                                        tmp = JourType.getDayType(ljc.getCleJourType());
                                        length = ljc.getDuree(contract.getDailyValue());
                                        if (tmp.isAvgValue() && ljc.getType() == 2 && length < this.getAvgValue(conducteur)) {
                                            length = this.getAvgValue(conducteur);
                                        }
                                        if (tmp.getCode().equals("JF") && System.getProperty("company.type", "1").equals("2")) {
                                            activitiesDetails.put(LanguageTranslator.getString("activity.jfIndemnisation"), service);
                                        }
                                        if (ljc.getType() == 2 && tmp.isServiceIncluded()) {
                                            TimsLogger.debug("#DS.calculService# On remet \u00e0 0 le service...");
                                            service = 0;
                                        }
                                        missingDesignation = String.valueOf(missingDesignation) + ";" + tmp.getCode();
                                        missingTime += length;
                                        if (!tmp.shouldPay(conducteur, ljc.getDateJour())) continue;
                                        if (tmp.isPaid()) {
                                            missingPaid += length;
                                        }
                                        if (!tmp.isGenerateHS()) continue;
                                        missingHS += length;
                                    }
                                }
                                if (missingDesignation != "") {
                                    activitiesDetails.put(LanguageTranslator.getString("generics.missing"), missingDesignation.length() != 0 ? missingDesignation.substring(1) : "");
                                    activitiesDetails.put(LanguageTranslator.getString("generics.missingTime"), missingTime);
                                }
                                if (expenseAmount.floatValue() != 0.0f) {
                                    activitiesDetails.put(LanguageTranslator.getString("generics.expenses"), expenseAmount);
                                }
                            }
                            activitiesDetails.put(LanguageTranslator.getString("generics.totalPaid"), missingPaid + service);
                            activitiesDetails.put(LanguageTranslator.getString("generics.totalHS"), missingHS + service);
                            activitiesDetails.put(LanguageTranslator.getString("generics.contract"), contract.getContractGroup(truncatedBegin));
                            if (previousServiceBegin == null || previousServiceBegin.after(truncatedBegin) || previousServiceBegin.equals(truncatedBegin)) {
                                System.err.println("#DynamicService.calculService# le dernier service est anormal (null ou apr\u00e8s le service en cours");
                            } else {
                                previousServiceBegin = ConversionTime.addDay(previousServiceBegin, 1);
                                while (previousServiceBegin.before(truncatedBegin)) {
                                    TimsLogger.debug(" :seek expenses and missing on previous day " + previousServiceBegin);
                                    missingDesignation = "";
                                    betweenTime = 0;
                                    betweenPaid = 0;
                                    betweenHS = 0;
                                    expenseAmount = new Float(0.0f);
                                    for (DriverExpenses de : DriverExpenses.find(this.expenses, conducteur.getCleConducteur(), previousServiceBegin)) {
                                        expenseAmount = Float.valueOf(expenseAmount.floatValue() + de.getAmount());
                                    }
                                    toAdd = LienJourConducteur.find(this.missing, conducteur.getCleConducteur(), previousServiceBegin);
                                    if (toAdd.size() != 0) {
                                        for (LienJourConducteur ljc : toAdd) {
                                            tmp = JourType.getDayType(ljc.getCleJourType());
                                            length = ljc.getDuree(contract.getDailyValue());
                                            if (tmp.isAvgValue() && ljc.getType() == 2 && length < this.getAvgValue(conducteur)) {
                                                length = this.getAvgValue(conducteur);
                                            }
                                            missingDesignation = String.valueOf(missingDesignation) + ";" + tmp.getCode();
                                            betweenTime = length;
                                            if (!tmp.shouldPay(conducteur, ljc.getDateJour())) continue;
                                            if (tmp.isPaid()) {
                                                betweenPaid += length;
                                            }
                                            if (!tmp.isGenerateHS()) continue;
                                            betweenHS += length;
                                        }
                                    }
                                    if (missingDesignation != "" || expenseAmount.floatValue() != 0.0f) {
                                        betweenService = new HashMap<String, Object>();
                                        betweenService.put(LanguageTranslator.getString("generics.begin"), previousServiceBegin);
                                        if (expenseAmount.floatValue() != 0.0f) {
                                            betweenService.put(LanguageTranslator.getString("generics.expenses"), expenseAmount);
                                        }
                                        if (!missingDesignation.equals("")) {
                                            betweenService.put(LanguageTranslator.getString("generics.missing"), missingDesignation.length() != 0 ? missingDesignation.substring(1) : "");
                                            betweenService.put(LanguageTranslator.getString("generics.missingTime"), betweenTime);
                                            betweenService.put(LanguageTranslator.getString("generics.totalPaid"), betweenPaid);
                                            betweenService.put(LanguageTranslator.getString("generics.totalHS"), betweenHS);
                                            betweenService.put(LanguageTranslator.getString("generics.contract"), contract.getContractGroup(truncatedBegin));
                                        }
                                        this.data.get(this.data.size() - 1).add(betweenService);
                                    }
                                    previousServiceBegin = ConversionTime.addDay(previousServiceBegin, 1);
                                }
                            }
                            this.data.get(this.data.size() - 1).add(activitiesDetails);
                        }
                        if (repos >= 540 && x <= this.activities.size() - 1 || !this.lastActivityProcessed && x == this.activities.size() - 1) {
                            TimsLogger.debug("\r\n#DS.calculService#start new calculation at " + x);
                            this.calculService(x, conducteur, truncatedBegin, contract);
                        } else {
                            TimsLogger.debug("#DS.calculService#dernier passage dans la fonction... on regarde les absences et les frais entre " + truncatedBegin + " et " + this.end);
                            truncatedBegin = ConversionTime.addDay(truncatedBegin, 1);
                            while (truncatedBegin.compareTo(this.end) <= 0) {
                                missingDesignation = "";
                                betweenTime = 0;
                                betweenPaid = 0;
                                betweenHS = 0;
                                expenseAmount = 0.0f;
                                for (DriverExpenses de : DriverExpenses.find(this.expenses, conducteur.getCleConducteur(), truncatedBegin)) {
                                    TimsLogger.debug(":expenses " + de.getExpensesId() + ":");
                                    expenseAmount += de.getAmount();
                                }
                                toAdd = LienJourConducteur.find(this.missing, conducteur.getCleConducteur(), truncatedBegin);
                                if (toAdd.size() != 0) {
                                    for (LienJourConducteur ljc : toAdd) {
                                        tmp = JourType.getDayType(ljc.getCleJourType());
                                        TimsLogger.debug(":day " + tmp.getCode() + ":");
                                        length = ljc.getDuree(contract.getDailyValue());
                                        if (tmp.isAvgValue() && ljc.getType() == 2 && length < this.getAvgValue(conducteur)) {
                                            length = this.getAvgValue(conducteur);
                                        }
                                        missingDesignation = String.valueOf(missingDesignation) + ";" + tmp.getCode();
                                        betweenTime = length;
                                        if (!tmp.shouldPay(conducteur, ljc.getDateJour())) continue;
                                        if (tmp.isPaid()) {
                                            betweenPaid += length;
                                        }
                                        if (!tmp.isGenerateHS()) continue;
                                        betweenHS += length;
                                    }
                                }
                                if (missingDesignation != "" || expenseAmount != 0.0f) {
                                    betweenService = new HashMap<String, Object>();
                                    betweenService.put(LanguageTranslator.getString("generics.begin"), truncatedBegin);
                                    if (expenseAmount != 0.0f) {
                                        betweenService.put(LanguageTranslator.getString("generics.expenses"), Float.valueOf(expenseAmount));
                                    }
                                    if (!missingDesignation.equals("")) {
                                        betweenService.put(LanguageTranslator.getString("generics.missing"), missingDesignation.length() != 0 ? missingDesignation.substring(1) : "");
                                        betweenService.put(LanguageTranslator.getString("generics.missingTime"), betweenTime);
                                        betweenService.put(LanguageTranslator.getString("generics.totalPaid"), betweenPaid);
                                        betweenService.put(LanguageTranslator.getString("generics.totalHS"), betweenHS);
                                        betweenService.put(LanguageTranslator.getString("generics.contract"), contract.getContractGroup(truncatedBegin));
                                    }
                                    this.data.get(this.data.size() - 1).add(betweenService);
                                }
                                truncatedBegin = ConversionTime.addDay(truncatedBegin, 1);
                            }
                        }
                        break;
                    }
                }
                ++x;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DynamicService.calculService()# end of process");
    }

    private int getAvgValue(Conducteur current) {
        if (this.avgValue == -1) {
            this.avgValue = Fonctions.getAvgValue(current, this.begin, this.end);
        }
        return this.avgValue;
    }

    public int endRestIndex(int offsetRestBegin) {
        try {
            while (offsetRestBegin < this.activities.size() && TypeActivite.getActivityType(this.activities.get(offsetRestBegin).getCleType()).isRest()) {
                ++offsetRestBegin;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return offsetRestBegin;
    }

    public int restLength(int offsetWeeklyRestBegin) {
        int toReturn = 0;
        ActiviteConducteur activite = this.activities.get(offsetWeeklyRestBegin);
        try {
            while (offsetWeeklyRestBegin < this.activities.size() - 1 && TypeActivite.getActivityType(this.activities.get(offsetWeeklyRestBegin).getCleType()).isRest()) {
                toReturn += activite.getDuree();
                activite = this.activities.get(++offsetWeeklyRestBegin);
            }
            if (offsetWeeklyRestBegin == this.activities.size() && TypeActivite.getActivityType(this.activities.get(offsetWeeklyRestBegin).getCleType()).isRest()) {
                toReturn += activite.getDuree();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }
}

