/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.TypeActivite;
import fr.pgh.data.bdd.VehicleUsed;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DBObjectNotFoundException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTable;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.PerformanceScanner;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJServiceGenerator;

public class DynamicVehicleSynthesis
extends DynamicGeneric {
    public static final int SEUIL_RJ = 540;
    public static final int DAY = 7;
    private String analysisBegin = null;
    private String analysisEnd = null;
    private Vector<ActiviteConducteur> activities = null;
    private Vector<VehicleUsed> vehiclesUsed = null;
    boolean lastActivityProcessed = false;
    int vehicleOffset = 0;
    int activityOffset = 0;
    DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    GregorianCalendar calendrier = new GregorianCalendar();

    public DynamicVehicleSynthesis() {
        this.setGenerator(new DJServiceGenerator());
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicService.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getVehicleSynthesis();
        this.userParameters.putAll(this.customReport.getProperties());
        this.customReport.getProperties().clear();
        this.customReport.getProperties().putAll(params);
    }

    @Override
    public void setCustomReport(CustomReport customReport) {
        this.customReport = customReport;
    }

    public void showOverview(JTable table) {
        int x = 0;
        if (this.data == null || this.data.size() == 0) {
            this.dataInitialization();
            int serviceCount = 0;
            while (serviceCount == 0) {
                try {
                    if (x >= this.drivers.size()) {
                        System.err.println("#DynamicService.showOverview# no overviewable datas available");
                        return;
                    }
                    this.buildOneDriver((Conducteur)this.drivers.get(x));
                    serviceCount = this.data.size();
                    ++x;
                }
                catch (Exception ex) {
                    TimsLogger.warn("#DynamicService.showOverview# build Error on ." + ((Conducteur)this.drivers.get(x)).getNom());
                    ex.printStackTrace();
                }
            }
        }
        this.data.clear();
    }

    @Override
    public void process() throws Exception {
        if (this.getGenerator() == null) {
            TimsLogger.debug("#DynService.process# no generator defined, set DJServiceGenerator");
            this.setGenerator(new DJServiceGenerator());
        }
        boolean needBuild = false;
        if (this.data == null || this.data.size() == 0) {
            TimsLogger.debug("#DynamicService.process# Build during process");
            needBuild = true;
        }
        if (needBuild) {
            this.dataInitialization();
        }
        if (this.pb != null) {
            this.pb.getBar().setString("g\u00e9n\u00e9ration de la structure du rapport");
            this.pb.getBar().setMaximum(this.drivers.size());
            this.pb.getBar().setMinimum(0);
            this.pb.getBar().setValue(0);
        }
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        try {
            this.getGenerator().compile(this.userParameters);
        }
        catch (Exception ex) {
            TimsLogger.warn("#DynamucService.process# error on compilation");
            ex.printStackTrace();
            return;
        }
        int x = 0;
        while (x < this.drivers.size()) {
            Conducteur conducteur = (Conducteur)this.drivers.get(x);
            if (needBuild) {
                try {
                    this.buildOneDriver(conducteur);
                }
                catch (Exception ex) {
                    TimsLogger.warn("build Error on ." + conducteur.getNom());
                    ex.printStackTrace();
                }
            }
            if (this.pb != null) {
                this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.generation")) + " : " + conducteur.getNom() + " " + conducteur.getPrenom());
                if (!needBuild) {
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                }
            }
            ++x;
        }
        if (this.pb != null) {
            this.pb.getBar().setString(LanguageTranslator.getString("generics.generation"));
        }
        TimsLogger.debug("on va construire le rapprot " + this.customReport.getName());
        this.load(new JRMapCollectionDataSource((Collection)this.data), this.customReport.getName());
        this.print();
        this.generate();
        this.jasperPrintList.clear();
        this.data.clear();
    }

    public void buildData() {
        if (this.begin == null || this.end == null) {
            TimsLogger.warn("missing parameters begin or end");
            return;
        }
        this.dataInitialization();
        for (Conducteur conducteur : this.drivers) {
            try {
                this.buildOneDriver(conducteur);
            }
            catch (Exception ex) {
                TimsLogger.warn("build Error on ." + conducteur.getNom());
                ex.printStackTrace();
            }
        }
    }

    public void dataInitialization() {
        this.activities = new Vector();
        this.vehiclesUsed = new Vector();
        this.calendrier.setTime(this.begin);
        this.calendrier.add(5, -7);
        this.analysisBegin = this.dateFormat.format(this.calendrier.getTime());
        this.calendrier.setTime(this.end);
        this.calendrier.add(5, 7);
        this.analysisEnd = this.dateFormat.format(this.calendrier.getTime());
    }

    public int buildOneDriver(Conducteur toBuild) throws Exception {
        if (this.pb != null) {
            this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.process")) + toBuild.getNom() + " " + toBuild.getPrenom());
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
        }
        if (this.data == null) {
            this.data = new ArrayList();
        }
        Transport.ps.startOperation();
        this.activities.clear();
        Vector<ActiviteConducteur> calculActiviteTmp = Transport.bdd.getActivite(toBuild.getCleConducteur(), this.analysisBegin, this.analysisEnd, -1, 0);
        if (calculActiviteTmp.size() != 0) {
            this.calendrier.setTime(this.dateFormat.parse(this.analysisBegin));
            ActiviteConducteur act = null;
            int i = 0;
            while (i < calculActiviteTmp.size() - 1) {
                act = calculActiviteTmp.get(i);
                while (this.calendrier.getTime().compareTo(act.getDate()) < 0) {
                    this.activities.add(new ActiviteConducteur(0, toBuild.getCleConducteur(), 0, 4, "REPOS", "", 0, 1440, 1440, this.dateFormat.format(this.calendrier.getTime()), "", "", "", "", "", 0, 0, 0));
                    this.calendrier.add(5, 1);
                }
                while (act.getDate().equals(this.calendrier.getTime()) && i < calculActiviteTmp.size() - 1) {
                    this.activities.add(act);
                    act = calculActiviteTmp.get(++i);
                }
                this.calendrier.add(5, 1);
            }
            this.activities.add(act);
            while (this.calendrier.getTime().compareTo(ConversionTime.stringToDate(this.analysisEnd, "yyyy-MM-dd")) < 0) {
                this.activities.add(new ActiviteConducteur(0, toBuild.getCleConducteur(), 0, 4, "REPOS", "", 0, 1440, 1440, this.dateFormat.format(this.calendrier.getTime()), "", "", "", "", "", 0, 0, 0));
                this.calendrier.add(5, 1);
            }
        }
        if (this.activities.size() == 0) {
            return 0;
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DynamicService.buildData()# requ\u00eate ActiviteConducteur : " + this.activities.size() + " activit\u00e9s r\u00e9cup\u00e9r\u00e9es", "#DynamicService.buildData()# requ\u00eate ActiviteConducteur : " + this.activities.size() + " activit\u00e9s r\u00e9cup\u00e9r\u00e9es", 1);
        Transport.ps.startOperation();
        this.vehiclesUsed = VehicleUsed.loadListDriver(toBuild.getCleConducteur(), 0, this.begin, this.end);
        int origin = this.vehiclesUsed.size();
        int x = 0;
        while (x < this.vehiclesUsed.size()) {
            VehicleUsed tmp = this.vehiclesUsed.get(x);
            Date begin = tmp.getDateFin();
            Date nextMinute = ConversionTime.add(begin, 12, 1);
            Date nextSecond = ConversionTime.add(begin, 13, 1);
            TimsLogger.debug("#DVehicleSynthesis.buildOneDriver# vehicule <" + tmp.getDateDebut() + "=>" + begin + "> " + nextMinute + " " + nextSecond);
            if (x < this.vehiclesUsed.size() - 1) {
                TimsLogger.debug("#DVehicleSynthesis.buildOneDriver# prochain <" + this.vehiclesUsed.get(x + 1).getDateDebut() + ">");
            }
            while (x < this.vehiclesUsed.size() - 1 && (nextMinute.equals(this.vehiclesUsed.get(x + 1).getDateDebut()) || nextSecond.equals(this.vehiclesUsed.get(x + 1).getDateDebut())) && this.vehiclesUsed.get(x + 1).getCleVehicule() == tmp.getCleVehicule()) {
                TimsLogger.debug("#DVehicleSynthesis.buildOneDriver# 2 utilisations v\u00e9hicules qui se suivent !!");
                tmp.setDateFin(this.vehiclesUsed.get(x + 1).getDateFin());
                this.vehiclesUsed.remove(x + 1);
                begin = tmp.getDateFin();
                nextMinute = ConversionTime.add(begin, 12, 1);
                nextSecond = ConversionTime.add(begin, 13, 1);
            }
            ++x;
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DVehicleSynthesis.buildData()# requ\u00eate VehicleUsed : " + origin + " vehicules r\u00e9cup\u00e9r\u00e9s, " + (origin - this.vehiclesUsed.size()) + " fusionn\u00e9s", "#DVehicleSynthesis.buildData()# requ\u00eate VehicleUsed : " + origin + " vehicules r\u00e9cup\u00e9r\u00e9s, " + (origin - this.vehiclesUsed.size()) + " fusionn\u00e9s", 1);
        this.vehicleOffset = 0;
        this.activityOffset = 0;
        this.calculService(toBuild);
        return this.data.size();
    }

    private boolean activityIsBefore(ActiviteConducteur activity, VehicleUsed vehicleUsed) {
        Date vehicleBeginTruncate = ConversionTime.dateTruncate(vehicleUsed.getDateDebut());
        Date truncatedBegin = ConversionTime.dateTruncate(activity.getDate());
        int hour = ConversionTime.heureStringToInt(ConversionTime.dateToString(vehicleUsed.getDateDebut(), "HH:mm"), ":");
        return truncatedBegin.before(vehicleBeginTruncate) || truncatedBegin.equals(vehicleBeginTruncate) && activity.getHeureFin() <= hour;
    }

    /*
     * Unable to fully structure code
     */
    public void calculService(Conducteur conducteur) {
        if (this.vehicleOffset >= this.vehiclesUsed.size()) {
            return;
        }
        currentVehicleUsed = this.vehiclesUsed.get(this.vehicleOffset);
        vehicleEnd = currentVehicleUsed.getDateFin();
        TimsLogger.debug("#DVehicleSynthesis.calculService# vehicule en cours < " + currentVehicleUsed.getDateDebut() + ":" + currentVehicleUsed.getDateFin() + ">");
        totalService = 0;
        forceLast = false;
        Transport.ps.startOperation();
        try {
            numActiviteFin = this.activities.size() - 1;
            repos = 0;
            while (this.activityIsBefore(this.activities.get(this.activityOffset), currentVehicleUsed) && this.activityOffset < this.activities.size()) {
                ++this.activityOffset;
            }
            serviceBegin = String.valueOf(this.activities.get(this.activityOffset).getDateJour()) + " " + ConversionTime.heureIntToString(this.activities.get(this.activityOffset).getHeureDebut(), ":");
            begin = ConversionTime.stringToDate(serviceBegin, "yyyy-MM-dd HH:mm");
            TimsLogger.debug("#DVehicleSynthesis.calculService# start at " + this.activityOffset + " <" + serviceBegin + ">");
            x = this.activityOffset;
            while (x < this.activities.size()) {
                if (x == this.activities.size() - 1) {
                    this.lastActivityProcessed = true;
                }
                activite = this.activities.get(x);
                typeAct = TypeActivite.getActivityType(activite.getCleType());
                if (Fonctions.isActiv(activite.getCleType())) {
                    totalService += activite.getDuree();
                    numActiviteFin = x;
                }
                if (typeAct.isRest() && !forceLast) {
                    repos = this.restLength(x);
                }
                if (repos < 540 && x != this.activities.size() - 1) ** GOTO lbl83
                TimsLogger.debug("#DVehicleSynthesis.calculService# begin : " + this.activities.get(this.activityOffset).getDateJour() + " " + this.activities.get(this.activityOffset).getHeureDebut() + ", end " + this.activities.get(numActiviteFin).getDateJour() + " " + this.activities.get(numActiviteFin).getHeureFin());
                x = this.endRestIndex(x);
                if (x != this.activities.size() - 1 || repos >= 540 || forceLast) ** GOTO lbl38
                if (!this.lastActivityProcessed) {
                    forceLast = true;
                    --x;
                } else {
                    numActiviteFin = this.activities.size() - 1;
lbl38:
                    // 2 sources

                    heureFin = this.activities.get(numActiviteFin).getHeureFin();
                    serviceEnd = String.valueOf(this.activities.get(numActiviteFin).getDateJour()) + " " + ConversionTime.heureIntToString(heureFin, ":");
                    end = ConversionTime.stringToDate(serviceEnd, "yyyy-MM-dd HH:mm");
                    if (heureFin == 1440) {
                        serviceEnd = String.valueOf(ConversionTime.addDay(serviceEnd, "yyyy-MM-dd", 1)) + " 00:00";
                        heureFin = 0;
                    }
                    if (begin.compareTo(ConversionTime.addDay(this.end, 1)) >= 0) {
                        return;
                    }
                    if (begin.before(this.begin)) {
                        TimsLogger.debug(" :: on n'est pas encore au d\u00e9but, on n'enregistre pas : " + begin + " < " + this.begin + " :: ");
                    } else {
                        activitiesDetails = new HashMap<String, Object>();
                        vehicle = null;
                        try {
                            vehicle = Vehicule.getVehicule(null, currentVehicleUsed.getCleVehicule());
                        }
                        catch (DBObjectNotFoundException var18_25) {
                            // empty catch block
                        }
                        activitiesDetails.put(LanguageTranslator.getString("generics.vehicle"), vehicle == null ? LanguageTranslator.getString("generics.unknown") : vehicle.getRegistrationNumber());
                        activitiesDetails.put(LanguageTranslator.getString("generics.driver"), String.valueOf(conducteur.getNom()) + " " + conducteur.getPrenom());
                        activitiesDetails.put(LanguageTranslator.getString("user.registration"), conducteur.getMatricule());
                        activitiesDetails.put(LanguageTranslator.getString("generics.beginDate"), begin);
                        activitiesDetails.put(LanguageTranslator.getString("generics.begin"), ConversionTime.dateToString(begin, "HH:mm"));
                        activitiesDetails.put(LanguageTranslator.getString("generics.endDate"), end);
                        activitiesDetails.put(LanguageTranslator.getString("generics.end"), ConversionTime.dateToString(end, "HH:mm"));
                        activitiesDetails.put(LanguageTranslator.getString("generics.total"), totalService);
                        TimsLogger.debug("#DVehicleSynthesis.calculService# on cr\u00e9e une nouvelle ligne (fin service " + end + ") (" + activite.getDateJour() + " " + activite.getHeureFin() + ")");
                        this.data.add(activitiesDetails);
                    }
                    if (repos >= 540 && x <= this.activities.size() - 1 || !this.lastActivityProcessed && x == this.activities.size() - 1) {
                        TimsLogger.debug("\r\n#DVehicleSynthesis.calculService# launch new calculation after RJ at " + x + " <" + this.activities.get(x).getDateJour() + " " + ConversionTime.heureIntToString(this.activities.get(x).getHeureDebut(), ":") + ">");
                        this.activityOffset = x;
                        if (vehicleEnd.compareTo(ConversionTime.stringToDateDb(String.valueOf(this.activities.get(this.activityOffset).getDateJour()) + " " + ConversionTime.heureIntToString(this.activities.get(x).getHeureDebut(), ":") + ":00", true)) <= 0) {
                            TimsLogger.debug("#DVehicleSynthesis.calculService# vehicleEnd befor");
                            ++this.vehicleOffset;
                        }
                        this.calculService(conducteur);
                    }
                    break;
lbl83:
                    // 1 sources

                    if (ConversionTime.dateTruncate(vehicleEnd).equals(activite.getDate()) && ConversionTime.getMinut(currentVehicleUsed.getDateFin()) <= activite.getHeureFin()) {
                        activitiesDetails = new HashMap<String, Object>();
                        vehicle = null;
                        try {
                            vehicle = Vehicule.getVehicule(null, currentVehicleUsed.getCleVehicule());
                        }
                        catch (DBObjectNotFoundException ex) {
                            TimsLogger.warn("#DVehicleSynthesis.calculservice# vehicule introuvable");
                        }
                        heureFin = this.activities.get(numActiviteFin).getHeureFin();
                        serviceEnd = String.valueOf(this.activities.get(numActiviteFin).getDateJour()) + " " + ConversionTime.heureIntToString(heureFin, ":");
                        end = ConversionTime.stringToDate(serviceEnd, "yyyy-MM-dd HH:mm");
                        if (heureFin == 1440) {
                            serviceEnd = String.valueOf(ConversionTime.addDay(serviceEnd, "yyyy-MM-dd", 1)) + " 00:00";
                            heureFin = 0;
                        }
                        activitiesDetails.put(LanguageTranslator.getString("generics.vehicle"), vehicle == null ? LanguageTranslator.getString("generics.unknown") : vehicle.getRegistrationNumber());
                        activitiesDetails.put(LanguageTranslator.getString("generics.driver"), String.valueOf(conducteur.getNom()) + " " + conducteur.getPrenom());
                        activitiesDetails.put(LanguageTranslator.getString("user.registration"), conducteur.getMatricule());
                        activitiesDetails.put(LanguageTranslator.getString("generics.beginDate"), begin);
                        activitiesDetails.put(LanguageTranslator.getString("generics.begin"), ConversionTime.dateToString(begin, "HH:mm"));
                        activitiesDetails.put(LanguageTranslator.getString("generics.endDate"), end);
                        activitiesDetails.put(LanguageTranslator.getString("generics.end"), ConversionTime.dateToString(end, "HH:mm"));
                        activitiesDetails.put(LanguageTranslator.getString("generics.total"), totalService);
                        TimsLogger.debug("#DVehicleSynthesis.calculservice# on cr\u00e9e une nouvelle ligne (fin utilisation v\u00e9hicule " + vehicleEnd + ") (" + activite.getDateJour() + " " + activite.getHeureFin() + ")");
                        this.data.add(activitiesDetails);
                        totalService = 0;
                        ++this.vehicleOffset;
                        TimsLogger.debug("#\r\nDVehicleSynthesis.calculService# launch new calculation after vehicle used at " + this.activityOffset + " <" + this.activities.get(this.activityOffset).getDateJour() + " " + ConversionTime.heureIntToString(this.activities.get(this.activityOffset).getHeureDebut(), ">"));
                        this.calculService(conducteur);
                        break;
                    }
                }
                ++x;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Transport.ps.endOperation(PerformanceScanner.PROCESS, "#DynamicService.calculService()# end of process");
    }

    public int endRestIndex(int offsetRestBegin) {
        try {
            while (offsetRestBegin < this.activities.size() && TypeActivite.getActivityType(this.activities.get(offsetRestBegin).getCleType()).isRest()) {
                ++offsetRestBegin;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return offsetRestBegin;
    }

    public int restLength(int offsetWeeklyRestBegin) {
        int toReturn = 0;
        ActiviteConducteur activite = this.activities.get(offsetWeeklyRestBegin);
        try {
            while (offsetWeeklyRestBegin < this.activities.size() - 1 && TypeActivite.getActivityType(this.activities.get(offsetWeeklyRestBegin).getCleType()).isRest()) {
                toReturn += activite.getDuree();
                activite = this.activities.get(++offsetWeeklyRestBegin);
            }
            if (offsetWeeklyRestBegin == this.activities.size() && TypeActivite.getActivityType(this.activities.get(offsetWeeklyRestBegin).getCleType()).isRest()) {
                toReturn += activite.getDuree();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    public int findServiceTotalTime(String sBegin, String sEnd) {
        Date begin = ConversionTime.stringToDate(sBegin.substring(0, 18), "yyyy-MM-dd HH:mm");
        Date end = ConversionTime.stringToDate(sEnd.substring(0, 18), "yyyy-MM-dd HH:mm");
        TimsLogger.debug("#DVehicleSynthesis.findServiceTotalTime# on cherche le temps de service entre " + begin + " " + "et " + end + "(" + ConversionTime.heureStringToInt(sBegin.substring(11, 16), ":") + " " + ConversionTime.heureStringToInt(sEnd.substring(11, 16), ":") + ")" + "(" + sBegin.substring(11, 16) + " " + sEnd.substring(11, 16) + ")");
        int total = 0;
        int beginLimit = -1;
        int endLimit = -1;
        int x = 0;
        while (x < this.activities.size()) {
            ActiviteConducteur act = this.activities.get(x);
            TimsLogger.debug("#DVehicleSynthesis.findServiceTotalTime# pour (" + act.getDateJour() + ", " + act.getHeureDebut() + " -> " + act.getHeureFin() + ")");
            if (act.getDate().after(ConversionTime.dateTruncate(end))) {
                TimsLogger.debug("#DVehicleSynthesis.findServiceTotalTime# on s'arrete total = " + total);
                break;
            }
            if (!Fonctions.isActiv(act.getCleType()) || act.getDate().before(ConversionTime.dateTruncate(begin))) {
                this.activities.remove(x);
                --x;
            } else {
                if (act.getDate().equals(ConversionTime.dateTruncate(begin))) {
                    beginLimit = ConversionTime.heureStringToInt(sBegin.substring(11, 16), ":");
                }
                if (act.getDate().equals(ConversionTime.dateTruncate(end))) {
                    endLimit = ConversionTime.heureStringToInt(sEnd.substring(11, 16), ":");
                }
                if (beginLimit != -1 || endLimit != -1) {
                    int tot = Fonctions.getTimeBetween(act, beginLimit == -1 ? 0 : beginLimit, endLimit == -1 ? 1440 : endLimit);
                    TimsLogger.debug("#DVehicleSynthesis.findServiceTotalTime# on ajoute " + tot + " (" + act.getDateJour() + ", " + act.getHeureDebut() + " -> " + act.getHeureFin() + ")");
                    total += tot;
                    this.activities.remove(x);
                    --x;
                }
                beginLimit = -1;
                endLimit = -1;
            }
            ++x;
        }
        return total;
    }
}

