/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.exception.ExpensesNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.MasterReport;

public class ExpenseSynthesis
extends MasterReport {
    private ArrayList<Map<String, ?>> data = null;

    @Override
    public void process() {
        this.data = new ArrayList();
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        block4: for (Agence currentAgency : this.agencies) {
            this.pb.getBar().setString(String.valueOf(LanguageTranslator.getString("generics.loading")) + " : " + currentAgency.getDescription());
            Vector<DriverExpenses> expensesList = DriverExpenses.loadList(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            TimsLogger.info("#ExpensisSynthesis.process()# " + expensesList.size() + " frais");
            int x = 0;
            while (x < this.drivers.size()) {
                if (expensesList.size() == 0) {
                    TimsLogger.debug("#ExpensisSynthesis.process# no expenses left...");
                    continue block4;
                }
                if (((Conducteur)this.drivers.get(x)).getCleAgence() == currentAgency.getCleAgence()) {
                    Conducteur currentDriver = (Conducteur)this.drivers.get(x);
                    TimsLogger.debug("#ExpensisSynthesis.process# C'est le d\u00e9but du conducteur " + currentDriver.getNom() + " (" + currentDriver.getCleConducteur() + ")");
                    this.pb.getBar().setString(currentAgency + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                    HashMap<String, Object> line = new HashMap<String, Object>();
                    int counter = 0;
                    Float amount = Float.valueOf("0");
                    line.put("AGENCY", currentAgency.getDescription());
                    line.put("DRIVER", String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                    while (expensesList.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                        try {
                            ExpensesType expenseType = ExpensesType.getExpenses(expensesList.get(0).getExpensesId());
                            String expensesName = expenseType.getCode();
                            int currentValue = line.get(String.valueOf(expensesName) + "_COUNT") == null ? 0 : Integer.parseInt(line.get(String.valueOf(expensesName) + "_COUNT").toString());
                            line.put(String.valueOf(expensesName) + "_COUNT", currentValue + 1);
                            Float currentAmount = Float.valueOf(line.get(String.valueOf(expensesName) + "_AMOUNT") == null ? 0.0f : Float.parseFloat(line.get(String.valueOf(expensesName) + "_AMOUNT").toString()));
                            line.put(String.valueOf(expensesName) + "_AMOUNT", Float.valueOf(currentAmount.floatValue() + expensesList.get(0).getAmount()));
                            ++counter;
                            amount = Float.valueOf(amount.floatValue() + expensesList.get(0).getAmount());
                        }
                        catch (ExpensesNotFoundException ex) {
                            TimsLogger.warn("Type de frais non trouv\u00e9 " + expensesList.get(0).getExpensesId());
                        }
                        expensesList.remove(0);
                        if (expensesList.size() == 0) break;
                    }
                    line.put("TOTAL_COUNT", counter);
                    line.put("TOTAL_AMOUNT", amount);
                    if (counter != 0) {
                        this.data.add(line);
                    }
                    TimsLogger.debug("#ExpensisSynthesis.process# C'est la fin du conducteur " + currentDriver.getNom());
                }
                ++x;
            }
        }
        try {
            this.afficheData();
            this.load(new JRMapCollectionDataSource(this.data), this.report.getCustomizedName());
            this.data.clear();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.generate();
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\nnew line : ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "   ");
            }
        }
    }
}

