/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.ExternalDay;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DriverNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGenerator;

public class FaultReport
extends DynamicGeneric {
    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
    }

    @Override
    public void process() {
        block10: {
            int startThreshold = Integer.parseInt(System.getProperty("FAULT_SERVICE_START_THRESHOLD", "1"));
            if (this.data == null) {
                this.data = new ArrayList();
            }
            this.customReport = CustomReportFactory.getFaultList();
            this.customReport.setName(this.report.getCustomizedName());
            this.setGenerator(new DJGenerator());
            this.getGenerator().setReport(this.customReport);
            this.getGenerator().prebuild();
            this.userParameters.put("DEBUT", this.begin);
            this.userParameters.put("FIN", this.end);
            this.userParameters.put("TITLE", this.customReport.getName());
            Vector<Service> services = Service.getService(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
            Vector<ExternalDay> exDays = ExternalDay.loadList(0, 0, this.begin, this.end);
            this.pb.getBar().setMaximum(services.size());
            this.pb.getBar().setMinimum(0);
            block6: for (ExternalDay ext : exDays) {
                this.pb.incrementBarValue(1);
                Date beginDate = ConversionTime.add(ConversionTime.dateTruncate(ext.getBegin()), 12, ext.getBeginTime());
                Date beginThreshold = ConversionTime.add(beginDate, 12, -startThreshold);
                Date endThreshold = ConversionTime.add(beginDate, 12, startThreshold);
                for (Service tmp : services) {
                    Conducteur driver;
                    boolean isEnd;
                    ext.getBegin();
                    Date begin = ConversionTime.stringToDate(tmp.getBeginDate(), "yyyy-MM-dd hh:MM:ss");
                    Date end = ConversionTime.stringToDate(tmp.getEndDate(), "yyyy-MM-dd hh:MM:ss");
                    boolean isBegin = beginThreshold.compareTo(begin) < 0 && begin.compareTo(endThreshold) < 0;
                    boolean bl = isEnd = endThreshold.compareTo(end) < 0 && end.compareTo(endThreshold) < 0;
                    if (ext.getDriverId() == tmp.getDriverId() && (isBegin || isEnd)) {
                        if (!Fonctions.isFault(tmp, ext)) continue block6;
                        try {
                            driver = Conducteur.getDriver(null, tmp.getDriverId());
                            this.data.add(this.fillMap(driver, tmp, ext));
                        }
                        catch (DriverNotFoundException ex) {
                            TimsLogger.warn("process# unable to fin driver " + tmp.getDriverId() + " => " + ex.getMessage());
                        }
                        continue block6;
                    }
                    try {
                        driver = Conducteur.getDriver(null, tmp.getDriverId());
                        this.data.add(this.fillMap(driver, tmp, ext));
                    }
                    catch (DriverNotFoundException ex) {
                        TimsLogger.warn("process# unable to fin driver " + tmp.getDriverId() + " => " + ex.getMessage());
                    }
                }
            }
            try {
                this.print();
                this.load(new JRMapCollectionDataSource((Collection)this.data), this.customReport.getName());
                this.data.clear();
            }
            catch (Exception ex) {
                TimsLogger.error("process# An error occured while generating fault report");
                if (Transport.debug < 1) break block10;
                ex.printStackTrace();
            }
        }
        this.generate();
    }

    public HashMap<String, Object> fillMap(Conducteur driver, Service s, ExternalDay e) {
        TimsLogger.debug("fillMap()# on ajoute ");
        Agence a = Agence.find(null, driver.getCleAgence());
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put(LanguageTranslator.getString("generics.agency"), a != null ? a.getDescription() : LanguageTranslator.getString("generics.unknown"));
        tmp.put(LanguageTranslator.getString("generics.driver"), String.valueOf(driver.getNom()) + " " + driver.getPrenom());
        tmp.put(LanguageTranslator.getString("generics.date"), s == null ? LanguageTranslator.getString("generics.none") : s.getBeginDate());
        tmp.put(LanguageTranslator.getString("generics.cardLength"), s == null ? 0 : s.getService());
        tmp.put(LanguageTranslator.getString("generics.ieLength"), e.getTotal());
        return tmp;
    }
}

