/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Properties;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartCustomizer;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer3D;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.TextAnchor;

public class HourFollowingGraphRenderer
implements JRChartCustomizer {
    public void customize(JFreeChart jfreechart, JRChart jasperChart) {
        CategoryPlot plot = jfreechart.getCategoryPlot();
        plot.getDomainAxis().setTickLabelsVisible(false);
        plot.getRangeAxis().setTickLabelsVisible(false);
        plot.getRangeAxis().setRange(new Range(0.0, 250.0));
        plot.getRenderer().setBaseItemLabelFont(new Font("Arial", 1, 12));
        plot.getRenderer().setBaseItemLabelPaint((Paint)Color.WHITE);
        plot.getRenderer().setBasePositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.TOP_CENTER));
        plot.getRenderer().setSeriesPaint(0, (Paint)new Color(0, 153, 0));
        plot.getRenderer().setSeriesPaint(1, (Paint)new Color(163, 255, 152));
        plot.getRenderer().setSeriesPaint(2, (Paint)new Color(245, 180, 51));
        plot.getRenderer().setSeriesPaint(3, (Paint)new Color(247, 204, 116));
        plot.getRenderer().setSeriesPaint(4, (Paint)new Color(144, 0, 0));
        plot.getRenderer().setSeriesPaint(5, (Paint)new Color(224, 171, 159));
    }

    private void hide(int i, CategoryItemRenderer renderer) {
        renderer.setSeriesItemLabelsVisible(i, false);
        renderer.setSeriesVisible(i, Boolean.valueOf(false));
        renderer.setSeriesVisibleInLegend(i, Boolean.valueOf(false));
    }

    public static enum LineClass {
        SPLINE("spline"),
        STRAIGHT("straight");

        private final String name;

        private LineClass(String name) {
            this.name = name;
        }

        public boolean equals(String name) {
            return this.toString().equalsIgnoreCase(name);
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Option {
        SERIES_NAME("series.name"),
        SERIES_ORDER("series.order"),
        SERIES_LEGEND("series.legend"),
        SERIES_COLOUR("series.colour"),
        SHAPE_CLASS("shape.class"),
        SHAPE_SIZE("shape.size"),
        SHAPE_SHOWN("shape.shown"),
        LINE_CLASS("line.class"),
        LINE_SIZE("line.size"),
        LINE_SHOWN("line.shown");

        private final String name;

        private Option(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    private class SeriesConfiguration
    implements Comparable<SeriesConfiguration> {
        private Properties properties = new Properties();

        public SeriesConfiguration(String configuration) {
            this.parse(configuration);
        }

        public CategoryItemRenderer createRenderer(int i) {
            StackedBarRenderer3D renderer = null;
            renderer = new StackedBarRenderer3D();
            if (this.getShapesVisible()) {
                Shape shape = this.getSeriesShape();
                renderer.setSeriesShape(i, shape);
            }
            if (this.getLinesVisible()) {
                renderer.setSeriesStroke(i, (Stroke)this.getSeriesStroke());
            }
            renderer.setSeriesPaint(0, (Paint)new Color(0, 153, 0));
            renderer.setSeriesPaint(1, (Paint)new Color(205, 52, 0));
            renderer.setSeriesPaint(2, (Paint)new Color(205, 52, 0));
            renderer.setSeriesPaint(3, (Paint)new Color(144, 0, 0));
            renderer.setSeriesPaint(4, (Paint)new Color(0, 253, 0));
            renderer.setSeriesPaint(5, (Paint)new Color(255, 102, 0));
            renderer.setSeriesPaint(6, (Paint)new Color(255, 102, 0));
            renderer.setSeriesPaint(7, (Paint)new Color(204, 0, 0));
            renderer.setSeriesItemLabelFont(i, new Font("Arial", 2, 8));
            renderer.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BASELINE_CENTER));
            return renderer;
        }

        public String getSeriesName() {
            return this.getProperty(Option.SERIES_NAME.toString(), "unknown");
        }

        private Shape getSeriesShape() {
            Shape[] shapes = DefaultDrawingSupplier.createStandardSeriesShapes();
            Shape result = shapes[1];
            String shapeClass = this.getProperty(Option.SHAPE_CLASS.toString(), ShapeClass.CIRCLE.toString());
            if (ShapeClass.SQUARE.equals(shapeClass)) {
                result = shapes[0];
            } else if (ShapeClass.TRIANGLE.equals(shapeClass)) {
                result = shapes[2];
            } else if (ShapeClass.DIAMOND.equals(shapeClass)) {
                result = shapes[3];
            }
            return result;
        }

        private BasicStroke getSeriesStroke() {
            return new BasicStroke(this.getPropertyFloat(Option.LINE_SIZE.toString()), 1, 1, 1.0f, null, 0.0f);
        }

        private Color getSeriesColour() {
            String[] rgbstring = this.getProperty(Option.SERIES_COLOUR.toString(), "0,0,255").split(",");
            int[] rgb = new int[3];
            int i = 0;
            while (i < 3) {
                rgb[i] = Integer.parseInt(rgbstring[i]);
                ++i;
            }
            return new Color(rgb[0], rgb[1], rgb[2]);
        }

        private int getOrder() {
            return this.getPropertyInt(Option.SERIES_ORDER.toString());
        }

        private boolean getLegendVisible() {
            return this.getPropertyBoolean(Option.SERIES_LEGEND.toString());
        }

        private boolean getShapesVisible() {
            return this.getPropertyBoolean(Option.SHAPE_SHOWN.toString());
        }

        private boolean getLinesVisible() {
            return this.getPropertyBoolean(Option.LINE_SHOWN.toString());
        }

        private String getProperty(String key, String defaultValue) {
            return this.getProperties().getProperty(key, defaultValue);
        }

        private int getPropertyInt(String key) {
            return Integer.parseInt(this.getProperties().getProperty(key, "0"));
        }

        private float getPropertyFloat(String key) {
            return Float.parseFloat(this.getProperties().getProperty(key, "4.0"));
        }

        private boolean getPropertyBoolean(String key) {
            return Boolean.parseBoolean(this.getProperties().getProperty(key, "false"));
        }

        private void parse(String configuration) {
            String[] pairs = configuration.split(";");
            Properties properties = this.getProperties();
            int i = 0;
            while (i < pairs.length) {
                String[] property = pairs[i].split("=");
                properties.setProperty(property[0], property[1]);
                ++i;
            }
        }

        private Properties getProperties() {
            return this.properties;
        }

        public boolean equals(SeriesConfiguration configuration) {
            boolean result = false;
            if (configuration != null) {
                result = configuration.getOrder() == this.getOrder();
            }
            return result;
        }

        @Override
        public int compareTo(SeriesConfiguration configuration) {
            int result = 0;
            if (configuration != null) {
                result = configuration.getOrder() - this.getOrder();
            }
            return result;
        }

        public String toString() {
            return this.getSeriesName();
        }

        private class LabelGenerator
        implements XYSeriesLabelGenerator {
            private String label;

            public LabelGenerator(String label) {
                this.setLabel(label);
            }

            public String generateLabel(XYDataset dataset, int series) {
                return this.getLabel();
            }

            private void setLabel(String label) {
                this.label = label;
            }

            private String getLabel() {
                return this.label;
            }
        }
    }

    public static enum ShapeClass {
        SQUARE("square"),
        CIRCLE("circle"),
        TRIANGLE("triangle"),
        DIAMOND("diamond");

        private final String name;

        private ShapeClass(String name) {
            this.name = name;
        }

        public boolean equals(String name) {
            return this.toString().equalsIgnoreCase(name);
        }

        public String toString() {
            return this.name;
        }
    }
}

