/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Vehicule;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.print.PrintService;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPrintServiceExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.export.ExporterConfiguration;
import net.sf.jasperreports.export.ExporterInput;
import net.sf.jasperreports.export.ExporterOutput;
import net.sf.jasperreports.export.SimpleExporterInput;
import net.sf.jasperreports.export.SimpleOutputStreamExporterOutput;
import net.sf.jasperreports.export.SimplePdfExporterConfiguration;
import net.sf.jasperreports.export.SimplePrintServiceExporterConfiguration;
import net.sf.jasperreports.view.JasperViewer;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transport.report.generator.DJGenerator;

public class MasterReport {
    public static final int HUNDRETH = 0;
    public static final int MINUTE = 1;
    public static final int DRIVER = 0;
    public static final int VEHICLE = 1;
    public static final int SCREEN = 0;
    public static final int PDF = 1;
    public static final int PRINT = 2;
    public static final int XLS = 3;
    public static final int HTML = 4;
    public static final int CSV = 5;
    public Preferences prefs = null;
    protected Map<String, Object> userParameters = null;
    protected ArrayList<JasperPrint> jasperPrintList = null;
    protected Vector<Object> warningList = new Vector();
    protected Report report = null;
    protected ProgressBar pb = null;
    protected Vector<Conducteur> drivers = null;
    protected Vector<Vehicule> vehicles = null;
    protected Vector<Agence> agencies = null;
    protected Date begin = null;
    protected Date end = null;
    public int type = 0;
    protected DJGenerator generator = null;
    public File file = null;

    public MasterReport() {
        this.prefs = Preferences.userRoot().node("TIMS");
        this.jasperPrintList = new ArrayList();
    }

    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        this.pb = pb;
        this.report = report;
        this.agencies = agencies;
        this.drivers = drivers;
        this.vehicles = vehicles;
        this.begin = (Date)params.get("BEGIN");
        this.end = (Date)params.get("END");
        this.jasperPrintList = new ArrayList();
        this.userParameters = params;
    }

    public void process() throws JRException, Exception {
        TimsLogger.info("#MasterReport.process# use old");
        if (!this.isMulti(this.report.getTranslationId())) {
            TimsLogger.debug("#MasterReport.process# unique report");
            if (this.pb != null) {
                this.pb.setVisible(true);
                this.pb.getBar().setMaximum(1);
            }
            this.load(null, this.report.getCustomizedName());
        } else {
            TimsLogger.debug("#MasterReport.process# multiple report");
            this.multiLoad();
        }
        if (this.jasperPrintList.size() == 0) {
            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("report.noData"));
            if (this.pb != null) {
                this.pb.dispose();
            }
            return;
        }
        this.generate();
    }

    private ArrayList<Object> multiLoad() throws Exception {
        ArrayList<Object> jpl;
        block27: {
            block29: {
                block28: {
                    block26: {
                        jpl = new ArrayList<Object>();
                        if (!this.report.getTranslationId().equals(Report.RAPPORT_ACTIVITE) && !this.report.getTranslationId().equals(Report.RAPPORT_SYNTHESE) && !this.report.getTranslationId().equals(Report.RAPPORT_NUIT) && !this.report.getTranslationId().equals(Report.RAPPORT_SERVICE) && !this.report.getTranslationId().equals(Report.RAPPORT_SSERVICE) && !this.report.getTranslationId().equals(Report.RAPPORT_COURRIER) && !this.report.getTranslationId().equals(Report.RAPPORT_INFRACTION) && !this.report.getTranslationId().equals(Report.RAPPORT_FRAIS) && !this.report.getTranslationId().equals(Report.RAPPORT_PREPAIE) && !this.report.getTranslationId().equals(Report.RAPPORT_MODIFICATION) && !this.report.getTranslationId().equals(Report.RAPPORT_SM)) break block26;
                        if (this.pb != null) {
                            this.pb.getBar().setMaximum(this.drivers.size() - 1);
                        }
                        if (this.pb != null) {
                            this.pb.getBar().setMinimum(0);
                        }
                        int i = 0;
                        while (i < this.drivers.size()) {
                            Conducteur list = this.drivers.get(i);
                            if (list instanceof Conducteur) {
                                this.getUserParameter().put("NOM_CH", list.getNom());
                                this.getUserParameter().put("PRENOM_CH", list.getPrenom());
                                this.getUserParameter().put("CLE_CH", String.valueOf(list.getCleConducteur()));
                                if (this.pb != null) {
                                    this.pb.getBar().setString(String.valueOf(list.getNom()) + " " + list.getPrenom());
                                }
                                if (this.pb != null) {
                                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                                }
                                this.getUserParameter().put("AGENCE", Agence.find(this.agencies, list.getCleAgence()).getDescription());
                                TimsLogger.debug("#MasterReport.multiGeneration# cleCond : " + list.getCleConducteur() + "(" + i + ")");
                                this.load(null, this.drivers.get(i).toString());
                            }
                            ++i;
                        }
                        break block27;
                    }
                    if (!this.report.getTranslationId().equals(Report.RAPPORT_UTILISATION_VEHICULE)) break block28;
                    if (this.pb != null) {
                        this.pb.getBar().setMaximum(this.vehicles.size() - 1);
                    }
                    if (this.pb != null) {
                        this.pb.getBar().setMinimum(0);
                    }
                    int i = 0;
                    while (i < this.vehicles.size()) {
                        Vehicule list = this.vehicles.get(i);
                        if (list instanceof Vehicule) {
                            String immatriculation = this.vehicles.get(i).toString();
                            this.getUserParameter().put("CLE_VEHICULE", String.valueOf(list.getCleVehicule()));
                            this.getUserParameter().put("VEHICLE_REGISTRATION", immatriculation);
                            this.getUserParameter().put("AGENCE", Agence.find(this.agencies, list.getAgencyId()).getDescription());
                            if (this.pb != null) {
                                this.pb.getBar().setString(immatriculation);
                            }
                            if (this.pb != null) {
                                this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                            }
                            TimsLogger.debug("#MasterReport.multiGeneration# cleVehicule : " + list.getCleVehicule() + "(" + i + ")");
                            this.load(null, immatriculation);
                        }
                        ++i;
                    }
                    break block27;
                }
                if (!this.report.getTranslationId().equals(Report.RAPPORT_AAC)) break block29;
                if (this.pb != null) {
                    this.pb.getBar().setMaximum(this.agencies.size() - 1);
                }
                if (this.pb != null) {
                    this.pb.getBar().setMinimum(0);
                }
                int i = 0;
                while (i < this.agencies.size()) {
                    Agence list = this.agencies.get(i);
                    if (list instanceof Agence) {
                        String name = this.agencies.get(i).toString();
                        this.getUserParameter().put("NOM_SOC", name);
                        this.getUserParameter().put("AGENCE", name);
                        if (this.pb != null) {
                            this.pb.getBar().setString(name);
                        }
                        if (this.pb != null) {
                            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                        }
                        TimsLogger.debug("#MasterReport.multiGeneration# agency " + name);
                        this.load(null, name);
                    }
                    ++i;
                }
                break block27;
            }
            if (!this.report.getTranslationId().equals(Report.RAPPORT_JOUR)) break block27;
            if (this.pb != null) {
                this.pb.getBar().setMaximum(ConversionTime.getDaysBetween(this.begin, this.end) * this.drivers.size());
            }
            if (this.pb != null) {
                this.pb.getBar().setMinimum(0);
            }
            int i = 0;
            while (i < this.drivers.size()) {
                Conducteur list = this.drivers.get(i);
                if (list instanceof Conducteur) {
                    String driverName = String.valueOf(list.getNom()) + " " + list.getPrenom();
                    this.getUserParameter().put("NOM_CH", list.getNom());
                    this.getUserParameter().put("PRENOM_CH", list.getPrenom());
                    this.getUserParameter().put("CLE_CH", String.valueOf(list.getCleConducteur()));
                    this.getUserParameter().put("AGENCE", Agence.find(this.agencies, list.getCleAgence()).getDescription());
                    if (this.pb != null) {
                        this.pb.getBar().setString(driverName);
                    }
                    TimsLogger.debug("#MasterReport.multiGeneration# cleCond : " + list.getCleConducteur() + "(" + i + ")");
                    Date start = new Date(this.begin.getTime());
                    while (start.compareTo(this.end) <= 0) {
                        String date = ConversionTime.dateToString(start, "dd/MM/yyyy");
                        this.getUserParameter().put("DATE_DEBUT", date);
                        if (this.pb != null) {
                            this.pb.getBar().setString(String.valueOf(driverName) + " => " + date);
                        }
                        if (this.pb != null) {
                            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                        }
                        this.load(null, date.replace("/", "-"));
                        start = ConversionTime.addDay(start, 1);
                    }
                }
                ++i;
            }
        }
        return jpl;
    }

    protected JasperPrint load(JRMapCollectionDataSource jrmcds, String pageName) throws Exception {
        JasperPrint jp = null;
        if (pageName == null) {
            pageName = this.report.getCustomizedName();
        }
        TimsLogger.info("#MasterReport.load# loading " + pageName + (jrmcds == null ? " from report request using file report " + this.getJasperName() : " from datasource" + (this.generator != null ? " using generator " + this.generator.getClass().getName() : " using file report " + this.getJasperName())));
        if (jrmcds != null) {
            if (this.generator != null) {
                jp = this.getGenerator().generate(this.getUserParameter(), jrmcds);
            } else {
                String reportFilePath = this.getJasperName();
                if (this.report.getTranslationId().equals("prepaie")) {
                    TimsLogger.debug("#MR.load# on met la connection dans les param\u00e8tres. date debut = " + this.getUserParameter().get("DATE_DEBUT"));
                    this.getUserParameter().put("CONNECTION", Transport.bdd.getConnection());
                }
                try {
                    jp = JasperFillManager.fillReport((InputStream)this.getClass().getClassLoader().getResourceAsStream(reportFilePath), this.getUserParameter(), (JRDataSource)jrmcds);
                }
                catch (Exception ex) {
                    System.out.println("erreur");
                    ex.printStackTrace();
                }
            }
        } else {
            String reportFilePath = this.getJasperName();
            jp = JasperFillManager.fillReport((InputStream)this.getClass().getClassLoader().getResourceAsStream(reportFilePath), this.getUserParameter(), (Connection)Transport.bdd.getConnection());
        }
        if (!jp.getPages().isEmpty()) {
            if (pageName.length() > 30) {
                pageName = pageName.substring(0, 30);
            }
            jp.setName(pageName);
            this.jasperPrintList.add(jp);
        }
        return jp;
    }

    public JasperPrint loadReport(Agence agency, JRMapCollectionDataSource jrmcds) throws Exception {
        if (!this.agencies.contains(agency)) {
            TimsLogger.debug("Agence " + agency.getDescription() + " non pr\u00e9sentes sur les filtres");
        }
        if (jrmcds.getRecordCount() == 0 || agency == null) {
            TimsLogger.debug("#MasterReport.loadReport# empty data or agency");
            return null;
        }
        TimsLogger.debug("#Master.loadReport()# on g\u00e9n\u00e8re pour l'agence " + agency.getDescription());
        String libAgency = agency == null ? "INCONNU" : agency.getDescription();
        this.getUserParameter().put("AGENCE", libAgency);
        this.getUserParameter().put("NOM_SOC", libAgency);
        JasperPrint jp = this.load(jrmcds, agency.getDescription());
        return jp;
    }

    public JasperPrint loadReport(Conducteur driver, JRMapCollectionDataSource jrmcds) throws Exception {
        if (!this.drivers.contains(driver)) {
            TimsLogger.debug("#MasterReport.loadReport# Conducteur " + driver.getNom() + " non pr\u00e9sents sur les filtres");
        }
        if (jrmcds.getRecordCount() == 0 || driver == null) {
            TimsLogger.debug("#MasterReport.loadReport# empty data or driver");
            return null;
        }
        this.getUserParameter().put("CLE_CH", "" + driver.getCleConducteur());
        this.getUserParameter().put("MATRICULE", driver.getMatricule());
        this.getUserParameter().put("NOM_CONDUCTEUR", driver.getNom());
        this.getUserParameter().put("PRENOM_CONDUCTEUR", driver.getPrenom());
        this.getUserParameter().put("AGENCE", this.getAgency(driver.getCleAgence()) == null ? "INCONNU" : this.getAgency(driver.getCleAgence()).getDescription());
        this.getUserParameter().put("NOM_SOC", this.getUserParameter().get("AGENCE"));
        TimsLogger.verbose("CLE_CH " + this.getUserParameter().get("CLE_CH"));
        TimsLogger.verbose("DATE_DEBUT " + this.getUserParameter().get("DATE_DEBUT"));
        TimsLogger.verbose("DATE_FIN " + this.getUserParameter().get("DATE_FIN"));
        TimsLogger.verbose("AGENCE " + this.getUserParameter().get("AGENCE"));
        TimsLogger.verbose("NOM_CONDUCTEUR " + this.getUserParameter().get("NOM_CONDUCTEUR"));
        JasperPrint jp = this.load(jrmcds, String.valueOf(driver.getNom()) + " " + driver.getPrenom());
        return jp;
    }

    public JasperPrint loadReport(Vehicule vehicle, JRMapCollectionDataSource jrmcds) throws Exception {
        if (!this.vehicles.contains(vehicle)) {
            TimsLogger.debug("Vehicule " + vehicle.getRegistrationNumber() + " non pr\u00e9sentes sur les filtres");
        }
        if (jrmcds.getRecordCount() == 0 || vehicle == null) {
            TimsLogger.debug("#MasterReport.loadReport# empty data or driver");
            return null;
        }
        this.getUserParameter().put("IMMATRICULATION", vehicle.getRegistrationNumber());
        this.getUserParameter().put("DESIGNATION", vehicle.getDesignation());
        this.getUserParameter().put("AGENCE", this.getAgency(vehicle.getAgencyId()) == null ? "INCONNU" : this.getAgency(vehicle.getAgencyId()).getDescription());
        JasperPrint jp = this.load(jrmcds, vehicle.getRegistrationNumber());
        return jp;
    }

    public String reportName() {
        String agencyName = this.agencies.size() != 1 ? "" : " - " + this.agencies.get(0).getDescription();
        String driverName = this.drivers.size() != 1 ? "" : " - " + this.drivers.get(0).getNom() + " " + this.drivers.get(0).getPrenom();
        String reportName = String.valueOf(this.report != null ? this.report.getCustomizedName() : "rapport ") + agencyName + driverName;
        if (this.report != null && (Report.RAPPORT_INFRACTION.equals(this.report.getTranslationId()) || Report.RAPPORT_COURRIER.equals(this.report.getTranslationId()))) {
            int type = this.getUserParameter().get("TYPE") != null ? (Integer)this.getUserParameter().get("TYPE") : 0;
            reportName = String.valueOf(reportName) + (type == 0 ? " - RSE" : " - DF");
        }
        TimsLogger.debug("#MasterReport.reportName()# reportName = " + reportName);
        return reportName;
    }

    protected String getJasperName() {
        String ext = ".jasper";
        if ("xls".equals(this.getUserParameter().get("OUT").toString())) {
            ext = "xls.jasper";
        }
        return "report/" + this.report.getFileName() + ext;
    }

    public DJGenerator getGenerator() {
        if (this.generator == null) {
            TimsLogger.debug("#DynamicGeneric.getGenerator# Create default generator");
            this.generator = new DJGenerator();
        }
        return this.generator;
    }

    private Object[] getWarningList() {
        Object[] message = new Object[]{LanguageTranslator.getString("report.requirements"), new JScrollPane(new JList<Object>(this.warningList))};
        return message;
    }

    protected void generate() {
        TimsLogger.info("#MasterReport.generate()# " + (this.report == null ? "" : String.valueOf(this.report.getTranslationId()) + " (" + this.report.getCustomizedName() + ")") + " generation. " + this.jasperPrintList.size() + " pages. out type = " + this.getUserParameter().get("OUT"));
        if (this.warningList.size() != 0 && Transport.apiMode == 0) {
            Runnable tmp = new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MainFrameTransport.getInstance(), MasterReport.this.getWarningList(), LanguageTranslator.getString("report.warning"), 1);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                tmp.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(tmp);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (this.jasperPrintList == null || this.jasperPrintList.size() == 0) {
            if (Transport.apiMode == 0) {
                JOptionPane.showMessageDialog(null, LanguageTranslator.getString("report.noData"));
            }
            return;
        }
        String exportType = this.getUserParameter().get("OUT") == null ? "\u00e9cran" : this.getUserParameter().get("OUT").toString();
        try {
            String exportPath = "";
            if (!exportType.equals("\u00e9cran") && !exportType.equals("imprimer")) {
                if (this.getUserParameter().get("DESTINATION") != null) {
                    exportPath = this.getUserParameter().get("DESTINATION") + "\\" + this.reportName();
                } else {
                    GetFile tmp = new GetFile(this.reportName());
                    if (SwingUtilities.isEventDispatchThread()) {
                        tmp.run();
                    } else {
                        SwingUtilities.invokeAndWait(tmp);
                    }
                    if (tmp.getCheminSave() == null) {
                        return;
                    }
                    exportPath = tmp.getCheminSave();
                    TimsLogger.debug("#MasterReport.generate()# definition du nom : " + exportPath);
                }
                exportPath = String.valueOf(exportPath) + (exportType.equals("pdf") ? ".pdf" : (exportType.equals("csv") ? ".csv" : ".xls"));
                TimsLogger.info("#MasterReport.generate()# export to " + exportPath);
            }
            JRPdfExporter exporter = null;
            if (exportType.equals("\u00e9cran")) {
                JasperPrint toSee = this.getOneJasperPrint();
                JasperViewer.viewReport((JasperPrint)toSee, (boolean)false);
                System.out.println("on passe " + toSee.getPages().size());
            } else if (exportType.equals("pdf")) {
                exporter = new JRPdfExporter();
                exporter.setExporterInput((ExporterInput)SimpleExporterInput.getInstance(this.jasperPrintList));
                exporter.setExporterOutput((ExporterOutput)new SimpleOutputStreamExporterOutput(exportPath));
                SimplePdfExporterConfiguration configuration = new SimplePdfExporterConfiguration();
                configuration.setCreatingBatchModeBookmarks(Boolean.valueOf(true));
                exporter.setConfiguration((ExporterConfiguration)configuration);
                exporter.exportReport();
            } else if (exportType.equals("imprimer")) {
                exporter = new JRPrintServiceExporter();
                PrinterJob pj = PrinterJob.getPrinterJob();
                TimsLogger.debug("#MasterReport.generate# job name " + pj.getJobName() + " print " + this.jasperPrintList.size() + " to print");
                PrintService ps = pj.getPrintService();
                TimsLogger.debug("#MasterReport.generate# default printer " + ps.getName());
                exporter.setExporterInput((ExporterInput)new SimpleExporterInput(this.getOneJasperPrint()));
                SimplePrintServiceExporterConfiguration configuration = new SimplePrintServiceExporterConfiguration();
                configuration.setPrintService(ps);
                configuration.setPrintServiceAttributeSet(ps.getAttributes());
                configuration.setDisplayPageDialog(Boolean.valueOf(false));
                configuration.setOverrideHints(Boolean.valueOf(true));
                configuration.setDisplayPrintDialog(Boolean.valueOf(true));
                exporter.setConfiguration((ExporterConfiguration)configuration);
                exporter.exportReport();
            } else if (exportType.equals("xls")) {
                exporter = new JRXlsExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, this.jasperPrintList);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)exportPath);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.FALSE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)Boolean.FALSE);
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)Boolean.TRUE);
                exporter.exportReport();
            } else if (exportType.equals("csv")) {
                exporter = new JRCsvExporter();
                exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)";");
                exporter.setParameter(JRExporterParameter.JASPER_PRINT_LIST, this.jasperPrintList);
                exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)exportPath);
                exporter.exportReport();
            }
        }
        catch (Exception ex) {
            if (Transport.apiMode == 0) {
                JOptionPane.showMessageDialog(null, LanguageTranslator.getString("report.error", ex.getMessage() == null ? ex.toString() : ex.getMessage()), LanguageTranslator.getString("message.error"), 0);
            }
            ex.printStackTrace();
        }
        if (!exportType.equals("\u00e9cran") && Transport.apiMode == 0) {
            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("report.generate"), LanguageTranslator.getString("message.done"), 1);
        }
    }

    private JasperPrint getOneJasperPrint() {
        JasperPrint tmp = null;
        TimsLogger.debug("number of jasperPrint pages " + this.jasperPrintList.size());
        int i = 0;
        while (i < this.jasperPrintList.size()) {
            TimsLogger.debug("jasperPrint " + i);
            TimsLogger.debug("jasperPrint pages " + this.jasperPrintList.get(i).getPages().size() + ", " + this.jasperPrintList.get(i).getName());
            if (tmp == null) {
                tmp = this.jasperPrintList.get(i);
            } else {
                int j = 0;
                while (j < this.jasperPrintList.get(i).getPages().size()) {
                    tmp.addPage((JRPrintPage)this.jasperPrintList.get(i).getPages().get(j));
                    ++j;
                }
            }
            ++i;
        }
        return tmp;
    }

    protected Agence getAgency(int agencyId) {
        for (Agence tmp : this.agencies) {
            if (agencyId != tmp.getCleAgence()) continue;
            return tmp;
        }
        return null;
    }

    private boolean isMulti(String translationId) {
        if (translationId.equals(Report.RAPPORT_ACTIVITE) || translationId.equals(Report.RAPPORT_SYNTHESE) || translationId.equals(Report.RAPPORT_NUIT) || translationId.equals(Report.RAPPORT_SERVICE) || translationId.equals(Report.RAPPORT_SSERVICE) || translationId.equals(Report.RAPPORT_COURRIER) || translationId.equals(Report.RAPPORT_INFRACTION) || translationId.equals(Report.RAPPORT_FRAIS) || translationId.equals(Report.RAPPORT_PREPAIE) || translationId.equals(Report.RAPPORT_MODIFICATION) || translationId.equals(Report.RAPPORT_SM)) {
            return this.drivers.size() > 1;
        }
        if (translationId.equals(Report.RAPPORT_AAC)) {
            if (this.agencies.size() == 1) {
                this.getUserParameter().put("NOM_SOC", this.agencies.get(0).getDescription());
            }
            return this.agencies.size() > 1;
        }
        if (translationId.equals(Report.RAPPORT_UTILISATION_VEHICULE)) {
            return this.vehicles != null && this.vehicles.size() > 1;
        }
        if (translationId.equals(Report.RAPPORT_JOUR)) {
            return this.end != null;
        }
        return false;
    }

    public Map<String, Object> getUserParameter() {
        if (this.userParameters == null) {
            this.userParameters = new HashMap<String, Object>();
        }
        return this.userParameters;
    }

    class GetFile
    implements Runnable {
        private String cheminSave = null;

        public GetFile(String fileName) {
            this.cheminSave = String.valueOf(MasterReport.this.prefs.node("DIRECTORY").get("RAPPORT", System.getProperty("user.home"))) + "\\" + fileName;
        }

        @Override
        public void run() {
            JFileChooser choix = new JFileChooser(this.cheminSave);
            choix.setDialogTitle("Indiquez le chemin de destination du rapport");
            choix.setSelectedFile(new File(this.cheminSave));
            if (choix.showSaveDialog(MainFrameTransport.getInstance()) != 0) {
                return;
            }
            this.cheminSave = choix.getSelectedFile().getAbsolutePath();
            MasterReport.this.prefs.node("DIRECTORY").put("RAPPORT", choix.getSelectedFile().getParent());
        }

        public String getCheminSave() {
            return this.cheminSave;
        }
    }
}

