/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceType;
import fr.pgh.data.bdd.Societe;
import fr.pgh.data.bdd.UevOffence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.MasterReport;

public class Offence
extends MasterReport {
    private ArrayList<Map<String, ?>> data = null;
    int rseAdded = 0;

    @Override
    public void process() {
        if (this.pb != null) {
            this.pb.getBar().setMaximum(this.drivers.size());
        }
        if (this.pb != null) {
            this.pb.getBar().setMinimum(0);
        }
        String sBegin = ConversionTime.dateToString(this.begin, "yyyy-MM-dd");
        String sEnd = ConversionTime.dateToString(this.end, "yyyy-MM-dd");
        Vector<fr.pgh.data.bdd.Offence> offences = fr.pgh.data.bdd.Offence.loadList(null, this.drivers, sBegin, sEnd, "1".equals(this.userParameters.get("BRUTE")), false);
        ArrayList<UevOffence> uevOffences = null;
        if ("1".equals(this.userParameters.get("UEV_OFF"))) {
            uevOffences = UevOffence.loadByDriver(null, this.drivers, sBegin, sEnd);
        }
        TimsLogger.debug("#Offence.process()# " + offences.size() + " infractions, " + (uevOffences == null ? 0 : uevOffences.size()) + " infractions uev");
        Agence currentAgency = null;
        this.data = new ArrayList();
        for (Conducteur driver : this.drivers) {
            this.rseAdded = 0;
            currentAgency = Agence.find(this.agencies, driver.getCleAgence());
            for (fr.pgh.data.bdd.Offence offence : offences) {
                if (offence.getType() == 0 || offence.getDriverId() != driver.getCleConducteur()) continue;
                this.fillMap(offence, driver, currentAgency);
            }
            if (uevOffences != null) {
                for (UevOffence uevOffence : uevOffences) {
                    if (uevOffence.getDriverId() != driver.getCleConducteur()) continue;
                    if (uevOffence.getOffenceTypeId() == 1) {
                        if (uevOffence.getLength() <= Integer.parseInt(System.getProperty("cardless.threshold", "0"))) continue;
                        this.fillMap(uevOffence, driver, currentAgency);
                        continue;
                    }
                    this.fillMap(uevOffence, driver, currentAgency);
                }
            }
            if (!((Boolean)this.userParameters.get("DETAIL")).booleanValue()) continue;
            try {
                this.loadReport(driver, new JRMapCollectionDataSource(this.data));
                this.data.clear();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!((Boolean)this.userParameters.get("DETAIL")).booleanValue()) {
            try {
                this.load(new JRMapCollectionDataSource(this.data), "infraction");
                this.data.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.generate();
    }

    public Map<String, Object> fillMap(fr.pgh.data.bdd.Offence o, Conducteur driver, Agence agency) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        OffencePart part = OffencePart.getOffencePart(o.getOffencePartId());
        OffenceType type = OffenceType.getOffenceType(part.getOffenceTypeId());
        if (type == null) {
            TimsLogger.debug("#Offence.fillMap()# type d'infraction null " + o.getOffencePartId());
            return null;
        }
        TimsLogger.debug("#Offence.fillMap()# add offence for " + driver.getNom() + " " + driver.getPrenom() + " " + type.getMemberState());
        if (type.getMemberState() == 0 && !"1".equals(this.userParameters.get("RSE_OFF"))) {
            return null;
        }
        if (type.getMemberState() == 17 && !"1".equals(this.userParameters.get("DF_OFF"))) {
            return null;
        }
        tmp.put("DAY", o.getDate());
        tmp.put("DRIVER_ID", driver.getCleConducteur());
        tmp.put("AGENCY", agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription());
        tmp.put("HOUR", o.getTime());
        tmp.put("THRESHOLD", o.getThreshold());
        tmp.put("COST", o.getCost());
        tmp.put("NAME", LanguageTranslator.getString(type.getName()));
        tmp.put("MEMBER_STATE", type.getMemberState());
        tmp.put("NOM_CONDUCTEUR", driver.getNom());
        tmp.put("PRENOM_CONDUCTEUR", driver.getPrenom());
        tmp.put("NO_CONVERSION", 0);
        tmp.put("ON_UPDATED", o.isRaw() ? 1 : 0);
        if (this.report.getTranslationId().equals("ci") && agency != null) {
            this.addCi(tmp, driver, agency);
        }
        if (((Boolean)this.userParameters.get("DETAIL")).booleanValue() && type.getMemberState() == 0) {
            TimsLogger.debug("#Offence.fillMap()# add at " + this.rseAdded);
            this.data.add(this.rseAdded, tmp);
            ++this.rseAdded;
        } else {
            this.data.add(tmp);
        }
        return tmp;
    }

    public Map<String, Object> fillMap(UevOffence o, Conducteur driver, Agence agency) {
        TimsLogger.debug("#Offence.fillMap()# on ajoute ");
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put("DAY", o.getBegin());
        tmp.put("DRIVER_ID", driver.getCleConducteur());
        tmp.put("AGENCY", agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription());
        tmp.put("HOUR", ConversionTime.heureStringToInt(ConversionTime.dateToString(o.getBegin(), "HH:mm"), ":"));
        tmp.put("THRESHOLD", o.getThreshold());
        tmp.put("NAME", UevOffence.LIBELLE[o.getOffenceTypeId()]);
        tmp.put("COST", UevOffence.LIBELLE[o.getOffenceTypeId()].equals(LanguageTranslator.getString("uev.offence.card")) ? 1500 : 135);
        tmp.put("MEMBER_STATE", 254);
        tmp.put("NOM_CONDUCTEUR", driver.getNom());
        tmp.put("PRENOM_CONDUCTEUR", driver.getPrenom());
        tmp.put("NO_CONVERSION", o.getOffenceTypeId() == 2 ? 1 : 0);
        if (this.report.getTranslationId().equals("ci") && agency != null) {
            this.addCi(tmp, driver, agency);
        }
        this.data.add(tmp);
        return tmp;
    }

    private void addCi(Map<String, Object> tmp, Conducteur driver, Agence agency) {
        if (System.getProperty("offence.company", "0").equals("1")) {
            Societe company = BddTransport.getInstance().getCompany();
            tmp.put("AGENCY", company.getNomSociete());
            tmp.put("ADR", company.getAddress());
            tmp.put("CP", company.getPostalCode());
            tmp.put("VILLE_AGENCE", company.getCity());
        } else {
            tmp.put("ADR", agency.getAdresse());
            tmp.put("CP", agency.getCodePostal());
            tmp.put("VILLE_AGENCE", agency.getVille());
        }
        tmp.put("CODE_POSTAL", driver.getCodePostal());
        tmp.put("ADRESSE", driver.getAdresse());
        tmp.put("VILLE", driver.getVille());
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\nnew line : ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "   ");
            }
        }
    }
}

