/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import ar.com.fdvs.dj.domain.constants.Font;
import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.Offence;
import fr.pgh.data.bdd.OffencePart;
import fr.pgh.data.bdd.OffenceThreshold;
import fr.pgh.data.bdd.OffenceType;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.UevOffence;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGeneratorOffenceAlert;

public class OffenceAlert
extends DynamicGeneric {
    private ArrayList<Map<String, ?>> data = null;

    public OffenceAlert() {
        DJGeneratorOffenceAlert gen = new DJGeneratorOffenceAlert();
        Vector<Integer> typeValue = new Vector<Integer>();
        typeValue.add(1);
        typeValue.add(2);
        typeValue.add(3);
        Vector<Font> fontValue = new Vector<Font>();
        Font one = (Font)gen.getContentStyle().getFont().clone();
        one.setFontSize(10.0f);
        Font two = (Font)gen.getContentStyle().getFont().clone();
        two.setFontSize(12.0f);
        two.setBold(true);
        Font three = (Font)gen.getContentStyle().getFont().clone();
        three.setFontSize(14.0f);
        three.setBold(true);
        fontValue.add(one);
        fontValue.add(two);
        fontValue.add(three);
        gen.setConditions(typeValue, fontValue, "TYPE");
        this.setGenerator(gen);
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (params.get("RESOLUTION") != null) {
            TimsLogger.debug("#DynamicExpenseSynthesis.setValues# RESOLUTION workaround");
            params.put("RESOLUTION", params.get("RESOLUTION").toString());
        }
        TimsLogger.debug("#DynamicOffenceSynthesis.setValues# brute = " + this.userParameters.get("BRUTE"));
        TimsLogger.debug("#DynamicOffenceSynthesis.setValues# out = " + this.userParameters.get("OUT"));
        this.customReport = params.get("CUSTOM_REPORT") != null ? (CustomReport)params.get("CUSTOM_REPORT") : CustomReportFactory.getGeneric(LanguageTranslator.getString("report.soffence"));
        this.userParameters.putAll(this.customReport.getProperties());
        this.customReport.getProperties().clear();
        this.customReport.getProperties().putAll(params);
        TimsLogger.debug("#DynamicOffenceSynthesis.setValues# out = " + this.userParameters.get("OUT"));
    }

    @Override
    public void process() {
        if (this.pb != null) {
            this.pb.getBar().setMaximum(this.drivers.size());
        }
        if (this.pb != null) {
            this.pb.getBar().setMinimum(0);
        }
        String sBegin = ConversionTime.dateToString(this.begin, "yyyy-MM-dd");
        String sEnd = ConversionTime.dateToString(this.end, "yyyy-MM-dd");
        this.customReport.setColumn(CustomReportFactory.getOffenceAlertColumn());
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("MONTH", ConversionTime.dateToString(this.begin, "MMMMM YYYY"));
        this.userParameters.put("TITLE", this.customReport.getName());
        Vector<Offence> offences = Offence.loadList(null, this.drivers, sBegin, sEnd, "1".equals(this.userParameters.get("BRUTE")), false);
        ArrayList<UevOffence> uevOffences = UevOffence.loadByDriver(null, this.drivers, sBegin, sEnd);
        TimsLogger.debug("#Offence.process()# " + offences.size() + " infractions, " + (uevOffences == null ? 0 : uevOffences.size()) + " infractions uev");
        Agence currentAgency = null;
        this.data = new ArrayList();
        for (Conducteur driver : this.drivers) {
            int level;
            currentAgency = Agence.find(this.agencies, driver.getCleAgence());
            for (Offence offence : offences) {
                int minorThreshold;
                level = 0;
                if (offence.getType() == 0 || offence.getDriverId() != driver.getCleConducteur()) continue;
                OffencePart part = OffencePart.getOffencePart(offence.getOffencePartId());
                OffenceType type = OffenceType.getOffenceType(part.getOffenceTypeId());
                OffenceThreshold threshold = Fonctions.getOffenceThreshold(type, part.getName(), "offence.threshold.minor");
                OffenceThreshold notice = Fonctions.getOffenceThreshold(type, part.getName(), "offence.threshold.notice");
                OffenceThreshold warning = Fonctions.getOffenceThreshold(type, part.getName(), "offence.threshold.warning");
                OffenceThreshold alert = Fonctions.getOffenceThreshold(type, part.getName(), "offence.threshold.alert");
                int n = minorThreshold = threshold == null ? 0 : threshold.getThreshold();
                if (minorThreshold < notice.getThreshold()) {
                    if (offence.getThreshold() < notice.getThreshold()) {
                        TimsLogger.debug("On ignore " + offence.getDesignation() + " (" + offence.getThreshold() + ")");
                    } else {
                        level = offence.getThreshold() < warning.getThreshold() ? 1 : (offence.getThreshold() < alert.getThreshold() ? 2 : 3);
                    }
                }
                if (minorThreshold > notice.getThreshold()) {
                    if (offence.getThreshold() > notice.getThreshold()) {
                        TimsLogger.debug("On ignore " + offence.getDesignation() + " (" + offence.getThreshold() + ")");
                    } else {
                        level = offence.getThreshold() > warning.getThreshold() ? 1 : (offence.getThreshold() > alert.getThreshold() ? 2 : 3);
                    }
                }
                if (level <= 0) continue;
                this.fillMap(offence, driver, currentAgency, level);
            }
            if (uevOffences != null) {
                for (UevOffence uevOffence : uevOffences) {
                    if (uevOffence.getDriverId() != driver.getCleConducteur()) continue;
                    level = 0;
                    if (uevOffence.getOffenceTypeId() == 1) {
                        if (uevOffence.getThreshold() < Integer.parseInt(System.getProperty("cardless.threshold", "0"))) {
                            TimsLogger.debug("On ignore CARD (" + uevOffence.getThreshold() + ")");
                        } else {
                            level = uevOffence.getThreshold() < 15 ? 1 : (uevOffence.getThreshold() < 30 ? 2 : 3);
                        }
                    }
                    if (uevOffence.getOffenceTypeId() == 2 || uevOffence.getOffenceTypeId() == 3) {
                        int minor = Integer.parseInt(System.getProperty("speed.threshold", "95"));
                        if (uevOffence.getThreshold() < minor) {
                            TimsLogger.debug("On ignore SPEED (" + uevOffence.getThreshold() + ")");
                        } else {
                            level = uevOffence.getThreshold() < 95 ? 1 : (uevOffence.getThreshold() < 100 ? 2 : 3);
                        }
                    }
                    if (level <= 0) continue;
                    TimsLogger.debug("Add uevOffence " + uevOffence.getOffenceTypeId() + " (" + uevOffence.getThreshold() + ")");
                    this.fillMap(uevOffence, driver, currentAgency, level);
                }
            }
            try {
                this.loadReport(driver, new JRMapCollectionDataSource(this.data));
                this.data.clear();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!((Boolean)this.userParameters.get("DETAIL")).booleanValue()) {
            try {
                this.load(new JRMapCollectionDataSource(this.data), "infraction");
                this.data.clear();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.generate();
    }

    public Map<String, Object> fillMap(Offence o, Conducteur driver, Agence agency, int level) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        OffencePart part = OffencePart.getOffencePart(o.getOffencePartId());
        OffenceType type = OffenceType.getOffenceType(part.getOffenceTypeId());
        if (type == null) {
            TimsLogger.debug("#Offence.fillMap()# type d'infraction null " + o.getOffencePartId());
            return null;
        }
        TimsLogger.debug("#Offence.fillMap()# add offence for " + driver.getNom() + " " + driver.getPrenom() + " " + type.getMemberState());
        tmp.put(LanguageTranslator.getString("generics.date"), o.getDate());
        tmp.put("AGENCY", agency == null ? LanguageTranslator.getString("generics.unknown") : agency.getDescription());
        tmp.put(LanguageTranslator.getString("offence.time"), o.getTime());
        tmp.put(LanguageTranslator.getString("offence.threshold"), ConversionTime.heureIntToString(o.getThreshold(), "h"));
        tmp.put("TYPE", level);
        tmp.put(LanguageTranslator.getString("generics.cost"), o.getCost());
        tmp.put(LanguageTranslator.getString("generics.designation"), LanguageTranslator.getString(type.getName()));
        tmp.put(LanguageTranslator.getString("generics.driver"), String.valueOf(driver.getNom()) + " " + driver.getPrenom());
        tmp.put("MONTH", ConversionTime.dateToString(o.getDate(), "MMMMM YYYY"));
        tmp.put("NO_CONVERSION", 0);
        this.data.add(tmp);
        return tmp;
    }

    public Map<String, Object> fillMap(UevOffence o, Conducteur driver, Agence agency, int level) {
        TimsLogger.debug("#Offence.fillMap()# on ajoute ");
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        tmp.put(LanguageTranslator.getString("generics.date"), o.getBegin());
        tmp.put("MONTH", ConversionTime.dateToString(o.getBegin(), "MMMMM YYYY"));
        tmp.put(LanguageTranslator.getString("offence.time"), ConversionTime.heureStringToInt(ConversionTime.dateToString(o.getBegin(), "HH:mm"), ":"));
        tmp.put(LanguageTranslator.getString("offence.threshold"), o.getOffenceTypeId() == 2 ? String.valueOf(o.getThreshold()) : ConversionTime.heureIntToString(o.getThreshold(), "h"));
        tmp.put("TYPE", level);
        tmp.put(LanguageTranslator.getString("generics.designation"), UevOffence.LIBELLE[o.getOffenceTypeId()]);
        tmp.put(LanguageTranslator.getString("generics.cost"), UevOffence.LIBELLE[o.getOffenceTypeId()].equals(LanguageTranslator.getString("uev.offence.card")) ? 1500 : 135);
        tmp.put(LanguageTranslator.getString("generics.driver"), String.valueOf(driver.getNom()) + " " + driver.getPrenom());
        tmp.put("NO_CONVERSION", o.getOffenceTypeId() == 2 ? 1 : 0);
        this.data.add(tmp);
        return tmp;
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\nnew line : ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "   ");
            }
        }
    }
}

