/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DayTypeNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGenerator;

public class PayExport
extends DynamicGeneric {
    private static final String ETR = " - etranger";
    private static final String FR = " - france";
    private Collection<Map<String, ?>> data = null;
    private Vector<Region> regions = null;
    private boolean expenseDetail = false;
    private boolean separeForeignExp = false;
    private boolean groupLunch = false;
    private boolean groupGD = false;
    private HashMap<String, String> customCat = new HashMap();
    private int avgValue = -1;

    public PayExport() {
    }

    public PayExport(String destinationPath) {
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        if (report.getTranslationId().equals("payExportExp")) {
            this.expenseDetail = true;
        }
        if (report.getTranslationId().equals("payExportAfrac")) {
            this.expenseDetail = true;
            this.separeForeignExp = true;
            this.groupLunch = true;
            this.groupGD = true;
            this.customCat.put(LanguageTranslator.getString("user.registration"), "Matricule");
        }
        if (report.getTranslationId().equals("payExportPerbet")) {
            this.customCat.put("TS", "TT");
            this.customCat.put("HC", "heures contrat");
            this.customCat.put("HNC", "1330");
            this.customCat.put("HE25C", "1332");
            this.customCat.put("HS25C", "1334");
            this.customCat.put("HS50C", "1336");
            this.customCat.put("HNHC", "1830");
            this.customCat.put("HE25", "HE25");
            this.customCat.put("HS25", "HS25");
            this.customCat.put("HS50", "HS50");
            this.customCat.put("HN", "C01");
            this.customCat.put("FNEX", "F01");
            this.customCat.put("FEX", "F05");
        }
        CustomReport cr = this.getCR();
        this.setCustomReport(cr);
        this.setGenerator(new DJGenerator());
        this.getGenerator().setReport(cr);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void process() throws Exception {
        this.regions = Region.loadList(0);
        this.getGenerator().getReport().getProperties().put("OUT", this.getUserParameter().get("OUT"));
        this.userParameters.put("TITLE", this.getCustomReport().getName());
        this.getGenerator().prebuild();
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        for (Agence currentAgency : this.agencies) {
            region = Region.find(null, currentAgency.getRegionId());
            isLevage = region != null && region.getLibelle().equals("LEVAGE") != false;
            this.data = new ArrayList<Map<String, ?>>();
            tmpS = Service.getService(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            tmpL = LienJourConducteur.loadList(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            TimsLogger.info("#PayExport.process()# agency " + currentAgency.getDescription() + " => " + tmpS.size() + " services, " + tmpL.size() + " jours");
            currentContract = null;
            defaultDayLength = 0;
            x = 0;
            while (x < this.drivers.size()) {
                block79: {
                    block77: {
                        block78: {
                            if (((Conducteur)this.drivers.get(x)).getCleAgence() == currentAgency.getCleAgence()) break block78;
                            while (tmpS.size() != 0 && tmpS.get(0).getDriverId() == ((Conducteur)this.drivers.get(x)).getCleConducteur()) {
                                tmpS.remove(0);
                            }
                            while (tmpL.size() != 0 && tmpL.get(0).getCleConducteur() == ((Conducteur)this.drivers.get(x)).getCleConducteur()) {
                                tmpL.remove(0);
                            }
                            break block79;
                        }
                        workedTime = 0;
                        workedDay = 0;
                        altPaidHour = 0;
                        altGenerateHSHour = 0;
                        altGenerateRCHour = 0;
                        altDayCount = 0;
                        night = 0;
                        jfHour = 0;
                        sundayOrJFTotalTime = 0;
                        week = ConversionTime.getWeek(this.begin);
                        this.avgValue = -1;
                        currentDriver = (Conducteur)this.drivers.get(x);
                        TimsLogger.debug("#PayExport.process()# processing " + currentDriver.getNom());
                        requirements = true;
                        try {
                            currentContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                            if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                                defaultDayLength = currentContract.getDailyValue();
                            }
                        }
                        catch (TypeContratNotFoundException ex) {
                            requirements = false;
                            TimsLogger.error("#PayExport.process# unable to retrieve contract type " + currentDriver.getCleTypeContrat());
                            if (Transport.debug < 1) break block77;
                            ex.printStackTrace();
                        }
                    }
                    if (currentDriver.getMatricule() == null || currentDriver.getMatricule().equals("")) {
                        TimsLogger.error("#PayExport.process# no matricule on " + currentDriver.getNom());
                        requirements = false;
                    }
                    if (!requirements) {
                        this.warningList.add(currentDriver);
                    }
                    this.pb.getBar().setString(currentAgency + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                    tmpC = null;
                    if (currentDriver.getCalendarId() != 0) {
                        tmpC = GlobalCalendarDay.loadList(currentDriver.getCalendarId(), this.begin, this.end);
                    }
                    serviceLeft = true;
                    ljcLeft = true;
                    day = this.begin;
                    while (day.compareTo(this.end) <= 0) {
                        block80: {
                            dayTotalTime = 0;
                            if (serviceLeft && tmpS.size() != 0) {
                                dayOfService = ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd");
                                if (tmpS.get(0).getDriverId() != currentDriver.getCleConducteur()) {
                                    serviceLeft = false;
                                } else if (day.equals(dayOfService)) {
                                    if (isLevage && ConversionTime.getDayOfWeek(dayOfService, false) == 1) {
                                        sundayOrJFTotalTime += tmpS.get(0).getService();
                                    }
                                    dayTotalTime += tmpS.get(0).getService();
                                    workedTime += tmpS.get(0).getService();
                                    night += tmpS.get(0).getNight();
                                    ++workedDay;
                                    tmpS.remove(0);
                                    if (tmpS.size() != 0 && day.equals(dayOfService) && tmpS.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                                        dayTotalTime += tmpS.get(0).getService();
                                        workedTime += tmpS.get(0).getService();
                                        night += tmpS.get(0).getNight();
                                        ++workedDay;
                                        tmpS.remove(0);
                                    }
                                }
                            }
                            if (!ljcLeft || tmpL.size() == 0) break block80;
                            if (tmpL.get(0).getCleConducteur() == currentDriver.getCleConducteur()) ** GOTO lbl124
                            ljcLeft = false;
                            break block80;
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    jt = JourType.getDayType(tmpL.get(0).getCleJourType());
                                    length = tmpL.get(0).getDuree(defaultDayLength);
                                    if (jt.isAvgValue() && tmpL.get(0).getType() == 2 && length < this.getAvgValue(currentDriver)) {
                                        length = this.getAvgValue(currentDriver);
                                    }
                                    if (ConversionTime.getDayOfWeek(tmpL.get(0).getDateJour(), false) == 7 && jt.getCode().equals("CP")) {
                                        TimsLogger.debug("#PayExport.process# CP le samedi, on ignore");
                                    } else {
                                        if (jt.getCode().equals("JF")) {
                                            if (isLevage && dayTotalTime != 0) {
                                                sundayOrJFTotalTime += dayTotalTime;
                                            } else {
                                                jfHour += length;
                                            }
                                        }
                                        if (jt.shouldPay(currentDriver, tmpL.get(0).getDateJour())) {
                                            if (jt.isPaid()) {
                                                altPaidHour += length;
                                            }
                                            if (jt.isGenerateHS()) {
                                                altGenerateHSHour += length;
                                            }
                                            if (jt.isGenerateRC()) {
                                                altGenerateRCHour += length;
                                            }
                                        }
                                        if (tmpL.get(0).getType() == 2) {
                                            ++altDayCount;
                                        }
                                    }
                                }
                                catch (DayTypeNotFoundException ex) {
                                    TimsLogger.debug("type d'absence non trouv\u00e9, on ignore " + tmpL.get(0).getCleJourType());
                                }
                                tmpL.remove(0);
lbl124:
                                // 2 sources

                                ** while (tmpL.size() != 0 && day.equals((Object)tmpL.get((int)0).getDateJour()) && tmpL.get((int)0).getCleConducteur() == currentDriver.getCleConducteur())
                            }
                        }
                        if (tmpC != null) {
                            y = 0;
                            while (y < tmpC.size()) {
                                if (day.equals(tmpC.get(y).getDate())) {
                                    toAdd = new LienJourConducteur();
                                    toAdd.setValues(-1, currentDriver.getCleConducteur(), tmpC.get(y).getDayTypeId(), 0, day, 0, 0, 2);
                                    try {
                                        jt = JourType.getDayType(toAdd.getCleJourType());
                                        length = toAdd.getDuree(defaultDayLength);
                                        if (jt.isAvgValue() && toAdd.getType() == 2 && length < this.getAvgValue(currentDriver)) {
                                            length = this.getAvgValue(currentDriver);
                                        }
                                        if (ConversionTime.getDayOfWeek(toAdd.getDateJour(), false) == 7 && jt.getCode().equals("CP")) {
                                            TimsLogger.debug("#PayExport.process# CP le samedi, on ignore");
                                        } else {
                                            if (jt.shouldPay(currentDriver, toAdd.getDateJour())) {
                                                if (jt.getCode().equals("JF")) {
                                                    if (isLevage && dayTotalTime != 0) {
                                                        sundayOrJFTotalTime += dayTotalTime;
                                                    } else {
                                                        jfHour += length;
                                                    }
                                                }
                                                if (jt.isPaid()) {
                                                    altPaidHour += length;
                                                }
                                                if (jt.isGenerateHS()) {
                                                    altGenerateHSHour += length;
                                                }
                                                if (jt.isGenerateRC()) {
                                                    altGenerateRCHour += length;
                                                }
                                            }
                                            if (toAdd.getType() == 2) {
                                                ++altDayCount;
                                            }
                                        }
                                    }
                                    catch (DayTypeNotFoundException ex) {
                                        TimsLogger.warn("type d'absence non trouv\u00e9, on ignore " + toAdd.getCleJourType());
                                    }
                                    tmpC.remove(y);
                                    break;
                                }
                                ++y;
                            }
                        }
                        if (currentContract.getCalculationType() == 1) {
                            ConversionTime.getWeek(ConversionTime.addDay(day, 1));
                        }
                        day = ConversionTime.addDay(day, 1);
                    }
                    s1100 = workedTime + altGenerateRCHour;
                    s1101 = jfHour;
                    hsHour = workedTime + altGenerateHSHour;
                    baseCT = currentContract.getContractHour();
                    hnc1330 = 0;
                    hm125c1332 = 0;
                    hs125c1334 = 0;
                    hs150c1336 = 0;
                    abs4538 = 0;
                    if (baseCT > currentContract.getSeuilHS25(-1)) {
                        hnc1330 = currentContract.getSeuilHN(-1);
                        hm125c1332 = currentContract.getSeuilHE(-1) - currentContract.getSeuilHN(-1);
                        hs125c1334 = currentContract.getSeuilHS25(-1) - currentContract.getSeuilHE(-1);
                        hs150c1336 = baseCT - currentContract.getSeuilHS25(-1);
                    } else if (baseCT > currentContract.getSeuilHE(-1)) {
                        hnc1330 = currentContract.getSeuilHN(-1);
                        hm125c1332 = currentContract.getSeuilHE(-1) - currentContract.getSeuilHN(-1);
                        hs125c1334 = baseCT - currentContract.getSeuilHE(-1);
                    } else if (baseCT > currentContract.getSeuilHN(-1)) {
                        hnc1330 = currentContract.getSeuilHN(-1);
                        hm125c1332 = baseCT - currentContract.getSeuilHN(-1);
                    } else {
                        hnc1330 = baseCT;
                    }
                    abs = altPaidHour - altGenerateHSHour;
                    theoric = baseCT - abs;
                    delta = hsHour - theoric;
                    abs4538 = delta > 0 && abs != 0 ? abs - delta : 0;
                    hnc1830 = 0;
                    hm125c1845 = 0;
                    hs125c1855 = 0;
                    hs150c1865 = 0;
                    toDispatch = hsHour - baseCT;
                    adjustedTheoric = baseCT;
                    if (toDispatch > 0) {
                        TimsLogger.debug(String.valueOf(toDispatch) + " \u00e0 redispatcher sur un contrat th\u00e9orique de " + adjustedTheoric);
                        if (adjustedTheoric < currentContract.getSeuilHN(-1) && toDispatch != 0) {
                            hnc1830 = currentContract.getSeuilHN(-1) - adjustedTheoric;
                            if (hnc1830 > toDispatch) {
                                hnc1830 = toDispatch;
                            }
                            TimsLogger.debug(String.valueOf(hnc1830) + " en heures normale. reste " + (toDispatch -= hnc1830) + " \u00e0 disptcher. th\u00e9orique reajuster " + (adjustedTheoric += hnc1830));
                        }
                        if (adjustedTheoric < currentContract.getSeuilHE(-1) && toDispatch != 0) {
                            hm125c1845 = currentContract.getSeuilHE(-1) - adjustedTheoric;
                            if (hm125c1845 > toDispatch) {
                                hm125c1845 = toDispatch;
                            }
                            TimsLogger.debug(String.valueOf(hm125c1845) + " en hm125. reste " + (toDispatch -= hm125c1845) + " \u00e0 disptcher. th\u00e9orique reajuster " + (adjustedTheoric += hm125c1845));
                        }
                        if (adjustedTheoric < currentContract.getSeuilHS25(-1) && toDispatch != 0) {
                            hs125c1855 = currentContract.getSeuilHS25(-1) - adjustedTheoric;
                            if (hs125c1855 > toDispatch) {
                                hs125c1855 = toDispatch;
                            }
                            TimsLogger.debug(String.valueOf(hs125c1855) + " en hs125. reste " + (toDispatch -= hs125c1855) + " \u00e0 disptcher. th\u00e9orique reajuster " + (adjustedTheoric += hs125c1855));
                        }
                        if (toDispatch > 0) {
                            hs150c1865 = toDispatch;
                            TimsLogger.debug(String.valueOf(hs150c1865) + " en hs150. reste " + 0 + " \u00e0 disptcher.");
                        }
                    }
                    resume = new HashMap<String, Integer>();
                    groupLunchAdded = false;
                    for (ExpensesType et : ExpensesType.getList()) {
                        if (this.groupLunch && (et.getCode().startsWith("RM") || et.getCode().startsWith("RS"))) {
                            if (groupLunchAdded) continue;
                            groupLunchAdded = true;
                            resume.put("Repas" + (this.separeForeignExp != false ? " - france" : ""), 0);
                            if (!this.separeForeignExp) continue;
                            resume.put("Repas - etranger", 0);
                            continue;
                        }
                        resume.put(String.valueOf(et.getCode()) + (this.separeForeignExp != false ? " - france" : ""), 0);
                        if (!this.separeForeignExp) continue;
                        resume.put(String.valueOf(et.getCode()) + " - etranger", 0);
                    }
                    tmpEx = DriverExpenses.loadList(0, currentDriver.getCleConducteur(), this.begin, this.end);
                    TimsLogger.debug("#PayExport.process# " + tmpEx.size() + " expenses");
                    amount = 0.0f;
                    toRemove = new Vector<Date>();
                    for (DriverExpenses exp : tmpEx) {
                        code = String.valueOf(ExpensesType.getExpenses(exp.getExpensesId()).getCode()) + (this.separeForeignExp ? (exp.isOutside() ? " - etranger" : " - france") : "");
                        if (this.groupLunch && (code.startsWith("RM") || code.startsWith("RS"))) {
                            code = code.replace("RM", "Repas");
                            code = code.replace("RS", "Repas");
                        }
                        if (this.groupGD && (code.startsWith("GD1") || code.startsWith("GD2"))) {
                            toRemove.add(exp.getDate());
                        }
                        TimsLogger.debug("#PayExport.process# " + code + " expense");
                        number = (Integer)resume.get(code);
                        resume.put(code, number + 1);
                        amount += exp.getAmount();
                    }
                    if (this.groupGD) {
                        decrementFrance = 0;
                        decrementForeign = 0;
                        for (DriverExpenses exp : tmpEx) {
                            code = String.valueOf(ExpensesType.getExpenses(exp.getExpensesId()).getCode()) + (this.separeForeignExp ? (exp.isOutside() ? " - etranger" : " - france") : "");
                            if (!toRemove.contains(exp.getDate()) || !code.startsWith("RM") && !code.startsWith("RS")) continue;
                            if (this.separeForeignExp) {
                                if (exp.isOutside()) {
                                    ++decrementForeign;
                                    continue;
                                }
                                ++decrementFrance;
                                continue;
                            }
                            ++decrementFrance;
                        }
                        if (decrementFrance != 0 || decrementForeign != 0) {
                            if (this.separeForeignExp) {
                                number = (Integer)resume.get("Repas - etranger");
                                resume.put("Repas", number - decrementForeign);
                                number = (Integer)resume.get("Repas - france");
                                resume.put("Repas", number - decrementFrance);
                            } else {
                                number = (Integer)resume.get("Repas");
                                resume.put("Repas", number - decrementFrance);
                            }
                        }
                    }
                    TimsLogger.debug("\r\n#PayExport.process# " + currentDriver.getNom() + " " + currentDriver.getPrenom() + " :" + (requirements != false ? "" : "Matricule ou type de contrat manquants") + " base r\u00e9mun. contrat = " + (float)currentContract.getContractHour() / 60.0f + ", tps service = " + (float)workedTime / 60.0f + " (" + workedDay + " jrs)" + ", s1100 = " + (float)s1100 / 60.0f + " (" + (float)altGenerateRCHour / 60.0f + " abs g\u00e9n\u00e9rant RC)" + ", s1101 = " + (float)s1101 / 60.0f + ", base tps pay\u00e9 = " + (float)s1100 / 60.0f + " (" + (float)altPaidHour / 60.0f + " abs pay\u00e9e et" + (float)altGenerateHSHour / 60.0f + " abs HS)" + ", delta = " + delta + ", theoric = " + theoric + "\r\nseuil HN/HM125 = " + (float)currentContract.getSeuilHN(-1) / 60.0f + ", seuil HM125/HS125 = " + (float)currentContract.getSeuilHE(-1) / 60.0f + ", seuil HS125/HS150 = " + (float)currentContract.getSeuilHS25(-1) / 60.0f + "\r\nPartie fixe : heure normale (1330) = " + (float)hnc1330 / 60.0f + ", hm125 (1332) = " + (float)hm125c1332 / 60.0f + ", hs125 (1334) = " + (float)hs125c1334 / 60.0f + ", hs150 (1336) = " + (float)hs150c1336 / 60.0f + "\r\nPartie variable : heure normale (1830) = " + (float)hnc1830 / 60.0f + ", hm125 (1845) = " + (float)hm125c1845 / 60.0f + ", hs125 (1855) = " + (float)hs125c1855 / 60.0f + ", hs150 (1865) = " + (float)hs150c1865 / 60.0f + ", heure de nuit (1960) = " + (float)night / 60.0f + ", total frais = " + amount + " (" + resume.size() + " type)");
                    if (requirements) {
                        tmp = new HashMap<String, Object>();
                        mat = LanguageTranslator.getString("user.registration");
                        tmp.put(this.customCat.containsKey(mat) != false ? this.customCat.get(mat) : mat, currentDriver.getMatricule());
                        tmp.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                        tmp.put(this.customCat.containsKey("TS") != false ? this.customCat.get("TS") : "TS", s1100);
                        tmp.put(this.customCat.containsKey("HC") != false ? this.customCat.get("HC") : "HC", currentContract.getContractHour());
                        tmp.put(this.customCat.containsKey("HNC") != false ? this.customCat.get("HNC") : "HNC", hnc1330);
                        tmp.put(this.customCat.containsKey("HE25C") != false ? this.customCat.get("HE25C") : "HE25C", hm125c1332);
                        tmp.put(this.customCat.containsKey("HS25C") != false ? this.customCat.get("HS25C") : "HS25C", hs125c1334);
                        tmp.put(this.customCat.containsKey("HS50C") != false ? this.customCat.get("HS50C") : "HS50C", hs150c1336);
                        tmp.put(this.customCat.containsKey("HNHC") != false ? this.customCat.get("HNHC") : "HNHC", hnc1830);
                        tmp.put(this.customCat.containsKey("HE25") != false ? this.customCat.get("HE25") : "HE25", hm125c1845);
                        tmp.put(this.customCat.containsKey("HS25") != false ? this.customCat.get("HS25") : "HS25", hs125c1855);
                        tmp.put(this.customCat.containsKey("HS50") != false ? this.customCat.get("HS50") : "HS50", hs150c1865);
                        tmp.put(this.customCat.containsKey("HN") != false ? this.customCat.get("HN") : "HN", night);
                        if (this.expenseDetail) {
                            tmp.putAll(resume);
                        } else {
                            tmp.put(this.customCat.containsKey("FNEX") != false ? this.customCat.get("FNEX") : "FNEX", Float.valueOf(currentDriver.isExpensesAllowance() != false ? 0.0f : amount));
                            tmp.put(this.customCat.containsKey("FEX") != false ? this.customCat.get("FEX") : "FEX", Float.valueOf(currentDriver.isExpensesAllowance() != false ? amount : 0.0f));
                        }
                        this.data.add(tmp);
                    }
                }
                ++x;
            }
            this.afficheData();
            this.loadReport(currentAgency, new JRMapCollectionDataSource(this.data));
            this.data.clear();
        }
        this.generate();
        this.pb.dispose();
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\n=> ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "  ");
            }
        }
    }

    private int getAvgValue(Conducteur current) {
        if (this.avgValue == -1) {
            this.avgValue = Fonctions.getAvgValue(current, this.begin, this.end);
        }
        return this.avgValue;
    }

    private CustomReport getCR() {
        CustomReport toReturn = CustomReportFactory.getGeneric("Export paie");
        toReturn.setColumn(this.getColumn());
        return toReturn;
    }

    private Vector<CustomReportColumn> getColumn() {
        Vector<CustomReportColumn> toReturn = new Vector<CustomReportColumn>();
        String mat = LanguageTranslator.getString("user.registration");
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey(mat) ? this.customCat.get(mat) : mat, String.class.getName(), "", 12, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 12, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("TS") ? this.customCat.get("TS") : "TS", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HE25") ? this.customCat.get("HE25") : "HE25", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HS25") ? this.customCat.get("HS25") : "HS25", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HS50") ? this.customCat.get("HS50") : "HS50", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HN") ? this.customCat.get("HN") : "HN", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        if (this.expenseDetail) {
            boolean groupLunchAdded = false;
            for (ExpensesType et : ExpensesType.getList()) {
                if (this.groupLunch && (et.getCode().startsWith("RM") || et.getCode().startsWith("RS"))) {
                    if (groupLunchAdded) continue;
                    TimsLogger.debug("add Repas" + (this.separeForeignExp ? FR : ""));
                    groupLunchAdded = true;
                    toReturn.add(new CustomReportColumn(0, 0, "Repas" + (this.separeForeignExp ? FR : ""), Integer.class.getName(), "###", 8, toReturn.size() + 1));
                    if (!this.separeForeignExp) continue;
                    toReturn.add(new CustomReportColumn(0, 0, "Repas - etranger", Integer.class.getName(), "###", 8, toReturn.size() + 1));
                    continue;
                }
                toReturn.add(new CustomReportColumn(0, 0, String.valueOf(et.getCode()) + (this.separeForeignExp ? FR : ""), Integer.class.getName(), "###", 8, toReturn.size() + 1));
                if (!this.separeForeignExp) continue;
                toReturn.add(new CustomReportColumn(0, 0, String.valueOf(et.getCode()) + ETR, Integer.class.getName(), "###", 8, toReturn.size() + 1));
            }
        } else {
            toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("FNEX") ? this.customCat.get("FNEX") : "FNEX", Float.class.getName(), "###.##", 8, toReturn.size() + 1));
            toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("FEX") ? this.customCat.get("FEX") : "FEX", Float.class.getName(), "###.##", 8, toReturn.size() + 1));
        }
        return toReturn;
    }
}

