/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.DriverExpenses;
import fr.pgh.data.bdd.ExpensesType;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Report;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.data.bdd.Vehicule;
import fr.pgh.exception.DayTypeNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.ui.views.ProgressBar;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.MasterReport;
import transport.report.generator.DJGenerator;

public class PayExportVia
extends DynamicGeneric {
    public static final String EXPORT_FILE = "export.csv";
    private PrintWriter fileWriter = null;
    private DecimalFormat df = new DecimalFormat("#0.00");
    private static final String ETR = " - etranger";
    private static final String FR = " - france";
    private Collection<Map<String, ?>> data = null;
    private Vector<Region> regions = null;
    private boolean expenseDetail = false;
    private boolean separeForeignExp = false;
    private boolean groupLunch = false;
    private HashMap<String, String> customCat = new HashMap();
    private String destinationPath = System.getProperty("export_default_path");
    private int avgValue = -1;

    public PayExportVia() {
        if (this.destinationPath == null || this.destinationPath.equals("") || !new File(this.destinationPath).exists()) {
            MasterReport.GetFile tmp = new MasterReport.GetFile(EXPORT_FILE);
            if (SwingUtilities.isEventDispatchThread()) {
                tmp.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(tmp);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.destinationPath = tmp.getCheminSave();
        }
    }

    @Override
    public void setValues(ProgressBar pb, Report report, Vector<Agence> agencies, Vector<Conducteur> drivers, Vector<Vehicule> vehicles, Map<String, Object> params) {
        super.setValues(pb, report, agencies, drivers, vehicles, params);
        this.customCat.put("TS", "Serv");
        this.customCat.put("TDS", "EV-TDS");
        this.customCat.put("HC", "heures contrat");
        this.customCat.put("HNC", "Contrat-HN");
        this.customCat.put("HE25C", "Contrat-HE25");
        this.customCat.put("HS25C", "Contrat-HS25");
        this.customCat.put("HS50C", "Contrat-HS50");
        this.customCat.put("HNHC", "+HN");
        this.customCat.put("HE25", "HS-HE25");
        this.customCat.put("HS25", "HS-HS25-CD25");
        this.customCat.put("HS50", "HS-HS50");
        this.customCat.put("HN", "EV-Hnuit");
        this.customCat.put("EXP", "EV-Indemnit\u00e9 depl.");
        this.customCat.put("CP", "AB-300");
        this.customCat.put("RC", "AB-335");
        this.customCat.put("MAL", "AB-100");
        this.customCat.put("AT", "AB-120");
        this.customCat.put("EVTFAM", "AB-260");
        CustomReport cr = this.getCR();
        this.setCustomReport(cr);
        this.setGenerator(new DJGenerator());
        this.getGenerator().setReport(cr);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void process() throws Exception {
        this.regions = Region.loadList(0);
        this.getGenerator().getReport().getProperties().put("OUT", this.getUserParameter().get("OUT"));
        this.userParameters.put("TITLE", this.getCustomReport().getName());
        this.getGenerator().prebuild();
        try {
            this.fileWriter = new PrintWriter(new BufferedWriter(new FileWriter(this.destinationPath, false)));
            this.fileWriter.write("MAT;CODE;VAL;DEB;FIN\r\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        for (Agence currentAgency : this.agencies) {
            region = Region.find(null, currentAgency.getRegionId());
            this.data = new ArrayList<Map<String, ?>>();
            tmpS = Service.getService(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            tmpL = LienJourConducteur.loadList(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            TimsLogger.info("#PayExport.process()# agency " + currentAgency.getDescription() + " => " + tmpS.size() + " services, " + tmpL.size() + " jours");
            currentContract = null;
            defaultDayLength = 0;
            x = 0;
            while (x < this.drivers.size()) {
                block72: {
                    block70: {
                        block71: {
                            if (((Conducteur)this.drivers.get(x)).getCleAgence() == currentAgency.getCleAgence()) break block71;
                            while (tmpS.size() != 0 && tmpS.get(0).getDriverId() == ((Conducteur)this.drivers.get(x)).getCleConducteur()) {
                                tmpS.remove(0);
                            }
                            while (tmpL.size() != 0 && tmpL.get(0).getCleConducteur() == ((Conducteur)this.drivers.get(x)).getCleConducteur()) {
                                tmpL.remove(0);
                            }
                            break block72;
                        }
                        totalWorkedTime = 0;
                        totalAltGenerateHSHour = 0;
                        workedTime = 0;
                        workedDay = 0;
                        altPaidHour = 0;
                        altGenerateHSHour = 0;
                        altGenerateRCHour = 0;
                        altDayCount = 0;
                        night = 0;
                        jfHour = 0;
                        hnc1330 = 0;
                        hm125c1332 = 0;
                        hs125c1334 = 0;
                        hs150c1336 = 0;
                        hnc1830 = 0;
                        hm125c1845 = 0;
                        hs125c1855 = 0;
                        hs150c1865 = 0;
                        this.avgValue = -1;
                        currentDriver = (Conducteur)this.drivers.get(x);
                        TimsLogger.debug("#PayExport.process()# processing " + currentDriver.getNom());
                        requirements = true;
                        try {
                            currentContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                            if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                                defaultDayLength = currentContract.getDailyValue();
                            }
                        }
                        catch (TypeContratNotFoundException ex) {
                            requirements = false;
                            TimsLogger.error("#PayExport.process# unable to retrieve contract type " + currentDriver.getCleTypeContrat());
                            if (Transport.debug < 1) break block70;
                            ex.printStackTrace();
                        }
                    }
                    if (currentDriver.getMatricule() == null || currentDriver.getMatricule().equals("")) {
                        TimsLogger.error("#PayExport.process# no matricule on " + currentDriver.getNom());
                        requirements = false;
                    }
                    if (!requirements) {
                        this.warningList.add(currentDriver);
                    }
                    this.pb.getBar().setString(currentAgency + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                    tmpC = null;
                    if (currentDriver.getCalendarId() != 0) {
                        tmpC = GlobalCalendarDay.loadList(currentDriver.getCalendarId(), this.begin, this.end);
                    }
                    toSort = new Vector<LienJourConducteur>();
                    serviceLeft = true;
                    ljcLeft = true;
                    day = this.begin;
                    while (day.compareTo(this.end) <= 0) {
                        block73: {
                            if (serviceLeft && tmpS.size() != 0) {
                                dayOfService = ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd");
                                if (tmpS.get(0).getDriverId() != currentDriver.getCleConducteur()) {
                                    serviceLeft = false;
                                } else if (day.equals(dayOfService)) {
                                    TimsLogger.info("#PayExport.process()# " + ConversionTime.dateToString(day, "EEE dd/MM/yyyy") + " => add " + (double)tmpS.get(0).getService() / 60.0 + " (" + tmpS.get(0).getBeginDate() + ")");
                                    workedTime += tmpS.get(0).getService();
                                    night += tmpS.get(0).getNight();
                                    ++workedDay;
                                    tmpS.remove(0);
                                    if (tmpS.size() != 0 && day.equals(ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd")) && tmpS.get(0).getDriverId() == currentDriver.getCleConducteur()) {
                                        TimsLogger.info("#PayExport.process()# " + ConversionTime.dateToString(day, "EEE dd/MM/yyyy") + " => add 2 " + (double)tmpS.get(0).getService() / 60.0 + " (" + tmpS.get(0).getBeginDate() + ")");
                                        workedTime += tmpS.get(0).getService();
                                        night += tmpS.get(0).getNight();
                                        ++workedDay;
                                        tmpS.remove(0);
                                    }
                                }
                            }
                            if (!ljcLeft || tmpL.size() == 0) break block73;
                            if (tmpL.get(0).getCleConducteur() == currentDriver.getCleConducteur()) ** GOTO lbl136
                            ljcLeft = false;
                            break block73;
lbl-1000:
                            // 1 sources

                            {
                                if (tmpL.get(0).getType() == 2) {
                                    toSort.add(tmpL.get(0));
                                }
                                try {
                                    jt = JourType.getDayType(tmpL.get(0).getCleJourType());
                                    length = tmpL.get(0).getDuree(defaultDayLength);
                                    if (jt.isAvgValue() && tmpL.get(0).getType() == 2 && length < this.getAvgValue(currentDriver)) {
                                        length = this.getAvgValue(currentDriver);
                                    }
                                    if (ConversionTime.getDayOfWeek(tmpL.get(0).getDateJour(), false) == 7 && jt.getCode().equals("CP")) {
                                        TimsLogger.debug("#PayExport.process# CP le samedi, on ignore");
                                    } else {
                                        if (jt.getCode().equals("JF")) {
                                            jfHour += length;
                                        }
                                        if (jt.shouldPay(currentDriver, tmpL.get(0).getDateJour())) {
                                            if (jt.isPaid()) {
                                                altPaidHour += length;
                                            }
                                            if (jt.isGenerateHS()) {
                                                altGenerateHSHour += length;
                                            }
                                            if (jt.isGenerateRC()) {
                                                altGenerateRCHour += length;
                                            }
                                        }
                                        if (tmpL.get(0).getType() == 2) {
                                            ++altDayCount;
                                        }
                                    }
                                }
                                catch (DayTypeNotFoundException ex) {
                                    TimsLogger.debug("type d'absence non trouv\u00e9, on ignore " + tmpL.get(0).getCleJourType());
                                }
                                tmpL.remove(0);
lbl136:
                                // 2 sources

                                ** while (tmpL.size() != 0 && day.equals((Object)tmpL.get((int)0).getDateJour()) && tmpL.get((int)0).getCleConducteur() == currentDriver.getCleConducteur())
                            }
                        }
                        if (tmpC != null) {
                            y = 0;
                            while (y < tmpC.size()) {
                                if (day.equals(tmpC.get(y).getDate())) {
                                    toAdd = new LienJourConducteur();
                                    toAdd.setValues(-1, currentDriver.getCleConducteur(), tmpC.get(y).getDayTypeId(), 0, day, 0, 0, 2);
                                    toSort.add(toAdd);
                                    try {
                                        jt = JourType.getDayType(toAdd.getCleJourType());
                                        length = toAdd.getDuree(defaultDayLength);
                                        if (jt.isAvgValue() && toAdd.getType() == 2 && length < this.getAvgValue(currentDriver)) {
                                            length = this.getAvgValue(currentDriver);
                                        }
                                        if (ConversionTime.getDayOfWeek(toAdd.getDateJour(), false) == 7 && jt.getCode().equals("CP")) {
                                            TimsLogger.debug("#PayExport.process# CP le samedi, on ignore");
                                        } else {
                                            if (jt.shouldPay(currentDriver, toAdd.getDateJour())) {
                                                if (jt.getCode().equals("JF")) {
                                                    jfHour += length;
                                                }
                                                if (jt.isPaid()) {
                                                    altPaidHour += length;
                                                }
                                                if (jt.isGenerateHS()) {
                                                    altGenerateHSHour += length;
                                                }
                                                if (jt.isGenerateRC()) {
                                                    altGenerateRCHour += length;
                                                }
                                            }
                                            if (toAdd.getType() == 2) {
                                                ++altDayCount;
                                            }
                                        }
                                    }
                                    catch (DayTypeNotFoundException ex) {
                                        TimsLogger.warn("type d'absence non trouv\u00e9, on ignore " + toAdd.getCleJourType());
                                    }
                                    tmpC.remove(y);
                                    break;
                                }
                                ++y;
                            }
                        }
                        TimsLogger.info("#PayExport.process()# " + ConversionTime.dateToString(day, "EEE dd/MM/yyyy") + " => " + (double)workedTime / 60.0 + " (" + altGenerateHSHour + ")");
                        if (currentContract.getCalculationType() == 1 && ConversionTime.getWeek(ConversionTime.addDay(day, 1), ConversionTime.SUNDAY_START) != ConversionTime.getWeek(day, ConversionTime.SUNDAY_START) || day.compareTo(this.end) == 0) {
                            if (day.compareTo(this.end) == 0) {
                                TimsLogger.debug("dernier jour on calcul : on passe a une semaine diff\u00e9rente " + ConversionTime.dateToString(day, "EEE dd/MM/yyyy"));
                            } else {
                                TimsLogger.debug("semaine interm\u00e9diaire : on passe a une semaine diff\u00e9rente le lendemain " + ConversionTime.dateToString(day, "EEE dd/MM/yyyy"));
                            }
                            baseCT = currentContract.getContractHour();
                            hs150c = baseCT > currentContract.getSeuilHS25(-1) ? baseCT - currentContract.getSeuilHS25(-1) : 0;
                            hs125c = baseCT > currentContract.getSeuilHE(-1) ? Math.min(currentContract.getSeuilHS25(-1) - currentContract.getSeuilHE(-1), baseCT - currentContract.getSeuilHE(-1)) : 0;
                            hm125c = baseCT > currentContract.getSeuilHN(-1) ? Math.min(currentContract.getSeuilHE(-1) - currentContract.getSeuilHN(-1), baseCT - currentContract.getSeuilHN(-1)) : 0;
                            hnc = Math.min(baseCT, currentContract.getSeuilHN(-1));
                            hs150c1336 += hs150c;
                            hs125c1334 += hs125c;
                            hm125c1332 += hm125c;
                            hnc1330 += hnc;
                            hsHour = workedTime + altGenerateHSHour;
                            hm125 = 0;
                            hs125 = 0;
                            hs150 = 0;
                            hn = 0;
                            if (hsHour > baseCT) {
                                hs150 = hsHour > currentContract.getSeuilHS25(-1) ? hsHour - currentContract.getSeuilHS25(-1) - hs150c : 0;
                                hs125 = hsHour > currentContract.getSeuilHE(-1) ? Math.min(currentContract.getSeuilHS25(-1) - currentContract.getSeuilHE(-1) - hs125c, hsHour - currentContract.getSeuilHE(-1) - hs125c) : 0;
                                hm125 = hsHour > currentContract.getSeuilHN(-1) ? Math.min(currentContract.getSeuilHE(-1) - currentContract.getSeuilHN(-1) - hm125c, hsHour - currentContract.getSeuilHN(-1) - hm125c) : 0;
                                hn = Math.min(hsHour - hnc, currentContract.getSeuilHN(-1) - hnc);
                                hs150c1865 += hs150;
                                hs125c1855 += hs125;
                                hm125c1845 += hm125;
                                hnc1830 += hn;
                            }
                            TimsLogger.debug("calcul : (hsHour = " + (double)hsHour / 60.0 + ") => " + (double)hnc / 60.0 + " / " + (double)hm125c / 60.0 + " / " + (double)hs125c / 60.0 + " / " + (double)hs150c / 60.0 + " >< " + (double)hn / 60.0 + " / " + (double)hm125 / 60.0 + " (" + (double)hm125c1845 / 60.0 + ") / " + (double)hs125 / 60.0 + " (" + (double)hs125c1855 / 60.0 + ") / " + (double)hs150 / 60.0 + " (" + (double)hs150c1865 / 60.0 + ")");
                            totalWorkedTime += workedTime;
                            totalAltGenerateHSHour += altGenerateHSHour;
                            workedTime = 0;
                            altGenerateHSHour = 0;
                        }
                        day = ConversionTime.addDay(day, 1);
                    }
                    resume = new HashMap<String, Integer>();
                    if (this.expenseDetail) {
                        groupLunchAdded = false;
                        for (ExpensesType et : ExpensesType.getList()) {
                            if (this.groupLunch && (et.getCode().startsWith("RM") || et.getCode().startsWith("RS"))) {
                                if (groupLunchAdded) continue;
                                groupLunchAdded = true;
                                resume.put("Repas" + (this.separeForeignExp != false ? " - france" : ""), 0);
                                if (!this.separeForeignExp) continue;
                                resume.put("Repas - etranger", 0);
                                continue;
                            }
                            resume.put(String.valueOf(et.getCode()) + (this.separeForeignExp != false ? " - france" : ""), 0);
                            if (!this.separeForeignExp) continue;
                            resume.put(String.valueOf(et.getCode()) + " - etranger", 0);
                        }
                    }
                    tmpEx = DriverExpenses.loadList(0, currentDriver.getCleConducteur(), this.begin, this.end);
                    TimsLogger.debug("#PayExport.process# " + tmpEx.size() + " expenses");
                    amount = 0.0f;
                    for (DriverExpenses exp : tmpEx) {
                        if (this.expenseDetail) {
                            code = String.valueOf(ExpensesType.getExpenses(exp.getExpensesId()).getCode()) + (this.separeForeignExp ? (exp.isOutside() ? " - etranger" : " - france") : "");
                            if (this.groupLunch && (code.startsWith("RM") || code.startsWith("RS"))) {
                                code = code.replace("RM", "Repas");
                                code = code.replace("RS", "Repas");
                            }
                            TimsLogger.debug("#PayExport.process# " + code + " expense");
                            number = (Integer)resume.get(code);
                            resume.put(code, number + 1);
                        }
                        amount += exp.getAmount();
                    }
                    TimsLogger.debug("\r\n#PayExport.process# " + currentDriver.getNom() + " " + currentDriver.getPrenom() + " :" + (requirements != false ? "" : "Matricule ou type de contrat manquants") + " base r\u00e9mun. contrat = " + (float)currentContract.getContractHour() / 60.0f + ", tps service = " + (float)totalWorkedTime / 60.0f + " (" + workedDay + " jrs)" + ", s1100 = " + (float)(totalWorkedTime + altGenerateRCHour) / 60.0f + " (" + (float)altGenerateRCHour / 60.0f + " abs g\u00e9n\u00e9rant RC)" + ", s1101 = " + (float)jfHour / 60.0f + ", base tps pay\u00e9 = " + (float)(totalWorkedTime + altGenerateRCHour) / 60.0f + " (" + (float)altPaidHour / 60.0f + " abs pay\u00e9e et" + (float)altGenerateHSHour / 60.0f + " abs HS)" + "\r\nseuil HN/HM125 = " + (float)currentContract.getSeuilHN(-1) / 60.0f + ", seuil HM125/HS125 = " + (float)currentContract.getSeuilHE(-1) / 60.0f + ", seuil HS125/HS150 = " + (float)currentContract.getSeuilHS25(-1) / 60.0f + "\r\nPartie fixe : heure normale (1330) = " + (float)hnc1330 / 60.0f + ", hm125 (1332) = " + (float)hm125c1332 / 60.0f + ", hs125 (1334) = " + (float)hs125c1334 / 60.0f + ", hs150 (1336) = " + (float)hs150c1336 / 60.0f + "\r\nPartie variable : heure normale (1830) = " + (float)hnc1830 / 60.0f + ", hm125 (1845) = " + (float)hm125c1845 / 60.0f + ", hs125 (1855) = " + (float)hs125c1855 / 60.0f + ", hs150 (1865) = " + (float)hs150c1865 / 60.0f + ", heure de nuit (1960) = " + (float)night / 60.0f + ", total frais = " + amount + " (" + resume.size() + " type)");
                    if (requirements) {
                        tmp = new HashMap<String, Object>();
                        mat = LanguageTranslator.getString("user.registration");
                        tmp.put(this.customCat.containsKey(mat) != false ? this.customCat.get(mat) : mat, currentDriver.getMatricule());
                        tmp.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                        tmp.put(this.customCat.containsKey("TS") != false ? this.customCat.get("TS") : "TS", totalWorkedTime + altGenerateRCHour);
                        tmp.put(this.customCat.containsKey("TDS") != false ? this.customCat.get("TDS") : "TDS", totalWorkedTime + altPaidHour);
                        tmp.put(this.customCat.containsKey("HC") != false ? this.customCat.get("HC") : "HC", currentContract.getContractHour());
                        tmp.put(this.customCat.containsKey("HNC") != false ? this.customCat.get("HNC") : "HNC", hnc1330);
                        tmp.put(this.customCat.containsKey("HE25C") != false ? this.customCat.get("HE25C") : "HE25C", hm125c1332);
                        tmp.put(this.customCat.containsKey("HS25C") != false ? this.customCat.get("HS25C") : "HS25C", hs125c1334);
                        tmp.put(this.customCat.containsKey("HS50C") != false ? this.customCat.get("HS50C") : "HS50C", hs150c1336);
                        tmp.put(this.customCat.containsKey("HNHC") != false ? this.customCat.get("HNHC") : "HNHC", hnc1830);
                        tmp.put(this.customCat.containsKey("HE25") != false ? this.customCat.get("HE25") : "HE25", hm125c1845);
                        tmp.put(this.customCat.containsKey("HS25") != false ? this.customCat.get("HS25") : "HS25", hs125c1855);
                        tmp.put(this.customCat.containsKey("HS50") != false ? this.customCat.get("HS50") : "HS50", hs150c1865);
                        tmp.put(this.customCat.containsKey("HN") != false ? this.customCat.get("HN") : "HN", night);
                        if (this.expenseDetail) {
                            tmp.putAll(resume);
                        } else {
                            tmp.put(this.customCat.containsKey("EXP") != false ? this.customCat.get("EXP") : "EXP", Float.valueOf(amount));
                        }
                        this.data.add(tmp);
                        if (totalWorkedTime + altPaidHour != 0) {
                            TimsLogger.debug("TDS => " + (totalWorkedTime + altPaidHour) / 60);
                            this.fileWriter.write(String.valueOf(currentDriver.getMatricule()) + ";" + (this.customCat.containsKey("TDS") != false ? this.customCat.get("TDS") : "TDS") + ";" + this.df.format((float)(totalWorkedTime + altPaidHour) / 60.0f) + "\r\n");
                        }
                        if (hm125c1845 != 0) {
                            this.fileWriter.write(String.valueOf(currentDriver.getMatricule()) + ";" + (this.customCat.containsKey("HE25") != false ? this.customCat.get("HE25") : "HE25") + ";" + this.df.format((float)hm125c1845 / 60.0f) + "\r\n");
                        }
                        if (hs125c1855 != 0) {
                            this.fileWriter.write(String.valueOf(currentDriver.getMatricule()) + ";" + (this.customCat.containsKey("HS25") != false ? this.customCat.get("HS25") : "HS25") + ";" + this.df.format((float)hs125c1855 / 60.0f) + "\r\n");
                        }
                        if (hs150c1865 != 0) {
                            hs50 = "HS-HS50-CD50";
                            if (currentDriver.getCleTypeConducteur() == 1) {
                                hs50 = "HS-HS50-GR50";
                            }
                            this.fileWriter.write(String.valueOf(currentDriver.getMatricule()) + ";" + hs50 + ";" + this.df.format((float)hs150c1865 / 60.0f) + "\r\n");
                        }
                        if (night != 0) {
                            this.fileWriter.write(String.valueOf(currentDriver.getMatricule()) + ";" + (this.customCat.containsKey("HN") != false ? this.customCat.get("HN") : "HN") + ";" + this.df.format((float)night / 60.0f) + "\r\n");
                        }
                        if (amount != 0.0f) {
                            this.fileWriter.write(String.valueOf(currentDriver.getMatricule()) + ";" + (this.customCat.containsKey("EXP") != false ? this.customCat.get("EXP") : "EXP") + ";" + this.df.format(amount) + "\r\n");
                        }
                        first = null;
                        last = null;
                        dabrigeon = currentDriver.getCleAgence() == 3;
                        nbRc = 0;
                        for (LienJourConducteur ljc : toSort) {
                            TimsLogger.debug(ljc.getDateJour() + " " + JourType.getDayType(ljc.getCleJourType()).getCode());
                            if (first == null) {
                                first = ljc;
                                last = ljc;
                                ++nbRc;
                                continue;
                            }
                            if (first.getCleJourType() == ljc.getCleJourType() && ConversionTime.getWorkday(last.getDateJour(), ljc.getDateJour()) <= 2) {
                                last = ljc;
                                ++nbRc;
                                continue;
                            }
                            originalCode = JourType.getDayType(first.getCleJourType()).getCode();
                            code = this.getCode(originalCode, dabrigeon);
                            TimsLogger.debug(first.getDateJour() + " / " + last.getDateJour() + " " + JourType.getDayType(first.getCleJourType()).getCode() + "-" + code + " (" + first.getCleJourType() + "," + ConversionTime.getWorkday(first.getDateJour(), ljc.getDateJour()) + ")");
                            if (code != null) {
                                this.fileWriter.write(String.valueOf(currentDriver.getMatricule()) + ";" + code + ";" + (originalCode.equals("RC") != false ? Integer.valueOf(nbRc) : "") + ";" + ConversionTime.dateToStringFr(first.getDateJour()) + ";" + ConversionTime.dateToStringFr(last.getDateJour()) + "\r\n");
                            }
                            first = ljc;
                            last = ljc;
                            nbRc = 1;
                        }
                        if (last != null && this.getCode(JourType.getDayType(first.getCleJourType()).getCode(), dabrigeon) != null) {
                            this.fileWriter.write(String.valueOf(currentDriver.getMatricule()) + ";" + this.getCode(JourType.getDayType(first.getCleJourType()).getCode(), dabrigeon) + ";" + (JourType.getDayType(first.getCleJourType()).getCode().equals("RC") != false ? Integer.valueOf(nbRc) : "") + ";" + ConversionTime.dateToStringFr(first.getDateJour()) + ";" + ConversionTime.dateToStringFr(last.getDateJour()) + "\r\n");
                        }
                    }
                    this.fileWriter.flush();
                }
                ++x;
            }
            this.afficheData();
            this.fileWriter.close();
            this.loadReport(currentAgency, new JRMapCollectionDataSource(this.data));
            this.data.clear();
        }
        this.generate();
        this.pb.dispose();
    }

    private String getCode(String code, boolean dabrigeon) {
        switch (code) {
            case "CP": {
                return "AB-300";
            }
            case "CPV": {
                return "AB-300";
            }
            case "RC": {
                return dabrigeon ? "AB-340" : "AB-310";
            }
            case "EF": {
                return "AB-260";
            }
            case "AT": {
                return "AB-120";
            }
            case "AM": {
                return "AB-100";
            }
            case "CSS": {
                return "AB-632";
            }
        }
        return null;
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\n=> ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "  ");
            }
        }
    }

    private int getAvgValue(Conducteur current) {
        if (this.avgValue == -1) {
            this.avgValue = Fonctions.getAvgValue(current, this.begin, this.end);
        }
        return this.avgValue;
    }

    private CustomReport getCR() {
        CustomReport toReturn = CustomReportFactory.getGeneric("Export paie");
        toReturn.setColumn(this.getColumn());
        return toReturn;
    }

    private Vector<CustomReportColumn> getColumn() {
        Vector<CustomReportColumn> toReturn = new Vector<CustomReportColumn>();
        String mat = LanguageTranslator.getString("user.registration");
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey(mat) ? this.customCat.get(mat) : mat, String.class.getName(), "", 12, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 12, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("TS") ? this.customCat.get("TS") : "TS", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("TDS") ? this.customCat.get("TDS") : "TDS", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HC") ? this.customCat.get("HC") : "HC", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HNC") ? this.customCat.get("HNC") : "HNC", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HE25C") ? this.customCat.get("HE25C") : "HE25C", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HS25C") ? this.customCat.get("HS25C") : "HS25C", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HS50C") ? this.customCat.get("HS50C") : "HS50C", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HNHC") ? this.customCat.get("HNHC") : "HNHC", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HE25") ? this.customCat.get("HE25") : "HE25", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HS25") ? this.customCat.get("HS25") : "HS25", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HS50") ? this.customCat.get("HS50") : "HS50", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("HN") ? this.customCat.get("HN") : "HN", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        if (this.expenseDetail) {
            boolean groupLunchAdded = false;
            for (ExpensesType et : ExpensesType.getList()) {
                if (this.groupLunch && (et.getCode().startsWith("RM") || et.getCode().startsWith("RS"))) {
                    if (groupLunchAdded) continue;
                    TimsLogger.debug("add Repas" + (this.separeForeignExp ? FR : ""));
                    groupLunchAdded = true;
                    toReturn.add(new CustomReportColumn(0, 0, "Repas" + (this.separeForeignExp ? FR : ""), Integer.class.getName(), "###", 8, toReturn.size() + 1));
                    if (!this.separeForeignExp) continue;
                    toReturn.add(new CustomReportColumn(0, 0, "Repas - etranger", Integer.class.getName(), "###", 8, toReturn.size() + 1));
                    continue;
                }
                toReturn.add(new CustomReportColumn(0, 0, String.valueOf(et.getCode()) + (this.separeForeignExp ? FR : ""), Integer.class.getName(), "###", 8, toReturn.size() + 1));
                if (!this.separeForeignExp) continue;
                toReturn.add(new CustomReportColumn(0, 0, String.valueOf(et.getCode()) + ETR, Integer.class.getName(), "###", 8, toReturn.size() + 1));
            }
        } else {
            toReturn.add(new CustomReportColumn(0, 0, this.customCat.containsKey("EXP") ? this.customCat.get("EXP") : "EXP", Float.class.getName(), "###.##", 8, toReturn.size() + 1));
        }
        return toReturn;
    }
}

