/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.data.bdd.Droit;
import fr.pgh.data.bdd.Profil;
import fr.pgh.data.bdd.ReportAccess;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jxl.Workbook;
import jxl.format.Alignment;
import jxl.format.CellFormat;
import jxl.format.VerticalAlignment;
import jxl.write.Boolean;
import jxl.write.Label;
import jxl.write.WritableCell;
import jxl.write.WritableCellFormat;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import transpo.system.ui.MainFrameTransport;
import transpo.system.ui.resources.i18n.LanguageTranslator;

public class ProfilDetail {
    public void generate() {
        JFileChooser choix = new JFileChooser();
        choix.setDialogTitle(LanguageTranslator.getString("file.savePath"));
        choix.setApproveButtonText(LanguageTranslator.getString("button.save"));
        choix.setFileSelectionMode(1);
        if (choix.showOpenDialog(MainFrameTransport.getInstance()) == 0) {
            File destination = new File(String.valueOf(choix.getSelectedFile().getAbsolutePath()) + "//" + LanguageTranslator.getString("profil") + ".xls");
            if (destination.exists()) {
                destination.delete();
                destination = new File(String.valueOf(choix.getSelectedFile().getAbsolutePath()) + "//" + LanguageTranslator.getString("profil") + ".xls");
            }
            try {
                WritableWorkbook workbook = Workbook.createWorkbook((File)destination);
                Vector<Profil> list = Profil.list();
                for (Profil toWrite : list) {
                    toWrite.loadRight();
                    toWrite.loadReportAccess();
                    WritableSheet sheet = workbook.createSheet(toWrite.getNomProfil(), 0);
                    WritableCellFormat center = new WritableCellFormat();
                    center.setAlignment(Alignment.CENTRE);
                    center.setVerticalAlignment(VerticalAlignment.CENTRE);
                    Label f = new Label(0, 2, "FICHE");
                    sheet.addCell((WritableCell)f);
                    Label c = new Label(1, 2, "C");
                    c.setCellFormat((CellFormat)center);
                    sheet.addCell((WritableCell)c);
                    Label v = new Label(2, 2, "V");
                    v.setCellFormat((CellFormat)center);
                    sheet.addCell((WritableCell)v);
                    Label m = new Label(3, 2, "M");
                    m.setCellFormat((CellFormat)center);
                    sheet.addCell((WritableCell)m);
                    Label s = new Label(4, 2, "S");
                    s.setCellFormat((CellFormat)center);
                    sheet.addCell((WritableCell)s);
                    Label r = new Label(6, 2, "RAPPORT");
                    sheet.addCell((WritableCell)r);
                    Label a = new Label(7, 2, "A");
                    a.setCellFormat((CellFormat)center);
                    sheet.addCell((WritableCell)a);
                    sheet.mergeCells(0, 0, 7, 1);
                    String txt = String.valueOf(LanguageTranslator.getString("profil")) + " : " + toWrite.getNomProfil();
                    txt = String.valueOf(txt) + (toWrite.isDefault() ? " (" + LanguageTranslator.getString("generics.default") + ")" : "");
                    Label nom = new Label(0, 0, txt);
                    nom.setCellFormat((CellFormat)center);
                    sheet.addCell((WritableCell)nom);
                    int x = 0;
                    while (x < toWrite.getDroit().size()) {
                        Droit droit = toWrite.getDroit().get(x);
                        Label nomdroit = new Label(0, x + 3, droit.getNomFiche());
                        sheet.addCell((WritableCell)nomdroit);
                        Boolean cd = new Boolean(1, x + 3, droit.isAjout());
                        sheet.addCell((WritableCell)cd);
                        Boolean vd = new Boolean(2, x + 3, droit.isConsultation());
                        sheet.addCell((WritableCell)vd);
                        Boolean md = new Boolean(3, x + 3, droit.isModification());
                        sheet.addCell((WritableCell)md);
                        Boolean sd = new Boolean(4, x + 3, droit.isSuppression());
                        sheet.addCell((WritableCell)sd);
                        ++x;
                    }
                    x = 0;
                    while (x < toWrite.getReport().size()) {
                        ReportAccess report = toWrite.getReport().get(x);
                        Label nomrapport = new Label(6, x + 3, report.getReport().getCustomizedName());
                        sheet.addCell((WritableCell)nomrapport);
                        Boolean rd = new Boolean(7, x + 3, report.isEnable());
                        sheet.addCell((WritableCell)rd);
                        ++x;
                    }
                    sheet.setColumnView(0, 25);
                    sheet.setColumnView(6, 25);
                }
                workbook.write();
                workbook.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            JOptionPane.showMessageDialog(null, LanguageTranslator.getString("message.done"));
        }
    }
}

