/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Service;
import fr.pgh.exception.DriverNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.util.Fonctions;
import transport.report.MasterReport;

public class ServiceReport
extends MasterReport {
    private Collection<Map<String, ?>> data = null;

    @Override
    public void process() {
        Vector<Service> tmpS = Service.getService(null, (Vector<Conducteur>)this.drivers, this.begin, this.end);
        Vector<Integer> orderedDriverId = Fonctions.reorder(tmpS, null);
        Conducteur currentDriver = null;
        this.pb.getBar().setMaximum(orderedDriverId.size());
        this.pb.getBar().setMinimum(0);
        if (this.data == null) {
            this.data = new ArrayList();
        }
        for (Integer driverId : orderedDriverId) {
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            boolean serviceLeft = true;
            try {
                currentDriver = this.getDriver(this.drivers, driverId);
                this.pb.getBar().setString(String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                Date day = this.begin;
                while (day.compareTo(this.end) <= 0) {
                    TimsLogger.debug("#ServiceReport.process# (" + driverId + ") " + ConversionTime.dateToString(day, "dd/MM/yyyy"));
                    Service s = null;
                    Service second = null;
                    if (serviceLeft) {
                        int x = 0;
                        while (x < tmpS.size()) {
                            if (tmpS.get(x).getDriverId() != driverId.intValue()) {
                                if (x != 0) break;
                                serviceLeft = false;
                                break;
                            }
                            if (day.equals(ConversionTime.stringToDate(tmpS.get(x).getBeginDate().substring(0, 10), "yyyy-MM-dd"))) {
                                s = tmpS.get(x);
                                tmpS.remove(x);
                                if (x >= tmpS.size() || tmpS.get(x).getDriverId() != driverId.intValue() || !day.equals(ConversionTime.stringToDate(tmpS.get(x).getBeginDate().substring(0, 10), "yyyy-MM-dd"))) break;
                                second = tmpS.get(x);
                                tmpS.remove(x);
                                break;
                            }
                            ++x;
                        }
                    }
                    if (s != null) {
                        this.data.add(this.fillMap(s));
                        if (second != null) {
                            this.data.add(this.fillMap(second));
                        }
                    }
                    day = ConversionTime.addDay(day, 1);
                }
                this.loadReport(currentDriver, new JRMapCollectionDataSource(this.data));
                this.data.clear();
                TimsLogger.debug("#ServiceReport.process# C'est la fin du conducteur " + currentDriver.getNom());
            }
            catch (DriverNotFoundException ex) {
                TimsLogger.warn("Unable to find driver " + driverId);
            }
            catch (Exception ex) {
                TimsLogger.warn("Erreur sur conducteur " + driverId);
                ex.printStackTrace();
            }
        }
        this.generate();
    }

    public Map<String, Object> fillMap(Service s) {
        if (s != null) {
            s.affiche();
        }
        if (s == null) {
            return null;
        }
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        Date debut = ConversionTime.stringToDate(s.getBeginDate(), "yyyy-MM-dd HH:mm");
        tmp.put("DATE_DEBUT", debut);
        tmp.put("DATE_FIN", ConversionTime.stringToDate(s.getEndDate(), "yyyy-MM-dd HH:mm"));
        tmp.put("SEMAINE", ConversionTime.dateToString(debut, "w"));
        tmp.put("CONDUITE", s.getDriving());
        tmp.put("TRAVAIL", s.getWork());
        tmp.put("DISPO", s.getAvailability());
        tmp.put("DOUBLE_EQUIPAGE", s.getCrew());
        tmp.put("REPOS", s.getRest());
        tmp.put("AUTRE_SERVICE", s.getOther());
        tmp.put("INCONNU", s.getUnk());
        tmp.put("SERVICE", s.getService());
        tmp.put("AMPLITUDE", s.getAmplitude());
        tmp.put("DISTANCE", s.getDistance());
        tmp.put("HEURE_NUIT", s.getNight());
        return tmp;
    }

    public Conducteur getDriver(Vector<Conducteur> driverList, int driverId) throws DriverNotFoundException {
        for (Conducteur tmp : driverList) {
            if (tmp.getCleConducteur() != driverId) continue;
            return tmp;
        }
        throw new DriverNotFoundException();
    }
}

