/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.CustomReport;
import fr.pgh.data.bdd.CustomReportColumn;
import fr.pgh.data.bdd.GlobalCalendarDay;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Region;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.DayTypeNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.Transport;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transpo.system.util.Fonctions;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.MasterReport;
import transport.report.generator.DJGenerator;

public class TimeMToCcmxCayon
extends DynamicGeneric {
    public static final String CCMX_FILE = "heures-ccmx.xls";
    private PrintWriter file = null;
    private DecimalFormat df = new DecimalFormat("##.00");
    private String destinationPath = null;
    private Collection<Map<String, ?>> data = null;
    private Vector<Region> regions = null;
    private int avgValue = -1;

    public TimeMToCcmxCayon() {
        this.destinationPath = System.getProperty("export_default_path");
        if (this.destinationPath == null || this.destinationPath.equals("") || !new File(this.destinationPath).exists()) {
            MasterReport.GetFile tmp = new MasterReport.GetFile(CCMX_FILE);
            if (SwingUtilities.isEventDispatchThread()) {
                tmp.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(tmp);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.destinationPath = tmp.getCheminSave();
        }
        CustomReport cr = this.getCR();
        this.setCustomReport(cr);
        this.setGenerator(new DJGenerator());
        this.getGenerator().setReport(cr);
    }

    public TimeMToCcmxCayon(String destinationPath) {
        this.destinationPath = destinationPath;
        CustomReport cr = this.getCR();
        this.setCustomReport(cr);
        this.setGenerator(new DJGenerator());
        this.getGenerator().setReport(cr);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void process() throws Exception {
        this.regions = Region.loadList(0);
        this.userParameters.put("TITLE", this.getCustomReport().getName());
        this.getGenerator().prebuild();
        try {
            this.file = new PrintWriter(new BufferedWriter(new FileWriter(String.valueOf(this.destinationPath) + "\\" + "heures-ccmx.xls", false)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        for (Agence currentAgency : this.agencies) {
            this.data = new ArrayList<Map<String, ?>>();
            tmpS = Service.getService(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            tmpL = LienJourConducteur.loadList(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            TimsLogger.info("#TimeToCcmxCayon.process()# " + tmpS.size() + " services, " + tmpL.size() + " jours");
            currentContract = null;
            defaultDayLength = 0;
            x = 0;
            while (x < this.drivers.size()) {
                block76: {
                    block74: {
                        block75: {
                            region = Region.find(this.regions, currentAgency.getRegionId());
                            isLevage = region != null && region.getName().equals("LEVAGE") != false;
                            v0 = isMillon = region != null && region.getName().equals("VENISSIEUX") != false;
                            if (((Conducteur)this.drivers.get(x)).getCleAgence() == currentAgency.getCleAgence() && ((Conducteur)this.drivers.get(x)).getPayPeriodType() == 1) break block75;
                            while (tmpS.size() != 0 && tmpS.get(0).getDriverId() == ((Conducteur)this.drivers.get(x)).getCleConducteur()) {
                                tmpS.remove(0);
                            }
                            while (tmpL.size() != 0 && tmpL.get(0).getCleConducteur() == ((Conducteur)this.drivers.get(x)).getCleConducteur()) {
                                tmpL.remove(0);
                            }
                            break block76;
                        }
                        workedTime = 0;
                        workedDay = 0;
                        altPaidHour = 0;
                        altGenerateHSHour = 0;
                        altGenerateRCHour = 0;
                        altDayCount = 0;
                        night = 0;
                        jfHour = 0;
                        sundayOrJFTotalTime = 0;
                        week = ConversionTime.getWeek(this.begin);
                        this.avgValue = -1;
                        currentDriver = (Conducteur)this.drivers.get(x);
                        requirements = true;
                        try {
                            currentContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                            if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                                defaultDayLength = currentContract.getDailyValue();
                            }
                        }
                        catch (TypeContratNotFoundException ex) {
                            requirements = false;
                            System.err.println("#TimeToCcmxCayon.process# unable to retrieve contract type " + currentDriver.getCleTypeContrat());
                            if (Transport.debug < 1) break block74;
                            ex.printStackTrace();
                        }
                    }
                    if (currentDriver.getMatricule() == null || currentDriver.getMatricule().equals("")) {
                        requirements = false;
                    }
                    if (!requirements) {
                        this.warningList.add(currentDriver);
                    }
                    this.pb.getBar().setString(currentAgency + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                    tmpC = null;
                    if (currentDriver.getCalendarId() != 0) {
                        tmpC = GlobalCalendarDay.loadList(currentDriver.getCalendarId(), this.begin, this.end);
                    }
                    serviceLeft = true;
                    ljcLeft = true;
                    day = this.begin;
                    while (day.compareTo(this.end) <= 0) {
                        block77: {
                            dayTotalTime = 0;
                            if (serviceLeft) {
                                while (tmpS.size() != 0) {
                                    dayOfService = ConversionTime.stringToDate(tmpS.get(0).getBeginDate().substring(0, 10), "yyyy-MM-dd");
                                    if (tmpS.get(0).getDriverId() != currentDriver.getCleConducteur()) {
                                        serviceLeft = false;
                                        break;
                                    }
                                    if (!day.equals(dayOfService)) break;
                                    TimsLogger.debug(dayOfService + " found " + ConversionTime.getDayOfWeek(dayOfService, false) + " ==? " + 1);
                                    workedTime += tmpS.get(0).getService();
                                    dayTotalTime += tmpS.get(0).getService();
                                    night += tmpS.get(0).getNight();
                                    ++workedDay;
                                    tmpS.remove(0);
                                }
                            }
                            if (!ljcLeft || tmpL.size() == 0) break block77;
                            if (tmpL.get(0).getCleConducteur() == currentDriver.getCleConducteur()) ** GOTO lbl126
                            ljcLeft = false;
                            break block77;
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    jt = JourType.getDayType(tmpL.get(0).getCleJourType());
                                    length = tmpL.get(0).getDuree(defaultDayLength);
                                    if (jt.isAvgValue() && tmpL.get(0).getType() == 2 && length < this.getAvgValue(currentDriver)) {
                                        length = this.getAvgValue(currentDriver);
                                    }
                                    if (ConversionTime.getDayOfWeek(tmpL.get(0).getDateJour(), false) == 7 && jt.getCode().equals("CP")) {
                                        TimsLogger.debug("#TimeToCcmxCayon.process# CP le samedi, on ignore");
                                    } else {
                                        if (jt.shouldPay(currentDriver, tmpL.get(0).getDateJour())) {
                                            if (jt.getCode().equals("JF")) {
                                                if (isLevage) {
                                                    time = this.getCalendarTime(currentDriver.getCleConducteur(), day);
                                                    if (time != 0) {
                                                        TimsLogger.debug("#TimeToCcmxCayon.process# " + time + " minutes de travail sur le jour f\u00e9ri\u00e9 du " + day);
                                                        sundayOrJFTotalTime += time;
                                                    } else {
                                                        jfHour += length;
                                                    }
                                                } else {
                                                    jfHour += length;
                                                }
                                            }
                                            if (jt.isPaid()) {
                                                altPaidHour += length;
                                            }
                                            if (jt.isGenerateHS()) {
                                                altGenerateHSHour += length;
                                            }
                                            if (jt.isGenerateRC()) {
                                                altGenerateRCHour += length;
                                            }
                                        }
                                        if (tmpL.get(0).getType() == 2) {
                                            ++altDayCount;
                                        }
                                    }
                                }
                                catch (DayTypeNotFoundException ex) {
                                    TimsLogger.debug("type d'absence non trouv\u00e9, on ignore " + tmpL.get(0).getCleJourType());
                                }
                                tmpL.remove(0);
lbl126:
                                // 2 sources

                                ** while (tmpL.size() != 0 && day.equals((Object)tmpL.get((int)0).getDateJour()) && tmpL.get((int)0).getCleConducteur() == currentDriver.getCleConducteur())
                            }
                        }
                        if (tmpC != null) {
                            y = 0;
                            while (y < tmpC.size()) {
                                if (day.equals(tmpC.get(y).getDate())) {
                                    toAdd = new LienJourConducteur();
                                    toAdd.setValues(-1, currentDriver.getCleConducteur(), tmpC.get(y).getDayTypeId(), 0, day, 0, 0, 2);
                                    try {
                                        jt = JourType.getDayType(toAdd.getCleJourType());
                                        length = toAdd.getDuree(defaultDayLength);
                                        if (jt.isAvgValue() && toAdd.getType() == 2 && length < this.getAvgValue(currentDriver)) {
                                            length = this.getAvgValue(currentDriver);
                                        }
                                        if (ConversionTime.getDayOfWeek(toAdd.getDateJour(), false) == 7 && jt.getCode().equals("CP")) {
                                            TimsLogger.debug("#TimeToCcmxCayon.process# CP le samedi, on ignore");
                                        } else {
                                            if (jt.shouldPay(currentDriver, toAdd.getDateJour())) {
                                                if (jt.getCode().equals("JF") && isLevage) {
                                                    time = this.getCalendarTime(currentDriver.getCleConducteur(), day);
                                                    if (time != 0) {
                                                        TimsLogger.debug("#TimeToCcmxCayon.process# " + time + " minutes de travail sur le jour f\u00e9ri\u00e9 du " + day);
                                                        sundayOrJFTotalTime += time;
                                                    } else {
                                                        jfHour += length;
                                                    }
                                                }
                                                if (jt.isPaid()) {
                                                    altPaidHour += length;
                                                }
                                                if (jt.isGenerateHS()) {
                                                    altGenerateHSHour += length;
                                                }
                                                if (jt.isGenerateRC()) {
                                                    altGenerateRCHour += length;
                                                }
                                            }
                                            if (toAdd.getType() == 2) {
                                                ++altDayCount;
                                            }
                                        }
                                    }
                                    catch (DayTypeNotFoundException ex) {
                                        TimsLogger.warn("type d'absence non trouv\u00e9, on ignore " + toAdd.getCleJourType());
                                    }
                                    tmpC.remove(y);
                                    break;
                                }
                                ++y;
                            }
                        }
                        if (isLevage && ConversionTime.getDayOfWeek(day, false) == 1) {
                            sundayOrJFTotalTime += this.getCalendarTime(currentDriver.getCleConducteur(), day);
                        }
                        if (currentContract.getCalculationType() == 1) {
                            ConversionTime.getWeek(ConversionTime.addDay(day, 1));
                        }
                        day = ConversionTime.addDay(day, 1);
                    }
                    s1100 = workedTime + altGenerateRCHour;
                    s1101 = jfHour;
                    hsHour = workedTime + altGenerateHSHour;
                    baseCT = currentContract.getContractHour();
                    hnc1330 = 0;
                    hm125c1332 = 0;
                    hs125c1334 = 0;
                    hs150c1336 = 0;
                    abs4538 = 0;
                    if (baseCT > currentContract.getSeuilHS25(-1)) {
                        hnc1330 = currentContract.getSeuilHN(-1);
                        hm125c1332 = currentContract.getSeuilHE(-1) - currentContract.getSeuilHN(-1);
                        hs125c1334 = currentContract.getSeuilHS25(-1) - currentContract.getSeuilHE(-1);
                        hs150c1336 = baseCT - currentContract.getSeuilHS25(-1);
                    } else if (baseCT > currentContract.getSeuilHE(-1)) {
                        hnc1330 = currentContract.getSeuilHN(-1);
                        hm125c1332 = currentContract.getSeuilHE(-1) - currentContract.getSeuilHN(-1);
                        hs125c1334 = baseCT - currentContract.getSeuilHE(-1);
                    } else if (baseCT > currentContract.getSeuilHN(-1)) {
                        hnc1330 = currentContract.getSeuilHN(-1);
                        hm125c1332 = baseCT - currentContract.getSeuilHN(-1);
                    } else {
                        hnc1330 = baseCT;
                    }
                    abs = altPaidHour - altGenerateHSHour;
                    theoric = baseCT - abs;
                    delta = hsHour - theoric;
                    abs4538 = delta > 0 && abs != 0 ? abs - delta : 0;
                    hnc1830 = 0;
                    hm125c1845 = 0;
                    hs125c1855 = 0;
                    hs150c1865 = 0;
                    toDispatch = hsHour - baseCT;
                    adjustedTheoric = baseCT;
                    if (toDispatch > 0) {
                        TimsLogger.debug(String.valueOf(toDispatch) + " \u00e0 redispatcher sur un contrat th\u00e9orique de " + adjustedTheoric);
                        if (adjustedTheoric < currentContract.getSeuilHN(-1) && toDispatch != 0) {
                            hnc1830 = currentContract.getSeuilHN(-1) - adjustedTheoric;
                            if (hnc1830 > toDispatch) {
                                hnc1830 = toDispatch;
                            }
                            TimsLogger.debug(String.valueOf(hnc1830) + " en heures normale. reste " + (toDispatch -= hnc1830) + " \u00e0 disptcher. th\u00e9orique reajuster " + (adjustedTheoric += hnc1830));
                        }
                        if (adjustedTheoric < currentContract.getSeuilHE(-1) && toDispatch != 0) {
                            hm125c1845 = currentContract.getSeuilHE(-1) - adjustedTheoric;
                            if (hm125c1845 > toDispatch) {
                                hm125c1845 = toDispatch;
                            }
                            TimsLogger.debug(String.valueOf(hm125c1845) + " en hm125. reste " + (toDispatch -= hm125c1845) + " \u00e0 disptcher. th\u00e9orique reajuster " + (adjustedTheoric += hm125c1845));
                        }
                        if (adjustedTheoric < currentContract.getSeuilHS25(-1) && toDispatch != 0) {
                            hs125c1855 = currentContract.getSeuilHS25(-1) - adjustedTheoric;
                            if (hs125c1855 > toDispatch) {
                                hs125c1855 = toDispatch;
                            }
                            TimsLogger.debug(String.valueOf(hs125c1855) + " en hs125. reste " + (toDispatch -= hs125c1855) + " \u00e0 disptcher. th\u00e9orique reajuster " + (adjustedTheoric += hs125c1855));
                        }
                        if (toDispatch > 0) {
                            hs150c1865 = toDispatch;
                            TimsLogger.debug(String.valueOf(hs150c1865) + " en hs150. reste " + 0 + " \u00e0 disptcher.");
                        }
                    }
                    TimsLogger.debug("\r\n#TimeToCcmxCayon.process# " + currentDriver.getNom() + " " + currentDriver.getPrenom() + " :" + (requirements != false ? "" : "Matricule ou type de contrat manquants") + " isLevage = " + isLevage + " (" + region.getLibelle() + ")" + " base r\u00e9mun. contrat = " + (float)currentContract.getContractHour() / 60.0f + ", tps service = " + (float)workedTime / 60.0f + " (" + workedDay + " jrs)" + ", s1100 = " + (float)s1100 / 60.0f + " (" + (float)altGenerateRCHour / 60.0f + " abs g\u00e9n\u00e9rant RC)" + ", s1101 = " + (float)s1101 / 60.0f + ", base tps pay\u00e9 = " + (float)s1100 / 60.0f + " (" + (float)altPaidHour / 60.0f + " abs pay\u00e9e et" + (float)altGenerateHSHour / 60.0f + " abs HS)" + ", delta = " + delta + ", theoric = " + theoric + "\r\nseuil HN/HM125 = " + (float)currentContract.getSeuilHN(-1) / 60.0f + ", seuil HM125/HS125 = " + (float)currentContract.getSeuilHE(-1) / 60.0f + ", seuil HS125/HS150 = " + (float)currentContract.getSeuilHS25(-1) / 60.0f + "\r\nPartie fixe : heure normale (1330) = " + (float)hnc1330 / 60.0f + ", hm125 (1332) = " + (float)hm125c1332 / 60.0f + ", hs125 (1334) = " + (float)hs125c1334 / 60.0f + ", hs150 (1336) = " + (float)hs150c1336 / 60.0f + "\r\nPartie variable : heure normale (1830) = " + (float)hnc1830 / 60.0f + ", hm125 (1845) = " + (float)hm125c1845 / 60.0f + ", hs125 (1855) = " + (float)hs125c1855 / 60.0f + ", hs150 (1865) = " + (float)hs150c1865 / 60.0f + ", heure de nuit (1960) = " + (isLevage != false ? "0" : Float.valueOf((float)night / 60.0f)) + ", 1970 = " + (isLevage != false ? Float.valueOf((float)(night + sundayOrJFTotalTime) / 60.0f) : "0") + ", sundayOrJFTotalTime = " + (float)sundayOrJFTotalTime / 60.0f);
                    if (requirements) {
                        tmp = new HashMap<String, Object>();
                        tmp.put(LanguageTranslator.getString("generics.driver"), String.valueOf(currentDriver.getNom()) + " " + currentDriver.getPrenom());
                        tmp.put("1100", s1100);
                        tmp.put("1101", s1101);
                        tmp.put("abs", abs);
                        tmp.put("abs HS", altGenerateHSHour);
                        tmp.put("remun. contrat", currentContract.getContractHour());
                        tmp.put("1330", hnc1330);
                        tmp.put("1332", hm125c1332);
                        tmp.put("1334", hs125c1334);
                        tmp.put("1336", hs150c1336);
                        tmp.put("1830", hnc1830);
                        tmp.put("1845", hm125c1845);
                        tmp.put("1855", hs125c1855);
                        tmp.put("1865", hs150c1865);
                        tmp.put(isMillon != false ? "1973" : "1960", isLevage != false ? 0 : night);
                        tmp.put("1970", isLevage != false ? night + sundayOrJFTotalTime : 0);
                        tmp.put("4538", abs4538);
                        this.data.add(tmp);
                        this.writeFile(this.file, currentAgency, currentDriver, s1100, s1101, hnc1830, hm125c1845, hs125c1855, hs150c1865, abs4538, isLevage != false ? 0 : night, isLevage != false ? night + sundayOrJFTotalTime : 0);
                        night1960 = isLevage != false ? 0 : night;
                        sunday1970 = isLevage != false ? night + sundayOrJFTotalTime : 0;
                        matricule = currentDriver.getMatricule();
                        societeCode = Transport.bdd.getCompany().getCode();
                        description = currentAgency.getDescription();
                        v1 = sRegion = tmp == region ? "AUCUNE" : region.getName();
                        if (s1100 != 0) {
                            this.file.write(String.valueOf(sRegion) + "\t" + description + "\t" + societeCode + "\t" + matricule + "\t" + "1100" + "\t" + this.df.format((float)s1100 / 60.0f) + "\r\n");
                        }
                        if (s1101 != 0) {
                            this.file.write(String.valueOf(sRegion) + "\t" + description + "\t" + societeCode + "\t" + matricule + "\t" + "1101" + "\t" + this.df.format((float)s1101 / 60.0f) + "\r\n");
                        }
                        if (abs4538 != 0) {
                            this.file.write(String.valueOf(sRegion) + "\t" + description + "\t" + societeCode + "\t" + matricule + "\t" + "4538" + "\t" + this.df.format((float)abs4538 / 60.0f) + "\r\n");
                        }
                        if (hnc1830 != 0) {
                            this.file.write(String.valueOf(sRegion) + "\t" + description + "\t" + societeCode + "\t" + matricule + "\t" + "1830" + "\t" + this.df.format((float)hnc1830 / 60.0f) + "\r\n");
                        }
                        if (hm125c1845 != 0) {
                            this.file.write(String.valueOf(sRegion) + "\t" + description + "\t" + societeCode + "\t" + matricule + "\t" + "1845" + "\t" + this.df.format((float)hm125c1845 / 60.0f) + "\r\n");
                        }
                        if (hs125c1855 != 0) {
                            this.file.write(String.valueOf(sRegion) + "\t" + description + "\t" + societeCode + "\t" + matricule + "\t" + "1855" + "\t" + this.df.format((float)hs125c1855 / 60.0f) + "\r\n");
                        }
                        if (hs150c1865 != 0) {
                            this.file.write(String.valueOf(sRegion) + "\t" + description + "\t" + societeCode + "\t" + matricule + "\t" + "1865" + "\t" + this.df.format((float)hs150c1865 / 60.0f) + "\r\n");
                        }
                        if (night1960 != 0) {
                            this.file.write(String.valueOf(sRegion) + "\t" + description + "\t" + societeCode + "\t" + matricule + "\t" + (isMillon != false ? "1973" : "1960") + "\t" + this.df.format((float)night1960 / 60.0f) + "\r\n");
                        }
                        if (sunday1970 != 0) {
                            this.file.write(String.valueOf(sRegion) + "\t" + description + "\t" + societeCode + "\t" + matricule + "\t" + "1970" + "\t" + this.df.format((float)sunday1970 / 60.0f) + "\r\n");
                        }
                    }
                }
                ++x;
            }
            this.afficheData();
            this.loadReport(currentAgency, new JRMapCollectionDataSource(this.data));
            this.data.clear();
        }
        this.generate();
        this.file.close();
        this.pb.dispose();
    }

    public void writeFile(PrintWriter file, Agence agency, Conducteur driver, int s1100, int s1101, int hnc1830, int hm125c1845, int hs125c1855, int hs150c1865, int abs4538, int night1960, int sunday1970) {
    }

    public void afficheData() {
        for (Map<String, ?> tmp : this.data) {
            System.out.print("\n=> ");
            for (String value : tmp.keySet()) {
                System.out.print(value.toString());
                System.out.print(" : " + tmp.get(value).toString() + "  ");
            }
        }
    }

    private int getCalendarTime(int cleConducteur, Date day) {
        int toReturn = 0;
        Vector<Jour> dayInDB = BddTransport.getInstance().getJourNew(cleConducteur, day, null, 1, false);
        if (dayInDB.size() == 1) {
            TimsLogger.debug("#TimeToCcmxCayon.process# Heure de travail sur jour f\u00e9ri\u00e9 ou dimanche (" + day + ") => " + dayInDB.get(0).getService());
            toReturn += dayInDB.get(0).getService();
        }
        return toReturn;
    }

    private int getAvgValue(Conducteur current) {
        if (this.avgValue == -1) {
            this.avgValue = Fonctions.getAvgValue(current, this.begin, this.end);
        }
        return this.avgValue;
    }

    private CustomReport getCR() {
        CustomReport toReturn = CustomReportFactory.getGeneric("Export heures M");
        toReturn.setColumn(this.getColumn());
        return toReturn;
    }

    private Vector<CustomReportColumn> getColumn() {
        Vector<CustomReportColumn> toReturn = new Vector<CustomReportColumn>();
        toReturn.add(new CustomReportColumn(0, 0, LanguageTranslator.getString("generics.driver"), String.class.getName(), "", 12, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1100", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1101", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "abs", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "remun. contrat", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1330", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1332", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1334", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1336", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "4538", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1830", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1845", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1855", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1865", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1960", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        toReturn.add(new CustomReportColumn(0, 0, "1970", Integer.class.getName(), "time", 8, toReturn.size() + 1));
        return toReturn;
    }
}

