/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.JourType;
import fr.pgh.data.bdd.LienJourConducteur;
import fr.pgh.data.bdd.Service;
import fr.pgh.data.bdd.TypeContrat;
import fr.pgh.exception.ContractNotFoundException;
import fr.pgh.exception.DriverNotFoundException;
import fr.pgh.exception.TypeContratNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transport.report.MasterReport;

public class Traction
extends MasterReport {
    private Collection<Map<String, ?>> data = null;
    int workday = 0;

    @Override
    public void process() {
        this.workday = ConversionTime.getWorkday(this.begin, this.end);
        Vector<TypeContrat> contractList = TypeContrat.loadList();
        this.data = new ArrayList();
        boolean toAdd = false;
        int workedTime = 0;
        int workedDay = 0;
        int firstRule = 0;
        int secondRule = 0;
        int driving = 0;
        int work = 0;
        int availability = 0;
        int rest = 0;
        int coupure = 0;
        int hourProj = 0;
        int satHour = 0;
        int satDayCount = 0;
        int sunHour = 0;
        int sunDayCount = 0;
        int altPaidHour = 0;
        int altGenerateHSHour = 0;
        int altDayCount = 0;
        this.pb.getBar().setMaximum(this.agencies.size() + this.drivers.size());
        this.pb.getBar().setMinimum(0);
        for (Agence currentAgency : this.agencies) {
            Vector<String> dayTypeOnly = new Vector<String>();
            this.pb.getBar().setString(currentAgency.getDescription());
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            Vector<Service> tmpS = Service.getService(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            Vector<LienJourConducteur> others = LienJourConducteur.loadList(currentAgency.getCleAgence(), (Vector<Conducteur>)this.drivers, this.begin, this.end);
            Conducteur currentDriver = null;
            int defaultDayLength = 0;
            TimsLogger.info("#Traction.process()# " + tmpS.size() + " services, " + others.size() + " journ\u00e9es d'absences");
            if (tmpS.size() == 0) continue;
            for (Service s : tmpS) {
                if (currentDriver == null || s.getDriverId() != currentDriver.getCleConducteur()) {
                    if (currentDriver != null && toAdd) {
                        float moyenne = workedDay == 0 ? 0.0f : (float)workedTime / (float)workedDay;
                        hourProj = (int)(moyenne * (float)(this.workday + sunDayCount - altDayCount));
                        TimsLogger.debug("Adding " + (currentDriver.getNom().length() > 4 ? currentDriver.getNom().substring(0, 3) : currentDriver.getNom()) + " " + (currentDriver.getPrenom().length() > 4 ? currentDriver.getPrenom().substring(0, 3) : currentDriver.getPrenom()) + "\tworkday = " + this.workday + "\tworkedDay = " + workedDay + "\tworkedTime = " + workedTime + "(moyenne = " + moyenne + ")" + "\tprojection = " + hourProj + "\taltPaidHour = " + altPaidHour + "\taltGenerateHSHour = " + altGenerateHSHour + "\taltDayCount = " + altDayCount + "\tsatHour = " + satHour + "\tsatDayCount = " + satDayCount + "\tdriving = " + driving + "\twork = " + work + "\tavailability = " + availability + "\trest = " + rest + "\tcoupure = " + coupure + "\tfirstRule = " + firstRule + "\tsecondRule = " + secondRule);
                        try {
                            TypeContrat contrat = TypeContrat.getContractType(contractList, currentDriver.getCleTypeContrat());
                            this.data.add(this.fillMap(currentDriver, contrat, workedDay + satDayCount, workedTime + satHour, firstRule, secondRule, driving, work, availability, rest, coupure, hourProj, altPaidHour, altGenerateHSHour, satHour, satDayCount));
                        }
                        catch (ContractNotFoundException ex) {
                            TimsLogger.warn("#Traction.process# No contract for " + currentDriver.getCleTypeContrat() + " (" + currentDriver.getNom() + ")");
                        }
                    }
                    workedTime = 0;
                    workedDay = 0;
                    firstRule = 0;
                    secondRule = 0;
                    driving = 0;
                    work = 0;
                    availability = 0;
                    rest = 0;
                    coupure = 0;
                    hourProj = 0;
                    altPaidHour = 0;
                    altDayCount = 0;
                    satHour = 0;
                    satDayCount = 0;
                    sunDayCount = 0;
                    altGenerateHSHour = 0;
                    dayTypeOnly.clear();
                    toAdd = false;
                    try {
                        currentDriver = Conducteur.getDriver((Vector<Conducteur>)this.drivers, s.getDriverId());
                        if (System.getProperty("contract_day_length_reference", "0").equals("1")) {
                            TypeContrat driverContract = TypeContrat.getTypeContrat(currentDriver.getCleTypeContrat());
                            defaultDayLength = driverContract.getDailyValue();
                        }
                    }
                    catch (DriverNotFoundException ex) {
                        TimsLogger.warn("Unable to find driver " + s.getDriverId());
                    }
                    catch (TypeContratNotFoundException ex) {
                        TimsLogger.warn("Contrat " + currentDriver.getCleTypeContrat() + " introuvable pour " + currentDriver.getNom());
                    }
                    this.pb.getBar().setString(String.valueOf(currentAgency.getDescription()) + " : " + currentDriver.getNom() + " " + currentDriver.getPrenom());
                    this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
                    for (LienJourConducteur tmp : others) {
                        int day;
                        JourType dayType = tmp.getDayType();
                        if (tmp.getCleConducteur() != currentDriver.getCleConducteur()) continue;
                        if (dayType.isPaid()) {
                            altPaidHour += tmp.getDuree(defaultDayLength);
                        }
                        if (dayType.isGenerateHS()) {
                            altGenerateHSHour += tmp.getDuree(defaultDayLength);
                        }
                        if (tmp.getType() == 2 || tmp.getDuree(defaultDayLength) >= 420) {
                            day = ConversionTime.getDayOfWeek(tmp.getDateJour(), false);
                            if (day != 7 && day != 1) {
                                ++altDayCount;
                            }
                        } else if (tmp.getType() == 1 && LienJourConducteur.find(others, tmp.getCleConducteur(), tmp.getDateJour()).size() > 1 && (day = ConversionTime.getDayOfWeek(tmp.getDateJour(), false)) != 7 && day != 1) {
                            ++altDayCount;
                        }
                        if (!dayType.isServiceIncluded() || tmp.getType() != 2 && (!System.getProperty("company", "PGH").equals("salvesen") || tmp.getDuree(defaultDayLength) < 420)) continue;
                        TimsLogger.debug("#Traction.process# no service possible on " + tmp.getDateJour());
                        dayTypeOnly.add(ConversionTime.dateToString(tmp.getDateJour(), "yyyy-MM-dd"));
                    }
                }
                if (currentDriver.getNightDay() == 0 && ConversionTime.getNbJourBetween(s.getBeginDate().substring(0, 10), s.getEndDate().substring(0, 10), "yyyy-MM-dd") >= 1 || currentDriver.getNightDay() == 2) {
                    toAdd = true;
                }
                int dayOfWeek = ConversionTime.getDayOfWeek(s.getBeginDate(), "yyyy-MM-dd HH:mm:ss", false);
                if (dayTypeOnly.contains(s.getBeginDate().substring(0, 10))) {
                    TimsLogger.debug("#Traction.process# Unauthorized service on " + s.getBeginDate());
                    continue;
                }
                if (dayOfWeek == 7) {
                    satHour += s.getService();
                    ++satDayCount;
                    continue;
                }
                if (dayOfWeek == 1) {
                    sunHour += s.getService();
                    ++sunDayCount;
                }
                workedTime += s.getService();
                ++workedDay;
                workedDay += ConversionTime.getNbJourBetween(s.getBeginDate(), s.getEndDate(), "yyyy-MM-dd HH:mm:ss");
                driving += s.getDriving();
                work += s.getWork();
                availability += s.getAvailability();
                rest += s.getRest();
                firstRule += s.getFirstWork();
                secondRule += s.getLastWork();
                coupure += s.getCut();
            }
            if (toAdd) {
                float moyenne = workedDay == 0 ? 0.0f : (float)workedTime / (float)workedDay;
                hourProj = (int)(moyenne * (float)(this.workday + sunDayCount - altDayCount));
                TimsLogger.debug("Adding " + (currentDriver.getNom().length() > 4 ? currentDriver.getNom().substring(0, 3) : currentDriver.getNom()) + " " + (currentDriver.getPrenom().length() > 4 ? currentDriver.getPrenom().substring(0, 3) : currentDriver.getPrenom()) + "\tworkday = " + workedDay + "\tworkedDay = " + workedDay + "\tworkedTime = " + workedTime + "(moyenne = " + moyenne + ")" + "\tprojection = " + hourProj + "\taltPaidHour = " + altPaidHour + "\taltGenerateHSHour = " + altGenerateHSHour + "\taltDayCount = " + altDayCount + "\tsatHour = " + satHour + "\tsatDayCount = " + satDayCount + "\tdriving = " + driving + "\twork = " + work + "\tavailability = " + availability + "\trest = " + rest + "\tcoupure = " + coupure + "\tfirstRule = " + firstRule + "\tsecondRule = " + secondRule);
                try {
                    TypeContrat contrat = TypeContrat.getContractType(contractList, currentDriver.getCleTypeContrat());
                    this.data.add(this.fillMap(currentDriver, contrat, workedDay + satDayCount, workedTime + satHour, firstRule, secondRule, driving, work, availability, rest, coupure, hourProj, altPaidHour, altGenerateHSHour, satHour, satDayCount));
                    workedTime = 0;
                    workedDay = 0;
                    firstRule = 0;
                    secondRule = 0;
                    driving = 0;
                    work = 0;
                    availability = 0;
                    rest = 0;
                    coupure = 0;
                    hourProj = 0;
                    altPaidHour = 0;
                    altDayCount = 0;
                    satHour = 0;
                    satDayCount = 0;
                    sunDayCount = 0;
                    altGenerateHSHour = 0;
                    toAdd = false;
                }
                catch (ContractNotFoundException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                this.loadReport(currentAgency, new JRMapCollectionDataSource(this.data));
                this.data.clear();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.generate();
    }

    public Map<String, Object> fillMap(Conducteur driver, TypeContrat contract, int workedDay, int workedTime, int firstRule, int secondRule, int driving, int work, int availability, int rest, int coupure, int projection, int altPaidHour, int altGenerateHSHour, int satHour, int satDayCount) {
        HashMap<String, Object> tmp = new HashMap<String, Object>();
        int baseHS = projection + altGenerateHSHour + satHour;
        int hs25 = 0;
        int hs50 = 0;
        if (baseHS > contract.getSeuilHS25(2)) {
            hs50 = baseHS - contract.getSeuilHS25(2);
            hs25 = contract.getSeuilHS25(2) - contract.getSeuilHN(2);
        } else if (baseHS > contract.getSeuilHN(2)) {
            hs25 = baseHS - contract.getSeuilHN(2);
        }
        tmp.put("FIRST_NAME", driver.getPrenom());
        tmp.put("LAST_NAME", driver.getNom());
        tmp.put("MATRICULE", driver.getMatricule());
        tmp.put("DRIVER_FIRSTNAME", workedDay);
        tmp.put("WORKED_DAY", workedDay);
        tmp.put("DAY_PERIOD", this.workday);
        tmp.put("WORKED_TIME", workedTime + satHour);
        tmp.put("CONTRACT_TIME", contract.getContractHour());
        tmp.put("HS25", hs25);
        tmp.put("HS50", hs50);
        tmp.put("MAXIMUM", projection + altPaidHour + satHour > contract.getMaximumHour() ? "O" : "N");
        tmp.put("FIRST_RULE", workedDay != 0 ? firstRule / workedDay : 0);
        tmp.put("SECOND_RULE", workedDay != 0 ? secondRule / workedDay : 0);
        tmp.put("WORK", work);
        tmp.put("DRIVING", driving);
        tmp.put("AVAILABILITY", availability);
        tmp.put("REST", rest);
        tmp.put("COUPURE", workedDay != 0 ? coupure / workedDay : 0);
        tmp.put("PROJECTION", projection + altPaidHour + satHour);
        return tmp;
    }
}

