/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.BddTransport;
import fr.pgh.data.bdd.ActiviteConducteur;
import fr.pgh.data.bdd.Conducteur;
import fr.pgh.data.bdd.Jour;
import fr.pgh.data.bdd.Utilisateur;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.MasterReport;

public class Update
extends MasterReport {
    Collection<Map<String, ?>> data = null;

    @Override
    public void process() {
        this.pb.getBar().setMaximum(this.drivers.size());
        this.pb.getBar().setMinimum(0);
        if (this.data == null) {
            this.data = new ArrayList();
        }
        for (Conducteur driver : this.drivers) {
            this.pb.getBar().setString(String.valueOf(driver.getNom()) + " " + driver.getPrenom());
            this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            TimsLogger.debug("#Update.retrieveData()# driver id = " + driver.getCleConducteur() + " (" + driver.getNom() + ")");
            Vector<Jour> days = BddTransport.getInstance().getJourNew(driver.getCleConducteur(), this.begin, this.end, 2, false);
            try {
                for (Jour day : days) {
                    TimsLogger.debug("#Update.retrieveData()# generation pour " + driver.getNom() + " " + day.getDate());
                    this.loadPage(driver, day);
                }
                this.loadReport(driver, new JRMapCollectionDataSource(this.data));
                this.data.clear();
            }
            catch (JRException ex) {
                ex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.generate();
        this.pb.dispose();
    }

    public void loadPage(Conducteur driver, Jour day) {
        Vector<ActiviteConducteur> original = day.getActivity();
        Vector<Jour> updatedDay = BddTransport.getInstance().getJourNew(driver.getCleConducteur(), day.getDate(), null, 1, false);
        if (updatedDay.size() != 1) {
            TimsLogger.error("#Update.loadPage# erreur, il n'y a pas une seule journ\u00e9e");
        }
        Vector<ActiviteConducteur> updated = updatedDay.get(0).getActivity();
        int x = 0;
        int y = 0;
        String comment = BddTransport.getInstance().getCommentJour(driver.getCleConducteur(), day.getDate());
        Utilisateur user = BddTransport.getInstance().getAuteurModification(day.getDate(), driver.getCleConducteur());
        String sUser = user == null ? LanguageTranslator.getString("generics.unknown") : String.valueOf(user.getNom()) + " " + user.getPrenom();
        TimsLogger.debug("#Update.loadPage()# updatedDate : " + day.getDate() + ", " + original.size() + " activit\u00e9s originales, " + updated.size() + " modifi\u00e9es");
        while (x != original.size() && y != updated.size()) {
            ActiviteConducteur u;
            TimsLogger.debug("#Update.loadPage()# x : " + x + " y : " + y);
            ActiviteConducteur o = x < original.size() ? original.get(x) : null;
            ActiviteConducteur activiteConducteur = u = y < updated.size() ? updated.get(y) : null;
            if (o.equals(u)) {
                TimsLogger.debug("activit\u00e9s identiques, on les enl\u00e8ve (" + o.getHeureDebut() + "," + o.getHeureFin() + "," + o.getCleType() + ") / (" + u.getHeureDebut() + "," + u.getHeureFin() + "," + u.getCleType() + ")");
                original.remove(o);
                updated.remove(u);
                continue;
            }
            int newY = y;
            boolean found = false;
            while (newY < updated.size()) {
                if (o.equals(updated.get(newY))) {
                    TimsLogger.debug("on laisse les activit\u00e9s modifi\u00e9es de " + y + " \u00e0 " + newY);
                    TimsLogger.debug("on enl\u00e8ve (" + o.getHeureDebut() + "," + o.getHeureFin() + "," + o.getCleType() + ") / (" + updated.get(newY).getHeureDebut() + "," + updated.get(newY).getHeureFin() + "," + updated.get(newY).getCleType() + ")");
                    original.remove(o);
                    updated.remove(newY);
                    y = newY;
                    found = true;
                    break;
                }
                ++newY;
            }
            TimsLogger.debug("fin de updated. found = " + found);
            if (found) continue;
            int newX = x;
            while (newX < original.size()) {
                if (u.equals(original.get(newX))) {
                    TimsLogger.debug("on laisse les activit\u00e9s originales de " + y + " \u00e0 " + newY);
                    TimsLogger.debug("on enl\u00e8ve (" + original.get(newX).getHeureDebut() + "," + original.get(newX).getHeureFin() + "," + original.get(newX).getCleType() + ") / (" + u.getHeureDebut() + "," + u.getHeureFin() + "," + u.getCleType() + ")");
                    original.remove(newX);
                    updated.remove(u);
                    x = newX;
                    found = true;
                    break;
                }
                ++newX;
            }
            TimsLogger.debug("fin de original. found = " + found);
            if (found) continue;
            TimsLogger.debug("on garde les 2 activit\u00e9s (" + o.getHeureDebut() + "," + o.getHeureFin() + "," + o.getCleType() + ") / (" + u.getHeureDebut() + "," + u.getHeureFin() + "," + u.getCleType() + ")");
            ++x;
            ++y;
        }
        TimsLogger.debug("il reste " + original.size() + " originales et " + updated.size() + " modifi\u00e9es");
        int b = 0;
        while (b < original.size() || b < updated.size()) {
            ActiviteConducteur oA = b < original.size() ? original.get(b) : null;
            ActiviteConducteur uA = b < updated.size() ? updated.get(b) : null;
            TimsLogger.debug("#Update.loadPage()# add to data : " + day.getDate() + ", ");
            TimsLogger.debug(String.valueOf(oA != null ? oA.getHeureDebut() : 0) + ", " + (oA != null ? oA.getHeureFin() : 0) + ", " + (oA != null ? oA.getDescription() : "null") + ", ");
            TimsLogger.debug(String.valueOf(uA != null ? uA.getHeureDebut() : 0) + ", " + (uA != null ? uA.getHeureFin() : 0) + ", " + (uA != null ? uA.getDescription() : "null") + "\n");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("DATE", ConversionTime.stringToDate(day.getDate(), "yyyy-MM-dd"));
            map.put("USER", sUser);
            map.put("COMMENT", comment);
            map.put("DEBUT_O", oA != null ? oA.getHeureDebut() : 0);
            map.put("FIN_O", oA != null ? oA.getHeureFin() : 0);
            map.put("ACTIVITE_O", oA != null ? oA.getDescription() : null);
            map.put("DUREE_O", oA != null ? oA.getDuree() : 0);
            map.put("DEBUT_U", uA != null ? uA.getHeureDebut() : 0);
            map.put("FIN_U", uA != null ? uA.getHeureFin() : 0);
            map.put("ACTIVITE_U", uA != null ? uA.getDescription() : null);
            map.put("DUREE_U", uA != null ? uA.getDuree() : 0);
            this.data.add(map);
            ++b;
        }
    }
}

