/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJVehicleLocationGenerator;

public class VehicleLocation
extends DynamicGeneric {
    private Collection<Map<String, ?>> data = null;

    @Override
    public void process() {
        this.customReport = CustomReportFactory.getVehicleLocation();
        this.customReport.setName(this.report.getCustomizedName());
        this.setGenerator(new DJVehicleLocationGenerator());
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        try {
            this.getGenerator().compile(this.userParameters);
        }
        catch (Exception ex) {
            TimsLogger.warn("#VehicleLocation.process# error on compilation");
            ex.printStackTrace();
            return;
        }
        if (this.pb != null) {
            this.pb.getBar().setMaximum(this.vehicles.size());
        }
        if (this.pb != null) {
            this.pb.getBar().setMinimum(0);
        }
        for (Agence agency : this.agencies) {
            this.data = new ArrayList();
            for (Vehicule vehicle : this.vehicles) {
                if (vehicle.getAgencyId() != agency.getCle() || vehicle.getLocationLimit() == null) continue;
                int lastKnownKm = vehicle.getLastKnownKm();
                int leftUntilEnd = ConversionTime.getDaysBetween(new Date(), vehicle.getLocationLimit());
                TimsLogger.debug(String.valueOf(leftUntilEnd) + " jour entre " + vehicle.getLocationLimit() + " et " + new Date());
                leftUntilEnd = leftUntilEnd * 5 / 7;
                int kmAtEnd = leftUntilEnd * vehicle.getAverageDailyKm() + vehicle.getLastKnownKm();
                HashMap<String, Object> vehicleData = new HashMap<String, Object>();
                vehicleData.put(LanguageTranslator.getString("vehicle.registrationNumber"), vehicle.getRegistrationNumber());
                vehicleData.put(LanguageTranslator.getString("vehicle.locationLimit"), vehicle.getLocationLimit());
                vehicleData.put(LanguageTranslator.getString("vehicle.locationKm"), vehicle.getLocationKm());
                vehicleData.put(LanguageTranslator.getString("vehicle.currentKm"), vehicle.getLastKnownKm());
                vehicleData.put(LanguageTranslator.getString("vehicle.average"), vehicle.getAverageDailyKm());
                vehicleData.put(LanguageTranslator.getString("vehicle.dayLeft"), leftUntilEnd);
                vehicleData.put(LanguageTranslator.getString("vehicle.endLocationKm"), kmAtEnd);
                vehicleData.put("delta", kmAtEnd - vehicle.getLocationKm());
                this.data.add(vehicleData);
            }
            try {
                this.loadReport(agency, new JRMapCollectionDataSource(this.data));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.generate();
    }
}

