/*
 * Decompiled with CFR 0.152.
 */
package transport.report;

import fr.pgh.conversion.ConversionTime;
import fr.pgh.data.bdd.Agence;
import fr.pgh.data.bdd.FuelConsumption;
import fr.pgh.data.bdd.JourUEV;
import fr.pgh.data.bdd.Vehicule;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;
import transpo.system.TimsLogger;
import transpo.system.ui.resources.i18n.LanguageTranslator;
import transport.report.CustomReportFactory;
import transport.report.DynamicGeneric;
import transport.report.generator.DJGenerator;

public class VehicleTIPP
extends DynamicGeneric {
    private Collection<Map<String, ?>> data = null;
    private int monthPerPeriod = 1;
    private boolean fromBegin = false;

    @Override
    public void process() {
        this.customReport = CustomReportFactory.getVehicleTIPP();
        this.customReport.setName(this.report.getCustomizedName());
        this.setGenerator(new DJGenerator());
        this.getGenerator().setReport(this.customReport);
        this.getGenerator().prebuild();
        this.userParameters.put("DEBUT", this.begin);
        this.userParameters.put("FIN", this.end);
        this.userParameters.put("TITLE", this.customReport.getName());
        try {
            this.getGenerator().compile(this.userParameters);
        }
        catch (Exception ex) {
            TimsLogger.warn("#VehicleLocation.process# error on compilation");
            ex.printStackTrace();
            return;
        }
        if (this.pb != null) {
            this.pb.getBar().setMaximum(this.agencies.size());
        }
        if (this.pb != null) {
            this.pb.getBar().setMinimum(0);
        }
        this.data = new ArrayList();
        for (Agence agency : this.agencies) {
            if (this.pb != null) {
                this.pb.getBar().setString(agency.getDescription());
            }
            if (this.pb != null) {
                this.pb.getBar().setValue(this.pb.getBar().getValue() + 1);
            }
            Vector<JourUEV> days = JourUEV.getJourUEV(ConversionTime.addDay(this.begin, -1), ConversionTime.addDay(this.end, 1), agency.getCleAgence(), this.vehicles.size() == 1 ? ((Vehicule)this.vehicles.get(0)).getCleVehicule() : 0, false);
            Vector<FuelConsumption> fuelCons = null;
            Vehicule currentVehicle = null;
            String currentPeriod = null;
            int beginKm = 0;
            int endKm = 0;
            for (JourUEV day : days) {
                String period = this.getPeriod(day.getDay());
                if (currentVehicle == null || currentVehicle.getCleVehicule() != day.getVehicleId() || currentPeriod == null || !currentPeriod.equals(period)) {
                    if (currentVehicle != null && currentPeriod != null) {
                        TimsLogger.debug("on inscrit les donn\u00e9es de " + currentPeriod + " pour " + currentVehicle.getRegistrationNumber() + "(de " + beginKm + " \u00e0 " + endKm + ")");
                        int liters = 0;
                        for (FuelConsumption tmp : fuelCons) {
                            if (!currentPeriod.equals(this.getPeriod(tmp.getDate()))) continue;
                            liters = (int)((float)liters + tmp.getLiters());
                        }
                        if (this.inDateFilter(currentPeriod)) {
                            this.data.add(this.fillMap(currentVehicle, agency, currentPeriod, beginKm, endKm, liters));
                        }
                    }
                    TimsLogger.debug("changement v\u00e9hicule");
                    currentPeriod = period;
                    if (currentVehicle == null || currentVehicle.getCleVehicule() != day.getVehicleId()) {
                        try {
                            currentVehicle = Vehicule.getVehicule((Vector<Vehicule>)this.vehicles, day.getVehicleId());
                            fuelCons = FuelConsumption.loadList(0, 0, day.getVehicleId(), this.begin, this.end);
                            TimsLogger.debug("nouveau v\u00e9hicule : " + currentVehicle.getRegistrationNumber() + "(d\u00e9but " + beginKm + " km sur la p\u00e9riode " + currentPeriod + ")");
                        }
                        catch (Exception ex) {
                            TimsLogger.warn("process() unable to find vehicle id " + day.getVehicleId());
                            currentVehicle = null;
                        }
                        endKm = 0;
                    }
                    beginKm = day.getDailyKm() != 0 || endKm == 0 ? day.getKm() - day.getDailyKm() : endKm;
                }
                endKm = day.getKm();
            }
            if (currentVehicle == null || currentPeriod == null) continue;
            int liters = 0;
            for (FuelConsumption tmp : fuelCons) {
                if (!currentPeriod.equals(this.getPeriod(tmp.getDate()))) continue;
                liters = (int)((float)liters + tmp.getLiters());
            }
            if (!this.inDateFilter(currentPeriod)) continue;
            this.data.add(this.fillMap(currentVehicle, agency, currentPeriod, beginKm, endKm, liters));
        }
        try {
            this.load(new JRMapCollectionDataSource(this.data), this.report.getCustomizedName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.generate();
    }

    public Map<String, Object> fillMap(Vehicule currentVehicle, Agence agence, String currentPeriod, int beginKm, int endKm, int liters) {
        TimsLogger.debug("#VehicleTIPP.fillMap()# on ajoute une ligne ");
        HashMap<String, Object> vehicleData = new HashMap<String, Object>();
        vehicleData.put(LanguageTranslator.getString("generics.period"), this.getPeriod(currentPeriod));
        vehicleData.put(LanguageTranslator.getString("vehicle.registrationNumber"), currentVehicle.getRegistrationNumber());
        vehicleData.put(LanguageTranslator.getString("generics.agency"), agence.getDescription());
        vehicleData.put(LanguageTranslator.getString("vehicle.state"), currentVehicle.getLocationLimit() != null ? "L" : "P");
        vehicleData.put(LanguageTranslator.getString("vehicle.beginKm"), beginKm);
        vehicleData.put(LanguageTranslator.getString("vehicle.endKm"), endKm);
        vehicleData.put(LanguageTranslator.getString("vehicle.totalKm"), endKm - beginKm);
        vehicleData.put(LanguageTranslator.getString("fuel.consumption"), liters);
        return vehicleData;
    }

    private String getPeriod(Date date) {
        int month = Integer.parseInt(ConversionTime.dateToString(date, "MM"));
        int periodOfYear = (month - 1) / this.monthPerPeriod + 1;
        String toReturn = String.valueOf(ConversionTime.dateToString(date, "yyyy")) + (periodOfYear < 10 ? "0" : "") + periodOfYear;
        return toReturn;
    }

    private boolean inDateFilter(String period) {
        int iPeriod = Integer.parseInt(period);
        int beginPeriod = Integer.parseInt(this.getPeriod(this.begin));
        int endPeriod = Integer.parseInt(this.getPeriod(this.end));
        TimsLogger.debug("#VehicleTIPP.inDateFilter# " + period + " in filter ? (" + beginPeriod + "-" + endPeriod + ") " + (beginPeriod <= iPeriod && iPeriod <= endPeriod));
        return beginPeriod <= iPeriod && iPeriod <= endPeriod;
    }

    private String getPeriod(String period) {
        int periodOfYear = Integer.parseInt(period.substring(4, 6));
        int year = Integer.parseInt(period.substring(0, 4));
        TimsLogger.debug("getPeriod " + period + " returns " + periodOfYear + " " + year);
        int endPeriod = periodOfYear * this.monthPerPeriod;
        int beginPeriod = endPeriod - this.monthPerPeriod + 1;
        Calendar cal = Calendar.getInstance();
        cal.set(year, endPeriod - 1, 1);
        int day = cal.getActualMaximum(5);
        String sBegin = "01/" + (beginPeriod < 10 ? "0" + beginPeriod : Integer.valueOf(beginPeriod)) + "/" + year;
        String sEnd = String.valueOf(day) + "/" + (endPeriod < 10 ? "0" + endPeriod : Integer.valueOf(endPeriod)) + "/" + year;
        TimsLogger.debug("#VehicleTIPP.getPeriod# " + LanguageTranslator.getString("generics.from") + " " + sBegin + " " + LanguageTranslator.getString("generics.to") + " " + sEnd);
        return String.valueOf(LanguageTranslator.getString("generics.from")) + " " + sBegin + " " + LanguageTranslator.getString("generics.to") + " " + sEnd;
    }
}

